/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xdja.pams.syms.service.SystemConfigService;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pams.function.xatl.crewaddressbook.bean.FangxiangBean;
import pams.function.xatl.crewaddressbook.bean.PhoneBean;
import pams.function.xatl.crewaddressbook.bean.RailWayBook;
import pams.function.xatl.crewaddressbook.bean.ResultCode;
import pams.function.xatl.crewaddressbook.bean.XianLuBean;
import pams.function.xatl.crewaddressbook.bean.ZhandianBean;

public class JDBCSession {
    private Connection conn = null;
    private PreparedStatement pstm = null;
    private ResultSet rs = null;
    private static Map<String, String> paramsMap = new HashMap<String, String>(4);
    String driver = "";
    String url = "";
    String user = "";
    String password = "";
    private static final Logger log = LoggerFactory.getLogger(JDBCSession.class);

    private JDBCSession() {
    }

    public JDBCSession(Map<String, String> paramsMap) {
        this.url = paramsMap.get("url");
        this.driver = paramsMap.get("driverClassName");
        this.user = paramsMap.get("usr");
        this.password = paramsMap.get("password");
    }

    public static Map<String, String> getInstanceJdbcParamter(SystemConfigService systemConfigService) {
        if (paramsMap.keySet().isEmpty()) {
            String driverClassName = systemConfigService.getValueByCode("driverClassName");
            String url = systemConfigService.getValueByCode("url");
            String usr = systemConfigService.getValueByCode("usr");
            String password = systemConfigService.getValueByCode("password");
            paramsMap.put("url", url);
            paramsMap.put("driverClassName", driverClassName);
            paramsMap.put("usr", usr);
            paramsMap.put("password", password);
        }
        return paramsMap;
    }

    private void initConnection() {
        try {
            Class.forName(this.driver);
            this.conn = DriverManager.getConnection(this.url, this.user, this.password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Connection getConnection() {
        this.initConnection();
        return this.conn;
    }

    public void releaseConnectn() {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (this.pstm != null) {
            try {
                this.pstm.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long executeQueryCount(String sql, List<Object> params) {
        this.initConnection();
        ArrayList list = null;
        long count = 0L;
        int index = 1;
        try {
            this.pstm = this.conn.prepareStatement(sql);
            if (params != null && !params.isEmpty()) {
                for (Object param : params) {
                    this.pstm.setObject(index++, param);
                }
            }
            this.rs = this.pstm.executeQuery();
            list = new ArrayList();
            ResultSetMetaData rsmd = this.rs.getMetaData();
            while (this.rs.next()) {
                count = this.rs.getLong(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseConnectn();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> executeQuery(String sql, List<Object> params) {
        this.initConnection();
        ArrayList list = null;
        int index = 1;
        try {
            this.pstm = this.conn.prepareStatement(sql);
            if (params != null && !params.isEmpty()) {
                for (Object param : params) {
                    this.pstm.setObject(index++, param);
                }
            }
            this.rs = this.pstm.executeQuery();
            list = new ArrayList();
            ResultSetMetaData rsmd = this.rs.getMetaData();
            while (this.rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                for (int j = 1; j <= rsmd.getColumnCount(); ++j) {
                    String colKey = rsmd.getColumnLabel(j);
                    Object colValue = this.rs.getObject(colKey);
                    if ("TIMESTAMP".equals(rsmd.getColumnTypeName(j))) {
                        colValue = colValue.toString();
                    }
                    if (colValue == null) {
                        colValue = "";
                    }
                    map.put(colKey, colValue);
                }
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseConnectn();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql, List<Object> params) {
        this.initConnection();
        int rows = 0;
        int index = 1;
        try {
            this.pstm = this.conn.prepareStatement(sql);
            if (params != null && !params.isEmpty()) {
                for (int i = 0; i < params.size(); ++i) {
                    this.pstm.setObject(index++, params.get(i));
                }
            }
            rows = this.pstm.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseConnectn();
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T findSimpleRefResult(String sql, List<Object> params, Class<T> cls) {
        this.initConnection();
        T resultObject = null;
        int index = 1;
        try {
            this.pstm = this.conn.prepareStatement(sql);
            if (params != null && !params.isEmpty()) {
                for (Object param : params) {
                    this.pstm.setObject(index++, param);
                }
            }
            this.rs = this.pstm.executeQuery();
            ResultSetMetaData rsmd = this.rs.getMetaData();
            int colLen = rsmd.getColumnCount();
            while (this.rs.next()) {
                resultObject = cls.newInstance();
                for (int i = 1; i <= colLen; ++i) {
                    String colKey = rsmd.getColumnLabel(i);
                    Object colValue = this.rs.getObject(colKey);
                    if (colValue == null) {
                        colValue = "";
                    }
                    Field field = cls.getDeclaredField(colKey);
                    field.setAccessible(true);
                    field.set(resultObject, colValue);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseConnectn();
        }
        return resultObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Map<Object, T> findMapRefResult(String sql, List<Object> params, Class<T> cls, String keyName) {
        this.initConnection();
        Object resultObject = null;
        int index = 1;
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        try {
            this.pstm = this.conn.prepareStatement(sql);
            if (params != null && !params.isEmpty()) {
                for (Object param : params) {
                    this.pstm.setObject(index++, param);
                }
            }
            this.rs = this.pstm.executeQuery();
            ResultSetMetaData rsmd = this.rs.getMetaData();
            int colLen = rsmd.getColumnCount();
            while (this.rs.next()) {
                resultObject = cls.newInstance();
                Object key = null;
                for (int i = 1; i <= colLen; ++i) {
                    String colKey = rsmd.getColumnLabel(i);
                    Object colValue = this.rs.getObject(colKey);
                    if (colValue == null) {
                        colValue = "";
                    }
                    if (keyName.equalsIgnoreCase(colKey)) {
                        key = colValue;
                    }
                    Field field = cls.getDeclaredField(colKey);
                    field.setAccessible(true);
                    field.set(resultObject, colValue);
                }
                map.put(key, resultObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseConnectn();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getZhandianByParentId(String sql) {
        this.initConnection();
        ArrayList<ZhandianBean> list = new ArrayList<ZhandianBean>(256);
        try {
            this.pstm = this.conn.prepareStatement(sql);
            this.rs = this.pstm.executeQuery();
            ZhandianBean bean = null;
            int lastRailBookId = 0;
            while (this.rs.next()) {
                String discriptions;
                List<PhoneBean> phoneList;
                int id = this.rs.getInt("id");
                if (lastRailBookId == id) {
                    int type = this.rs.getInt("type");
                    String phones = this.rs.getString("phones");
                    if (!StringUtils.isNotBlank((String)phones) || type != 2 || null == (phoneList = this.getPhoneList(phones, discriptions = this.rs.getString("discriptions")))) continue;
                    assert (bean != null);
                    bean.setPositionPhoneList(phoneList);
                    continue;
                }
                bean = new ZhandianBean();
                list.add(bean);
                bean.setId(id);
                lastRailBookId = id;
                bean.setName(this.rs.getString("name"));
                bean.setParentId(this.rs.getInt("parent_id"));
                bean.setLevel(this.rs.getInt("level"));
                bean.setType(this.rs.getInt("is_leaf"));
                bean.setStationLocation(this.rs.getString("station_desctiption"));
                String phones = this.rs.getString("phones");
                int type = this.rs.getInt("type");
                if (StringUtils.isNotBlank((String)phones)) {
                    discriptions = this.rs.getString("discriptions");
                    phoneList = this.getPhoneList(phones, discriptions);
                    if (null == phoneList) continue;
                    if (type == 1) {
                        bean.setStationPhoneList(phoneList);
                        continue;
                    }
                    bean.setPositionPhoneList(phoneList);
                    continue;
                }
                if (type == 1) {
                    bean.setStationPhoneList(Collections.EMPTY_LIST);
                    continue;
                }
                bean.setPositionPhoneList(Collections.EMPTY_LIST);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseConnectn();
        }
        return list;
    }

    private List<PhoneBean> getPhoneList(String phones, String descriptions) throws SQLException {
        ArrayList<PhoneBean> phoneList = new ArrayList<PhoneBean>(4);
        if (StringUtils.isNotBlank((String)phones)) {
            String[] phoneArr = phones.split(",");
            if (phones.contains(",")) {
                if (StringUtils.isNotBlank((String)descriptions)) {
                    String[] discriptions = descriptions.split(",");
                    if (phoneArr.length > 0) {
                        for (int j = 0; j < phoneArr.length; ++j) {
                            String str = "";
                            if (discriptions.length > j) {
                                str = discriptions[j];
                            }
                            if (StringUtils.isNotBlank((String)phoneArr[j]) && "\u65e0\u63a5\u5165".equalsIgnoreCase(phoneArr[j])) {
                                phoneArr[j] = "\u6682\u65e0";
                                str = "";
                            }
                            phoneList.add(new PhoneBean(0, phoneArr[j], str));
                        }
                    }
                }
            } else {
                if (StringUtils.isNotBlank((String)phones) && "\u65e0\u63a5\u5165".equalsIgnoreCase(phones)) {
                    phones = "\u6682\u65e0";
                    descriptions = "";
                }
                phoneList.add(new PhoneBean(0, phones, descriptions));
            }
        }
        return phoneList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> findMoreRefResult(String sql, List<Object> params, Class<T> cls) throws Exception {
        this.initConnection();
        ArrayList<T> list = new ArrayList<T>();
        int index = 1;
        try {
            this.pstm = this.conn.prepareStatement(sql);
            if (params != null && !params.isEmpty()) {
                for (Object param : params) {
                    this.pstm.setObject(index++, param);
                }
            }
            this.rs = this.pstm.executeQuery();
            ResultSetMetaData rsmd = this.rs.getMetaData();
            int colLen = rsmd.getColumnCount();
            while (this.rs.next()) {
                T resultObject = cls.newInstance();
                for (int i = 1; i <= colLen; ++i) {
                    String colKey = rsmd.getColumnLabel(i);
                    Object colValue = this.rs.getObject(colKey);
                    if (colValue == null) {
                        colValue = "";
                    }
                    if ("TIMESTAMP".equals(rsmd.getColumnTypeName(i))) {
                        colValue = colValue.toString();
                    }
                    Field field = cls.getDeclaredField(colKey);
                    field.setAccessible(true);
                    field.set(resultObject, colValue.toString());
                    field.setAccessible(false);
                }
                list.add(resultObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseConnectn();
        }
        return list;
    }

    private ResultCode deleteFangxiang(int parentId) {
        String sql = "DELETE FROM `rail_phone` WHERE `rail_book_id` IN ( SELECT id FROM `rail_directory` WHERE parent_id IN  (SELECT id FROM `rail_directory` WHERE parent_id = ?))";
        try {
            this.pstm = this.conn.prepareStatement(sql);
            this.pstm.setInt(1, parentId);
            this.pstm.executeUpdate();
            sql = "DELETE FROM rail_directory WHERE parent_id IN ( SELECT a.id FROM ((SELECT id FROM rail_directory WHERE parent_id = ?) AS a) ) OR id IN ( SELECT b.id FROM ((SELECT id FROM rail_directory WHERE parent_id = ?) AS b) )";
            this.pstm = this.conn.prepareStatement(sql);
            this.pstm.setInt(1, parentId);
            this.pstm.setInt(2, parentId);
            this.pstm.executeUpdate();
            return ResultCode.SUCCESS;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return ResultCode.DELETEFAIL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultCode insertFangxiang(List<FangxiangBean> list) {
        ResultCode resultCode;
        FangxiangBean fangxiangBean;
        this.initConnection();
        if (null != list && !list.isEmpty() && (fangxiangBean = list.get(0)) != null && (resultCode = this.deleteFangxiang(fangxiangBean.getParentId())).getCode() == 405) {
            return resultCode;
        }
        ArrayList<ZhandianBean> zhandianList = new ArrayList<ZhandianBean>(64);
        try {
            String sql = "INSERT INTO rail_directory (id,level,parent_id,name,is_leaf,station_desctiption,position_desctiption,directory_type,status)  VALUES(?,?,?,?,?,?,?,?,?)";
            this.pstm = this.conn.prepareStatement(sql);
            this.conn.setAutoCommit(false);
            for (FangxiangBean fangxiangBean2 : list) {
                this.pstm.setInt(1, fangxiangBean2.getId());
                this.pstm.setInt(2, fangxiangBean2.getLevel());
                this.pstm.setInt(3, fangxiangBean2.getParentId());
                this.pstm.setString(4, fangxiangBean2.getName());
                this.pstm.setInt(5, fangxiangBean2.getType());
                this.pstm.setString(6, fangxiangBean2.getStationLocation());
                this.pstm.setString(7, fangxiangBean2.getPositionLocation());
                this.pstm.setInt(8, fangxiangBean2.getParentId());
                this.pstm.setInt(9, 1);
                zhandianList.addAll(fangxiangBean2.getChildren());
                this.pstm.addBatch();
            }
            this.pstm.executeBatch();
            this.conn.commit();
            this.pstm.clearBatch();
            ResultCode resultCode2 = this.insertZhandian(sql, zhandianList);
            return resultCode2;
        }
        catch (SQLException e) {
            e.printStackTrace();
            ResultCode resultCode3 = ResultCode.INSERTFAIL;
            return resultCode3;
        }
        finally {
            this.releaseConnectn();
        }
    }

    public ResultCode insertZhandian(String sql, List<ZhandianBean> list) {
        ArrayList<PhoneBean> stationPhoneList = new ArrayList<PhoneBean>(64);
        ArrayList<PhoneBean> positionPhoneList = new ArrayList<PhoneBean>(64);
        try {
            this.pstm = this.conn.prepareStatement(sql);
            this.conn.setAutoCommit(false);
            for (ZhandianBean zhandianBean : list) {
                this.pstm.setInt(1, zhandianBean.getId());
                this.pstm.setInt(2, zhandianBean.getLevel());
                this.pstm.setInt(3, zhandianBean.getParentId());
                this.pstm.setString(4, zhandianBean.getName());
                this.pstm.setInt(5, zhandianBean.getType());
                this.pstm.setString(6, zhandianBean.getStationLocation());
                this.pstm.setString(7, zhandianBean.getPositionLocation());
                this.pstm.setInt(8, zhandianBean.getParentId());
                this.pstm.setInt(9, 1);
                if (null != zhandianBean.getStationPhoneList()) {
                    stationPhoneList.addAll(zhandianBean.getStationPhoneList());
                }
                if (null != zhandianBean.getPositionPhoneList()) {
                    positionPhoneList.addAll(zhandianBean.getPositionPhoneList());
                }
                this.pstm.addBatch();
            }
            this.pstm.executeBatch();
            this.conn.commit();
            this.pstm.clearBatch();
            return this.insertPhoneList(stationPhoneList, positionPhoneList);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return ResultCode.INSERTFAIL;
        }
    }

    private ResultCode insertPhoneList(List<PhoneBean> stationPhoneList, List<PhoneBean> positionPhoneList) {
        String sql = "INSERT INTO rail_phone (rail_book_id,phone,discription,type,sort,STATUS)  VALUES  (?,?,?,?,?,?) ";
        try {
            PhoneBean pstationPhoneBean;
            int i;
            this.pstm = this.conn.prepareStatement(sql);
            this.conn.setAutoCommit(false);
            int stationLength = stationPhoneList.size();
            int positionLength = positionPhoneList.size();
            int len = stationLength <= positionLength ? stationLength : positionLength;
            int sqlCount = 0;
            for (i = 0; i < len; ++i) {
                pstationPhoneBean = stationPhoneList.get(i);
                PhoneBean positionPhoneBean = positionPhoneList.get(i);
                this.setSqlParamByPhone(pstationPhoneBean, 1);
                this.pstm.addBatch();
                this.setSqlParamByPhone(positionPhoneBean, 2);
                this.pstm.addBatch();
                sqlCount += 2;
                sqlCount = this.excuteBatchSqlCount(sqlCount);
            }
            if (stationLength > positionLength) {
                while (i < stationLength) {
                    pstationPhoneBean = stationPhoneList.get(i);
                    this.setSqlParamByPhone(pstationPhoneBean, 1);
                    this.pstm.addBatch();
                    ++sqlCount;
                    sqlCount = this.excuteBatchSqlCount(sqlCount);
                    ++i;
                }
            } else if (stationLength < positionLength) {
                while (i < positionLength) {
                    pstationPhoneBean = positionPhoneList.get(i);
                    this.setSqlParamByPhone(pstationPhoneBean, 2);
                    this.pstm.addBatch();
                    ++sqlCount;
                    sqlCount = this.excuteBatchSqlCount(sqlCount);
                    ++i;
                }
            }
            this.pstm.executeBatch();
            this.conn.commit();
            this.pstm.clearBatch();
            return ResultCode.SUCCESS;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return ResultCode.INSERTFAIL;
        }
    }

    private int excuteBatchSqlCount(int sqlCount) throws SQLException {
        if (sqlCount % 1000 == 0) {
            this.pstm.executeBatch();
            this.conn.commit();
            this.pstm.clearBatch();
            sqlCount = 0;
        }
        return sqlCount;
    }

    private void setSqlParamByPhone(PhoneBean pstationPhoneBean, int type) throws SQLException {
        this.pstm.setInt(1, pstationPhoneBean.getRailBookId());
        this.pstm.setString(2, pstationPhoneBean.getPhone());
        this.pstm.setString(3, pstationPhoneBean.getDescription());
        this.pstm.setInt(4, type);
        this.pstm.setInt(5, 0);
        this.pstm.setInt(6, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray getFangxiangJsonArray(int parentId) {
        this.initConnection();
        JSONArray jsonArray = new JSONArray();
        String sql = "SELECT id,name,level FROM rail_directory  WHERE id IN (SELECT  id FROM rail_directory WHERE parent_id = ?) ";
        try {
            this.pstm = this.conn.prepareStatement(sql);
            this.pstm.setInt(1, parentId);
            this.rs = this.pstm.executeQuery();
            ResultSetMetaData rsmd = this.rs.getMetaData();
            while (this.rs.next()) {
                JSONObject json = new JSONObject();
                String colKey = rsmd.getColumnLabel(1);
                Integer id = this.rs.getInt(colKey);
                colKey = rsmd.getColumnLabel(2);
                String name = this.rs.getString(colKey);
                colKey = rsmd.getColumnLabel(3);
                Integer level = this.rs.getInt(colKey);
                json.put("id", (Object)id);
                json.put("text", (Object)name);
                json.put("level", (Object)level);
                JSONObject jsonObj = new JSONObject();
                json.put("attributes", (Object)jsonObj);
                jsonArray.add((Object)json);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseConnectn();
        }
        return jsonArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, XianLuBean> getFangxiang(String sql) {
        this.initConnection();
        FangxiangBean fangxiangBean = new FangxiangBean();
        HashMap<Integer, XianLuBean> xianluMap = new HashMap<Integer, XianLuBean>(16);
        HashMap<Integer, FangxiangBean> map = new HashMap<Integer, FangxiangBean>(32);
        List<FangxiangBean> xianluChildren = null;
        try {
            this.pstm = this.conn.prepareStatement(sql);
            this.rs = this.pstm.executeQuery();
            ZhandianBean bean = new ZhandianBean();
            int lastRailBookId = 0;
            while (this.rs.next()) {
                int id = this.rs.getInt("id");
                if (lastRailBookId == id) {
                    String discriptions = this.rs.getString("discriptions");
                    String phones = this.rs.getString("phones");
                    List<PhoneBean> phoneList = this.getPhoneList(phones, discriptions);
                    if (null == phoneList) continue;
                    bean.setPositionPhoneList(phoneList);
                    continue;
                }
                Integer pId = this.rs.getInt("pId");
                XianLuBean xianLuBean = (XianLuBean)xianluMap.get(pId);
                if (null == xianluMap.get(pId)) {
                    xianLuBean = new XianLuBean();
                    xianLuBean.setId(pId);
                    xianluChildren = xianLuBean.getChildren();
                    String name = RailWayBook.getNameByCode(pId);
                    xianLuBean.setName(name);
                    xianluMap.put(pId, xianLuBean);
                } else {
                    xianluChildren = xianLuBean.getChildren();
                }
                int fangxiangId = this.rs.getInt("parent_id");
                if (null == map.get(fangxiangId)) {
                    fangxiangBean = new FangxiangBean();
                    String fangxiangName = this.rs.getString("fangxiangName");
                    fangxiangBean.setName(fangxiangName);
                    fangxiangBean.setId(fangxiangId);
                    fangxiangBean.setParentId(pId);
                    map.put(fangxiangId, fangxiangBean);
                    xianluChildren.add(fangxiangBean);
                }
                bean = new ZhandianBean();
                bean.setId(id);
                lastRailBookId = id;
                fangxiangBean.getChildren().add(bean);
                bean.setName(this.rs.getString("name"));
                bean.setLevel(this.rs.getInt("level"));
                bean.setType(this.rs.getInt("is_leaf"));
                bean.setStationLocation(this.rs.getString("station_desctiption"));
                String phones = this.rs.getString("phones");
                if (!StringUtils.isNotBlank((String)phones)) continue;
                int type = this.rs.getInt("type");
                String discriptions = this.rs.getString("discriptions");
                List<PhoneBean> phoneList = this.getPhoneList(phones, discriptions);
                if (null == phoneList) continue;
                if (type == 1) {
                    bean.setStationPhoneList(phoneList);
                    continue;
                }
                bean.setPositionPhoneList(phoneList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.releaseConnectn();
        }
        return xianluMap;
    }

    public JSONObject getPhoneListById(String sql, int id) {
        this.initConnection();
        JSONObject json = new JSONObject();
        try {
            json.put("id", (Object)id);
            this.pstm = this.conn.prepareStatement(sql);
            this.pstm.setInt(1, id);
            this.rs = this.pstm.executeQuery();
            while (this.rs.next()) {
                String discriptions;
                int type = this.rs.getInt("type");
                String phones = this.rs.getString("phones");
                List<PhoneBean> phoneList = this.getPhoneList(phones, discriptions = this.rs.getString("discriptions"));
                if (null == phoneList || phoneList.size() == 0) {
                    PhoneBean bean = new PhoneBean();
                    bean.setPhone("\u6682\u65e0");
                    phoneList.add(bean);
                }
                if (type == 1) {
                    json.put("stationPhone", phoneList);
                    continue;
                }
                json.put("posotionPhone", phoneList);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultCode updatePhoneList(int id, List<PhoneBean> stationPhoneList, List<PhoneBean> positionPhoneList) {
        this.initConnection();
        String sql = "delete from rail_phone where rail_book_id = ? ";
        try {
            this.pstm = this.conn.prepareStatement(sql);
            this.pstm.setInt(1, id);
            this.pstm.executeUpdate();
            if (stationPhoneList.size() > 0 || positionPhoneList.size() > 0) {
                this.insertPhoneList(stationPhoneList, positionPhoneList);
            }
            ResultCode resultCode = ResultCode.SUCCESS;
            return resultCode;
        }
        catch (SQLException e) {
            log.error("updatePhoneList\uff1a{}", (Object)"\u66f4\u65b0\u7535\u8bdd\u5217\u8868\u5931\u8d25\u3002");
            e.printStackTrace();
            ResultCode resultCode = ResultCode.UPDATEFAIL;
            return resultCode;
        }
        finally {
            this.releaseConnectn();
        }
    }

    public String getZhanPath(int id) {
        this.initConnection();
        StringBuffer path = new StringBuffer();
        String sql = " SELECT parent_id as parentId,NAME FROM `rail_directory` WHERE id = ?";
        try {
            this.pstm = this.conn.prepareStatement(sql);
            this.pstm.setInt(1, id);
            String name = "";
            String zhanName = "";
            String luxianName = "";
            int parentId = 0;
            this.rs = this.pstm.executeQuery();
            while (this.rs.next()) {
                parentId = this.rs.getInt("parentId");
                zhanName = this.rs.getString("name");
            }
            if (parentId != 0) {
                this.pstm = this.conn.prepareStatement(sql);
                this.pstm.setInt(1, parentId);
                this.rs = this.pstm.executeQuery();
                while (this.rs.next()) {
                    luxianName = this.rs.getString("name");
                }
                String idStr = id + "";
                if (idStr.startsWith("1")) {
                    name = RailWayBook.getNameByCode(100);
                } else if (idStr.startsWith("2")) {
                    name = RailWayBook.getNameByCode(200);
                } else if (idStr.startsWith("3")) {
                    name = RailWayBook.getNameByCode(300);
                } else if (idStr.startsWith("4")) {
                    name = RailWayBook.getNameByCode(400);
                }
            }
            path.append(name).append(">").append(luxianName).append(">").append(zhanName);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return path.toString();
    }
}

