/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.workreport.control;

import com.alibaba.fastjson.JSON;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.syms.service.CommonCodePbService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.xatl.bims.service.UserManageServiceForXatl;
import pams.function.xatl.workreport.bean.WorkReportAdminRelBean;
import pams.function.xatl.workreport.bean.WorkReportAdminSetBean;
import pams.function.xatl.workreport.entity.WorkReportAdminEntity;
import pams.function.xatl.workreport.service.WorkReportAdminSetService;

@Controller
@Scope(value="session")
public class WorkReportAdminSetControl
extends BaseControler {
    private static final Logger logger = LoggerFactory.getLogger(WorkReportAdminSetControl.class);
    @Autowired
    private com.xdja.pams.common.resource.ResourceBundleMessageSource resourceBundleMessageSource;
    @Autowired
    private WorkReportAdminSetService workReportAdminSetService;
    @Autowired
    private UserManageServiceForXatl userManageService;
    @Autowired
    private CommonCodePbService commonCodePbService;

    @RequestMapping(value={"/workReportAdminSet/adminset/index.do"})
    public String index(HttpServletRequest request, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/workReportAdminSet/adminset/queryAdminList.do"})
    public void queryAdminList(HttpServletResponse response, WorkReportAdminSetBean bean) {
        HashMap<String, Serializable> mapBean = new HashMap<String, Serializable>(8);
        try {
            int pageNum = 1;
            int rows = 10;
            try {
                pageNum = Integer.parseInt(bean.getPage());
                rows = Integer.parseInt(bean.getRows());
            }
            catch (Exception e) {
                pageNum = 1;
                rows = 100;
            }
            Page page = new Page(pageNum, rows);
            List<WorkReportAdminEntity> listWork = this.workReportAdminSetService.queryAdminList(bean, page);
            ArrayList listPerson = new ArrayList();
            if (null != listWork && listWork.size() > 0) {
                HashMap<String, Object> map = null;
                for (WorkReportAdminEntity entity : listWork) {
                    Person person = this.userManageService.queryPersonById(entity.getAdminId());
                    List<WorkReportAdminRelBean> listAdminRel = this.workReportAdminSetService.queryAdminRelList(entity.getAdminId());
                    map = new HashMap<String, Object>(8);
                    map.put("id", person.getId());
                    map.put("name", person.getName());
                    map.put("code", person.getCode());
                    map.put("position", this.commonCodePbService.getCodeNameByCode(person.getPosition(), "2011"));
                    map.put("depName", person.getDepartment().getParentDep().getName());
                    map.put("notePersonCount", listAdminRel.size());
                    listPerson.add(map);
                }
            }
            mapBean.put("total", Integer.valueOf(page.getTotal()));
            mapBean.put("rows", listPerson);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5de5\u4f5c\u5199\u5b9e\u7ba1\u7406\u5458\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)JSON.toJSONString(mapBean));
    }

    @RequestMapping(value={"/workReportAdminSet/adminset/toWorkReportAdminSet.do"})
    public String toWorkReportPersonForm(HttpServletRequest request, HttpServletResponse response) {
        try {
            List<WorkReportAdminEntity> listWork = this.workReportAdminSetService.queryAdminList(new WorkReportAdminSetBean(), new Page(1, Integer.MAX_VALUE));
            List<Object> personlist = new ArrayList();
            if (null != listWork && listWork.size() > 0) {
                ArrayList listPerson = new ArrayList();
                listWork.size();
                ArrayList<String> list = new ArrayList<String>();
                for (WorkReportAdminEntity entity : listWork) {
                    list.add(entity.getAdminId());
                }
                personlist = this.userManageService.queryPersonByPersonIds(list);
            }
            request.setAttribute("personList", personlist);
            request.getRequestDispatcher("/bims/GroupManageControler/toGroupMember.do").forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return "workreport/adminset/index";
    }

    @RequestMapping(value={"/workReportAdminSet/adminset/saveWorkReportAdminSet.do"})
    public void saveWorkReportAdminSet(HttpServletResponse response, String adminIds) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            Person loginPerson = this.operator.getPerson();
            this.workReportAdminSetService.saveWorkReportAdminSet(loginPerson, adminIds);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u6216\u66f4\u65b0\u8bbe\u7f6e\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.message.operate.fail"));
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/workReportAdminSet/adminset/deletWorkReportAdminSet.do"})
    public void deletWorkReportAdminSet(HttpServletResponse response, String adminId) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            Person loginPerson = this.operator.getPerson();
            this.workReportAdminSetService.deletWorkReportAdminSet(loginPerson, adminId);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u6216\u66f4\u65b0\u8bbe\u7f6e\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.message.operate.fail"));
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/workReportAdminSet/adminset/toWorkReportAdminRel.do"})
    public String toWorkReportAdminRel(HttpServletRequest request, HttpServletResponse response, ModelMap map, String adminId) {
        try {
            List<WorkReportAdminRelBean> listWork = this.workReportAdminSetService.queryAdminRelList(adminId);
            List<Object> personlist = new ArrayList();
            if (null != listWork && listWork.size() > 0) {
                ArrayList listPerson = new ArrayList();
                listWork.size();
                ArrayList<String> list = new ArrayList<String>();
                for (WorkReportAdminRelBean entity : listWork) {
                    list.add(entity.getPersonId());
                }
                personlist = this.userManageService.queryPersonByPersonIds(list);
            }
            request.setAttribute("personList", personlist);
            request.getRequestDispatcher("/bims/GroupManageControler/toGroupMember.do").forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return "workreport/adminset/index";
    }

    @RequestMapping(value={"/workReportAdminSet/adminset/saveWorkReportAdminRel.do"})
    public void saveWorkReportAdminRel(HttpServletResponse response, String adminId, String personIds) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            Person loginPerson = this.operator.getPerson();
            this.workReportAdminSetService.saveWorkReportAdminRel(loginPerson, adminId, personIds);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg("\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u6216\u66f4\u65b0\u8bbe\u7f6e\u5f02\u5e38", (Throwable)e);
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.message.operate.fail"));
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }
}

