/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.workreport.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;
import pams.function.xatl.workreport.bean.WorkReport;
import pams.function.xatl.workreport.dao.IWorkReportDao;

@Repository
public class WorkReportDaoImpl
implements IWorkReportDao {
    @Resource
    private BaseDao baseDao;

    @Override
    public String save(WorkReport workReport) {
        this.baseDao.saveOrUpdate((Object)workReport);
        return workReport.getId();
    }

    @Override
    public void save(List<WorkReport> workReports) {
    }

    @Override
    public void update(WorkReport workReport) {
        this.baseDao.update((Object)workReport);
    }

    @Override
    public WorkReport get(String id, Integer diff, Integer offset, String accountId, Double reportOrderDate) {
        StringBuilder select = new StringBuilder();
        ArrayList<Object> values = new ArrayList<Object>();
        select.append(" from WorkReport where accountId = ? ");
        values.add(accountId);
        if (diff >= 0) {
            select.append("and reportOrderDate >= ? ORDER BY reportOrderDate ASC ");
            values.add(reportOrderDate);
        } else {
            select.append(" and reportOrderDate <= ? ORDER BY reportOrderDate DESC ");
            values.add(reportOrderDate);
        }
        String selectCount = "select count(*) " + select.toString();
        List list = this.baseDao.getListByHQL(selectCount, select.toString(), values.toArray(), new Page(offset + 1, 1));
        return null != list && list.size() > 0 ? (WorkReport)list.get(0) : null;
    }

    @Override
    public List<WorkReport> get(String[] ids) {
        StringBuilder select = new StringBuilder();
        ArrayList<String> values = new ArrayList<String>();
        select.append("from WorkReport t where 1 = 1 ");
        if (null != ids && ids.length > 0) {
            for (String id : ids) {
                select.append(" or id = ? ");
                values.add(id);
            }
        }
        return this.baseDao.getListByHQL(select.toString(), values.toArray());
    }

    @Override
    public WorkReport get(String workReportId) {
        return (WorkReport)this.baseDao.getObjectById(WorkReport.class, (Serializable)((Object)workReportId));
    }

    @Override
    public int leftCount(String accountId, Double id) {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(accountId);
        values.add(id);
        Number rst = (Number)this.baseDao.getObjectByHQL("SELECT count(*) from WorkReport WHERE accountId = ? AND reportOrderDate < ? ", values.toArray());
        return rst.intValue();
    }

    @Override
    public int rightCount(String accountId, Double id) {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(accountId);
        values.add(id);
        Number rst = (Number)this.baseDao.getObjectByHQL("SELECT count(*) from WorkReport WHERE accountId = ? AND reportOrderDate < ? ", values.toArray());
        return rst.intValue();
    }

    @Override
    public List<WorkReport> listDetail(Long startDate, String accountId) {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(startDate);
        values.add(accountId);
        String sb = "from WorkReport  where reportDate = ?  and accountId = ? ";
        return this.baseDao.getListByHQL(sb, values.toArray());
    }

    @Override
    public List<WorkReport> atMeList(String accountId, long time) {
        StringBuilder sb = new StringBuilder("FROM WorkReport ");
        sb.append(" WHERE atIds LIKE '%").append(accountId).append("%'");
        if (time > 0L) {
            sb.append(" and createTime < ").append(time);
        }
        sb.append(" ORDER BY createTime DESC ");
        return this.baseDao.getListByHQL("SELECT count(*) " + sb.toString(), sb.toString(), null, new Page(1, 10));
    }

    @Override
    public void del(String id) {
        WorkReport workReport = this.get(id);
        this.baseDao.delete((Object)workReport);
    }

    @Override
    public List<WorkReport> reportMonth(Long startDate, Long endDate, String accountId) {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(accountId);
        values.add(startDate);
        values.add(endDate);
        String select = "SELECT bwr.c_id id, bwr.c_content content, bda.c_operate_content operateContent, bwr.n_report_date reportDate FROM t_business_work_report bwr LEFT JOIN t_business_work_report_approva bda ON bwr.c_id = bda.c_work_report_id WHERE bwr.c_account_id = ? AND bwr.n_report_date >= ? AND bwr.n_report_date <= ? ORDER BY n_report_date ASC ";
        List list = this.baseDao.getListBySQL(select, values.toArray(), Map.class);
        ArrayList<WorkReport> listWorkReport = new ArrayList<WorkReport>();
        if (null != list && list.size() > 0) {
            WorkReport workReport = null;
            for (Map map : list) {
                workReport = new WorkReport();
                String id = map.get("ID") == null ? null : map.get("ID") + "";
                String content = map.get("CONTENT") == null ? null : map.get("CONTENT") + "";
                String operaterContent = map.get("OPERATECONTENT") == null ? null : map.get("OPERATECONTENT") + "";
                String reportDate = map.get("REPORTDATE") == null ? null : map.get("REPORTDATE") + "";
                workReport.setId(id);
                workReport.setContent(content);
                workReport.setOperateContent(operaterContent);
                assert (reportDate != null);
                workReport.setReportDate(Long.parseLong(reportDate));
                listWorkReport.add(workReport);
            }
        }
        return listWorkReport;
    }
}

