/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.workreport.rpcMethod;

import com.alibaba.fastjson.JSON;
import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.xatl.ruyihu.jsonrpc.AbstractLakeMobMethod;
import pams.function.xatl.ruyihu.jsonrpc.SuperRequest;
import pams.function.xatl.workreport.bean.DeptResponse;
import pams.function.xatl.workreport.bean.EmployeeResponse;
import pams.function.xatl.workreport.bean.WorkReportAdminRelBean;
import pams.function.xatl.workreport.constans.RedisConstants;
import pams.function.xatl.workreport.service.IAccountFollowService;
import pams.function.xatl.workreport.service.WorkReportAdminSetService;
import pams.function.xatl.workreport.util.DateUtil;
import pams.function.xatl.workreport.util.RedisUtil;

@Service
public class ControlDept
extends AbstractLakeMobMethod {
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private WorkReportAdminSetService workReportAdminSetService;
    @Autowired
    private IAccountFollowService accountFollowService;
    private RedisUtil.Strings strings = new RedisUtil.Strings(RedisUtil.getInstance());

    @Override
    protected Object execute0(String currentUser, SuperRequest request) throws Exception {
        this.logger.debug("ControlDept \u6211\u7684\u7ba1\u8f96\u90e8\u95e8\uff08\u6c47\u62a5\u6279\u6ce8\uff09>>>currentUser: \u3010{}\u3011, params: \u3010{}\u3011", (Object)currentUser, (Object)request.toJsonString());
        String deptId = request.needText("deptId", "");
        HashMap map = new HashMap(50);
        ArrayList<DeptResponse> listDept = new ArrayList<DeptResponse>();
        ArrayList<EmployeeResponse> listEmployee = new ArrayList<EmployeeResponse>();
        if (StringUtils.isBlank((CharSequence)deptId)) {
            List<WorkReportAdminRelBean> listWorkReportAdminRel = this.workReportAdminSetService.queryAdminRelList(currentUser);
            if (null != listWorkReportAdminRel && listWorkReportAdminRel.size() > 0) {
                HashMap<String, Department> mapDept = new HashMap<String, Department>(50);
                for (WorkReportAdminRelBean workReportAdminRelBean : listWorkReportAdminRel) {
                    String personId = workReportAdminRelBean.getPersonId();
                    Person person = this.userManageService.queryPersonById(personId);
                    if (!"0".equals(person.getFlag())) continue;
                    Department department = person.getDepartment();
                    mapDept.put(department.getId(), department);
                }
                if (mapDept.size() > 0) {
                    DeptResponse deptResponse = null;
                    for (String key : mapDept.keySet()) {
                        Department department = (Department)mapDept.get(key);
                        deptResponse = new DeptResponse();
                        deptResponse.setId(department.getId());
                        deptResponse.setName(department.getName());
                        listDept.add(deptResponse);
                    }
                }
            }
        } else {
            List<EmployeeResponse> list = this.workReportAdminSetService.queryAdminRelListByDeptId(currentUser, deptId);
            if (null != list && list.size() > 0) {
                for (EmployeeResponse employeeResponse : list) {
                    Person person;
                    if (currentUser.equals(employeeResponse.getId()) || "1".equals((person = this.userManageService.queryPersonById(employeeResponse.getId())).getFlag())) continue;
                    boolean isFollow = this.accountFollowService.queryAdminIsFollowEmploy(currentUser, employeeResponse.getId());
                    employeeResponse.setIsFollow(isFollow);
                    Map<String, Object> followAccountReportMap = this.getFollowAccountReportMap(currentUser, employeeResponse.getId(), employeeResponse.getName());
                    employeeResponse.setFinalReportDate(String.valueOf(followAccountReportMap.get("finalReportDate")));
                    employeeResponse.setIsUpdate(Boolean.parseBoolean(String.valueOf(followAccountReportMap.get("isUpdate"))));
                    listEmployee.add(employeeResponse);
                }
            }
        }
        map.put("deptList", listDept);
        map.put("employeeList", listEmployee);
        this.logger.debug("ControlDept \u6211\u7684\u7ba1\u8f96\u90e8\u95e8\uff08\u6c47\u62a5\u6279\u6ce8\uff09<<<currentUser: \u3010{}\u3011, params: \u3010{}\u3011, resp: \u3010{}\u3011", new Object[]{currentUser, request.toJsonString(), JSON.toJSONString(map)});
        return map;
    }

    private Map<String, Object> getFollowAccountReportMap(String accountId, String followAccountId, String followAccountName) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(50);
        String reportDateAndCreateTime = this.strings.get(RedisConstants.getBusinessWorkReportKey(followAccountId));
        if (StringUtils.isNotBlank((CharSequence)reportDateAndCreateTime) && reportDateAndCreateTime.split("\\|").length == 2) {
            String[] reportDateAndCreateTimeArray = reportDateAndCreateTime.split("\\|");
            String reportDate = reportDateAndCreateTimeArray[0];
            this.logger.debug("reportDate{}", (Object)reportDate);
            String monthDate = reportDate.substring(4);
            StringBuilder sb = new StringBuilder(monthDate);
            sb.insert(2, "-");
            this.logger.debug("\u8fd4\u56de\u7ed9\u7ec8\u7aef\u5c55\u793a\u65e5\u671f{}", (Object)sb.toString());
            String reportCreateTime = reportDateAndCreateTimeArray[1];
            resultMap.put("finalReportDate", sb.toString());
            int criticalValueUpdateReport = 5;
            Date today = DateUtil.getTodayZeroHour();
            if (DateUtil.givedTimeToBeforeOrAfter(reportDate, criticalValueUpdateReport * 86400, "yyyyMMdd").getTime() >= today.getTime()) {
                String businessWorkReportControllerBrowse = this.strings.get(RedisConstants.getBusinessWorkReportControllerBrowseKey(accountId, followAccountId));
                if (StringUtils.isNotBlank((CharSequence)businessWorkReportControllerBrowse) && Long.parseLong(reportCreateTime) < Long.parseLong(businessWorkReportControllerBrowse)) {
                    resultMap.put("isUpdate", Boolean.FALSE);
                } else {
                    resultMap.put("isUpdate", Boolean.TRUE);
                }
            } else {
                resultMap.put("isUpdate", Boolean.FALSE);
            }
        } else {
            this.logger.warn("\u5458\u5de5{}\u6ca1\u6709\u5de5\u4f5c\u6c47\u62a5", (Object)followAccountName);
            resultMap.put("finalReportDate", "");
            resultMap.put("isUpdate", Boolean.FALSE);
        }
        return resultMap;
    }
}

