/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.workreport.rpcMethod;

import com.alibaba.fastjson.JSON;
import com.xdja.pams.common.util.Page;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.xatl.ruyihu.jsonrpc.AbstractLakeMobMethod;
import pams.function.xatl.ruyihu.jsonrpc.SuperRequest;
import pams.function.xatl.workreport.bean.EmployeeResponse;
import pams.function.xatl.workreport.constans.RedisConstants;
import pams.function.xatl.workreport.service.IAccountFollowService;
import pams.function.xatl.workreport.service.WorkReportAdminSetService;
import pams.function.xatl.workreport.util.DateUtil;
import pams.function.xatl.workreport.util.RedisUtil;

@Service
public class QueryControlEmployee
extends AbstractLakeMobMethod {
    @Autowired
    private WorkReportAdminSetService workReportAdminSetService;
    @Autowired
    private IAccountFollowService accountFollowService;
    private RedisUtil.Strings strings = new RedisUtil.Strings(RedisUtil.getInstance());

    @Override
    protected Object execute0(String currentUser, SuperRequest request) throws Exception {
        this.logger.debug("QueryControlEmployee \u7ba1\u8f96\u90e8\u95e8\u4eba\u5458\u67e5\u8be2\uff08\u6c47\u62a5\u6279\u6ce8\uff09>>>currentUser: \u3010{}\u3011, params: \u3010{}\u3011", (Object)currentUser, (Object)request.toJsonString());
        String key = request.needText("key");
        int pageNo = request.needInt("pageNo", 1);
        int pageSize = request.needInt("pageSize", 10);
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        Page page = new Page(pageNo, pageSize);
        List<EmployeeResponse> employeeList = this.workReportAdminSetService.queryAdminRelListByCondition(currentUser, key, page);
        if (employeeList != null && employeeList.size() > 0) {
            for (EmployeeResponse employeeResponse : employeeList) {
                boolean isFollow = this.accountFollowService.queryAdminIsFollowEmploy(currentUser, employeeResponse.getId());
                employeeResponse.setIsFollow(isFollow);
                Map<String, Object> followAccountReportMap = this.getFollowAccountReportMap(currentUser, employeeResponse.getId(), employeeResponse.getName());
                employeeResponse.setFinalReportDate(String.valueOf(followAccountReportMap.get("finalReportDate")));
                employeeResponse.setIsUpdate(Boolean.parseBoolean(String.valueOf(followAccountReportMap.get("isUpdate"))));
            }
        }
        boolean hasMore = false;
        if (page.getPageCount() > pageNo) {
            hasMore = true;
        }
        map.put("list", employeeList);
        map.put("hasMore", hasMore);
        this.logger.debug("QueryControlEmployee \u7ba1\u8f96\u90e8\u95e8\u4eba\u5458\u67e5\u8be2\uff08\u6c47\u62a5\u6279\u6ce8\uff09<<<currentUser: \u3010{}\u3011, params: \u3010{}\u3011, resp: \u3010{}\u3011", new Object[]{currentUser, request.toJsonString(), JSON.toJSONString(map)});
        return map;
    }

    private Map<String, Object> getFollowAccountReportMap(String accountId, String followAccountId, String followAccountName) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        String reportDateAndCreateTime = this.strings.get(RedisConstants.getBusinessWorkReportKey(followAccountId));
        int dateLen = 2;
        String splitChars = "\\|";
        if (!StringUtils.isEmpty((CharSequence)reportDateAndCreateTime) && reportDateAndCreateTime.split(splitChars).length == dateLen) {
            String[] reportDateAndCreateTimeArray = reportDateAndCreateTime.split(splitChars);
            String reportDate = reportDateAndCreateTimeArray[0];
            this.logger.debug("reportDate{}", (Object)reportDate);
            String monthDate = reportDate.substring(4);
            StringBuilder sb = new StringBuilder(monthDate);
            sb.insert(2, "-");
            this.logger.debug("\u8fd4\u56de\u7ed9\u7ec8\u7aef\u5c55\u793a\u65e5\u671f{}", (Object)sb.toString());
            String reportCreateTime = reportDateAndCreateTimeArray[1];
            resultMap.put("finalReportDate", sb.toString());
            int criticalValueUpdateReport = 5;
            Date today = DateUtil.getTodayZeroHour();
            if (Objects.requireNonNull(DateUtil.givedTimeToBeforeOrAfter(reportDate, criticalValueUpdateReport * 24 * 60 * 60, "yyyyMMdd")).getTime() >= today.getTime()) {
                String businessWorkReportControllerBrowse = this.strings.get(RedisConstants.getBusinessWorkReportControllerBrowseKey(accountId, followAccountId));
                if (!StringUtils.isEmpty((CharSequence)businessWorkReportControllerBrowse) && Long.parseLong(reportCreateTime) < Long.parseLong(businessWorkReportControllerBrowse)) {
                    resultMap.put("isUpdate", Boolean.FALSE);
                } else {
                    resultMap.put("isUpdate", Boolean.TRUE);
                }
            } else {
                resultMap.put("isUpdate", Boolean.FALSE);
            }
        } else {
            this.logger.warn("\u5458\u5de5{}\u6ca1\u6709\u5de5\u4f5c\u6c47\u62a5", (Object)followAccountName);
            resultMap.put("finalReportDate", "");
            resultMap.put("isUpdate", Boolean.FALSE);
        }
        return resultMap;
    }
}

