/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.workreport.rpcMethod;

import com.alibaba.fastjson.JSON;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.xatl.ruyihu.jsonrpc.AbstractLakeMobMethod;
import pams.function.xatl.ruyihu.jsonrpc.SuperRequest;
import pams.function.xatl.ruyihu.service.LakeMobPushService;
import pams.function.xatl.workreport.bean.WorkReport;
import pams.function.xatl.workreport.bean.WorkReportApprova;
import pams.function.xatl.workreport.service.IWorkReportApprovaService;
import pams.function.xatl.workreport.service.IWorkReportService;

@Service
public class ReportApproval
extends AbstractLakeMobMethod {
    @Autowired
    private IWorkReportApprovaService workReportApprovaService;
    @Autowired
    private IWorkReportService workReportService;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private LakeMobPushService lakeMobPushService;
    private final Pattern pattern = Pattern.compile("\\$`[a-zA-Z0-9]{1,}[@].*?`\\$");

    @Override
    protected Object execute0(String currentUser, SuperRequest request) throws Exception {
        String approvaContent;
        String atContent;
        this.logger.debug("ReportApproval \u5de5\u4f5c\u6c47\u62a5\u6279\u6ce8>>>currentUser: \u3010{}\u3011, params: \u3010{}\u3011", (Object)currentUser, (Object)request.toJsonString());
        String workReportId = request.needText("workReportId");
        String operateContent = request.needText("operateContent");
        int operateType = request.needInt("operateType");
        String operateTargeAccountId = request.needText("operateTargeAccountId", "");
        int replyApprovalContentType = 2;
        if (operateType == replyApprovalContentType && !org.springframework.util.StringUtils.hasText((String)operateTargeAccountId)) {
            throw new IllegalArgumentException("\u4f20\u9012\u53c2\u6570\u975e\u6cd5");
        }
        int max = 300;
        if (operateContent.length() > max) {
            throw new IllegalArgumentException("\u4f20\u9012\u53c2\u6570\u975e\u6cd5");
        }
        WorkReport workReport = this.workReportService.getAccountIdByWorkId(workReportId);
        if (workReport == null) {
            throw new IllegalArgumentException("\u5ba1\u6279\u6216\u56de\u590d\u7684\u5de5\u4f5c\u6c47\u62a5\u4e0d\u5b58\u5728");
        }
        Person currentUserPerson = this.userManageService.queryPersonById(currentUser);
        WorkReportApprova workReportApprova = new WorkReportApprova();
        workReportApprova.setWorkReportId(workReportId);
        workReportApprova.setOperateType(operateType);
        workReportApprova.setOperateTargeAccountId(operateTargeAccountId);
        workReportApprova.setOperateContent(operateContent);
        workReportApprova.setOperateAccountId(currentUser);
        workReportApprova.setOperateAccountName(currentUserPerson.getName());
        String approvalId = this.workReportApprovaService.save(workReportApprova);
        Matcher matcher = this.pattern.matcher(operateContent);
        ArrayList<String> atIdTmpList = new ArrayList<String>();
        while (matcher.find()) {
            atIdTmpList.add(matcher.group());
        }
        ArrayList<String> atIdList = new ArrayList<String>();
        if (atIdTmpList.size() > 0) {
            for (String str : atIdTmpList) {
                String[] split = str.split("@");
                String id = split[0].replace("$`", "");
                Person person = this.userManageService.queryPersonById(id);
                if (person == null) continue;
                atIdList.add(id);
            }
        }
        if (workReportApprova.getOperateType() == 1) {
            if (atIdList.size() > 0) {
                atContent = "\u6709\u4eba\u7684\u5de5\u4f5c\u5199\u5b9e\u6279\u793a\u4e2d\u63d0\u5230\u4e86\u60a8";
                this.lakeMobPushService.pushWorkReport(StringUtils.join(atIdList, (String)","), atContent, workReport.getId());
            }
            if (!workReportApprova.getOperateAccountId().equals(workReport.getAccountId())) {
                approvaContent = "\u6709\u4eba\u6279\u793a\u4e86\u60a8\u7684\u5de5\u4f5c\u5199\u5b9e";
                this.lakeMobPushService.pushWorkReport(workReport.getAccountId(), approvaContent, workReport.getId());
            }
        } else {
            if (atIdList.size() > 0) {
                atContent = "\u6709\u4eba\u7684\u5de5\u4f5c\u5199\u5b9e\u56de\u590d\u4e2d\u63d0\u5230\u4e86\u60a8";
                this.lakeMobPushService.pushWorkReport(StringUtils.join(atIdList, (String)","), atContent, workReport.getId());
            }
            if (workReport.getAccountId().equals(workReportApprova.getOperateTargeAccountId())) {
                approvaContent = "\u6709\u4eba\u56de\u590d\u4e86\u60a8\u7684\u6279\u793a";
                this.lakeMobPushService.pushWorkReport(workReportApprova.getOperateTargeAccountId(), approvaContent, workReport.getId());
            } else {
                approvaContent = "\u6709\u4eba\u56de\u590d\u4e86\u60a8\u7684\u6279\u793a";
                this.lakeMobPushService.pushWorkReport(workReportApprova.getOperateTargeAccountId(), approvaContent, workReport.getId());
            }
            if (workReportApprova.getOperateAccountId().equals(workReportApprova.getOperateTargeAccountId())) {
                throw new IllegalArgumentException("\u4e0d\u80fd\u56de\u590d\u81ea\u5df1");
            }
        }
        WorkReportApprova approva1 = this.workReportApprovaService.get(approvalId);
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("id", approva1.getId());
        map.put("operateContent", approva1.getOperateContent());
        map.put("operateAccountId", approva1.getOperateAccountId());
        map.put("operateAccountName", approva1.getOperateAccountName());
        map.put("operateTargetAccountId", approva1.getOperateTargeAccountId());
        map.put("operateTargetAccountName", approva1.getOperateTargeAccountName());
        if (workReportApprova.getOperateType() == 1) {
            map.put("operateTargeAccountAvatar", "");
        }
        map.put("operateType", approva1.getOperateType());
        map.put("createTime", approva1.getCreateTime());
        this.logger.debug("ReportApproval \u5de5\u4f5c\u6c47\u62a5\u6279\u6ce8<<<currentUser: \u3010{}\u3011, params: \u3010{}\u3011\uff0c resp: \u3010{}\u3011", new Object[]{currentUser, request.toJsonString(), JSON.toJSONString(map)});
        return map;
    }
}

