/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.workreport.rpcMethod;

import com.alibaba.fastjson.JSON;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import pams.function.xatl.ruyihu.jsonrpc.AbstractLakeMobMethod;
import pams.function.xatl.ruyihu.jsonrpc.SuperRequest;
import pams.function.xatl.ruyihu.util.LakeMobException;
import pams.function.xatl.workreport.bean.WorkReport;
import pams.function.xatl.workreport.service.IWorkReportService;
import pams.function.xatl.workreport.util.FileServerUtil;

@Service
public class ReportDetail
extends AbstractLakeMobMethod {
    @Resource
    private IWorkReportService workReportService;
    @Resource
    private UserManageService userManageService;

    @Override
    protected Object execute0(String currentUser, SuperRequest request) throws Exception {
        this.logger.debug("ReportDetail \u5de5\u4f5c\u6c47\u62a5\u8be6\u60c5>>>currentUser: \u3010{}\u3011, params: \u3010{}\u3011", (Object)currentUser, (Object)request.toJsonString());
        String id = request.needText("id");
        Integer diff = request.needInt("diff");
        this.logger.debug("\u5de5\u4f5c\u6c47\u62a5\u8be6\u60c5\uff1aid\uff1a{} ,diff{}", (Object)id, (Object)diff);
        if (null == id) {
            this.logger.error("\u4f20\u9012\u53c2\u6570\u975e\u6cd5: id\u548cdiff\u4e0d\u80fd\u4e3a\u7a7a");
            throw new IllegalArgumentException("\u4f20\u9012\u53c2\u6570\u975e\u6cd5");
        }
        WorkReport workReport = this.workReportService.get(id, diff, currentUser);
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        if (workReport == null) {
            return map;
        }
        Person employee = this.userManageService.queryPersonById(workReport.getAccountId());
        if (employee == null) {
            throw new LakeMobException("\u8be5\u4eba\u5458\u4e0d\u5b58\u5728");
        }
        String delete = "1";
        if (delete.equals(employee.getFlag())) {
            throw new LakeMobException("\u8be5\u4eba\u5458\u8d26\u53f7\u5df2\u6ce8\u9500");
        }
        map.put("name", employee.getName());
        map.put("workReportId", workReport.getId());
        map.put("content", workReport.getContent());
        map.put("createTime", workReport.getCreateTime());
        map.put("reportDate", workReport.getReportDate());
        Map map1 = null;
        if (StringUtils.isNotBlank((CharSequence)workReport.getCoordinate())) {
            map1 = (Map)JSON.parseObject((String)workReport.getCoordinate(), Map.class);
        }
        map.put("coordinate", map1);
        map.put("approvalList", workReport.getWorkReportApprovas());
        map.put("reportBrowseList", workReport.getWorkReportBrowses());
        map.put("hasFiles", null != workReport.getFiles() && workReport.getFiles().size() > 0);
        StringBuilder atNamesSB = new StringBuilder();
        String atNames = workReport.getAtNames();
        if (workReport.getAtIds() != null && workReport.getAtIds().contains(currentUser)) {
            this.logger.debug("@\u6709\u81ea\u5df1");
            int i = 0;
            String[] split = workReport.getAtIds().split(",");
            for (i = 0; i < split.length && !split[i].equals(currentUser); ++i) {
            }
            String[] splitName = atNames.split(",");
            for (int j = 0; j < splitName.length; ++j) {
                if (j == i) {
                    splitName[j] = "\u6211";
                }
                if (j == 0) {
                    atNamesSB.append(splitName[j]);
                    continue;
                }
                atNamesSB.append("\uff0c");
                atNamesSB.append(splitName[j]);
            }
            this.logger.debug("\u66ff\u6362\u540e\u503c\u4e3a:{}", (Object)atNamesSB.toString());
        } else {
            this.logger.debug("@\u6ca1\u6709\u81ea\u5df1\u7684");
            if (org.springframework.util.StringUtils.hasText((String)atNames)) {
                String comma = ",";
                if (atNames.contains(comma)) {
                    atNamesSB.append(atNames.replaceAll(comma, "\uff0c"));
                } else {
                    atNamesSB.append(atNames);
                }
            }
            this.logger.debug("\u66ff\u6362\u540e\u503c\u4e3a:{}", (Object)atNamesSB.toString());
        }
        map.put("atNames", atNamesSB.toString());
        map.put("files", FileServerUtil.getFileList(workReport.getFiles()));
        map.put("leftCount", workReport.getLeftCount());
        map.put("rightCount", workReport.getRightCount());
        this.logger.debug("ReportDetail \u5de5\u4f5c\u6c47\u62a5\u8be6\u60c5<<<currentUser: \u3010{}\u3011, params: \u3010{}\u3011\uff0c resp: \u3010{}\u3011", new Object[]{currentUser, request.toJsonString(), JSON.toJSONString(map)});
        return map;
    }
}

