/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.workreport.rpcMethod;

import com.alibaba.fastjson.JSON;
import com.xdja.pams.bims.entity.Person;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import pams.function.xatl.bims.service.UserManageServiceForXatl;
import pams.function.xatl.ruyihu.jsonrpc.AbstractLakeMobMethod;
import pams.function.xatl.ruyihu.jsonrpc.SuperRequest;
import pams.function.xatl.ruyihu.service.LakeMobPushService;
import pams.function.xatl.ruyihu.util.LakeMobException;
import pams.function.xatl.workreport.bean.Attachment;
import pams.function.xatl.workreport.bean.WorkReportReponse;
import pams.function.xatl.workreport.service.IWorkReportService;
import pams.function.xatl.workreport.util.ArithUtil;
import pams.function.xatl.workreport.util.FileServerUtil;

@Service
public class WorkReport
extends AbstractLakeMobMethod {
    @Resource
    private UserManageServiceForXatl userManageService;
    @Resource
    private IWorkReportService service;
    @Resource
    private LakeMobPushService lakeMobPushService;

    @Override
    protected Object execute0(String currentUser, SuperRequest request) throws Exception {
        this.logger.debug("WorkReport \u4fdd\u5b58\u5de5\u4f5c\u6c47\u62a5>>>currentUser: \u3010{}\u3011, params: \u3010{}\u3011", (Object)currentUser, (Object)request.toJsonString());
        Long reportDate = request.needLong("reportDate");
        String content = request.needText("content");
        String coordinate = request.needText("coordinate", "");
        String atIds = request.needText("atIds", "");
        List<Attachment> files = request.needList("files", Attachment.class);
        if (!StringUtils.hasText((String)content) && files == null) {
            this.logger.error("\u4f20\u9012\u53c2\u6570\u975e\u6cd5\uff0c\u56fe\u7247\u548c\u5185\u5bb9\u5fc5\u4f20\u5176\u4e00");
            throw new IllegalArgumentException("\u4f20\u9012\u53c2\u6570\u975e\u6cd5\uff0c\u56fe\u7247\u548c\u5185\u5bb9\u5fc5\u4f20\u5176\u4e00");
        }
        if (StringUtils.hasText((String)content) && content.length() > 2000) {
            this.logger.error("\u8d85\u8fc7\u6700\u5927\u9650\u6b21\u5b57\u6570");
            throw new IllegalArgumentException("\u8d85\u8fc7\u6700\u5927\u9650\u6b21\u5b57\u6570");
        }
        if (files != null && files.size() > 9) {
            this.logger.error("\u8d85\u8fc7\u6700\u5927\u9650\u6b21\u9644\u4ef6\u6570\u91cf");
            throw new IllegalArgumentException("\u8d85\u8fc7\u6700\u5927\u9650\u6b21\u9644\u4ef6\u6570\u91cf");
        }
        pams.function.xatl.workreport.bean.WorkReport workReport = new pams.function.xatl.workreport.bean.WorkReport();
        workReport.setAtIds(atIds);
        workReport.setReportDate(reportDate);
        workReport.setContent(content);
        workReport.setCoordinate(coordinate);
        workReport.setFiles(files);
        workReport.setAccountId(currentUser);
        workReport.setCreateTime(System.currentTimeMillis());
        List<pams.function.xatl.workreport.bean.WorkReport> workReports = this.service.listByDate(workReport.getReportDate(), currentUser);
        workReport.setReportOrderDate(ArithUtil.add(0.01 * (double)workReports.size(), workReport.getReportDate().longValue()));
        if (workReports.size() >= 10) {
            this.logger.error("\u5df2\u8d85\u8fc7\u6700\u5927\u5de5\u4f5c\u6c47\u62a5\u6b21\u6570");
            throw new LakeMobException("\u5df2\u8d85\u8fc7\u6700\u5927\u5de5\u4f5c\u6c47\u62a5\u6b21\u6570");
        }
        String s2 = "";
        if (StringUtils.hasText((String)atIds)) {
            List<Person> employees;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("@\u7684\u4eba\u5458ids:{}", (Object)workReport.getAtIds());
            }
            String[] ids = workReport.getAtIds().split(",");
            List<String> personIds = Arrays.asList(ids);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("@\u7684\u4eba\u5458ids:{}", JSON.toJSON((Object)ids));
            }
            if ((employees = this.userManageService.queryPersonByPersonIds(personIds)) != null && !employees.isEmpty()) {
                ArrayList<String> names = new ArrayList<String>();
                ArrayList<String> employeeIds = new ArrayList<String>();
                for (Person employee : employees) {
                    if ("0".equals(employee.getFlag())) {
                        names.add(employee.getName());
                        employeeIds.add(employee.getId());
                        continue;
                    }
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("employee.getDeleteFlag() == 0 && employee.getCompanyId().longValue() == atv.getCompanyId().longValue():{}", (Object)"0".equals(employee.getFlag()));
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("@\u7684\u4eba\u5458ids{}, @\u7684\u4eba\u5458names{}", JSON.toJSON(names), JSON.toJSON(employeeIds));
                }
                String s1 = StringUtils.collectionToCommaDelimitedString(names);
                s2 = StringUtils.collectionToCommaDelimitedString(employeeIds);
                workReport.setAtIds(s2);
                workReport.setAtNames(s1);
            } else {
                workReport.setAtIds(null);
                workReport.setAtNames(null);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u4fdd\u5b58\u5de5\u4f5c\u6c47\u62a5\u5bf9\u8c61\u4e3a:{}", JSON.toJSON((Object)workReport));
        }
        String save = this.service.save(workReport);
        if (StringUtils.hasText((String)s2)) {
            String pushContent = "\u6709\u4eba\u7684\u5de5\u4f5c\u5199\u5b9e\u63d0\u5230\u4e86\u60a8";
            this.lakeMobPushService.pushWorkReport(s2, pushContent, save);
        }
        WorkReportReponse workReportReponse = new WorkReportReponse();
        workReportReponse.setContent(workReport.getContent());
        List<pams.function.xatl.workreport.bean.WorkReport> workReportsize = this.service.listByDate(workReport.getReportDate(), currentUser);
        workReportReponse.setWrite(workReportsize.size() < 10);
        workReportReponse.setIsEmpty(false);
        workReportReponse.setId(String.valueOf(save));
        workReportReponse.setReportBrowseCount(0);
        workReportReponse.setReportApprovalCount(0);
        Map map = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)workReport.getCoordinate())) {
            map = (Map)JSON.parseObject((String)workReport.getCoordinate(), Map.class);
        }
        workReportReponse.setCoordinate(map);
        workReportReponse.setCreateTime(System.currentTimeMillis());
        workReportReponse.setReportDate(workReport.getReportDate() + "");
        List<Map<String, Object>> fileList = FileServerUtil.getFileList(workReport.getFiles());
        workReportReponse.setFiles(fileList);
        workReportReponse.setHasFiles(fileList.size() > 0);
        this.logger.debug("WorkReport \u4fdd\u5b58\u5de5\u4f5c\u6c47\u62a5<<<currentUser: \u3010{}\u3011, params: \u3010{}\u3011, resp: \u3010{}\u3011", new Object[]{currentUser, request.toJsonString(), JSON.toJSONString((Object)workReportReponse)});
        return workReportReponse;
    }
}

