/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.workreport.service.impl;

import com.xdja.pams.bims.entity.Department;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.report.bean.QueryForm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pams.function.xatl.bims.service.DepManageServiceForXatl;
import pams.function.xatl.workreport.bean.EmployeeResponse;
import pams.function.xatl.workreport.bean.WorkReportAdminRelBean;
import pams.function.xatl.workreport.bean.WorkReportAdminSetBean;
import pams.function.xatl.workreport.dao.WorkReportAdminSetDao;
import pams.function.xatl.workreport.entity.WorkReportAdminEntity;
import pams.function.xatl.workreport.service.IAccountFollowService;
import pams.function.xatl.workreport.service.WorkReportAdminSetService;

@Service
public class WorkReportAdminSetServiceImpl
implements WorkReportAdminSetService {
    @Autowired
    private DepManageServiceForXatl depManageService;
    @Autowired
    private WorkReportAdminSetDao workReportAdminSetDao;
    @Autowired
    private IAccountFollowService accountFollowService;

    @Override
    public List<WorkReportAdminEntity> queryAdminList(WorkReportAdminSetBean bean, Page page) {
        StringBuffer bufferDepId = new StringBuffer();
        if (StringUtils.isNotBlank((CharSequence)bean.getDepName())) {
            Page pageDep = new Page(1, Integer.MAX_VALUE);
            QueryForm queryForm = new QueryForm();
            queryForm.setName(bean.getDepName());
            List<Department> listDep = this.depManageService.queryDepartmentListByCondition(queryForm, pageDep);
            if (null != listDep && listDep.size() > 0) {
                for (Department dep : listDep) {
                    String depId = dep.getId();
                    if ("org".equals(dep.getDepType())) {
                        List<Department> list = this.getAllDepId(depId, bufferDepId);
                        continue;
                    }
                    bufferDepId.append("'" + depId + "',");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)bufferDepId.toString())) {
                bean.setDepId(bufferDepId.toString().substring(0, bufferDepId.length() - 1));
            } else {
                bean.setDepId("'noDep'");
            }
        }
        return this.workReportAdminSetDao.queryWorkAdminList(bean, page);
    }

    @Override
    public List<WorkReportAdminRelBean> queryAdminRelList(String adminPersonId) {
        return this.workReportAdminSetDao.queryAdminRelList(adminPersonId);
    }

    @Override
    public int queryAdminRelCount(String adminPersonId, String personId) {
        return this.workReportAdminSetDao.queryAdminRelCount(adminPersonId, personId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveWorkReportAdminSet(Person loginPerson, String adminIds) {
        List<String> listPage;
        WorkReportAdminSetBean bean = new WorkReportAdminSetBean();
        Page page = new Page(1, Integer.MAX_VALUE);
        ArrayList<String> listAll = new ArrayList<String>();
        List<WorkReportAdminEntity> listWork = this.workReportAdminSetDao.queryWorkAdminList(bean, page);
        if (null != listWork && listWork.size() > 0 && null != listWork && listWork.size() > 0) {
            for (WorkReportAdminEntity entity : listWork) {
                listAll.add(entity.getAdminId());
            }
        }
        if (null == (listPage = Arrays.asList(adminIds.split(",")))) {
            listPage = new ArrayList<String>();
        }
        ArrayList<String> listAllTmp = new ArrayList<String>();
        listAllTmp.addAll(listAll);
        ArrayList<String> listPageTmp = new ArrayList<String>();
        listPageTmp.addAll(listPage);
        listAll.removeAll(listPage);
        listPageTmp.removeAll(listAllTmp);
        if (null != listPageTmp && listPageTmp.size() > 0) {
            for (String id : listPageTmp) {
                if (StringUtils.isBlank((CharSequence)id)) continue;
                WorkReportAdminEntity workReportAdminEntity = new WorkReportAdminEntity();
                workReportAdminEntity.setAdminId(id);
                workReportAdminEntity.setCreateTime(System.currentTimeMillis());
                workReportAdminEntity.setCreateUser(loginPerson.getId());
                this.workReportAdminSetDao.saveWorkReportAdmin(workReportAdminEntity);
            }
        }
        if (null != listAll && listAll.size() > 0) {
            this.workReportAdminSetDao.deleteWorkReportAdmin(listAll);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveWorkReportAdminRel(Person loginPerson, String adminId, String personIds) {
        List<String> listPage;
        List<WorkReportAdminRelBean> listRel = this.workReportAdminSetDao.queryAdminRelList(adminId);
        ArrayList<String> listAll = new ArrayList<String>();
        if (null != listRel && listRel.size() > 0 && null != listRel && listRel.size() > 0) {
            for (WorkReportAdminRelBean entity : listRel) {
                listAll.add(entity.getPersonId());
            }
        }
        if (null == (listPage = Arrays.asList(personIds.split(",")))) {
            listPage = new ArrayList<String>();
        }
        listAll.removeAll(listPage);
        if (null != listAll && listAll.size() > 0) {
            this.accountFollowService.del(adminId, listAll.toArray(new String[0]));
        }
        this.workReportAdminSetDao.deleteWorkReportRelByAdminId(adminId);
        if (null != listPage && listPage.size() > 0) {
            for (String personId : listPage) {
                if (!StringUtils.isNotBlank((CharSequence)personId)) continue;
                this.workReportAdminSetDao.saveWorkReportAdminRel(adminId, personId);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deletWorkReportAdminSet(Person loginPerson, String adminId) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(adminId);
        this.workReportAdminSetDao.deleteWorkReportAdmin(list);
        this.workReportAdminSetDao.deleteWorkReportRelByAdminId(adminId);
    }

    @Override
    public List<EmployeeResponse> queryAdminRelListByCondition(String currentUser, String key, Page page) {
        return this.workReportAdminSetDao.queryAdminRelListByCondition(currentUser, key, page);
    }

    @Override
    public List<EmployeeResponse> queryAdminRelListByDeptId(String currentUser, String deptId) {
        return this.workReportAdminSetDao.queryAdminRelListByDeptId(currentUser, deptId);
    }

    private List<Department> getAllDepId(String depId, StringBuffer bufferDepId) {
        List<Department> listChild = this.depManageService.queryChildDepListByParentId(depId);
        if (null != listChild && listChild.size() > 0) {
            for (Department dep2 : listChild) {
                if ("org".equals(dep2.getDepType())) {
                    listChild = this.getAllDepId(dep2.getId(), bufferDepId);
                    continue;
                }
                bufferDepId.append("'" + dep2.getId() + "',");
            }
        }
        return listChild;
    }
}

