/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.workreport.service.impl;

import com.alibaba.fastjson.JSON;
import com.xdja.pams.bims.bean.PersonBean;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pams.function.xatl.workreport.bean.AccountFollow;
import pams.function.xatl.workreport.bean.Attachment;
import pams.function.xatl.workreport.bean.WorkReport;
import pams.function.xatl.workreport.bean.WorkReportAdminRelBean;
import pams.function.xatl.workreport.bean.WorkReportApprova;
import pams.function.xatl.workreport.bean.WorkReportBrowse;
import pams.function.xatl.workreport.bean.WorkReportReponse;
import pams.function.xatl.workreport.constans.RedisConstants;
import pams.function.xatl.workreport.dao.AttachmentDao;
import pams.function.xatl.workreport.dao.IAccountFollowDao;
import pams.function.xatl.workreport.dao.IWorkReportApprovaDao;
import pams.function.xatl.workreport.dao.IWorkReportBrowseDao;
import pams.function.xatl.workreport.dao.IWorkReportDao;
import pams.function.xatl.workreport.dao.WorkReportAdminSetDao;
import pams.function.xatl.workreport.service.IWorkReportBrowseService;
import pams.function.xatl.workreport.service.IWorkReportService;
import pams.function.xatl.workreport.service.WorkReportAdminSetService;
import pams.function.xatl.workreport.util.DateUtil;
import pams.function.xatl.workreport.util.FileServerUtil;
import pams.function.xatl.workreport.util.RedisUtil;

@Service
public class WorkReportServiceImpl
implements IWorkReportService {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private IWorkReportDao workReportDao;
    @Autowired
    private AttachmentDao attachmentDao;
    @Autowired
    private IWorkReportApprovaDao workReportApprovaDao;
    @Autowired
    private IWorkReportBrowseDao workReportBrowseDao;
    @Autowired
    private WorkReportAdminSetDao workReportAdminSetDao;
    @Autowired
    private IAccountFollowDao accountFollowDao;
    @Autowired
    private WorkReportAdminSetService workReportAdminSetService;
    @Autowired
    private IWorkReportBrowseService workReportBrowseService;
    private RedisUtil.Strings strings = new RedisUtil.Strings(RedisUtil.getInstance());

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String save(WorkReport workReport) {
        String reportstr;
        String workReportId = this.workReportDao.save(workReport);
        List<Attachment> files = workReport.getFiles();
        if (files != null && !files.isEmpty()) {
            for (Attachment attach : files) {
                if (attach.getFileId() == null || attach.getFileName() == null || attach.getFileSize() == null) {
                    throw new IllegalArgumentException("\u4f20\u9012\u53c2\u6570\u975e\u6cd5");
                }
                Attachment attachment = new Attachment();
                attachment.setObjectId(workReportId);
                attachment.setFileId(attach.getFileId());
                attachment.setFileName(attach.getFileName());
                attachment.setFileSize(attach.getFileSize());
                attachment.setType(4);
                attachment.setCreateTime(System.currentTimeMillis());
                this.attachmentDao.save(attachment);
            }
        }
        if ((reportstr = this.strings.get(RedisConstants.getBusinessWorkReportKey(workReport.getAccountId()))) == null) {
            this.strings.set(RedisConstants.getBusinessWorkReportKey(workReport.getAccountId()), workReport.getReportDate() + "|" + System.currentTimeMillis());
        } else {
            String[] split = reportstr.split("\\|");
            Long reportDate = Long.parseLong(split[0]);
            if (workReport.getReportDate() < reportDate) {
                this.strings.set(RedisConstants.getBusinessWorkReportKey(workReport.getAccountId()), reportDate + "|" + System.currentTimeMillis());
            } else {
                this.strings.set(RedisConstants.getBusinessWorkReportKey(workReport.getAccountId()), workReport.getReportDate() + "|" + System.currentTimeMillis());
            }
        }
        return workReportId;
    }

    @Override
    public WorkReport get(String workReportId, Integer diff, String userId) {
        List<WorkReportBrowse> listWorkReportBrowse;
        Integer offset = Math.abs(diff);
        WorkReport workReport = this.workReportDao.get(workReportId);
        if (workReport == null) {
            return null;
        }
        WorkReport workReport1 = null;
        if (workReport.getAccountId().equals(userId)) {
            workReport1 = this.workReportDao.get(workReportId, diff, offset, userId, workReport.getReportOrderDate());
            if (workReport1 == null) {
                return null;
            }
            workReport1.setLeftCount(this.workReportDao.leftCount(userId, workReport.getReportOrderDate()));
            workReport1.setRightCount(this.workReportDao.rightCount(userId, workReport.getReportOrderDate()));
        } else {
            int i = this.workReportAdminSetService.queryAdminRelCount(userId, workReport.getAccountId());
            if (i > 0) {
                workReport1 = this.workReportDao.get(workReportId, diff, offset, workReport.getAccountId(), workReport.getReportOrderDate());
                if (workReport1 == null) {
                    return null;
                }
                workReport1.setLeftCount(this.workReportDao.leftCount(workReport.getAccountId(), workReport.getReportOrderDate()));
                workReport1.setRightCount(this.workReportDao.rightCount(workReport.getAccountId(), workReport.getReportOrderDate()));
            } else {
                workReport1 = workReport;
            }
        }
        List<WorkReportApprova> listWorkReportApprovas = this.workReportApprovaDao.listByReportId(workReport1.getId());
        if (listWorkReportApprovas != null && listWorkReportApprovas.size() > 0) {
            ArrayList<Map<String, Object>> workReportBrowseList = new ArrayList<Map<String, Object>>();
            HashMap<String, Object> mapWorkReportApprova = null;
            for (WorkReportApprova workReportApprova : listWorkReportApprovas) {
                mapWorkReportApprova = new HashMap<String, Object>(8);
                mapWorkReportApprova.put("id", workReportApprova.getId());
                mapWorkReportApprova.put("operateContent", workReportApprova.getOperateContent());
                mapWorkReportApprova.put("operateAccountId", workReportApprova.getOperateAccountId());
                mapWorkReportApprova.put("operateAccountName", workReportApprova.getOperateAccountName());
                mapWorkReportApprova.put("operateTargetAccountId", workReportApprova.getOperateTargeAccountId());
                mapWorkReportApprova.put("operateTargetAccountName", workReportApprova.getOperateTargeAccountName());
                mapWorkReportApprova.put("operateType", workReportApprova.getOperateType());
                mapWorkReportApprova.put("createTime", workReportApprova.getCreateTime());
                workReportBrowseList.add(mapWorkReportApprova);
            }
            workReport1.setWorkReportApprovas(workReportBrowseList);
        }
        if ((listWorkReportBrowse = this.workReportBrowseDao.listByReportId(workReport1.getId())) != null && listWorkReportBrowse.size() > 0) {
            ArrayList<Map<String, Object>> workReportBrowseList = new ArrayList<Map<String, Object>>();
            HashMap<String, String> workMaps = null;
            for (WorkReportBrowse workReportBrowse : listWorkReportBrowse) {
                workMaps = new HashMap<String, String>(8);
                workMaps.put("browseAccountId", workReportBrowse.getBrowseAccountId());
                workMaps.put("browseAccountName", workReportBrowse.getBrowseAccountName());
                workReportBrowseList.add(workMaps);
            }
            workReport1.setWorkReportBrowses(workReportBrowseList);
        }
        if (null != workReport1) {
            Person employee;
            List<Attachment> files = this.attachmentDao.getObjectId(workReport1.getId(), 4);
            if (files != null && files.size() > 0) {
                workReport1.setFiles(files);
            }
            if (!(employee = this.userManageService.queryPersonById(userId)).getId().equals(workReport1.getAccountId())) {
                this.writeBrowse(workReport1.getId(), userId);
            }
        }
        return workReport1;
    }

    @Override
    public WorkReport getAccountIdByWorkId(String workReportId) {
        return this.workReportDao.get(workReportId);
    }

    @Override
    public Map<String, Object> list(Long startDate, Long endDate, String accountId, Integer days) {
        Person employee = this.userManageService.queryPersonById(accountId);
        List<WorkReportReponse> workReportReponses = this.queryWorkReportList(startDate, null, accountId, days, null);
        if (workReportReponses != null & workReportReponses.size() > 0) {
            for (WorkReportReponse workReport : workReportReponses) {
                StringBuilder atNamesSB = new StringBuilder();
                String atNames = workReport.getAtNames();
                if (workReport.getAtIds() != null && workReport.getAtIds().contains(accountId)) {
                    this.log.debug("@\u6709\u81ea\u5df1");
                    int i = 0;
                    String[] split = workReport.getAtIds().split(",");
                    for (i = 0; i < split.length && !split[i].equals(accountId); ++i) {
                    }
                    String[] splitName = atNames.split(",");
                    for (int j = 0; j < splitName.length; ++j) {
                        if (j == i) {
                            splitName[j] = "\u6211";
                        }
                        if (j == 0) {
                            atNamesSB.append(splitName[j]);
                            continue;
                        }
                        atNamesSB.append("\uff0c");
                        atNamesSB.append(splitName[j]);
                    }
                    this.log.debug("\u66ff\u6362\u540e\u503c\u4e3a:{}", (Object)atNamesSB.toString());
                } else {
                    this.log.debug("@\u6ca1\u6709\u81ea\u5df1\u7684");
                    if (StringUtils.isNotBlank((CharSequence)atNames)) {
                        if (atNames.indexOf(",") != -1) {
                            atNamesSB.append(atNames.replaceAll(",", "\uff0c"));
                        } else {
                            atNamesSB.append(atNames);
                        }
                    }
                    this.log.debug("\u66ff\u6362\u540e\u503c\u4e3a:{}", (Object)atNamesSB.toString());
                }
                workReport.setAtNames(atNamesSB.toString());
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("startDate", startDate + "");
        map.put("endDate", endDate + "");
        map.put("accountId", accountId);
        map.put("accountName", employee.getName());
        map.put("reportList", workReportReponses);
        map.put("leftCount", 0);
        map.put("rightCount", 0);
        map.put("accountIdIsFollow", null);
        return map;
    }

    private List<WorkReportReponse> queryWorkReportList(Long startDate, Person employee, String accountId, Integer days, String atv) {
        ArrayList<WorkReportReponse> includeNullList = new ArrayList<WorkReportReponse>();
        for (int i = 1; i <= days; ++i) {
            String yyyyMMdd = DateUtil.givedTimeToBefore(startDate + "", -i * 24 * 60 * 59, "yyyyMMdd");
            List<WorkReport> workReports = this.workReportDao.listDetail(Long.parseLong(yyyyMMdd), accountId);
            if (workReports == null || workReports.isEmpty()) {
                WorkReportReponse workReportReponse = new WorkReportReponse();
                workReportReponse.setReportDate(yyyyMMdd);
                workReportReponse.setIsEmpty(true);
                if (atv == null) {
                    workReportReponse.setWrite(true);
                }
                includeNullList.add(workReportReponse);
            }
            for (WorkReport workReport : workReports) {
                List<WorkReport> workReportsSize;
                WorkReportReponse workReportReponse = new WorkReportReponse();
                workReportReponse.setId(workReport.getId());
                workReportReponse.setContent(workReport.getContent());
                workReportReponse.setAtIds(workReport.getAtIds());
                workReportReponse.setAtNames(workReport.getAtNames());
                if (StringUtils.isNotBlank((CharSequence)workReport.getCoordinate())) {
                    Map map = (Map)JSON.parseObject((String)workReport.getCoordinate(), Map.class);
                    workReportReponse.setCoordinate(map);
                }
                workReportReponse.setReportDate(yyyyMMdd);
                workReportReponse.setCreateTime(workReport.getCreateTime());
                List<Map<String, Object>> files = this.getFiles(workReport.getId());
                workReportReponse.setFiles(workReport == null ? null : files);
                workReportReponse.setHasFiles(files.size() > 0);
                workReportReponse.setIsEmpty(workReport == null);
                if (StringUtils.isBlank((CharSequence)atv) && ((workReportsSize = this.workReportDao.listDetail(workReport.getReportDate(), accountId)) == null || workReportsSize.size() < 10)) {
                    workReportReponse.setWrite(true);
                }
                if (StringUtils.isNotBlank((CharSequence)atv)) {
                    this.writeBrowse(workReport.getId(), atv);
                    this.strings.set(RedisConstants.getBusinessWorkReportControllerBrowseKey(atv, employee.getId()), System.currentTimeMillis() + "");
                }
                workReportReponse.setReportApprovalCount(workReport == null ? null : Integer.valueOf(this.workReportApprovaDao.countByWorkReportId(workReport.getId())));
                workReportReponse.setReportBrowseCount(workReport == null ? null : Integer.valueOf(this.workReportBrowseDao.countByWorkReportId(workReport.getId())));
                includeNullList.add(workReportReponse);
            }
        }
        return includeNullList;
    }

    @Override
    public Map<String, Object> listFollow(Long startDate, Long endDate, Integer diff, String accountId, String userId, Integer days) {
        Person employee = this.userManageService.queryPersonById(accountId);
        if (employee == null) {
            throw new IllegalArgumentException("\u8be5\u4eba\u5458\u4e0d\u5b58\u5728");
        }
        if ("1".equals(employee.getFlag())) {
            throw new IllegalArgumentException("\u8be5\u4eba\u5458\u8d26\u53f7\u5df2\u6ce8\u9500");
        }
        int count = this.workReportAdminSetDao.queryAdminRelCount(userId, accountId);
        if (count == 0) {
            throw new IllegalArgumentException("\u8be5\u8d1f\u8d23\u4eba\u6ca1\u6709\u7ba1\u8f96\u6743\u9650");
        }
        List<WorkReportReponse> workReportReponses = this.queryWorkReportList(startDate, employee, accountId, days, userId);
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("startDate", startDate + "");
        map.put("endDate", endDate + "");
        map.put("accountId", accountId);
        map.put("accountName", employee.getName());
        map.put("reportList", workReportReponses);
        map.put("rightCount", 0);
        map.put("leftCount", 0);
        AccountFollow id = this.accountFollowDao.getId(diff, 0, accountId, userId);
        map.put("accountIdIsFollow", id != null);
        return map;
    }

    @Override
    public Map<String, Object> listDepts(Long startDate, Long endDate, Integer diff, String accountId, String userId, Integer days) {
        Person employee1 = this.userManageService.queryPersonById(accountId);
        if (employee1 == null) {
            throw new IllegalArgumentException("\u8be5\u4eba\u5458\u4e0d\u5b58\u5728");
        }
        if ("1".equals(employee1.getFlag())) {
            throw new IllegalArgumentException("\u8be5\u4eba\u5458\u8d26\u53f7\u5df2\u6ce8\u9500");
        }
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        String wrAccountId = null;
        List<WorkReportAdminRelBean> adminList = this.workReportAdminSetDao.queryAdminRelList(userId);
        if (adminList != null && adminList.size() > 0) {
            ArrayList<String> allAccountIds = new ArrayList<String>();
            for (WorkReportAdminRelBean adminRelBean : adminList) {
                allAccountIds.add(adminRelBean.getPersonId());
            }
            if (allAccountIds != null && !allAccountIds.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("\u67e5\u8be2\u6240\u6709\u7ba1\u8f96\u4eba\u96c6\u5408\u4e3a:{}", (Object)JSON.toJSONString(allAccountIds));
                }
                if (allAccountIds != null && !allAccountIds.isEmpty()) {
                    int currentIndex = allAccountIds.indexOf(accountId);
                    int rightSize = 0;
                    int leftSize = 0;
                    if (currentIndex != -1) {
                        int targetIndex = currentIndex + diff;
                        if (targetIndex <= 0) {
                            wrAccountId = (String)allAccountIds.get(0);
                            leftSize = 0;
                            rightSize = allAccountIds.size() - 1;
                        } else if (targetIndex >= allAccountIds.size() - 1) {
                            wrAccountId = (String)allAccountIds.get(allAccountIds.size() - 1);
                            leftSize = allAccountIds.size() - 1;
                            rightSize = 0;
                        } else {
                            wrAccountId = (String)allAccountIds.get(targetIndex);
                            leftSize = targetIndex;
                            rightSize = allAccountIds.size() - 1 - targetIndex;
                        }
                    } else {
                        throw new IllegalArgumentException("\u8be5\u8d1f\u8d23\u4eba\u6ca1\u6709\u7ba1\u8f96\u6743\u9650");
                    }
                    map.put("rightCount", rightSize);
                    map.put("leftCount", leftSize);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("\u5de6\u8fb9\u6570\u76ee:{},\u53f3\u8fb9\u6570\u76ee:{}", (Object)leftSize, (Object)rightSize);
                    }
                }
            } else {
                throw new IllegalArgumentException("\u8be5\u8d1f\u8d23\u4eba\u6ca1\u6709\u7ba1\u8f96\u6743\u9650");
            }
        }
        if (wrAccountId == null) {
            throw new IllegalArgumentException("\u8be5\u8d1f\u8d23\u4eba\u6ca1\u6709\u7ba1\u8f96\u6743\u9650");
        }
        Person employee = this.userManageService.queryPersonById(wrAccountId);
        if (employee == null) {
            throw new IllegalArgumentException("\u8be5\u4eba\u5458\u4e0d\u5b58\u5728");
        }
        if (employee.getFlag().equals(1)) {
            throw new IllegalArgumentException("\u8be5\u4eba\u5458\u8d26\u53f7\u5df2\u6ce8\u9500");
        }
        List<WorkReportReponse> workReportReponses = this.queryWorkReportList(startDate, employee, wrAccountId, days, userId);
        map.put("startDate", startDate + "");
        map.put("endDate", endDate + "");
        map.put("accountId", wrAccountId);
        map.put("accountName", employee.getName());
        map.put("reportList", workReportReponses);
        AccountFollow id = this.accountFollowDao.getId(0, 0, wrAccountId, userId);
        map.put("accountIdIsFollow", id != null);
        map.put("write", false);
        return map;
    }

    @Override
    public List<WorkReportReponse> atMeList(String accountId, long time) {
        List<WorkReport> workReports = this.workReportDao.atMeList(accountId, time);
        ArrayList<WorkReportReponse> includeNullList = new ArrayList<WorkReportReponse>();
        for (WorkReport workReport : workReports) {
            WorkReportReponse workReportReponse = new WorkReportReponse();
            workReportReponse.setId(workReport.getId());
            workReportReponse.setAccountId(workReport.getAccountId());
            PersonBean personById = this.userManageService.getPersonById(workReport.getAccountId());
            workReportReponse.setAccountName(personById.getNAME());
            workReportReponse.setContent(workReport.getContent());
            workReportReponse.setAtIds(workReport.getAtIds());
            workReportReponse.setAtNames(workReport.getAtNames());
            if (workReport.getCoordinate() != null) {
                Map map = (Map)JSON.parseObject((String)workReport.getCoordinate(), Map.class);
                workReportReponse.setCoordinate(map);
            }
            workReportReponse.setReportDate(String.valueOf(workReport.getReportDate()));
            workReportReponse.setCreateTime(workReport.getCreateTime());
            List<Map<String, Object>> files = this.getFiles(workReport.getId());
            workReportReponse.setFiles(workReport == null ? null : files);
            workReportReponse.setHasFiles(files.size() > 0);
            workReportReponse.setIsEmpty(workReport == null);
            List<WorkReport> workReportsSize = this.workReportDao.listDetail(workReport.getReportDate(), accountId);
            if (workReportsSize == null || workReportsSize.size() < 10) {
                workReportReponse.setWrite(true);
            }
            int reportApprovalCount = this.workReportApprovaDao.countByWorkReportId(workReport.getId());
            workReportReponse.setReportApprovalCount(reportApprovalCount);
            int reportBrowseCount = this.workReportBrowseDao.countByWorkReportId(workReport.getId());
            workReportReponse.setReportBrowseCount(reportBrowseCount);
            includeNullList.add(workReportReponse);
        }
        return includeNullList;
    }

    @Override
    public Map<String, Object> reportMonth(Long startDate, Long endDate, String accountId, Integer days) {
        List<WorkReport> workReports = this.workReportDao.reportMonth(startDate, endDate, accountId);
        Date yyyyMMdd = DateUtil.getStartDayOfMonth(DateUtil.stringToDate(startDate + "", "yyyyMMdd"));
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("reportStartDate", startDate);
        map.put("reportCurrentDate", new SimpleDateFormat("yyyyMMdd").format(new Date()));
        ArrayList mapList = new ArrayList();
        for (int i = 1; i <= days + 1; ++i) {
            Iterator<WorkReport> iterator;
            Date nextDayOfMonth = DateUtil.getNextDayOfMonth(yyyyMMdd, i);
            String yyyyMMdd1 = new SimpleDateFormat("yyyyMMdd").format(nextDayOfMonth);
            HashMap<String, Object> reportMap = new HashMap<String, Object>(8);
            if (workReports == null || workReports.isEmpty()) {
                reportMap.put("id", null);
                reportMap.put("hasReport", false);
                reportMap.put("hasApproval", false);
                reportMap.put("reportDate", yyyyMMdd1);
            }
            if ((iterator = workReports.iterator()).hasNext()) {
                WorkReport next = iterator.next();
                Long reportDate = next.getReportDate();
                if (yyyyMMdd1.equals(reportDate.toString())) {
                    reportMap.put("id", next.getId());
                    reportMap.put("hasReport", true);
                    reportMap.put("hasApproval", !StringUtils.isBlank((CharSequence)next.getOperateContent()));
                    reportMap.put("reportDate", yyyyMMdd1);
                    iterator.remove();
                    Iterator<WorkReport> it = workReports.iterator();
                    while (it.hasNext()) {
                        WorkReport next1 = it.next();
                        Long reportDate1 = next1.getReportDate();
                        if (yyyyMMdd1.equals(reportDate1.toString())) {
                            if (StringUtils.isNotBlank((CharSequence)next1.getOperateContent())) {
                                reportMap.put("hasApproval", true);
                            }
                            it.remove();
                        }
                        if (Long.parseLong(yyyyMMdd1) <= reportDate1) continue;
                        break;
                    }
                } else {
                    reportMap.put("id", null);
                    reportMap.put("hasReport", false);
                    reportMap.put("hasApproval", false);
                    reportMap.put("reportDate", yyyyMMdd1);
                }
            }
            mapList.add(reportMap);
        }
        map.put("reportList", mapList);
        return map;
    }

    @Override
    public List<WorkReport> listByDate(Long startDate, String accountId) {
        return this.workReportDao.listDetail(startDate, accountId);
    }

    public void writeBrowse(String reportId, String atv) {
        WorkReportBrowse byAccountId = this.workReportBrowseDao.getByAccountId(atv, reportId);
        if (byAccountId == null) {
            Person employee = this.userManageService.queryPersonById(atv);
            WorkReportBrowse workReportBrowse = new WorkReportBrowse();
            workReportBrowse.setWorkReportId(reportId);
            workReportBrowse.setBrowseAccountId(atv);
            workReportBrowse.setBrowseAccountName(employee.getName());
            workReportBrowse.setCreateTime(System.currentTimeMillis());
            this.workReportBrowseService.save(workReportBrowse);
        }
    }

    private List<Map<String, Object>> getFiles(String id) {
        List<Attachment> workReport = this.attachmentDao.getObjectId(id, 4);
        return FileServerUtil.getFileList(workReport);
    }
}

