/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.workreport.util;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pams.function.xatl.workreport.util.JedisPoolConf;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.SortingParams;
import redis.clients.util.SafeEncoder;

public class RedisUtil {
    private static final Logger log = LoggerFactory.getLogger(RedisUtil.class);
    private static JedisPool jedisPool = null;
    private static final RedisUtil JEDIS_UTIL;

    private RedisUtil() {
    }

    public JedisPool getPool() {
        return jedisPool;
    }

    public Jedis getJedis() {
        return jedisPool.getResource();
    }

    public static RedisUtil getInstance() {
        return JEDIS_UTIL;
    }

    public void returnJedis(Jedis jedis) {
        jedis.close();
    }

    public void expire(String key, int seconds) {
        if (seconds <= 0) {
            return;
        }
        Jedis jedis = this.getJedis();
        jedis.expire(key, seconds);
        this.returnJedis(jedis);
    }

    public void expire(String key) {
        int expire = 60000;
        this.expire(key, expire);
    }

    static {
        try {
            JedisPoolConfig config = new JedisPoolConfig();
            config.setMaxTotal(JedisPoolConf.MAX_TOTAL);
            config.setMaxIdle(JedisPoolConf.MAX_IDLE);
            config.setMaxWaitMillis(JedisPoolConf.MAX_WAIT_MILLIS);
            config.setTestOnBorrow(JedisPoolConf.TEST_ON_BORROW);
            config.setTestOnReturn(JedisPoolConf.TEST_ON_RETURN);
            jedisPool = StringUtils.isBlank((CharSequence)JedisPoolConf.REDIS_PASSWORD) ? new JedisPool((GenericObjectPoolConfig)config, JedisPoolConf.REDIS_IP, JedisPoolConf.REDIS_PORT) : new JedisPool((GenericObjectPoolConfig)config, JedisPoolConf.REDIS_IP, JedisPoolConf.REDIS_PORT, 10000, JedisPoolConf.REDIS_PASSWORD);
        }
        catch (Exception e) {
            log.error("Redis\u8fde\u63a5\u5931\u8d25", (Throwable)e);
        }
        JEDIS_UTIL = new RedisUtil();
    }

    public class Scripts {
        public Object evalsha(String script) {
            Jedis jedis = RedisUtil.this.getJedis();
            Object obj = jedis.evalsha(script);
            return obj;
        }

        public Object evalsha(String script, int keyCount, String ... params) {
            Jedis jedis = RedisUtil.this.getJedis();
            Object obj = jedis.evalsha(script, keyCount, params);
            return obj;
        }

        public Object evalsha(String script, List<String> keys, List<String> args) {
            Jedis jedis = RedisUtil.this.getJedis();
            Object obj = jedis.evalsha(script, keys, args);
            return obj;
        }
    }

    public class Lists {
        public long llen(String key) {
            return this.llen(SafeEncoder.encode((String)key));
        }

        public long llen(byte[] key) {
            Jedis sjedis = RedisUtil.this.getJedis();
            long count = sjedis.llen(key);
            RedisUtil.this.returnJedis(sjedis);
            return count;
        }

        public String lset(byte[] key, int index, byte[] value) {
            Jedis jedis = RedisUtil.this.getJedis();
            String status = jedis.lset(key, (long)index, value);
            RedisUtil.this.returnJedis(jedis);
            return status;
        }

        public String lset(String key, int index, String value) {
            return this.lset(SafeEncoder.encode((String)key), index, SafeEncoder.encode((String)value));
        }

        public long linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
            return this.linsert(SafeEncoder.encode((String)key), where, SafeEncoder.encode((String)pivot), SafeEncoder.encode((String)value));
        }

        public long linsert(byte[] key, BinaryClient.LIST_POSITION where, byte[] pivot, byte[] value) {
            Jedis jedis = RedisUtil.this.getJedis();
            long count = jedis.linsert(key, where, pivot, value);
            RedisUtil.this.returnJedis(jedis);
            return count;
        }

        public String lindex(String key, int index) {
            return SafeEncoder.encode((byte[])this.lindex(SafeEncoder.encode((String)key), index));
        }

        public byte[] lindex(byte[] key, int index) {
            Jedis sjedis = RedisUtil.this.getJedis();
            byte[] value = sjedis.lindex(key, (long)index);
            RedisUtil.this.returnJedis(sjedis);
            return value;
        }

        public String lpop(String key) {
            return SafeEncoder.encode((byte[])this.lpop(SafeEncoder.encode((String)key)));
        }

        public byte[] lpop(byte[] key) {
            Jedis jedis = RedisUtil.this.getJedis();
            byte[] value = jedis.lpop(key);
            RedisUtil.this.returnJedis(jedis);
            return value;
        }

        public String blpop(String key) {
            List<String> value = this.blpop(key, "0");
            return value.get(1);
        }

        public List<String> blpop(String ... key) {
            Jedis jedis = RedisUtil.this.getJedis();
            List value = jedis.blpop(key);
            RedisUtil.this.returnJedis(jedis);
            return value;
        }

        public List<byte[]> blpop(byte[] ... key) {
            Jedis jedis = RedisUtil.this.getJedis();
            List value = jedis.blpop(key);
            RedisUtil.this.returnJedis(jedis);
            return value;
        }

        public String rpop(String key) {
            return SafeEncoder.encode((byte[])this.rpop(SafeEncoder.encode((String)key)));
        }

        public byte[] rpop(byte[] key) {
            Jedis jedis = RedisUtil.this.getJedis();
            byte[] value = jedis.rpop(key);
            RedisUtil.this.returnJedis(jedis);
            return value;
        }

        public String brpop(String key) {
            List<String> value = this.brpop(key, "0");
            return value.get(1);
        }

        public List<String> brpop(String ... key) {
            Jedis jedis = RedisUtil.this.getJedis();
            List value = jedis.brpop(key);
            RedisUtil.this.returnJedis(jedis);
            return value;
        }

        public List<byte[]> brpop(byte[] ... key) {
            Jedis jedis = RedisUtil.this.getJedis();
            List value = jedis.brpop(key);
            RedisUtil.this.returnJedis(jedis);
            return value;
        }

        public long lpush(String key, String value) {
            return this.lpush(SafeEncoder.encode((String)key), SafeEncoder.encode((String)value));
        }

        public long rpush(String key, String value) {
            Jedis jedis = RedisUtil.this.getJedis();
            long count = jedis.rpush(key, new String[]{value});
            RedisUtil.this.returnJedis(jedis);
            return count;
        }

        public long rpush(byte[] key, byte[] value) {
            Jedis jedis = RedisUtil.this.getJedis();
            long count = jedis.rpush(key, (byte[][])new byte[][]{value});
            RedisUtil.this.returnJedis(jedis);
            return count;
        }

        public long lpush(byte[] key, byte[] value) {
            Jedis jedis = RedisUtil.this.getJedis();
            long count = jedis.lpush(key, (byte[][])new byte[][]{value});
            RedisUtil.this.returnJedis(jedis);
            return count;
        }

        public List<String> lrange(String key, long start, long end) {
            Jedis sjedis = RedisUtil.this.getJedis();
            List list = sjedis.lrange(key, start, end);
            RedisUtil.this.returnJedis(sjedis);
            return list;
        }

        public List<byte[]> lrange(byte[] key, int start, int end) {
            Jedis sjedis = RedisUtil.this.getJedis();
            List list = sjedis.lrange(key, (long)start, (long)end);
            RedisUtil.this.returnJedis(sjedis);
            return list;
        }

        public long lrem(byte[] key, int c, byte[] value) {
            Jedis jedis = RedisUtil.this.getJedis();
            long count = jedis.lrem(key, (long)c, value);
            RedisUtil.this.returnJedis(jedis);
            return count;
        }

        public long lrem(String key, int c, String value) {
            return this.lrem(SafeEncoder.encode((String)key), c, SafeEncoder.encode((String)value));
        }

        public String ltrim(byte[] key, int start, int end) {
            Jedis jedis = RedisUtil.this.getJedis();
            String str = jedis.ltrim(key, (long)start, (long)end);
            RedisUtil.this.returnJedis(jedis);
            return str;
        }

        public String ltrim(String key, int start, int end) {
            return this.ltrim(SafeEncoder.encode((String)key), start, end);
        }
    }

    public class Strings {
        public String get(String key) {
            Jedis sjedis = RedisUtil.this.getJedis();
            String value = sjedis.get(key);
            RedisUtil.this.returnJedis(sjedis);
            return value;
        }

        public byte[] get(byte[] key) {
            Jedis sjedis = RedisUtil.this.getJedis();
            byte[] value = sjedis.get(key);
            RedisUtil.this.returnJedis(sjedis);
            return value;
        }

        public String setEx(String key, int seconds, String value) {
            Jedis jedis = RedisUtil.this.getJedis();
            String str = jedis.setex(key, seconds, value);
            RedisUtil.this.returnJedis(jedis);
            return str;
        }

        public String setEx(byte[] key, int seconds, byte[] value) {
            Jedis jedis = RedisUtil.this.getJedis();
            String str = jedis.setex(key, seconds, value);
            RedisUtil.this.returnJedis(jedis);
            return str;
        }

        public long setnx(String key, String value) {
            Jedis jedis = RedisUtil.this.getJedis();
            long str = jedis.setnx(key, value);
            RedisUtil.this.returnJedis(jedis);
            return str;
        }

        public String set(String key, String value) {
            return this.set(SafeEncoder.encode((String)key), SafeEncoder.encode((String)value));
        }

        public String set(String key, byte[] value) {
            return this.set(SafeEncoder.encode((String)key), value);
        }

        public String set(byte[] key, byte[] value) {
            Jedis jedis = RedisUtil.this.getJedis();
            String status = jedis.set(key, value);
            RedisUtil.this.returnJedis(jedis);
            return status;
        }

        public long setRange(String key, long offset, String value) {
            Jedis jedis = RedisUtil.this.getJedis();
            long len = jedis.setrange(key, offset, value);
            RedisUtil.this.returnJedis(jedis);
            return len;
        }

        public long append(String key, String value) {
            Jedis jedis = RedisUtil.this.getJedis();
            long len = jedis.append(key, value);
            RedisUtil.this.returnJedis(jedis);
            return len;
        }

        public long decrBy(String key, long number) {
            Jedis jedis = RedisUtil.this.getJedis();
            long len = jedis.decrBy(key, number);
            RedisUtil.this.returnJedis(jedis);
            return len;
        }

        public long incrBy(String key, long number) {
            Jedis jedis = RedisUtil.this.getJedis();
            long len = jedis.incrBy(key, number);
            RedisUtil.this.returnJedis(jedis);
            return len;
        }

        public String getrange(String key, long startOffset, long endOffset) {
            Jedis sjedis = RedisUtil.this.getJedis();
            String value = sjedis.getrange(key, startOffset, endOffset);
            RedisUtil.this.returnJedis(sjedis);
            return value;
        }

        public String getSet(String key, String value) {
            Jedis jedis = RedisUtil.this.getJedis();
            String str = jedis.getSet(key, value);
            RedisUtil.this.returnJedis(jedis);
            return str;
        }

        public List<String> mget(String ... keys) {
            Jedis jedis = RedisUtil.this.getJedis();
            List str = jedis.mget(keys);
            RedisUtil.this.returnJedis(jedis);
            return str;
        }

        public String mset(String ... keysvalues) {
            Jedis jedis = RedisUtil.this.getJedis();
            String str = jedis.mset(keysvalues);
            RedisUtil.this.returnJedis(jedis);
            return str;
        }

        public long strlen(String key) {
            Jedis jedis = RedisUtil.this.getJedis();
            long len = jedis.strlen(key);
            RedisUtil.this.returnJedis(jedis);
            return len;
        }
    }

    public class Hash {
        public long hdel(String key, String fieid) {
            Jedis jedis = RedisUtil.this.getJedis();
            long s = jedis.hdel(key, new String[]{fieid});
            RedisUtil.this.returnJedis(jedis);
            return s;
        }

        public long hdel(String key) {
            Jedis jedis = RedisUtil.this.getJedis();
            long s = jedis.del(key);
            RedisUtil.this.returnJedis(jedis);
            return s;
        }

        public boolean hexists(String key, String fieid) {
            Jedis sjedis = RedisUtil.this.getJedis();
            boolean s = sjedis.hexists(key, fieid);
            RedisUtil.this.returnJedis(sjedis);
            return s;
        }

        public String hget(String key, String fieid) {
            Jedis sjedis = RedisUtil.this.getJedis();
            String s = sjedis.hget(key, fieid);
            RedisUtil.this.returnJedis(sjedis);
            return s;
        }

        public byte[] hget(byte[] key, byte[] fieid) {
            Jedis sjedis = RedisUtil.this.getJedis();
            byte[] s = sjedis.hget(key, fieid);
            RedisUtil.this.returnJedis(sjedis);
            return s;
        }

        public Map<String, String> hgetAll(String key) {
            Jedis sjedis = RedisUtil.this.getJedis();
            Map map = sjedis.hgetAll(key);
            RedisUtil.this.returnJedis(sjedis);
            return map;
        }

        public long hset(String key, String fieid, String value) {
            Jedis jedis = RedisUtil.this.getJedis();
            long s = jedis.hset(key, fieid, value);
            RedisUtil.this.returnJedis(jedis);
            return s;
        }

        public long hset(String key, String fieid, byte[] value) {
            Jedis jedis = RedisUtil.this.getJedis();
            long s = jedis.hset(key.getBytes(), fieid.getBytes(), value);
            RedisUtil.this.returnJedis(jedis);
            return s;
        }

        public long hsetnx(String key, String fieid, String value) {
            Jedis jedis = RedisUtil.this.getJedis();
            long s = jedis.hsetnx(key, fieid, value);
            RedisUtil.this.returnJedis(jedis);
            return s;
        }

        public List<String> hvals(String key) {
            Jedis sjedis = RedisUtil.this.getJedis();
            List list = sjedis.hvals(key);
            RedisUtil.this.returnJedis(sjedis);
            return list;
        }

        public long hincrby(String key, String fieid, long value) {
            Jedis jedis = RedisUtil.this.getJedis();
            long s = jedis.hincrBy(key, fieid, value);
            RedisUtil.this.returnJedis(jedis);
            return s;
        }

        public Set<String> hkeys(String key) {
            Jedis sjedis = RedisUtil.this.getJedis();
            Set set = sjedis.hkeys(key);
            RedisUtil.this.returnJedis(sjedis);
            return set;
        }

        public long hlen(String key) {
            Jedis sjedis = RedisUtil.this.getJedis();
            long len = sjedis.hlen(key);
            RedisUtil.this.returnJedis(sjedis);
            return len;
        }

        public List<String> hmget(String key, String ... fieids) {
            Jedis sjedis = RedisUtil.this.getJedis();
            List list = sjedis.hmget(key, fieids);
            RedisUtil.this.returnJedis(sjedis);
            return list;
        }

        public List<byte[]> hmget(byte[] key, byte[] ... fieids) {
            Jedis sjedis = RedisUtil.this.getJedis();
            List list = sjedis.hmget(key, fieids);
            RedisUtil.this.returnJedis(sjedis);
            return list;
        }

        public String hmset(String key, Map<String, String> map) {
            Jedis jedis = RedisUtil.this.getJedis();
            String s = jedis.hmset(key, map);
            RedisUtil.this.returnJedis(jedis);
            return s;
        }

        public String hmset(byte[] key, Map<byte[], byte[]> map) {
            Jedis jedis = RedisUtil.this.getJedis();
            String s = jedis.hmset(key, map);
            RedisUtil.this.returnJedis(jedis);
            return s;
        }
    }

    public class SortSet {
        public long zadd(String key, double score, String member) {
            Jedis jedis = RedisUtil.this.getJedis();
            long s = jedis.zadd(key, score, member);
            RedisUtil.this.returnJedis(jedis);
            return s;
        }

        public long zadd(String key, Map<String, Double> scoreMembers) {
            Jedis jedis = RedisUtil.this.getJedis();
            long s = jedis.zadd(key, scoreMembers);
            RedisUtil.this.returnJedis(jedis);
            return s;
        }

        public long zcard(String key) {
            Jedis sjedis = RedisUtil.this.getJedis();
            long len = sjedis.zcard(key);
            RedisUtil.this.returnJedis(sjedis);
            return len;
        }

        public long zcount(String key, double min, double max) {
            Jedis sjedis = RedisUtil.this.getJedis();
            long len = sjedis.zcount(key, min, max);
            RedisUtil.this.returnJedis(sjedis);
            return len;
        }

        public long zlength(String key) {
            long len = 0L;
            Set<String> set = this.zrange(key, 0, -1);
            len = set.size();
            return len;
        }

        public double zincrby(String key, double score, String member) {
            Jedis jedis = RedisUtil.this.getJedis();
            double s = jedis.zincrby(key, score, member);
            RedisUtil.this.returnJedis(jedis);
            return s;
        }

        public Set<String> zrange(String key, int start, int end) {
            Jedis sjedis = RedisUtil.this.getJedis();
            Set set = sjedis.zrange(key, (long)start, (long)end);
            RedisUtil.this.returnJedis(sjedis);
            return set;
        }

        public Set<String> zrangeByScore(String key, double min, double max) {
            Jedis sjedis = RedisUtil.this.getJedis();
            Set set = sjedis.zrangeByScore(key, min, max);
            RedisUtil.this.returnJedis(sjedis);
            return set;
        }

        public long zrank(String key, String member) {
            Jedis sjedis = RedisUtil.this.getJedis();
            long index = sjedis.zrank(key, member);
            RedisUtil.this.returnJedis(sjedis);
            return index;
        }

        public long zrevrank(String key, String member) {
            Jedis sjedis = RedisUtil.this.getJedis();
            long index = sjedis.zrevrank(key, member);
            RedisUtil.this.returnJedis(sjedis);
            return index;
        }

        public long zrem(String key, String member) {
            Jedis jedis = RedisUtil.this.getJedis();
            long s = jedis.zrem(key, new String[]{member});
            RedisUtil.this.returnJedis(jedis);
            return s;
        }

        public long zrem(String key) {
            Jedis jedis = RedisUtil.this.getJedis();
            long s = jedis.del(key);
            RedisUtil.this.returnJedis(jedis);
            return s;
        }

        public long zremrangeByRank(String key, int start, int end) {
            Jedis jedis = RedisUtil.this.getJedis();
            long s = jedis.zremrangeByRank(key, (long)start, (long)end);
            RedisUtil.this.returnJedis(jedis);
            return s;
        }

        public long zremrangeByScore(String key, double min, double max) {
            Jedis jedis = RedisUtil.this.getJedis();
            long s = jedis.zremrangeByScore(key, min, max);
            RedisUtil.this.returnJedis(jedis);
            return s;
        }

        public Set<String> zrevrange(String key, int start, int end) {
            Jedis sjedis = RedisUtil.this.getJedis();
            Set set = sjedis.zrevrange(key, (long)start, (long)end);
            RedisUtil.this.returnJedis(sjedis);
            return set;
        }

        public double zscore(String key, String member) {
            Jedis sjedis = RedisUtil.this.getJedis();
            Double score = sjedis.zscore(key, member);
            RedisUtil.this.returnJedis(sjedis);
            if (score != null) {
                return score;
            }
            return 0.0;
        }
    }

    public class Sets {
        public long sadd(String key, String member) {
            Jedis jedis = RedisUtil.this.getJedis();
            long s = jedis.sadd(key, new String[]{member});
            RedisUtil.this.returnJedis(jedis);
            return s;
        }

        public long sadd(byte[] key, byte[] member) {
            Jedis jedis = RedisUtil.this.getJedis();
            long s = jedis.sadd(key, (byte[][])new byte[][]{member});
            RedisUtil.this.returnJedis(jedis);
            return s;
        }

        public long scard(String key) {
            Jedis sjedis = RedisUtil.this.getJedis();
            long len = sjedis.scard(key);
            RedisUtil.this.returnJedis(sjedis);
            return len;
        }

        public Set<String> sdiff(String ... keys) {
            Jedis jedis = RedisUtil.this.getJedis();
            Set set = jedis.sdiff(keys);
            RedisUtil.this.returnJedis(jedis);
            return set;
        }

        public long sdiffstore(String newkey, String ... keys) {
            Jedis jedis = RedisUtil.this.getJedis();
            long s = jedis.sdiffstore(newkey, keys);
            RedisUtil.this.returnJedis(jedis);
            return s;
        }

        public Set<String> sinter(String ... keys) {
            Jedis jedis = RedisUtil.this.getJedis();
            Set set = jedis.sinter(keys);
            RedisUtil.this.returnJedis(jedis);
            return set;
        }

        public long sinterstore(String newkey, String ... keys) {
            Jedis jedis = RedisUtil.this.getJedis();
            long s = jedis.sinterstore(newkey, keys);
            RedisUtil.this.returnJedis(jedis);
            return s;
        }

        public boolean sismember(String key, String member) {
            Jedis sjedis = RedisUtil.this.getJedis();
            boolean s = sjedis.sismember(key, member);
            RedisUtil.this.returnJedis(sjedis);
            return s;
        }

        public Set<String> smembers(String key) {
            Jedis sjedis = RedisUtil.this.getJedis();
            Set set = sjedis.smembers(key);
            RedisUtil.this.returnJedis(sjedis);
            return set;
        }

        public Set<byte[]> smembers(byte[] key) {
            Jedis sjedis = RedisUtil.this.getJedis();
            Set set = sjedis.smembers(key);
            RedisUtil.this.returnJedis(sjedis);
            return set;
        }

        public long smove(String srckey, String dstkey, String member) {
            Jedis jedis = RedisUtil.this.getJedis();
            long s = jedis.smove(srckey, dstkey, member);
            RedisUtil.this.returnJedis(jedis);
            return s;
        }

        public String spop(String key) {
            Jedis jedis = RedisUtil.this.getJedis();
            String s = jedis.spop(key);
            RedisUtil.this.returnJedis(jedis);
            return s;
        }

        public long srem(String key, String member) {
            Jedis jedis = RedisUtil.this.getJedis();
            long s = jedis.srem(key, new String[]{member});
            RedisUtil.this.returnJedis(jedis);
            return s;
        }

        public Set<String> sunion(String ... keys) {
            Jedis jedis = RedisUtil.this.getJedis();
            Set set = jedis.sunion(keys);
            RedisUtil.this.returnJedis(jedis);
            return set;
        }

        public long sunionstore(String newkey, String ... keys) {
            Jedis jedis = RedisUtil.this.getJedis();
            long s = jedis.sunionstore(newkey, keys);
            RedisUtil.this.returnJedis(jedis);
            return s;
        }
    }

    public class Keys {
        public String flushAll() {
            Jedis jedis = RedisUtil.this.getJedis();
            String stata = jedis.flushAll();
            RedisUtil.this.returnJedis(jedis);
            return stata;
        }

        public String rename(String oldkey, String newkey) {
            return this.rename(SafeEncoder.encode((String)oldkey), SafeEncoder.encode((String)newkey));
        }

        public long renamenx(String oldkey, String newkey) {
            Jedis jedis = RedisUtil.this.getJedis();
            long status = jedis.renamenx(oldkey, newkey);
            RedisUtil.this.returnJedis(jedis);
            return status;
        }

        public String rename(byte[] oldkey, byte[] newkey) {
            Jedis jedis = RedisUtil.this.getJedis();
            String status = jedis.rename(oldkey, newkey);
            RedisUtil.this.returnJedis(jedis);
            return status;
        }

        public long expired(String key, int seconds) {
            Jedis jedis = RedisUtil.this.getJedis();
            long count = jedis.expire(key, seconds);
            RedisUtil.this.returnJedis(jedis);
            return count;
        }

        public long expireAt(String key, long timestamp) {
            Jedis jedis = RedisUtil.this.getJedis();
            long count = jedis.expireAt(key, timestamp);
            RedisUtil.this.returnJedis(jedis);
            return count;
        }

        public long ttl(String key) {
            Jedis sjedis = RedisUtil.this.getJedis();
            long len = sjedis.ttl(key);
            RedisUtil.this.returnJedis(sjedis);
            return len;
        }

        public long persist(String key) {
            Jedis jedis = RedisUtil.this.getJedis();
            long count = jedis.persist(key);
            RedisUtil.this.returnJedis(jedis);
            return count;
        }

        public long del(String ... keys) {
            Jedis jedis = RedisUtil.this.getJedis();
            long count = jedis.del(keys);
            RedisUtil.this.returnJedis(jedis);
            return count;
        }

        public long del(byte[] ... keys) {
            Jedis jedis = RedisUtil.this.getJedis();
            long count = jedis.del(keys);
            RedisUtil.this.returnJedis(jedis);
            return count;
        }

        public boolean exists(String key) {
            Jedis sjedis = RedisUtil.this.getJedis();
            boolean exis = sjedis.exists(key);
            RedisUtil.this.returnJedis(sjedis);
            return exis;
        }

        public List<String> sort(String key) {
            Jedis sjedis = RedisUtil.this.getJedis();
            List list = sjedis.sort(key);
            RedisUtil.this.returnJedis(sjedis);
            return list;
        }

        public List<String> sort(String key, SortingParams parame) {
            Jedis sjedis = RedisUtil.this.getJedis();
            List list = sjedis.sort(key, parame);
            RedisUtil.this.returnJedis(sjedis);
            return list;
        }

        public String type(String key) {
            Jedis sjedis = RedisUtil.this.getJedis();
            String type = sjedis.type(key);
            RedisUtil.this.returnJedis(sjedis);
            return type;
        }

        public Set<String> keys(String pattern) {
            Jedis jedis = RedisUtil.this.getJedis();
            Set set = jedis.keys(pattern);
            RedisUtil.this.returnJedis(jedis);
            return set;
        }
    }
}

