/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.attendance.service.impl;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.xatl.attendance.bean.RequestBean;
import pams.function.xatl.attendance.bean.ResponseBean;
import pams.function.xatl.attendance.bean.ResponsePageBean;
import pams.function.xatl.attendance.bean.push.ImeiPersonBean;
import pams.function.xatl.attendance.bean.push.RulePushPersonBean;
import pams.function.xatl.attendance.bean.rule.AttendanceRuleAddress;
import pams.function.xatl.attendance.bean.rule.AttendanceRuleBean;
import pams.function.xatl.attendance.bean.rule.AttendanceRulePageBean;
import pams.function.xatl.attendance.bean.rule.AttendanceRulePeriod;
import pams.function.xatl.attendance.bean.rule.AttendanceRulePersonBean;
import pams.function.xatl.attendance.bean.rule.AttendanceRuleSetBean;
import pams.function.xatl.attendance.bean.rule.AttendanceRuleWifi;
import pams.function.xatl.attendance.bean.rule.AttendanceSetBean;
import pams.function.xatl.attendance.bean.statistics.AttendanceClockBean;
import pams.function.xatl.attendance.bean.statistics.AttendanceDetailDailyBean;
import pams.function.xatl.attendance.bean.statistics.AttendanceDetailDailyPageBean;
import pams.function.xatl.attendance.bean.statistics.AttendanceSumaryDailyBean;
import pams.function.xatl.attendance.bean.statistics.AttendanceSumaryDailyPageBean;
import pams.function.xatl.attendance.bean.statistics.ClockInRecordStatisticsBean;
import pams.function.xatl.attendance.bean.statistics.ClockInRecordStatisticsPageBean;
import pams.function.xatl.attendance.service.AttendanceService;
import pams.function.xatl.bims.bean.PersonDepBean;
import pams.function.xatl.bims.service.UserManageServiceForXatl;
import pams.function.xatl.common.exception.ServiceException;
import pams.function.xatl.tims.bean.TaxMessageBean;
import pams.function.xatl.tims.dao.MsgPushDaoForXatl;

@Service
public class AttendanceServiceImpl
implements AttendanceService {
    private static final Logger log = LoggerFactory.getLogger(AttendanceServiceImpl.class);
    @Autowired
    private SystemConfigPbService systemConfigPbService;
    @Autowired
    private UserManageServiceForXatl userManageService;
    @Autowired
    private MsgPushDaoForXatl msgPushDao;

    @Override
    public List<AttendanceRulePageBean> queryAttendanceSetList(AttendanceRuleBean attendanceRule, Page page) {
        String attendanceUrl = this.systemConfigPbService.getValueByCode("attendance_url");
        String attendanceApi = this.systemConfigPbService.getValueByCode("attendance_api");
        ArrayList<AttendanceRulePageBean> listResult = new ArrayList<AttendanceRulePageBean>();
        try {
            attendanceRule.setPage(page.getPage() + "");
            attendanceRule.setRows(page.getRp() + "");
            RequestBean requestBean = new RequestBean("queryAttendanceRuleList", attendanceRule);
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String param = Util.toJsonStr((Object)requestBean);
            log.debug("\u83b7\u53d6\u8003\u52e4\u89c4\u5219\u5217\u8868 \u8bf7\u6c42\u53c2\u6570param : [{}]", (Object)param);
            String result = httpclient.post(attendanceUrl + attendanceApi, param);
            ResponseBean rb = (ResponseBean)Util.readValue((String)result, ResponseBean.class);
            log.debug("\u83b7\u53d6\u8003\u52e4\u89c4\u5219\u5217\u8868 \u8fd4\u56de\u6570\u636eresult : [{}]", (Object)Util.toJsonStr((Object)rb));
            assert (rb != null);
            if (null == rb.getError()) {
                ResponsePageBean bean = (ResponsePageBean)Util.readValue((String)Util.toJsonStr((Object)rb.getResult()), ResponsePageBean.class, (Class[])new Class[]{AttendanceRuleBean.class});
                assert (bean != null);
                List list = bean.getList();
                if (null != list && list.size() > 0) {
                    AttendanceRulePageBean pageBean = null;
                    String ruleId = "";
                    for (AttendanceRuleBean attendanceRuleBean : list) {
                        List<AttendanceRuleWifi> queryAttendanceWifiList;
                        pageBean = new AttendanceRulePageBean();
                        ruleId = attendanceRuleBean.getRuleId();
                        BeanUtils.copyProperties((Object)attendanceRuleBean, (Object)pageBean);
                        List<AttendanceRulePeriod> queryAttendanceTimeList = this.queryAttendanceTimeList(ruleId);
                        if (null != queryAttendanceTimeList && queryAttendanceTimeList.size() > 0) {
                            StringBuilder rulePeriod = new StringBuilder();
                            for (int i = 0; i < queryAttendanceTimeList.size(); ++i) {
                                AttendanceRulePeriod attendanceRulePeriod = queryAttendanceTimeList.get(i);
                                String[] aryStartTime = attendanceRulePeriod.getStartTime().split(":");
                                String[] aryEndTime = attendanceRulePeriod.getEndTime().split(":");
                                rulePeriod.append(aryStartTime[0]).append(":").append(aryStartTime[1]).append("-").append(aryEndTime[0]).append(":").append(aryEndTime[1]);
                                if (i == queryAttendanceTimeList.size() - 1) continue;
                                rulePeriod.append(",");
                            }
                            pageBean.setRulePeriod(rulePeriod.toString());
                        }
                        if (null != (queryAttendanceWifiList = this.queryAttendanceWifiList(ruleId)) && queryAttendanceWifiList.size() > 0) {
                            String ruleWifi = queryAttendanceWifiList.get(0).getWifiName();
                            if (queryAttendanceWifiList.size() > 1) {
                                ruleWifi = ruleWifi + " \u7b49" + queryAttendanceWifiList.size() + "\u4e2a\u8003\u52e4WIFI";
                            }
                            pageBean.setRuleWifi(ruleWifi);
                        }
                        this.getAddressByAttendanceRuleId(pageBean, ruleId);
                        this.getPersonByAttendanceRuleId(pageBean, ruleId);
                        listResult.add(pageBean);
                    }
                }
                page.setTotal(bean.getTotalCount());
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8003\u52e4\u8bbe\u7f6e\u5217\u8868\u5f02\u5e38:{}", (Throwable)e);
        }
        return listResult;
    }

    private void getAddressByAttendanceRuleId(AttendanceRulePageBean pageBean, String ruleId) {
        List<AttendanceRuleAddress> queryAttendanceRuleAddressList = this.queryAttendanceSiteList(ruleId);
        if (null != queryAttendanceRuleAddressList && queryAttendanceRuleAddressList.size() > 0) {
            String ruleAddress;
            AttendanceRuleAddress ruleAddress2 = queryAttendanceRuleAddressList.get(0);
            String description = ruleAddress2.getDescription();
            String string = ruleAddress = StringUtils.isNotBlank((CharSequence)description) ? description : ruleAddress2.getAddressName();
            if (queryAttendanceRuleAddressList.size() > 1) {
                ruleAddress = ruleAddress + " \u7b49" + queryAttendanceRuleAddressList.size() + "\u4e2a\u8003\u52e4\u5730\u5740";
            }
            pageBean.setRuleAddress(ruleAddress);
        }
    }

    private void getPersonByAttendanceRuleId(AttendanceRulePageBean pageBean, String ruleId) {
        AttendanceRulePersonBean attendanceRulePersonBean = new AttendanceRulePersonBean();
        attendanceRulePersonBean.setRuleId(ruleId);
        attendanceRulePersonBean.setPageNo(1);
        attendanceRulePersonBean.setPageSize(Integer.MAX_VALUE);
        ResponsePageBean<AttendanceRulePersonBean> rulePersonPageBean = this.queryAttendanceRulePerson(attendanceRulePersonBean);
        pageBean.setRulePersonCount(null != rulePersonPageBean ? rulePersonPageBean.getTotalCount() : 0);
    }

    @Override
    public void saveOrUpdateAttendanceSet(AttendanceSetBean bean) throws ServiceException {
        String attendanceUrl = this.systemConfigPbService.getValueByCode("attendance_url");
        String attendanceApi = this.systemConfigPbService.getValueByCode("attendance_api");
        HttpRequestUtil httpclient = new HttpRequestUtil();
        try {
            ArrayList<AttendanceRulePeriod> attendanceRulePeriod = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)bean.getAttendanceTime())) {
                attendanceRulePeriod = (List)Util.readValue((String)bean.getAttendanceTime(), List.class, (Class[])new Class[]{AttendanceRulePeriod.class});
            }
            List attendanceRuleAddress = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)bean.getAttendanceSite())) {
                attendanceRuleAddress = (List)Util.readValue((String)bean.getAttendanceSite(), List.class, (Class[])new Class[]{AttendanceRuleAddress.class});
            }
            List attendanceRuleWifi = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)bean.getAttendanceWifi())) {
                attendanceRuleWifi = (List)Util.readValue((String)bean.getAttendanceWifi(), List.class, (Class[])new Class[]{AttendanceRuleWifi.class});
            }
            ArrayList<AttendanceRuleAddress> attendanceRuleAddress2 = new ArrayList<AttendanceRuleAddress>();
            if (null != attendanceRuleAddress && attendanceRuleAddress.size() > 0) {
                Integer effectiveDistance = null;
                try {
                    effectiveDistance = Integer.parseInt(bean.getEffectiveDistance());
                }
                catch (Exception e) {
                    effectiveDistance = 500;
                }
                for (AttendanceRuleAddress address : attendanceRuleAddress) {
                    if (StringUtils.isBlank((CharSequence)address.getDimension()) || StringUtils.isBlank((CharSequence)address.getLongitude())) continue;
                    address.setEffectiveDistance(effectiveDistance);
                    attendanceRuleAddress2.add(address);
                }
            }
            ArrayList<AttendanceRuleWifi> attendanceRuleWifi2 = new ArrayList<AttendanceRuleWifi>();
            assert (attendanceRuleWifi != null);
            for (AttendanceRuleWifi wifi : attendanceRuleWifi) {
                if (!StringUtils.isNotBlank((CharSequence)wifi.getWifiName())) continue;
                attendanceRuleWifi2.add(wifi);
            }
            AttendanceRuleSetBean attendanceRuleSetBean = this.getAttendanceRuleSetBean(bean, attendanceRulePeriod, attendanceRuleAddress2, attendanceRuleWifi2);
            RequestBean requestBean = new RequestBean("updateAttendanceRule", attendanceRuleSetBean);
            String param = Util.toJsonStr((Object)requestBean);
            log.debug("\u4fdd\u5b58\u8003\u52e4\u89c4\u5219 \u8bf7\u6c42\u53c2\u6570param : [{}]", (Object)param);
            String result = httpclient.post(attendanceUrl + attendanceApi, param);
            ResponseBean rb = (ResponseBean)Util.readValue((String)result, ResponseBean.class);
            log.debug("\u4fdd\u5b58\u8003\u52e4\u89c4\u5219 \u8fd4\u56de\u6570\u636eresult : [{}]", (Object)Util.toJsonStr((Object)rb));
            assert (rb != null);
            if (null != rb.getError()) {
                log.error("\u4fdd\u5b58\u3001\u66f4\u65b0\u8003\u52e4\u8bbe\u7f6e\u5931\u8d25: {}", (Object)rb.getError().getMessage());
                int errorCode = -3;
                if (errorCode == rb.getError().getCode()) {
                    throw new ServiceException("\u540c\u4e00\u4e2a\u5355\u4f4d\u4e0b\u8003\u52e4\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
                }
                throw new ServiceException("\u4fdd\u5b58\u8003\u52e4\u8bbe\u7f6e\u5931\u8d25");
            }
            log.debug("result:[{}]", (Object)Util.toJsonStr((Object)rb.getResult()));
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u3001\u66f4\u65b0\u8003\u52e4\u8bbe\u7f6e\u5931\u8d25\u5f02\u5e38:{}", (Throwable)e);
            throw new ServiceException(e.getMessage());
        }
    }

    private AttendanceRuleSetBean getAttendanceRuleSetBean(AttendanceSetBean bean, List<AttendanceRulePeriod> attendanceRulePeriod, List<AttendanceRuleAddress> attendanceRuleAddress2, List<AttendanceRuleWifi> attendanceRuleWifi2) {
        AttendanceRuleSetBean attendanceRuleSetBean = new AttendanceRuleSetBean();
        attendanceRuleSetBean.setCreatorId(bean.getPersonId());
        attendanceRuleSetBean.setDeptId(bean.getDeptId());
        attendanceRuleSetBean.setWorkday(bean.getAttendanceWorkDay());
        attendanceRuleSetBean.setRuleId(bean.getAttendanceId());
        attendanceRuleSetBean.setRuleName(bean.getAttendanceName());
        attendanceRuleSetBean.setRuleMethod(bean.getAttendanceType());
        attendanceRuleSetBean.setAttendanceRulePeriod(attendanceRulePeriod);
        attendanceRuleSetBean.setAttendanceRuleAddress(attendanceRuleAddress2);
        attendanceRuleSetBean.setAttendanceRuleWifi(attendanceRuleWifi2);
        attendanceRuleSetBean.setRuleAdminName(bean.getRuleAdminName());
        attendanceRuleSetBean.setStatus(0);
        return attendanceRuleSetBean;
    }

    @Override
    public List<AttendanceRulePeriod> queryAttendanceTimeList(String ruleId) {
        String attendanceUrl = this.systemConfigPbService.getValueByCode("attendance_url");
        String attendanceApi = this.systemConfigPbService.getValueByCode("attendance_api");
        List<AttendanceRulePeriod> listResult = new ArrayList<AttendanceRulePeriod>();
        HttpRequestUtil httpclient = new HttpRequestUtil();
        try {
            AttendanceRuleBean attendanceRule = new AttendanceRuleBean();
            attendanceRule.setRuleId(ruleId);
            RequestBean requestBean = new RequestBean("queryAttendanceRulePeriodList", attendanceRule);
            String param = Util.toJsonStr((Object)requestBean);
            log.debug("\u83b7\u53d6\u8003\u52e4\u65f6\u6bb5\u5217\u8868 \u8bf7\u6c42\u53c2\u6570param : [{}]", (Object)param);
            String result = httpclient.post(attendanceUrl + attendanceApi, param);
            ResponseBean rb = (ResponseBean)Util.readValue((String)result, ResponseBean.class);
            log.debug("\u83b7\u53d6\u8003\u52e4\u65f6\u6bb5\u5217\u8868 \u8fd4\u56de\u6570\u636eresult : [{}]", (Object)Util.toJsonStr((Object)rb));
            if (null == rb.getError()) {
                log.debug("result:[{}]", (Object)Util.toJsonStr((Object)rb.getResult()));
                listResult = (List)Util.readValue((String)Util.toJsonStr((Object)rb.getResult()), List.class, (Class[])new Class[]{AttendanceRulePeriod.class});
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8003\u52e4\u8bbe\u7f6e\u65f6\u6bb5\u5217\u8868\u5f02\u5e38:{}", (Throwable)e);
        }
        return listResult;
    }

    @Override
    public List<AttendanceRuleAddress> queryAttendanceSiteList(String ruleId) {
        String attendanceUrl = this.systemConfigPbService.getValueByCode("attendance_url");
        String attendanceApi = this.systemConfigPbService.getValueByCode("attendance_api");
        List<AttendanceRuleAddress> listResult = new ArrayList<AttendanceRuleAddress>();
        HttpRequestUtil httpclient = new HttpRequestUtil();
        try {
            AttendanceRuleBean attendanceRule = new AttendanceRuleBean();
            attendanceRule.setRuleId(ruleId);
            RequestBean requestBean = new RequestBean("queryAttendanceRuleAddressList", attendanceRule);
            String param = Util.toJsonStr((Object)requestBean);
            log.debug("\u83b7\u53d6\u8003\u52e4\u5730\u70b9\u5217\u8868 \u8bf7\u6c42\u53c2\u6570param : [{}]", (Object)param);
            String result = httpclient.post(attendanceUrl + attendanceApi, param);
            ResponseBean rb = (ResponseBean)Util.readValue((String)result, ResponseBean.class);
            log.debug("\u83b7\u53d6\u8003\u52e4\u5730\u70b9\u5217\u8868 \u8fd4\u56de\u6570\u636eresult : [{}]", (Object)Util.toJsonStr((Object)rb));
            if (null == rb.getError()) {
                log.debug("result:[{}]", (Object)Util.toJsonStr((Object)rb.getResult()));
                listResult = (List)Util.readValue((String)Util.toJsonStr((Object)rb.getResult()), List.class, (Class[])new Class[]{AttendanceRuleAddress.class});
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8003\u52e4\u5730\u70b9\u5217\u8868\u5f02\u5e38:{}", (Throwable)e);
        }
        return listResult;
    }

    @Override
    public List<AttendanceRuleWifi> queryAttendanceWifiList(String ruleId) {
        String attendanceUrl = this.systemConfigPbService.getValueByCode("attendance_url");
        String attendanceApi = this.systemConfigPbService.getValueByCode("attendance_api");
        List<AttendanceRuleWifi> listResult = new ArrayList<AttendanceRuleWifi>();
        HttpRequestUtil httpclient = new HttpRequestUtil();
        try {
            AttendanceRuleWifi attendanceRuleWifi = new AttendanceRuleWifi();
            attendanceRuleWifi.setRuleId(ruleId);
            RequestBean requestBean = new RequestBean("queryAttendanceRuleWifiList", attendanceRuleWifi);
            String param = Util.toJsonStr((Object)requestBean);
            log.debug("\u83b7\u53d6\u8003\u52e4Wifi\u5217\u8868 \u8bf7\u6c42\u53c2\u6570param : [{}]", (Object)param);
            String result = httpclient.post(attendanceUrl + attendanceApi, param);
            ResponseBean rb = (ResponseBean)Util.readValue((String)result, ResponseBean.class);
            log.debug("\u83b7\u53d6\u8003\u52e4Wifi\u5217\u8868 \u8fd4\u56de\u6570\u636eresult : [{}]", (Object)Util.toJsonStr((Object)rb));
            if (null == rb.getError()) {
                log.debug("result:[{}]", (Object)Util.toJsonStr((Object)rb.getResult()));
                listResult = (List)Util.readValue((String)Util.toJsonStr((Object)rb.getResult()), List.class, (Class[])new Class[]{AttendanceRuleWifi.class});
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8003\u52e4\u8bbe\u7f6eWifi\u5217\u8868\u5f02\u5e38:{}", (Throwable)e);
        }
        return listResult;
    }

    @Override
    public void deleteAttendanceRule(AttendanceRuleBean attendanceRuleBean) {
        String attendanceUrl = this.systemConfigPbService.getValueByCode("attendance_url");
        String attendanceApi = this.systemConfigPbService.getValueByCode("attendance_api");
        try {
            RequestBean requestBean = new RequestBean("deleteAttendanceRuleOperator", attendanceRuleBean);
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String param = Util.toJsonStr((Object)requestBean);
            log.debug("\u5220\u9664\u8003\u52e4\u89c4\u5219 \u8bf7\u6c42\u53c2\u6570param : [{}]", (Object)param);
            String result = httpclient.post(attendanceUrl + attendanceApi, param);
            ResponseBean rb = (ResponseBean)Util.readValue((String)result, ResponseBean.class);
            log.debug("\u5220\u9664\u8003\u52e4\u89c4\u5219 \u8fd4\u56de\u6570\u636eresult : [{}]", (Object)Util.toJsonStr((Object)rb));
            if (null != rb.getError()) {
                log.error("\u5220\u9664\u8003\u52e4\u89c4\u5219\u5931\u8d25: {}", (Object)rb.getError().getMessage());
                throw new ServiceException("\u5220\u9664\u8003\u52e4\u89c4\u5219\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u8003\u52e4\u89c4\u5219\u5931\u8d25: {}", (Throwable)e);
            throw new ServiceException("\u5220\u9664\u8003\u52e4\u89c4\u5219\u5931\u8d25");
        }
    }

    @Override
    public void updateAttendanceRulePerson(AttendanceRulePersonBean attendanceRulePersonBean) {
        String attendanceUrl = this.systemConfigPbService.getValueByCode("attendance_url");
        String attendanceApi = this.systemConfigPbService.getValueByCode("attendance_api");
        try {
            this.dataConvert(attendanceRulePersonBean);
            attendanceRulePersonBean.setPersonId("");
            attendanceRulePersonBean.setPersonAndImei(new HashMap<String, String>(2));
            HttpRequestUtil httpclient = new HttpRequestUtil();
            RequestBean requestBean = new RequestBean("updateAttendanceRulePersonOperator", attendanceRulePersonBean);
            String param = Util.toJsonStr((Object)requestBean);
            log.debug("\u66f4\u65b0\u8003\u52e4\u89c4\u5219\u4e0e\u4eba\u5458\u5173\u7cfb \u8bf7\u6c42\u53c2\u6570param : [{}]", (Object)param);
            String result = httpclient.post(attendanceUrl + attendanceApi, param);
            ResponseBean rb = (ResponseBean)Util.readValue((String)result, ResponseBean.class);
            log.debug("\u66f4\u65b0\u8003\u52e4\u89c4\u5219\u4e0e\u4eba\u5458\u5173\u7cfb \u8fd4\u56de\u6570\u636eresult : [{}]", (Object)Util.toJsonStr((Object)rb));
            assert (rb != null);
            if (null != rb.getError()) {
                log.error("\u4fdd\u5b58\u8003\u52e4\u89c4\u5219\u4e0e\u4eba\u5458\u5173\u7cfb\u5931\u8d25: {}", (Object)rb.getError().getMessage());
                int errorCode = -2;
                if (errorCode == rb.getError().getCode()) {
                    List<Person> listPerson;
                    String[] aryPersonId;
                    StringBuffer message = new StringBuffer();
                    String personIds = rb.getError().getMessage();
                    if (StringUtils.isNotBlank((CharSequence)personIds) && (aryPersonId = personIds.split(",")).length > 0 && null != (listPerson = this.userManageService.queryPersonByPersonIds(Arrays.asList(aryPersonId))) && listPerson.size() > 0) {
                        for (int i = 0; i < listPerson.size(); ++i) {
                            Person person = listPerson.get(i);
                            String name = person.getName();
                            message.append(name);
                            message.append(",");
                            if (i <= 10) continue;
                            message.deleteCharAt(message.length() - 1);
                            message.append("\u7b49");
                            break;
                        }
                        if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                            message = message.deleteCharAt(message.lastIndexOf(","));
                        }
                    }
                    message.append("\u5df2\u5728\u5176\u4ed6\u8003\u52e4\u7ec4\uff0c\u662f\u5426\u5c06\u5176\u79fb\u81f3\u65b0\u7684\u8003\u52e4\u7ec4?");
                    throw new ServiceException(message.toString());
                }
                throw new RuntimeException("\u4fdd\u5b58\u8003\u52e4\u89c4\u5219\u4e0e\u4eba\u5458\u5173\u7cfb\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u8003\u52e4\u89c4\u5219\u4e0e\u4eba\u5458\u5173\u7cfb\u5931\u8d25: {}", (Throwable)e);
            throw new ServiceException(e.getMessage());
        }
    }

    private void dataConvert(AttendanceRulePersonBean attendanceRulePersonBean) {
        if (StringUtils.isNotBlank((CharSequence)attendanceRulePersonBean.getPersonId())) {
            String ids = attendanceRulePersonBean.getPersonId();
            String[] aryPersonId = ids.split(",");
            HashMap<String, String> personAndImei = new HashMap<String, String>(100);
            ArrayList<String> listPersonId = new ArrayList<String>();
            if (aryPersonId.length > 0) {
                for (String personId : aryPersonId) {
                    if (StringUtils.isBlank((CharSequence)personId)) continue;
                    listPersonId.add(personId);
                    TaxMessageBean taxMessageBean = new TaxMessageBean();
                    taxMessageBean.setIds(personId);
                    List<String> imeiPcidList = this.msgPushDao.queryImeiAndPcid(taxMessageBean);
                    StringBuilder imeiPcid = new StringBuilder();
                    for (int i = 0; i < imeiPcidList.size(); ++i) {
                        String tmp = imeiPcidList.get(i);
                        if (StringUtils.isBlank((CharSequence)tmp)) continue;
                        imeiPcid.append(tmp);
                        if (i == imeiPcidList.size() - 1) continue;
                        imeiPcid.append(",");
                    }
                    personAndImei.put(personId, imeiPcid.toString());
                }
            }
            attendanceRulePersonBean.setPersonIds(listPersonId);
            attendanceRulePersonBean.setPersonAndImei(personAndImei);
        }
    }

    @Override
    public AttendanceRuleBean queryAttendanceRuleByRuleId(AttendanceRuleBean attendanceRule) {
        String attendanceUrl = this.systemConfigPbService.getValueByCode("attendance_url");
        String attendanceApi = this.systemConfigPbService.getValueByCode("attendance_api");
        AttendanceRuleBean attendanceRuleBean = new AttendanceRuleBean();
        try {
            RequestBean requestBean = new RequestBean("queryAttendanceRuleList", attendanceRule);
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String param = Util.toJsonStr((Object)requestBean);
            log.debug("\u6839\u636eRuleId\u83b7\u53d6\u8003\u52e4\u89c4\u5219 \u8bf7\u6c42\u53c2\u6570param : [{}]", (Object)param);
            String result = httpclient.post(attendanceUrl + attendanceApi, param);
            ResponseBean rb = (ResponseBean)Util.readValue((String)result, ResponseBean.class);
            log.debug("\u6839\u636eRuleId\u83b7\u53d6\u8003\u52e4\u89c4\u5219 \u8fd4\u56de\u6570\u636eresult : [{}]", (Object)Util.toJsonStr((Object)rb));
            if (null == rb.getError()) {
                log.debug("result:[{}]", (Object)Util.toJsonStr((Object)rb.getResult()));
                ResponsePageBean bean = (ResponsePageBean)Util.readValue((String)Util.toJsonStr((Object)rb.getResult()), ResponsePageBean.class, (Class[])new Class[]{AttendanceRuleBean.class});
                List list = bean.getList();
                if (null != list && list.size() > 0) {
                    attendanceRuleBean = (AttendanceRuleBean)list.get(0);
                }
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8003\u52e4\u8bbe\u7f6e\u5f02\u5e38:{}", (Throwable)e);
        }
        return attendanceRuleBean;
    }

    @Override
    public ResponsePageBean<AttendanceRulePersonBean> queryAttendanceRulePerson(AttendanceRulePersonBean attendanceRulePersonBean) {
        String attendanceUrl = this.systemConfigPbService.getValueByCode("attendance_url");
        String attendanceApi = this.systemConfigPbService.getValueByCode("attendance_api");
        try {
            RequestBean requestBean = new RequestBean("queryAttendanceRulePersonListOperator", attendanceRulePersonBean);
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String param = Util.toJsonStr((Object)requestBean);
            log.debug("\u5206\u9875\u83b7\u53d6\u8003\u52e4\u89c4\u5219\u4eba\u5458 \u8bf7\u6c42\u53c2\u6570param : [{}]", (Object)param);
            String result = httpclient.post(attendanceUrl + attendanceApi, param);
            ResponseBean rb = (ResponseBean)Util.readValue((String)result, ResponseBean.class);
            log.debug("\u5206\u9875\u83b7\u53d6\u8003\u52e4\u89c4\u5219\u4eba\u5458 \u8fd4\u56de\u6570\u636eresult : [{}]", (Object)Util.toJsonStr((Object)rb));
            if (null == rb.getError()) {
                log.debug("result:[{}]", (Object)Util.toJsonStr((Object)rb.getResult()));
                return (ResponsePageBean)Util.readValue((String)Util.toJsonStr((Object)rb.getResult()), ResponsePageBean.class, (Class[])new Class[]{AttendanceRulePersonBean.class});
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8003\u52e4\u8bbe\u7f6e\u5f02\u5e38:{}", (Throwable)e);
        }
        return null;
    }

    @Override
    public List<AttendanceRulePersonBean> queryAttendanceRulePersonList(AttendanceRulePersonBean attendanceRulePersonBean) {
        return this.queryAttendanceRulePerson(attendanceRulePersonBean).getList();
    }

    @Override
    public List<AttendanceSumaryDailyBean> queryAttendanceSumaryDailyList(AttendanceSumaryDailyBean summaryDailyBean, Page page) {
        String attendanceUrl = this.systemConfigPbService.getValueByCode("attendance_url");
        String attendanceApi = this.systemConfigPbService.getValueByCode("attendance_api");
        List<AttendanceSumaryDailyBean> listResult = new ArrayList<AttendanceSumaryDailyBean>();
        try {
            summaryDailyBean.setPage(page.getPage() + "");
            summaryDailyBean.setRows(page.getRp() + "");
            RequestBean requestBean = new RequestBean("queryAttendanceSumaryDailyList", summaryDailyBean);
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String param = Util.toJsonStr((Object)requestBean);
            log.debug("\u83b7\u53d6\u8003\u52e4\u7edf\u8ba1\u5217\u8868 \u8bf7\u6c42\u53c2\u6570param : [{}]", (Object)param);
            String result = httpclient.post(attendanceUrl + attendanceApi, param);
            ResponseBean rb = (ResponseBean)Util.readValue((String)result, ResponseBean.class);
            log.debug("\u83b7\u53d6\u8003\u52e4\u7edf\u8ba1\u5217\u8868 \u8fd4\u56de\u6570\u636eresult : [{}]", (Object)Util.toJsonStr((Object)rb));
            listResult = this.getAttendanceSumaryDailyBeans(page, listResult, rb);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8003\u52e4\u7edf\u8ba1\u5217\u8868\u5f02\u5e38:{}", (Throwable)e);
        }
        return listResult;
    }

    @Override
    public List<AttendanceSumaryDailyBean> queryAttendanceSumaryTotalList(AttendanceSumaryDailyBean summaryDailyBean, Page page) {
        String attendanceUrl = this.systemConfigPbService.getValueByCode("attendance_url");
        String attendanceApi = this.systemConfigPbService.getValueByCode("attendance_api");
        List<AttendanceSumaryDailyBean> listResult = new ArrayList<AttendanceSumaryDailyBean>();
        try {
            summaryDailyBean.setPage(page.getPage() + "");
            summaryDailyBean.setRows(page.getRp() + "");
            RequestBean requestBean = new RequestBean("queryAttendanceSumaryTotalListOperator", summaryDailyBean);
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String param = Util.toJsonStr((Object)requestBean);
            log.debug("\u83b7\u53d6\u8003\u52e4\u7edf\u8ba1\u5217\u8868 \u8bf7\u6c42\u53c2\u6570param : [{}]", (Object)param);
            String result = httpclient.post(attendanceUrl + attendanceApi, param);
            ResponseBean rb = (ResponseBean)Util.readValue((String)result, ResponseBean.class);
            log.debug("\u83b7\u53d6\u8003\u52e4\u7edf\u8ba1\u5217\u8868 \u8fd4\u56de\u6570\u636eresult : [{}]", (Object)Util.toJsonStr((Object)rb));
            assert (rb != null);
            listResult = this.getAttendanceSumaryDailyBeans(page, listResult, rb);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8003\u52e4\u7edf\u8ba1\u5217\u8868\u5f02\u5e38:{}", (Throwable)e);
        }
        return listResult;
    }

    private List<AttendanceSumaryDailyBean> getAttendanceSumaryDailyBeans(Page page, List<AttendanceSumaryDailyBean> listResult, ResponseBean rb) {
        if (null == rb.getError()) {
            log.debug("result:[{}]", (Object)Util.toJsonStr((Object)rb.getResult()));
            ResponsePageBean bean = (ResponsePageBean)Util.readValue((String)Util.toJsonStr((Object)rb.getResult()), ResponsePageBean.class, (Class[])new Class[]{AttendanceSumaryDailyBean.class});
            assert (bean != null);
            listResult = bean.getList();
            page.setTotal(bean.getTotalCount());
        }
        return listResult;
    }

    @Override
    public List<AttendanceSumaryDailyPageBean> queryAttendanceTotalList(AttendanceSumaryDailyBean summaryDailyBean, Page page) {
        List<AttendanceSumaryDailyBean> listBean = this.queryAttendanceSumaryDailyList(summaryDailyBean, page);
        ArrayList<AttendanceSumaryDailyPageBean> listResult = new ArrayList<AttendanceSumaryDailyPageBean>();
        AttendanceSumaryDailyPageBean pageBean = null;
        if (null != listBean && listBean.size() > 0) {
            HashMap<String, AttendanceSumaryDailyPageBean> map = new HashMap<String, AttendanceSumaryDailyPageBean>(100);
            for (AttendanceSumaryDailyBean attendanceSumaryDailyBean : listBean) {
                attendanceSumaryDailyBean.setActualDay("1");
                String personId = attendanceSumaryDailyBean.getPersonId();
                if (map.containsKey(personId)) {
                    pageBean = (AttendanceSumaryDailyPageBean)map.get(personId);
                    this.convertData(attendanceSumaryDailyBean, pageBean);
                } else {
                    pageBean = new AttendanceSumaryDailyPageBean();
                    BeanUtils.copyProperties((Object)attendanceSumaryDailyBean, (Object)pageBean);
                    try {
                        Person person = this.userManageService.queryPersonById(attendanceSumaryDailyBean.getPersonId());
                        if (null == person) continue;
                        pageBean.setName(person.getName());
                        pageBean.setCode(person.getCode());
                        pageBean.setDeptName(person.getDepartment().getName());
                    }
                    catch (Exception e) {
                        log.error("pams\u4e0d\u5b58\u5728\u6b64\u4eba\u5458\u4fe1\u606f{}", (Throwable)e);
                    }
                }
                map.put(personId, pageBean);
            }
            if (map.size() > 0) {
                listResult.addAll(map.values());
            }
        }
        return listResult;
    }

    @Override
    public List<AttendanceSumaryDailyPageBean> queryAttendanceSumaryTotalPageList(AttendanceSumaryDailyBean summaryDailyBean, Page page) {
        List<AttendanceSumaryDailyBean> listBean = this.queryAttendanceSumaryTotalList(summaryDailyBean, page);
        ArrayList<AttendanceSumaryDailyPageBean> listResult = new ArrayList<AttendanceSumaryDailyPageBean>();
        if (null != listBean && listBean.size() > 0) {
            for (AttendanceSumaryDailyBean attendanceSumaryDailyBean : listBean) {
                AttendanceSumaryDailyPageBean pageBean = new AttendanceSumaryDailyPageBean();
                BeanUtils.copyProperties((Object)attendanceSumaryDailyBean, (Object)pageBean);
                try {
                    Person person = this.userManageService.queryPersonById(attendanceSumaryDailyBean.getPersonId());
                    if (null == person) continue;
                    pageBean.setName(person.getName());
                    pageBean.setCode(person.getCode());
                    pageBean.setDeptName(person.getDepartment().getName());
                    listResult.add(pageBean);
                }
                catch (Exception e) {
                    log.error("pams\u4e0d\u5b58\u5728\u6b64\u4eba\u5458\u4fe1\u606f{}", (Throwable)e);
                }
            }
        }
        return listResult;
    }

    @Override
    public List<AttendanceSumaryDailyPageBean> queryAttendanceSumaryTotalPageListExportOnly(AttendanceSumaryDailyBean summaryDailyBean, Page page, List<PersonDepBean> personList) {
        List<AttendanceSumaryDailyBean> listBean = this.queryAttendanceSumaryTotalList(summaryDailyBean, page);
        ArrayList<AttendanceSumaryDailyPageBean> listResult = new ArrayList<AttendanceSumaryDailyPageBean>();
        if (null != listBean && listBean.size() > 0) {
            for (AttendanceSumaryDailyBean attendanceSumaryDailyBean : listBean) {
                AttendanceSumaryDailyPageBean pageBean = new AttendanceSumaryDailyPageBean();
                BeanUtils.copyProperties((Object)attendanceSumaryDailyBean, (Object)pageBean);
                try {
                    for (PersonDepBean person : personList) {
                        if (!person.getID().equals(attendanceSumaryDailyBean.getPersonId())) continue;
                        pageBean.setName(person.getNAME());
                        pageBean.setCode(person.getCODE());
                        pageBean.setDeptName(person.getDEPNAME());
                        break;
                    }
                    listResult.add(pageBean);
                }
                catch (Exception e) {
                    log.error("pams\u4e0d\u5b58\u5728\u6b64\u4eba\u5458\u4fe1\u606f{}", (Throwable)e);
                }
            }
        }
        return listResult;
    }

    private void convertData(AttendanceSumaryDailyBean newBean, AttendanceSumaryDailyPageBean pageBean) {
        String dailyDate2 = newBean.getDailyDate();
        Integer beLateNum2 = newBean.getBeLateNum();
        Integer leaveEarlyNum2 = newBean.getLeaveEarlyNum();
        Float absentDay2 = newBean.getAbsentDay();
        Integer absentTime2 = newBean.getAbsentTime();
        Integer absentNum2 = newBean.getAbsentNum();
        Integer outWorkNum2 = newBean.getOutWorkNum();
        String overTime2 = newBean.getOverTime();
        String actualDay2 = newBean.getActualDay();
        String dailyDate1 = pageBean.getDailyDate();
        Integer beLateNum1 = pageBean.getBeLateNum();
        Integer leaveEarlyNum1 = pageBean.getLeaveEarlyNum();
        Float absentDay1 = pageBean.getAbsentDay();
        Integer absentTime1 = pageBean.getAbsentTime();
        Integer absentNum1 = pageBean.getAbsentNum();
        Integer outWorkNum1 = pageBean.getOutWorkNum();
        String overTime1 = pageBean.getOverTime();
        String actualDay1 = pageBean.getActualDay();
        String dailyDate = dailyDate1 + "," + dailyDate2;
        Integer beLateNum = beLateNum1 + beLateNum2;
        Integer leaveEarlyNum = leaveEarlyNum1 + leaveEarlyNum2;
        Float absentDay = Float.valueOf(absentDay1.floatValue() + absentDay2.floatValue());
        Integer absentTime = absentTime1 + absentTime2;
        Integer absentNum = absentNum1 + absentNum2;
        Integer outWorkNum = outWorkNum1 + outWorkNum2;
        String overTime = Integer.parseInt(overTime1) + Integer.parseInt(overTime2) + "";
        String actualDay = Integer.parseInt(actualDay1) + Integer.parseInt(actualDay2) + "";
        pageBean.setActualDay(actualDay);
        pageBean.setDailyDate(dailyDate);
        pageBean.setBeLateNum(beLateNum);
        pageBean.setLeaveEarlyNum(leaveEarlyNum);
        pageBean.setAbsentDay(absentDay);
        pageBean.setAbsentTime(absentTime);
        pageBean.setAbsentNum(absentNum);
        pageBean.setOutWorkNum(outWorkNum);
        pageBean.setOverTime(overTime);
    }

    @Override
    public List<AttendanceDetailDailyBean> queryAttendanceDetailDailyList(AttendanceDetailDailyBean detailDailyBean, Page page) {
        String attendanceUrl = this.systemConfigPbService.getValueByCode("attendance_url");
        String attendanceApi = this.systemConfigPbService.getValueByCode("attendance_api");
        List<AttendanceDetailDailyBean> listResult = new ArrayList<AttendanceDetailDailyBean>();
        try {
            detailDailyBean.setPage(page.getPage() + "");
            detailDailyBean.setRows(page.getRp() + "");
            detailDailyBean.setPageNo(page.getPage() + "");
            detailDailyBean.setPageSize(page.getRp() + "");
            RequestBean requestBean = new RequestBean("queryAttendanceDetailDailyListOperator", detailDailyBean);
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String param = Util.toJsonStr((Object)requestBean);
            log.debug("\u83b7\u53d6\u8003\u52e4\u7edf\u8ba1\u660e\u7ec6\u5217\u8868 \u8bf7\u6c42\u53c2\u6570param : [{}]", (Object)param);
            String result = httpclient.post(attendanceUrl + attendanceApi, param);
            ResponseBean rb = (ResponseBean)Util.readValue((String)result, ResponseBean.class);
            log.debug("\u83b7\u53d6\u8003\u52e4\u7edf\u8ba1\u660e\u7ec6\u5217\u8868 \u8fd4\u56de\u6570\u636eresult : [{}]", (Object)Util.toJsonStr((Object)rb));
            assert (rb != null);
            if (null == rb.getError()) {
                log.debug("result:[{}]", (Object)Util.toJsonStr((Object)rb.getResult()));
                ResponsePageBean bean = (ResponsePageBean)Util.readValue((String)Util.toJsonStr((Object)rb.getResult()), ResponsePageBean.class, (Class[])new Class[]{AttendanceDetailDailyBean.class});
                assert (bean != null);
                listResult = bean.getList();
                page.setTotal(bean.getTotalCount());
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8003\u52e4\u660e\u7ec6\u5217\u8868\u5f02\u5e38:{}", (Throwable)e);
        }
        return listResult;
    }

    @Override
    public List<AttendanceDetailDailyPageBean> queryAttendanceDetailPageList(AttendanceDetailDailyBean detailDailyBean, Page page) {
        List<AttendanceDetailDailyBean> listBean = this.queryAttendanceDetailDailyList(detailDailyBean, page);
        ArrayList<AttendanceDetailDailyPageBean> listResult = new ArrayList<AttendanceDetailDailyPageBean>();
        if (null != listBean && listBean.size() > 0) {
            for (AttendanceDetailDailyBean bean : listBean) {
                AttendanceDetailDailyPageBean pageBean = new AttendanceDetailDailyPageBean();
                BeanUtils.copyProperties((Object)bean, (Object)pageBean);
                try {
                    Person person = this.userManageService.queryPersonById(bean.getPersonId());
                    if (null == person) continue;
                    pageBean.setFlag("1");
                    pageBean.setName(person.getName());
                    pageBean.setCode(person.getCode());
                    pageBean.setDeptName(person.getDepartment().getName());
                    listResult.add(pageBean);
                }
                catch (Exception e) {
                    log.error("\u4eba\u5458\u4e0d\u5b58\u5728", (Throwable)e);
                }
            }
        }
        return listResult;
    }

    @Override
    public List<AttendanceDetailDailyPageBean> queryAttendanceDetailPageListExportOnly(AttendanceDetailDailyBean detailDailyBean, Page page, List<PersonDepBean> personList) {
        List<AttendanceDetailDailyBean> listBean = this.queryAttendanceDetailDailyList(detailDailyBean, page);
        ArrayList<AttendanceDetailDailyPageBean> listResult = new ArrayList<AttendanceDetailDailyPageBean>();
        if (null != listBean && listBean.size() > 0) {
            for (AttendanceDetailDailyBean bean : listBean) {
                AttendanceDetailDailyPageBean pageBean = new AttendanceDetailDailyPageBean();
                BeanUtils.copyProperties((Object)bean, (Object)pageBean);
                try {
                    for (PersonDepBean person : personList) {
                        if (!person.getID().equals(bean.getPersonId())) continue;
                        pageBean.setFlag("1");
                        pageBean.setName(person.getNAME());
                        pageBean.setCode(person.getCODE());
                        pageBean.setDeptName(person.getDEPNAME());
                        break;
                    }
                    listResult.add(pageBean);
                }
                catch (Exception e) {
                    log.error("\u4eba\u5458\u4e0d\u5b58\u5728", (Throwable)e);
                }
            }
        }
        return listResult;
    }

    @Override
    public List<AttendanceClockBean> queryAttendanceErrorDataList(AttendanceClockBean attendanceClockBean, Page page) {
        String attendanceUrl = this.systemConfigPbService.getValueByCode("attendance_url");
        String attendanceApi = this.systemConfigPbService.getValueByCode("attendance_api");
        List<AttendanceClockBean> listResult = new ArrayList<AttendanceClockBean>();
        try {
            attendanceClockBean.setPage(page.getPage() + "");
            attendanceClockBean.setRows(page.getRp() + "");
            attendanceClockBean.setPageNo(page.getPage() + "");
            attendanceClockBean.setPageSize(page.getRp() + "");
            RequestBean requestBean = new RequestBean("queryAttendanceErrorDataListOperator", attendanceClockBean);
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String param = Util.toJsonStr((Object)requestBean);
            log.debug("\u83b7\u53d6\u8003\u52e4\u7edf\u8ba1\u5f02\u5e38\u4fe1\u606f\u5217\u8868 \u8bf7\u6c42\u53c2\u6570param : [{}]", (Object)param);
            String result = httpclient.post(attendanceUrl + attendanceApi, param);
            ResponseBean rb = (ResponseBean)Util.readValue((String)result, ResponseBean.class);
            log.debug("\u83b7\u53d6\u8003\u52e4\u7edf\u8ba1\u5f02\u5e38\u4fe1\u606f\u5217\u8868 \u8fd4\u56de\u6570\u636eresult : [{}]", (Object)Util.toJsonStr((Object)rb));
            if (null == rb.getError()) {
                log.debug("result:[{}]", (Object)Util.toJsonStr((Object)rb.getResult()));
                ResponsePageBean bean = (ResponsePageBean)Util.readValue((String)Util.toJsonStr((Object)rb.getResult()), ResponsePageBean.class, (Class[])new Class[]{AttendanceClockBean.class});
                listResult = bean.getList();
                page.setTotal(bean.getTotalCount());
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8003\u52e4\u7edf\u8ba1\u660e\u7ec6\u5f02\u5e38:{}", (Throwable)e);
        }
        return listResult;
    }

    @Override
    public void updateAttendanceClock(AttendanceClockBean attendanceClockBean) {
        String attendanceUrl = this.systemConfigPbService.getValueByCode("attendance_url");
        String attendanceApi = this.systemConfigPbService.getValueByCode("attendance_api");
        try {
            RequestBean requestBean = new RequestBean("updateAttendanceClockOperator", attendanceClockBean);
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String param = Util.toJsonStr((Object)requestBean);
            log.debug("\u6539\u4e3a\u6b63\u5e38\u5361  \u8bf7\u6c42\u53c2\u6570param : [{}]", (Object)param);
            String result = httpclient.post(attendanceUrl + attendanceApi, param);
            ResponseBean rb = (ResponseBean)Util.readValue((String)result, ResponseBean.class);
            log.debug("\u6539\u4e3a\u6b63\u5e38\u5361 \u8fd4\u56de\u6570\u636eresult : [{}]", (Object)Util.toJsonStr((Object)rb));
            if (null != rb.getError()) {
                log.error("\u4fee\u6539\u6253\u5361\u72b6\u6001\u5f02\u5e38:{}", (Object)rb.getError().getMessage());
                throw new ServiceException("\u4fee\u6539\u6253\u5361\u72b6\u6001\u5f02\u5e38");
            }
            log.debug("result:[{}]", (Object)Util.toJsonStr((Object)rb.getResult()));
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u6253\u5361\u72b6\u6001\u5f02\u5e38:{}", (Throwable)e);
            throw new ServiceException("\u4fee\u6539\u6253\u5361\u72b6\u6001\u5f02\u5e38");
        }
    }

    @Override
    public List<ImeiPersonBean> queryImeiAndPcidByPersonIds(RulePushPersonBean rulePushPersonBean) {
        List<String> personIds = rulePushPersonBean.getPersonIds();
        String ruleId = rulePushPersonBean.getRuleId();
        ArrayList<ImeiPersonBean> imeiPersonBeans = new ArrayList<ImeiPersonBean>();
        ImeiPersonBean imeiPersonBean = null;
        if (null != personIds && personIds.size() > 0) {
            for (String personId : personIds) {
                TaxMessageBean taxMessageBean = new TaxMessageBean();
                taxMessageBean.setIds(personId);
                List<String> imeiPcidList = this.msgPushDao.queryImeiAndPcid(taxMessageBean);
                String imeiPcid = "";
                if (null == imeiPcidList || imeiPcidList.size() <= 0) continue;
                for (int i = 0; i < imeiPcidList.size(); ++i) {
                    String tmp = imeiPcidList.get(i);
                    if (!StringUtils.isNotBlank((CharSequence)tmp)) continue;
                    imeiPcid = imeiPcid + tmp;
                    if (i == imeiPcidList.size() - 1) continue;
                    imeiPcid = imeiPcid + ",";
                }
                if (!StringUtils.isNotBlank((CharSequence)imeiPcid)) continue;
                imeiPersonBean = new ImeiPersonBean();
                imeiPersonBean.setPersonId(personId);
                imeiPersonBean.setRuleId(ruleId);
                imeiPersonBean.setImei(imeiPcid);
                imeiPersonBeans.add(imeiPersonBean);
            }
        }
        return imeiPersonBeans;
    }

    @Override
    public List<ClockInRecordStatisticsPageBean> queryAttendanceClockInRecordPageList(AttendanceDetailDailyBean attendanceDetailDailyBean, Page page) {
        List<ClockInRecordStatisticsBean> listBean = this.queryAttendanceClockInRecordList(attendanceDetailDailyBean, page);
        ArrayList<ClockInRecordStatisticsPageBean> listResult = new ArrayList<ClockInRecordStatisticsPageBean>();
        if (null != listBean && listBean.size() > 0) {
            for (ClockInRecordStatisticsBean bean : listBean) {
                ClockInRecordStatisticsPageBean pageBean = new ClockInRecordStatisticsPageBean();
                BeanUtils.copyProperties((Object)bean, (Object)pageBean);
                try {
                    Person person = this.userManageService.queryPersonById(bean.getPersonId());
                    if (null == person) continue;
                    pageBean.setName(person.getName());
                    pageBean.setCode(person.getCode());
                    pageBean.setDeptName(person.getDepartment().getName());
                    listResult.add(pageBean);
                }
                catch (Exception e) {
                    log.error("\u4eba\u5458\u4e0d\u5b58\u5728", (Throwable)e);
                }
            }
        }
        return listResult;
    }

    @Override
    public List<ClockInRecordStatisticsBean> queryAttendanceClockInRecordList(AttendanceDetailDailyBean attendanceDetailDailyBean, Page page) {
        String attendanceUrl = this.systemConfigPbService.getValueByCode("attendance_url");
        String attendanceApi = this.systemConfigPbService.getValueByCode("attendance_api");
        List<ClockInRecordStatisticsBean> listResult = new ArrayList<ClockInRecordStatisticsBean>();
        try {
            attendanceDetailDailyBean.setPage(page.getPage() + "");
            attendanceDetailDailyBean.setRows(page.getRp() + "");
            attendanceDetailDailyBean.setPageNo(page.getPage() + "");
            attendanceDetailDailyBean.setPageSize(page.getRp() + "");
            RequestBean requestBean = new RequestBean("queryAttendanceClockInRecordListOperator", attendanceDetailDailyBean);
            HttpRequestUtil httpclient = new HttpRequestUtil();
            String param = Util.toJsonStr((Object)requestBean);
            log.debug("\u83b7\u53d6\u51fa\u5dee\u6253\u5361\u8bb0\u5f55 \u8bf7\u6c42\u53c2\u6570param : [{}]", (Object)param);
            String result = httpclient.post(attendanceUrl + attendanceApi, param);
            ResponseBean rb = (ResponseBean)Util.readValue((String)result, ResponseBean.class);
            log.debug("\u83b7\u53d6\u51fa\u5dee\u6253\u5361\u8bb0\u5f55 \u8fd4\u56de\u6570\u636eresult : [{}]", (Object)Util.toJsonStr((Object)rb));
            assert (rb != null);
            if (null == rb.getError()) {
                log.debug("result:[{}]", (Object)Util.toJsonStr((Object)rb.getResult()));
                ResponsePageBean bean = (ResponsePageBean)Util.readValue((String)Util.toJsonStr((Object)rb.getResult()), ResponsePageBean.class, (Class[])new Class[]{ClockInRecordStatisticsBean.class});
                assert (bean != null);
                listResult = bean.getList();
                page.setTotal(bean.getTotalCount());
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u51fa\u5dee\u6253\u5361\u8bb0\u5f55\u5f02\u5e38:{}", (Throwable)e);
        }
        return listResult;
    }
}

