/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.metting.control;

import com.alibaba.fastjson.JSONArray;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.xatl.metting.bean.MeetingBean;
import pams.function.xatl.metting.bean.MeetingInputBean;
import pams.function.xatl.metting.bean.QueryMeetBean;
import pams.function.xatl.metting.service.MeetingService;
import pams.function.xatl.metting.util.MeetingUtil;

@Controller
@Scope(value="session")
public class MeetingController
extends BaseControler {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(MeetingController.class);
    @Autowired
    private MeetingService meetingService;
    @Autowired
    private ResourceBundleMessageSource resourceBundleMessageSource;

    @RequestMapping(value={"/meet/MeetingController/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            String fromDate = "";
            String toDate = "";
            Date date = new Date();
            fromDate = Util.getDate((String)"yyyy-MM-dd HH:mm:ss", (Date)date);
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            c.add(2, 1);
            Date tDate = c.getTime();
            toDate = Util.getDate((String)"yyyy-MM-dd HH:mm:ss", (Date)tDate);
            map.put((Object)"fromDate", (Object)fromDate);
            map.put((Object)"toDate", (Object)toDate);
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/meet/MeetingController/noticeAuthIndex.do"})
    public String noticeAuthIndex(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/meet/MeetingController/toAddOrEdit.do"})
    public String toAddOrEdit(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id, String isView) {
        this.setOperator(request);
        String fromDate = "";
        String toDate = "";
        if ("noID".equals(id)) {
            Date date = new Date();
            toDate = fromDate = Util.getDate((String)"yyyy-MM-dd HH:mm:ss", (Date)date);
            map.put((Object)"fromDate", (Object)fromDate);
            map.put((Object)"toDate", (Object)toDate);
            MeetingBean meetingBean = new MeetingBean();
            meetingBean.setMemberIds(this.person.getId());
            meetingBean.setMemberNames(this.person.getName());
            map.put((Object)"meet", (Object)meetingBean);
        } else {
            MeetingBean meetingBean = this.meetingService.getMeetInfo(id, this.person.getId());
            fromDate = Util.getDate((String)"yyyy-MM-dd HH:mm:ss", (Date)meetingBean.getStartTime());
            toDate = Util.getDate((String)"yyyy-MM-dd HH:mm:ss", (Date)meetingBean.getEndTime());
            map.put((Object)"fromDate", (Object)fromDate);
            map.put((Object)"toDate", (Object)toDate);
            Map<String, List<Map<String, Object>>> member = meetingBean.getMeetMember();
            List<Map<String, Object>> read = member.get("readMember");
            List<Map<String, Object>> unRead = member.get("unReadMember");
            read.addAll(unRead);
            StringBuilder ids = new StringBuilder();
            StringBuilder names = new StringBuilder();
            ids.append(this.person.getId() + ",");
            names.append(this.person.getName() + ",");
            for (Map<String, Object> map2 : read) {
                ids.append(map2.get("member") + ",");
                names.append(map2.get("memberName") + ",");
            }
            meetingBean.setMemberIds(ids.length() > 0 ? ids.substring(0, ids.length() - 1) : "");
            meetingBean.setMemberNames(names.length() > 0 ? names.substring(0, names.length() - 1) : "");
            map.put((Object)"meet", (Object)meetingBean);
        }
        map.put((Object)"pid", (Object)this.person.getId());
        map.put((Object)"isView", (Object)isView);
        return "attendance/notice/default/addOrEdit";
    }

    @RequestMapping(value={"/meet/MeetingController/addPublishRangePage.do"})
    public String addPublishRangePage(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        return "attendance/notice/default/addAdmins";
    }

    @RequestMapping(value={"/meet/MeetingController/toEditPage.do"})
    public String toEditPage(HttpServletRequest request, HttpServletResponse response, ModelMap map, String terminalId) {
        return "attendance/notice/default/addOrEdit";
    }

    @RequestMapping(value={"/meet/MeetingController/toStatePage.do"})
    public String toStatePage(HttpServletRequest request, HttpServletResponse response, ModelMap map) {
        return "attendance/notice/default/stateDetail";
    }

    @RequestMapping(value={"/meet/MeetingController/getMeetList.do"})
    public void getMeetList(HttpServletRequest request, HttpServletResponse response, ModelMap map, QueryMeetBean queryMeetBean) {
        this.setOperator(request);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String s = queryMeetBean.getStartTimeStr();
            queryMeetBean.setStartTimeStr(StringUtils.isEmpty((String)s) ? s : s + " 00:00:00");
            String e = queryMeetBean.getEndTimeStr();
            queryMeetBean.setEndTimeStr(StringUtils.isEmpty((String)e) ? e : e + " 23:59:59");
            queryMeetBean.setUserId(this.person.getId());
            Page page = new Page(queryMeetBean.getPage().intValue(), queryMeetBean.getRows().intValue());
            List<MeetingBean> list = this.meetingService.getWebMeetList(queryMeetBean, page);
            for (MeetingBean meetingBean : list) {
                Map<String, List<Map<String, Object>>> member = meetingBean.getMeetMember();
                ArrayList<Map<String, Object>> totalMembers = new ArrayList<Map<String, Object>>();
                List<Map<String, Object>> read = member.get("readMember");
                List<Map<String, Object>> unRead = member.get("unReadMember");
                totalMembers.addAll(read);
                totalMembers.addAll(unRead);
                StringBuilder ids = new StringBuilder();
                StringBuilder names = new StringBuilder();
                ids.append(this.person.getId() + ",");
                names.append(this.person.getName() + ",");
                for (Map map2 : totalMembers) {
                    ids.append(map2.get("member") + ",");
                    names.append(map2.get("memberName") + ",");
                }
                meetingBean.setMemberIds(ids.length() > 0 ? ids.substring(0, ids.length() - 1) : "");
                meetingBean.setMemberNames(names.length() > 0 ? names.substring(0, names.length() - 1) : "");
            }
            result.put("total", page.getTotal());
            result.put("rows", list);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4f1a\u8bae\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        MeetingUtil.writeUtf8Text(response, MeetingUtil.toJsonStr(result));
    }

    @RequestMapping(value={"/meet/MeetingController/getWebDeptAndPerson.do"})
    public void getWebDeptAndPerson(HttpServletRequest request, HttpServletResponse response, ModelMap map, String mid) {
        this.setOperator(request);
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        JSONArray list = new JSONArray();
        try {
            list = this.meetingService.getWebDeptAndPerson(this.person.getId(), mid);
            result.put("total", list.size());
            result.put("rows", (Integer)list);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4f1a\u8bae\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)MeetingUtil.toJsonStr(result));
    }

    @RequestMapping(value={"/meet/MeetingController/getDetail.do"})
    public void getDetail(HttpServletRequest request, HttpServletResponse response, ModelMap map, String id) {
        this.setOperator(request);
        ReturnResult returnResult = new ReturnResult();
        try {
            MeetingBean meetingBean = this.meetingService.getMeetInfo(id, null);
            returnResult.setData((Object)meetingBean);
            returnResult.setRtnCode("0");
            returnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.message.operate.success"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            returnResult.setRtnCode("1");
            returnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.message.operate.fail") + e.getMessage());
        }
        MeetingUtil.writeUtf8Text(response, MeetingUtil.toJsonStr(returnResult));
    }

    @RequestMapping(value={"/meet/MeetingController/toAddMeetingMembers.do"})
    public String toAddMeetingMembers(HttpServletRequest request, HttpServletResponse response, ModelMap map, String mid) {
        this.setOperator(request);
        map.put((Object)"mid", (Object)mid);
        map.put((Object)"pid", (Object)this.person.getId());
        return "attendance/notice/default/addAdmins";
    }

    @RequestMapping(value={"/meet/MeetingController/delete.do"})
    public void delete(HttpServletRequest request, HttpServletResponse response, ModelMap map, String ids) {
        this.setOperator(request);
        ReturnResult returnResult = new ReturnResult();
        try {
            String userId = this.person.getId();
            this.meetingService.deletMeet(userId, ids);
            returnResult.setRtnCode("0");
            returnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.message.operate.success"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            returnResult.setRtnCode("1");
            returnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.message.operate.fail") + e.getMessage());
        }
        MeetingUtil.writeUtf8Text(response, MeetingUtil.toJsonStr(returnResult));
    }

    @RequestMapping(value={"/meet/MeetingController/addOrEditOrPublishMeet.do"})
    public void addOrEditOrPublishMeet(HttpServletRequest request, HttpServletResponse response, ModelMap map, MeetingInputBean mib) {
        this.setOperator(request);
        ReturnResult returnResult = new ReturnResult();
        try {
            if (StringUtils.isEmpty((String)mib.getMembers())) {
                mib.setMembers(this.person.getId());
            } else if (mib.getMembers().indexOf(this.person.getId()) < 0) {
                mib.setMembers(this.person.getId() + "," + mib.getMembers());
            }
            mib.setCreator(this.person.getId());
            this.meetingService.addMeet(mib);
            returnResult.setRtnCode("0");
            returnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.message.operate.success"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            returnResult.setRtnCode("1");
            returnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.message.operate.fail") + e.getMessage());
        }
        MeetingUtil.writeUtf8Text(response, MeetingUtil.toJsonStr(returnResult));
    }

    @RequestMapping(value={"/meet/MeetingController/publishMeet.do"})
    public void publishMeet(HttpServletRequest request, HttpServletResponse response, ModelMap map, String mid) {
        this.setOperator(request);
        ReturnResult returnResult = new ReturnResult();
        try {
            this.meetingService.publishMeeting(mid, this.person.getId());
            returnResult.setRtnCode("0");
            returnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.message.operate.success"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            returnResult.setRtnCode("1");
            returnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.message.operate.fail") + e.getMessage());
        }
        MeetingUtil.writeUtf8Text(response, MeetingUtil.toJsonStr(returnResult));
    }

    @RequestMapping(value={"/meet/MeetingController/getAllDeptAndPerson.do"})
    public void getDeptAndPerson(HttpServletRequest request, HttpServletResponse response, String mid, int type) {
        this.setOperator(request);
        ReturnResult returnResult = new ReturnResult();
        try {
            JSONArray resultArray = this.meetingService.getAllDeptAndPerson(this.person.getId(), type, mid);
            returnResult.setData((Object)resultArray);
            returnResult.setRtnCode("0");
            returnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.message.operate.success"));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            returnResult.setRtnCode("1");
            returnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.resourceBundleMessageSource, (String)"common.message.operate.fail") + e.getMessage());
        }
        MeetingUtil.writeUtf8Text(response, MeetingUtil.toJsonStr(returnResult));
    }

    @RequestMapping(value={"/meet/MeetingController/getPubPerson.do"})
    public void getPubPerson(HttpServletRequest request, HttpServletResponse response, ModelMap map) {
        this.setOperator(request);
        List<Object> list = new ArrayList();
        try {
            list = this.meetingService.getWebPublish(this.person.getId());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        MeetingUtil.writeUtf8Text(response, MeetingUtil.toJsonStr(list));
    }
}

