/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.metting.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import pams.function.xatl.metting.bean.QueryMeetBean;
import pams.function.xatl.metting.dao.MeetingDraftDao;
import pams.function.xatl.metting.entity.MeetingDraft;
import pams.function.xatl.metting.entity.MeetingMember;
import pams.function.xatl.metting.util.DateUtils;
import pams.function.xatl.metting.util.MeetingConstants;

@Repository
public class MeetingDraftDaoImpl
implements MeetingDraftDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public List<MeetingMember> getMeetMemberDraftList(QueryMeetBean queryMeetBean, Page page) {
        StringBuffer sb = new StringBuffer(" SELECT member.id,meet.id  \"meetId\" meet.title, meet.startTime,meet.endTime,meet.place, meet.content,meet.isImportant,meet.pubStatus,meet.creator,meet.createTime,meet.updateTime ,member.isRead").append(" FROM t_xatl_meeting_member member LEFT JOIN t_xatl_meetingdraft meet ON member.meetId=meet.id WHERE 1=1");
        ArrayList<Object> list = new ArrayList<Object>();
        if (StringUtils.isNotEmpty((String)queryMeetBean.getUserId())) {
            sb.append(" AND member.member=?");
            list.add(queryMeetBean.getUserId());
        }
        if (StringUtils.isNotEmpty((String)queryMeetBean.getTitle())) {
            sb.append(" AND meet.title LIKE ?");
            list.add("%" + queryMeetBean.getTitle() + "%");
        }
        if (StringUtils.isNotEmpty((String)queryMeetBean.getStartTimeStr())) {
            sb.append(" AND meet.createTime >= ?");
            list.add(DateUtils.parseDate(queryMeetBean.getStartTimeStr()));
        }
        if (StringUtils.isNotEmpty((String)queryMeetBean.getEndTimeStr())) {
            sb.append(" AND meet.createTime <= ?");
            list.add(DateUtils.parseDate(queryMeetBean.getEndTimeStr()));
        }
        sb.append(" and member.pubStatus=?");
        list.add(MeetingConstants.PUBSTATUS_DRAFT);
        String selectCount = "select count(*) from (" + sb.toString() + ")";
        return this.baseDao.getListBySQL(selectCount, sb.toString(), list.toArray(), page, MeetingMember.class);
    }

    @Override
    public String addMeetDraft(MeetingDraft meetingDraft) {
        meetingDraft.setCreateTime(new Date());
        meetingDraft.setUpdateTime(new Date());
        Serializable id = (Serializable)this.baseDao.create((Object)meetingDraft);
        return (String)((Object)id);
    }

    @Override
    public String updateMeetDraft(MeetingDraft meetingDraft) {
        meetingDraft.setUpdateTime(new Date());
        this.baseDao.update((Object)meetingDraft);
        return null;
    }

    @Override
    public MeetingDraft getMeetDraftInfo(String id) {
        return (MeetingDraft)this.baseDao.getObjectById(MeetingDraft.class, (Serializable)((Object)id));
    }

    @Override
    public void deleteMeetDraft(MeetingDraft meetingDraft) {
        this.baseDao.delete((Object)meetingDraft);
    }
}

