/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.control;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.xatl.ruyihu.bean.JsonrpcResult;
import pams.function.xatl.ruyihu.jsonrpc.AbstractJsonrpcMethod;
import pams.function.xatl.ruyihu.jsonrpc.SuperRequest;

@Controller
public class MobileApiController
implements ApplicationContextAware,
InitializingBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ObjectMapper json = new ObjectMapper();
    private ApplicationContext application;
    private final Map<String, AbstractJsonrpcMethod> methodMap = new HashMap<String, AbstractJsonrpcMethod>();

    @RequestMapping(value={"ruyihu/mobileApi/jsonrpc.do"})
    public void jsonrpc(HttpServletRequest request, HttpServletResponse response) {
        JsonrpcResult result = this.getJsonrpcResult(request);
        try {
            String bytes = this.json.writeValueAsString((Object)result);
            response.setContentType("application/json");
            response.getOutputStream().write(bytes.getBytes());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ruyihu mobileApi rpc feedback: " + bytes);
            }
        }
        catch (Exception e) {
            this.logger.warn("\u6570\u636e\u5e8f\u5217\u5316\u5f02\u5e38", (Throwable)e);
        }
    }

    private JsonrpcResult getJsonrpcResult(HttpServletRequest request) {
        JsonNode params;
        String method;
        String requestJson = null;
        try {
            requestJson = CharStreams.toString((Readable)new InputStreamReader((InputStream)request.getInputStream(), Charsets.UTF_8));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ruyihu mobileApi rpc receive: " + requestJson);
            }
        }
        catch (Exception e) {
            String msg = "\u83b7\u53d6\u8bf7\u6c42\u53c2\u6570\u51fa\u9519\uff1a" + e.getMessage();
            this.logger.warn(msg);
            return new JsonrpcResult("Unknown", "0", msg, null);
        }
        try {
            JsonNode root = this.json.readTree(requestJson);
            String jsonrpc = root.path("jsonrpc").asText();
            if (!StringUtils.hasText((String)jsonrpc) || !"2.0".equals(jsonrpc)) {
                String msg = "jsonrpc\u7248\u672c\u4e0d\u6b63\u786e:" + jsonrpc;
                this.logger.warn(msg);
                return new JsonrpcResult("Unknown", "0", msg, null);
            }
            method = root.path("method").asText();
            if (StringUtils.hasText((String)method)) {
                method = method.toUpperCase();
            }
            if (!StringUtils.hasText((String)method) || !this.isValidMethod(method)) {
                String msg = "\u4e0d\u53ef\u7528\u7684\u65b9\u6cd5:" + method;
                this.logger.warn(msg);
                return new JsonrpcResult("Unknown", "0", msg, null);
            }
            params = root.path("params");
            if (params.isMissingNode()) {
                String msg = "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5b58\u5728";
                this.logger.warn(msg);
                return new JsonrpcResult(method, "0", msg, null);
            }
        }
        catch (Exception e) {
            String msg = "\u89e3\u6790\u8bf7\u6c42\u53c2\u6570\u51fa\u9519\uff1a" + e.getMessage();
            this.logger.warn(msg);
            return new JsonrpcResult("Unknown", "0", msg, null);
        }
        try {
            this.logger.info("\u5f00\u59cb\u8c03\u7528\u65b9\u6cd5\uff1a" + method);
            JsonrpcResult result = this.callMethod(method, params);
            return result;
        }
        catch (Exception e) {
            String msg = "\u8c03\u7528\u65b9\u6cd5" + method + "\u5f02\u5e38\uff1a" + e.getMessage();
            this.logger.error("\u8c03\u7528\u65b9\u6cd5" + method + "\u5f02\u5e38", (Throwable)e);
            return new JsonrpcResult(method, "0", msg, null);
        }
    }

    private JsonrpcResult callMethod(String method, JsonNode params) throws Exception {
        Object result = this.methodMap.get(method).execute(new SuperRequest(params));
        return new JsonrpcResult(method, "1", null, result);
    }

    private boolean isValidMethod(String method) {
        return this.methodMap.containsKey(method);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.application = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        Collection methods = this.application.getBeansOfType(AbstractJsonrpcMethod.class).values();
        this.methodMap.clear();
        this.logger.info("\u626b\u63cf\u5230jsonrpc\u65b9\u6cd5\u6570\u91cf:" + methods.size());
        for (AbstractJsonrpcMethod one : methods) {
            this.logger.info("jsonrpc method: " + one.method() + ", class: " + one.getClass().getName());
            this.methodMap.put(one.method().toUpperCase(), one);
        }
    }
}

