/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.dao.impl;

import com.google.common.collect.Lists;
import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.stereotype.Repository;
import pams.function.xatl.ruyihu.bean.LeaveListParam;
import pams.function.xatl.ruyihu.dao.LeaveDao;
import pams.function.xatl.ruyihu.entity.LeaveEntity;
import pams.function.xatl.ruyihu.enums.LeaveTypeEnum;

@Repository
public class LeaveDaoImpl
implements LeaveDao {
    @Resource
    private BaseDao baseDao;

    @Override
    public LeaveEntity getLeaveById(String leaveId) {
        return (LeaveEntity)this.baseDao.getObjectById(LeaveEntity.class, (Serializable)((Object)leaveId));
    }

    @Override
    public void saveLeave(LeaveEntity leave) {
        this.baseDao.saveOrUpdate((Object)leave);
    }

    @Override
    public void updateLeave(LeaveEntity leave) {
        this.baseDao.update((Object)leave);
    }

    @Override
    public List<LeaveEntity> getLeaveList(LeaveListParam leaveListParam, int pageSize) throws Exception {
        StringBuilder sb = new StringBuilder(" from LeaveEntity  where 1=1");
        ArrayList<Object> params = new ArrayList<Object>();
        if (org.springframework.util.StringUtils.hasText((String)leaveListParam.getUserId())) {
            sb.append(" and personId= ? ");
            params.add(leaveListParam.getUserId());
        }
        if (org.springframework.util.StringUtils.hasText((String)leaveListParam.getType()) && !leaveListParam.getType().equals(LeaveTypeEnum.LEAVE_TYPE_ALL.getType())) {
            sb.append(" and leaveType= ? ");
            params.add(leaveListParam.getType());
        }
        if (org.springframework.util.StringUtils.hasText((String)leaveListParam.getStatus())) {
            sb.append(" and approvalStatus= ? ");
            params.add(leaveListParam.getStatus());
        }
        if (org.springframework.util.StringUtils.hasText((String)leaveListParam.getBeginDate())) {
            sb.append(" and endDate >= ? ");
            params.add(Util.parseDate((String)leaveListParam.getBeginDate(), (String)"yyyy-MM-dd"));
        }
        if (org.springframework.util.StringUtils.hasText((String)leaveListParam.getEndDate())) {
            sb.append(" and beginDate < ? ");
            Date date = Util.parseDate((String)leaveListParam.getEndDate(), (String)"yyyy-MM-dd");
            params.add(DateUtils.addDays((Date)date, (int)1));
        }
        if (leaveListParam.getTimestamp() > 0L) {
            sb.append(" and createTime < ? ");
            params.add(new Date(leaveListParam.getTimestamp()));
        }
        sb.append(" order by createTime desc");
        return this.baseDao.getTopListByHQL(sb.toString(), params.toArray(), pageSize);
    }

    @Override
    public List<LeaveEntity> getLeaveList(Date begin, Date end, String personNameLike, String type, String status, Page pageParam) {
        StringBuilder from = new StringBuilder("from LeaveEntity l, Person p where l.personId=p.id ");
        ArrayList params = Lists.newArrayList();
        if (org.springframework.util.StringUtils.hasText((String)type)) {
            if ("leave_type_all".equals(type)) {
                from.append(" and l.leaveType != ? ");
                params.add("leave_type_official");
            } else {
                from.append(" and l.leaveType = ? ");
                params.add(type);
            }
        }
        if (org.springframework.util.StringUtils.hasText((String)personNameLike)) {
            from.append(" and p.name like ?");
            params.add("%" + personNameLike + "%");
        }
        if (org.springframework.util.StringUtils.hasText((String)status)) {
            from.append(" and l.approvalStatus = ? ");
            params.add(status);
        }
        if (begin != null) {
            from.append(" and l.endDate >= ? ");
            params.add(begin);
        }
        if (end != null) {
            from.append(" and l.beginDate <? ");
            params.add(DateUtils.addDays((Date)end, (int)1));
        }
        List result = this.baseDao.getListByHQL("select count(l.leaveId) " + from.toString(), "select l " + from.toString() + " order by l.createTime desc", params.toArray(), pageParam);
        return result;
    }

    @Override
    public List<LeaveEntity> getLeaveList(String personId, Date begin, Date end, String leaveType, String cancelStatus) {
        StringBuilder from = new StringBuilder(" from LeaveEntity l where l.personId=? and l.approvalStatus=? ");
        ArrayList params = Lists.newArrayList();
        params.add(personId);
        params.add("leave_approval_pass");
        if (StringUtils.isNotEmpty((String)leaveType)) {
            from.append(" and l.leaveType=? ");
            params.add(leaveType);
        }
        if (StringUtils.isNotEmpty((String)cancelStatus)) {
            from.append(" and l.cancelStatus=? ");
            params.add(cancelStatus);
        }
        if (end != null) {
            from.append(" and l.beginDate <= ? ");
            params.add(end);
        }
        if (begin != null) {
            from.append(" and l.endDate >= ? ");
            params.add(begin);
        }
        return this.baseDao.getListByHQL(from.toString(), params.toArray());
    }

    @Override
    public List<LeaveEntity> getLeaveListNotType(String personId, Date begin, Date end, String leaveType) {
        StringBuilder from = new StringBuilder(" from LeaveEntity l where l.personId=? and l.approvalStatus=? and l.leaveType!=?");
        ArrayList params = Lists.newArrayList();
        params.add(personId);
        params.add("leave_approval_pass");
        params.add(leaveType);
        if (begin != null) {
            from.append(" and l.beginDate <= ? ");
            params.add(end);
        }
        if (end != null) {
            from.append(" and l.endDate >= ? ");
            params.add(begin);
        }
        return this.baseDao.getListByHQL(from.toString(), params.toArray());
    }

    @Override
    public int countLeaveList(LeaveListParam leaveListParam) throws Exception {
        StringBuilder sb = new StringBuilder(" select count(leaveId)  from LeaveEntity  where 1=1");
        ArrayList<Object> params = new ArrayList<Object>();
        if (org.springframework.util.StringUtils.hasText((String)leaveListParam.getUserId())) {
            sb.append(" and personId= ? ");
            params.add(leaveListParam.getUserId());
        }
        if (org.springframework.util.StringUtils.hasText((String)leaveListParam.getType())) {
            if (leaveListParam.getType().equals(LeaveTypeEnum.LEAVE_TYPE_ALL.getType())) {
                sb.append(" and leaveType != ? ");
                params.add(LeaveTypeEnum.LEAVE_TYPE_OFFICAL.getType());
            } else {
                sb.append(" and leaveType= ? ");
                params.add(leaveListParam.getType());
            }
        }
        if (org.springframework.util.StringUtils.hasText((String)leaveListParam.getStatus())) {
            sb.append(" and approvalStatus= ? ");
            params.add(leaveListParam.getStatus());
        }
        if (org.springframework.util.StringUtils.hasText((String)leaveListParam.getBeginDate())) {
            sb.append(" and endDate >= ? ");
            params.add(Util.parseDate((String)leaveListParam.getBeginDate(), (String)"yyyy-MM-dd"));
        }
        if (org.springframework.util.StringUtils.hasText((String)leaveListParam.getEndDate())) {
            sb.append(" and beginDate < ? ");
            Date tmpDate = Util.parseDate((String)leaveListParam.getEndDate(), (String)"yyyy-MM-dd");
            params.add(DateUtils.addDays((Date)tmpDate, (int)1));
        }
        if (leaveListParam.getTimestamp() > 0L) {
            sb.append(" and createTime < ? ");
            params.add(new Date(leaveListParam.getTimestamp()));
        }
        Object rst = this.baseDao.getObjectByHQL(sb.toString(), params.toArray());
        return ((Number)rst).intValue();
    }

    @Override
    public List<LeaveEntity> getLeaveListByIds(List<String> leaveIdList, int pageSize) {
        if (leaveIdList == null || leaveIdList.size() == 0) {
            return new ArrayList<LeaveEntity>();
        }
        String leaveIds = "";
        for (String leaveId : leaveIdList) {
            leaveIds = leaveIds + "'" + leaveId + "',";
        }
        leaveIds = leaveIds.substring(0, leaveIds.length() - 1);
        StringBuilder sb = new StringBuilder(" from LeaveEntity ");
        sb.append(" where leaveId in (" + leaveIds + ")");
        sb.append(" order by createTime desc");
        ArrayList params = new ArrayList();
        return this.baseDao.getTopListByHQL(sb.toString(), params.toArray(), pageSize);
    }

    @Override
    public int countLeaveListByIds(List<String> leaveIdList) {
        String leaveIds = "";
        for (String leaveId : leaveIdList) {
            leaveIds = leaveIds + "'" + leaveId + "',";
        }
        leaveIds = leaveIds.substring(0, leaveIds.length() - 1);
        StringBuilder sb = new StringBuilder(" select count(leaveId) from LeaveEntity ");
        sb.append(" where leaveId in (" + leaveIds + ")");
        ArrayList params = new ArrayList();
        Object rst = this.baseDao.getObjectByHQL(sb.toString(), params.toArray());
        return ((Number)rst).intValue();
    }

    @Override
    public List<LeaveEntity> getLeaveListWithApproval(LeaveListParam leaveListParam, int pageSize) throws Exception {
        StringBuilder sb = new StringBuilder(" select l from LeaveEntity l, BusinessJoinerEntity b  where l.leaveId = b.businessId and l.approvalStatus != 'leave_approval_revoke'");
        ArrayList<Object> params = new ArrayList<Object>();
        if (org.springframework.util.StringUtils.hasText((String)leaveListParam.getUserId())) {
            sb.append(" and b.personId= ? ");
            params.add(leaveListParam.getUserId());
        }
        if (org.springframework.util.StringUtils.hasText((String)leaveListParam.getType())) {
            if (leaveListParam.getType().equals(LeaveTypeEnum.LEAVE_TYPE_ALL.getType())) {
                sb.append(" and l.leaveType != ? ");
                params.add(LeaveTypeEnum.LEAVE_TYPE_OFFICAL.getType());
            } else {
                sb.append(" and l.leaveType= ? ");
                params.add(leaveListParam.getType());
            }
        }
        if (org.springframework.util.StringUtils.hasText((String)leaveListParam.getStatus())) {
            sb.append(" and l.approvalStatus= ? ");
            params.add(leaveListParam.getStatus());
        }
        if (org.springframework.util.StringUtils.hasText((String)leaveListParam.getBeginDate())) {
            sb.append(" and l.endDate >= ? ");
            params.add(Util.parseDate((String)leaveListParam.getBeginDate(), (String)"yyyy-MM-dd"));
        }
        if (org.springframework.util.StringUtils.hasText((String)leaveListParam.getEndDate())) {
            sb.append(" and l.beginDate < ? ");
            Date date = Util.parseDate((String)leaveListParam.getEndDate(), (String)"yyyy-MM-dd");
            params.add(DateUtils.addDays((Date)date, (int)1));
        }
        if (leaveListParam.getTimestamp() > 0L) {
            sb.append(" and l.createTime < ? ");
            params.add(new Date(leaveListParam.getTimestamp()));
        }
        sb.append(" order by l.createTime desc");
        return this.baseDao.getTopListByHQL(sb.toString(), params.toArray(), pageSize);
    }

    @Override
    public int countLeaveListWithApproval(LeaveListParam leaveListParam) throws Exception {
        StringBuilder sb = new StringBuilder(" select count(l.leaveId) from LeaveEntity l, BusinessJoinerEntity b  where l.leaveId = b.businessId and l.approvalStatus != 'leave_approval_revoke'");
        ArrayList<Object> params = new ArrayList<Object>();
        if (org.springframework.util.StringUtils.hasText((String)leaveListParam.getUserId())) {
            sb.append(" and b.personId= ? ");
            params.add(leaveListParam.getUserId());
        }
        if (org.springframework.util.StringUtils.hasText((String)leaveListParam.getType())) {
            if (leaveListParam.getType().equals(LeaveTypeEnum.LEAVE_TYPE_ALL.getType())) {
                sb.append(" and l.leaveType != ? ");
                params.add(LeaveTypeEnum.LEAVE_TYPE_OFFICAL.getType());
            } else {
                sb.append(" and l.leaveType= ? ");
                params.add(leaveListParam.getType());
            }
        }
        if (org.springframework.util.StringUtils.hasText((String)leaveListParam.getStatus())) {
            sb.append(" and l.approvalStatus= ? ");
            params.add(leaveListParam.getStatus());
        }
        if (org.springframework.util.StringUtils.hasText((String)leaveListParam.getBeginDate())) {
            sb.append(" and l.endDate >= ? ");
            params.add(Util.parseDate((String)leaveListParam.getBeginDate(), (String)"yyyy-MM-dd"));
        }
        if (org.springframework.util.StringUtils.hasText((String)leaveListParam.getEndDate())) {
            sb.append(" and l.beginDate < ? ");
            Date tmpDate = Util.parseDate((String)leaveListParam.getEndDate(), (String)"yyyy-MM-dd");
            params.add(DateUtils.addDays((Date)tmpDate, (int)1));
        }
        if (leaveListParam.getTimestamp() > 0L) {
            sb.append(" and l.createTime < ? ");
            params.add(new Date(leaveListParam.getTimestamp()));
        }
        Object rst = this.baseDao.getObjectByHQL(sb.toString(), params.toArray());
        return ((Number)rst).intValue();
    }

    @Override
    public void delete(LeaveEntity leave) {
        this.baseDao.delete((Object)leave);
    }
}

