/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.dao.impl;

import com.xdja.pams.common.basedao.BaseDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;
import pams.function.xatl.ruyihu.dao.NoticeDao;
import pams.function.xatl.ruyihu.entity.NoticeEntity;

@Repository
public class NoticeDaoImpl
implements NoticeDao {
    @Resource
    private BaseDao baseDao;

    @Override
    public int getNoticeCountByProcessStatusAndProcesser(String processStatus, String currentUser) {
        String hql = "select count(*) from NoticeEntity where processerId=? and processStatus=?";
        Object rst = this.baseDao.getObjectByHQL(hql, new Object[]{currentUser, processStatus});
        return ((Number)rst).intValue();
    }

    @Override
    public void saveNotice(NoticeEntity toMe) {
        this.baseDao.saveOrUpdate((Object)toMe);
    }

    @Override
    public List<NoticeEntity> getCopyListByDocumentId(String documentId) {
        return this.baseDao.getListByHQL("from NoticeEntity e where e.documentId=? and e.noticeType=? order by e.createTime asc", new Object[]{documentId, "notice_optype_copy_self"});
    }

    @Override
    public List<NoticeEntity> getTopNoticeList(String currentUser, long timestamp, int pageSize, String status) {
        StringBuilder sb = new StringBuilder("from NoticeEntity where processerId=? ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(currentUser);
        if (StringUtils.hasText((String)status)) {
            sb.append(" and processStatus = ? ");
            params.add(status);
        }
        if (timestamp > 0L) {
            sb.append(" and createTime<?");
            params.add(new Date(timestamp));
        }
        sb.append(" order by createTime desc");
        List rst = this.baseDao.getTopListByHQL(sb.toString(), params.toArray(), pageSize);
        return rst;
    }

    @Override
    public int countNoticeList(String currentUser, long timestamp, String status) {
        StringBuilder sb = new StringBuilder("select count(*) from NoticeEntity where processerId=? ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(currentUser);
        if (StringUtils.hasText((String)status)) {
            sb.append(" and processStatus = ? ");
            params.add(status);
        }
        if (timestamp > 0L) {
            sb.append(" and createTime<?");
            params.add(new Date(timestamp));
        }
        Number rst = (Number)this.baseDao.getObjectByHQL(sb.toString(), params.toArray());
        return rst.intValue();
    }

    @Override
    public NoticeEntity getNoticeById(String noticeId) {
        return (NoticeEntity)this.baseDao.getObjectById(NoticeEntity.class, (Serializable)((Object)noticeId));
    }

    @Override
    public void deleteByDoc(String documentId) {
        this.baseDao.updateBySql("DELETE FROM t_lakemob_notice WHERE document_id = ?", new Object[]{documentId});
    }
}

