/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.rpcMethod;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import pams.function.xatl.ruyihu.entity.DocumentEntity;
import pams.function.xatl.ruyihu.entity.LeaveEntity;
import pams.function.xatl.ruyihu.jsonrpc.LakeMobMethod;
import pams.function.xatl.ruyihu.jsonrpc.SuperRequest;
import pams.function.xatl.ruyihu.service.DocumentService;
import pams.function.xatl.ruyihu.service.LeaveQueryService;

@Service
public class DevMaster
extends LakeMobMethod {
    public static final Logger LOGGER = LoggerFactory.getLogger(DevMaster.class);
    @Resource
    private RuntimeService runtimeService;
    @Resource
    private TaskService taskService;
    @Resource
    private LeaveQueryService leaveService;
    @Resource
    private DocumentService documentService;

    @Override
    protected Object execute0(String currentUser, SuperRequest request) {
        String operate = request.needText("operate");
        if (operate.equals("delete")) {
            ProcessInstance instance;
            String businessType = request.needText("businessType");
            String id = request.needText("id");
            if (businessType.equals("leave")) {
                ProcessInstance instance2 = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(id, "lakemob_leave").singleResult();
                if (instance2 != null) {
                    String processInstanceId = instance2.getProcessInstanceId();
                    this.runtimeService.deleteProcessInstance(processInstanceId, "clean data");
                }
            } else if (businessType.equals("document") && (instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(id, "lakemob_document").singleResult()) != null) {
                String processInstanceId = instance.getProcessInstanceId();
                this.runtimeService.deleteProcessInstance(processInstanceId, "clean data");
            }
        } else if (operate.equals("check")) {
            LOGGER.info("start check business && workflow");
            List docTaskList = this.taskService.createTaskQuery().active().processDefinitionKey("lakemob_document").list();
            for (Task task : docTaskList) {
                DocumentEntity doc;
                ProcessInstance process = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                if (process == null || (doc = this.documentService.getDocumentById(process.getBusinessKey())) != null) continue;
                LOGGER.warn("find task {}:{}:{} without document:{}, workflow process:{}", new Object[]{task.getId(), task.getName(), task.getAssignee(), process.getBusinessKey(), task.getProcessInstanceId()});
            }
            List leaveTaskList = this.taskService.createTaskQuery().active().processDefinitionKey("lakemob_leave").list();
            for (Task task : leaveTaskList) {
                LeaveEntity leave;
                ProcessInstance process = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                if (process == null || (leave = this.leaveService.getLeaveById(process.getBusinessKey())) != null) continue;
                LOGGER.warn("find task {}:{}:{} without leave:{}, workflow process:{}", new Object[]{task.getId(), task.getName(), task.getAssignee(), process.getBusinessKey(), task.getProcessInstanceId()});
            }
            LOGGER.info("end check business && workflow");
        } else if (operate.equals("repair")) {
            LOGGER.info("start repair business && workflow");
            List docTaskList = this.taskService.createTaskQuery().active().processDefinitionKey("lakemob_document").list();
            for (Task task : docTaskList) {
                DocumentEntity doc;
                ProcessInstance process = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                if (process == null || (doc = this.documentService.getDocumentById(process.getBusinessKey())) != null) continue;
                try {
                    LOGGER.warn("clean task {}:{}:{} without document:{}, workflow process:{}", new Object[]{task.getId(), task.getName(), task.getAssignee(), process.getBusinessKey(), task.getProcessInstanceId()});
                    this.runtimeService.deleteProcessInstance(process.getProcessInstanceId(), "clean data");
                }
                catch (Exception e) {
                    LOGGER.error("clean one task failure", (Throwable)e);
                }
            }
            List leaveTaskList = this.taskService.createTaskQuery().active().processDefinitionKey("lakemob_leave").list();
            for (Task task : leaveTaskList) {
                LeaveEntity leave;
                ProcessInstance process = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                if (process == null || (leave = this.leaveService.getLeaveById(process.getBusinessKey())) != null) continue;
                try {
                    LOGGER.warn("clean task {}:{}:{} without leave:{}, workflow process:{}", new Object[]{task.getId(), task.getName(), task.getAssignee(), process.getBusinessKey(), task.getProcessInstanceId()});
                    this.runtimeService.deleteProcessInstance(process.getProcessInstanceId(), "clean data");
                }
                catch (Exception e) {
                    LOGGER.error("clean one task failure", (Throwable)e);
                }
            }
            LOGGER.info("end repair business && workflow");
        }
        return new HashMap();
    }
}

