/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.rpcMethod;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.TaskService;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.stereotype.Service;
import pams.function.xatl.ruyihu.entity.AttachmentEntity;
import pams.function.xatl.ruyihu.entity.DocumentEntity;
import pams.function.xatl.ruyihu.entity.ElectronicSignEntity;
import pams.function.xatl.ruyihu.entity.FlowAssociateEntity;
import pams.function.xatl.ruyihu.entity.FlowTraceEntity;
import pams.function.xatl.ruyihu.entity.NoticeEntity;
import pams.function.xatl.ruyihu.jsonrpc.LakeMobMethod;
import pams.function.xatl.ruyihu.jsonrpc.SuperRequest;
import pams.function.xatl.ruyihu.service.AttachmentService;
import pams.function.xatl.ruyihu.service.DocumentService;
import pams.function.xatl.ruyihu.service.ElectronicSignService;
import pams.function.xatl.ruyihu.service.FastDFSClientService;
import pams.function.xatl.ruyihu.service.FlowAssociateService;
import pams.function.xatl.ruyihu.service.FlowTraceService;
import pams.function.xatl.ruyihu.service.NoticeService;
import pams.function.xatl.ruyihu.util.LakeMobUtils;
import pams.function.xatl.ruyihu.util.MyAssert;
import pams.function.xatl.ruyihu.util.QuickJson;

@Service
public class GetDocumentDetail
extends LakeMobMethod {
    @Resource
    private DocumentService documentService;
    @Resource
    private AttachmentService attachmentService;
    @Resource
    private FlowAssociateService flowAssociateService;
    @Resource
    private FlowTraceService flowTraceService;
    @Resource
    private NoticeService noticeService;
    @Resource
    private UserManageService userManageService;
    @Resource
    private ElectronicSignService electronicSignService;
    @Resource
    private FastDFSClientService fastDFSClientService;
    @Resource
    private TaskService taskService;

    @Override
    public Object execute0(String currentUser, SuperRequest request) {
        String documentId = request.needText("documentId");
        DocumentEntity doc = this.documentService.getDocumentById(documentId);
        MyAssert.notNull(doc, "\u65e0\u6cd5\u627e\u5230\u516c\u6587" + documentId);
        List<AttachmentEntity> attachments = this.attachmentService.getAttachmentListByOwnerId(documentId, "doc");
        List<FlowAssociateEntity> flowAssociates = this.flowAssociateService.getFlowAssociateListByDocumentIdMergeDoneTask(documentId);
        List<FlowTraceEntity> flowTraces = this.flowTraceService.getFlowTraceListByDocumentId(documentId);
        List<NoticeEntity> copyList = this.noticeService.getCopyListByDocumentId(documentId);
        ObjectNode root = JsonNodeFactory.instance.objectNode();
        Person authorPerson = this.userManageService.queryPersonById(doc.getPersonId());
        root.put("documentId", doc.getDocumentId()).put("issueDate", DateFormatUtils.format((Date)doc.getIssueDate(), (String)"yyyy/MM/dd")).put("shortName", doc.getShortName()).put("typeDesc", LakeMobUtils.DocumentTypeMap.get(doc.getDocumentType())).put("issueOffice", doc.getIssueOffice()).put("title", doc.getDocumentTitle()).put("workflowDone", "doc_status_done".equals(doc.getApprovalStatus())).put("personName", authorPerson.getName()).put("depName", authorPerson.getDepartment().getName());
        ArrayNode attachmentListNode = JsonNodeFactory.instance.arrayNode();
        for (AttachmentEntity one : attachments) {
            attachmentListNode.add((JsonNode)QuickJson.newObjectNode().put("id", one.getAttachmentId()).put("size", one.getAttachmentSize()).put("name", one.getAttachmentName()).put("url", this.fastDFSClientService.getRealDownloadUrl(one.getAttachmentUrl())));
        }
        ArrayNode workflowPersonListNode = JsonNodeFactory.instance.arrayNode();
        for (FlowAssociateEntity one : flowAssociates) {
            if ("doneTask".equals(one.getTaskKey()) && one.getPersonId().equals("0")) {
                workflowPersonListNode.add((JsonNode)QuickJson.newObjectNode().put("id", one.getId()).put("personId", one.getPersonId()).put("personName", "\u529e\u516c\u5ba4\u529e\u7ed3").put("processed", LakeMobUtils.isTrue(one.getProcessStatus())));
                continue;
            }
            String personName = "";
            personName = one.getPersonId().equals(currentUser) ? "\u6211" : this.userManageService.queryPersonById(one.getPersonId()).getName();
            workflowPersonListNode.add((JsonNode)QuickJson.newObjectNode().put("id", one.getId()).put("personId", one.getPersonId()).put("personName", personName).put("processed", LakeMobUtils.isTrue(one.getProcessStatus())));
        }
        ArrayNode workflowTraceListNode = JsonNodeFactory.instance.arrayNode();
        for (FlowTraceEntity one : flowTraces) {
            ElectronicSignEntity electronicSignByPerson = this.electronicSignService.getElectronicSignByPerson(one.getPersonId());
            String personName = "";
            personName = one.getPersonId().equals(currentUser) ? "\u6211" : this.userManageService.queryPersonById(one.getPersonId()).getName();
            workflowTraceListNode.add((JsonNode)QuickJson.newObjectNode().put("id", one.getTraceId()).put("personId", one.getPersonId()).put("personName", personName).put("comment", one.getProcessComment()).put("createTime", DateFormatUtils.format((Date)one.getDoneTime(), (String)"yyyy/MM/dd HH:mm:ss")).put("electronicSignUrl", this.fastDFSClientService.getRealDownloadUrl(LakeMobUtils.getSignUrl(electronicSignByPerson))));
        }
        ArrayNode copyTraceListNode = JsonNodeFactory.instance.arrayNode();
        for (NoticeEntity one : copyList) {
            String signUrl = LakeMobUtils.getSignUrl(this.electronicSignService.getElectronicSignByPerson(one.getProcesserId()));
            boolean processed = LakeMobUtils.isTrue(one.getProcessStatus());
            String personName = "";
            personName = one.getProcesserId().equals(currentUser) ? "\u6211" : this.userManageService.queryPersonById(one.getProcesserId()).getName();
            copyTraceListNode.add((JsonNode)QuickJson.newObjectNode().put("id", one.getNoticeId()).put("personId", one.getProcesserId()).put("personName", personName).put("processed", processed).put("statusDesc", processed ? "\u5df2\u5904\u7406" : "\u5904\u7406\u4e2d").put("comment", one.getProcessComment()).put("createTime", DateFormatUtils.format((Date)one.getCreateTime(), (String)"yyyy/MM/dd HH:mm:ss")).put("electronicSignUrl", this.fastDFSClientService.getRealDownloadUrl(signUrl)));
        }
        root.put("attachmentList", (JsonNode)attachmentListNode);
        root.put("workflowPersonList", (JsonNode)workflowPersonListNode);
        root.put("workflowTraceList", (JsonNode)workflowTraceListNode);
        root.put("copyTraceList", (JsonNode)copyTraceListNode);
        return root;
    }
}

