/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.rpcMethod;

import com.xdja.pams.common.util.Util;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import pams.function.xatl.ruyihu.bean.ApplyLeaveInfo;
import pams.function.xatl.ruyihu.entity.CalendarEntity;
import pams.function.xatl.ruyihu.jsonrpc.LakeMobMethod;
import pams.function.xatl.ruyihu.jsonrpc.SuperRequest;
import pams.function.xatl.ruyihu.service.CalendarService;
import pams.function.xatl.ruyihu.service.LeaveQueryService;
import pams.function.xatl.ruyihu.util.LakeMobException;

@Service
public class GetLeaveDays
extends LakeMobMethod {
    @Resource
    private CalendarService calendarService;
    @Resource
    private LeaveQueryService leaveQueryService;
    public static final Logger LOGGER = LoggerFactory.getLogger(GetLeaveDays.class);

    @Override
    public Object execute0(String currentUser, SuperRequest request) {
        ApplyLeaveInfo applyLeaveInfo = new ApplyLeaveInfo();
        applyLeaveInfo.setBeginDate(request.needText("beginDate"));
        applyLeaveInfo.setBeginHalfDay(request.needInt("beginHalfDay"));
        applyLeaveInfo.setEndTime(request.needText("endTime"));
        applyLeaveInfo.setEndHalfDay(request.needInt("endHalfDay"));
        applyLeaveInfo.setType(request.needText("type"));
        Date beginDate = null;
        Date endDate = null;
        try {
            beginDate = Util.parseDate((String)applyLeaveInfo.getBeginDate(), (String)"yyyy-MM-dd");
            endDate = Util.parseDate((String)applyLeaveInfo.getEndTime(), (String)"yyyy-MM-dd");
        }
        catch (Exception e) {
            LOGGER.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u5316\u9519\u8bef\uff1a{}", (Throwable)e);
            throw new LakeMobException("\u65e5\u671f\u683c\u5f0f\u8f6c\u5316\u9519\u8bef");
        }
        if (endDate.getTime() < beginDate.getTime() || endDate == beginDate && applyLeaveInfo.getEndHalfDay() < applyLeaveInfo.getBeginHalfDay()) {
            throw new LakeMobException("\u7ed3\u675f\u65e5\u671f\u5c0f\u4e8e\u5f00\u59cb\u65e5\u671f");
        }
        List<CalendarEntity> calendarEntityList = this.calendarService.queryCalendarEntityList(beginDate, endDate);
        float leaveDays = this.leaveQueryService.getLeaveDays(beginDate, applyLeaveInfo.getBeginHalfDay(), endDate, applyLeaveInfo.getEndHalfDay(), calendarEntityList, applyLeaveInfo.getType());
        HashMap<String, Float> map = new HashMap<String, Float>();
        map.put("leaveDays", Float.valueOf(leaveDays));
        LOGGER.info("\u8bf7\u5047\u5929\u6570leaveDays\uff1a" + leaveDays);
        return map;
    }
}

