/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.rpcMethod;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Iterables;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.task.Task;
import org.apache.commons.lang.time.DateFormatUtils;
import org.springframework.stereotype.Service;
import pams.function.xatl.ruyihu.entity.DocumentEntity;
import pams.function.xatl.ruyihu.jsonrpc.LakeMobMethod;
import pams.function.xatl.ruyihu.jsonrpc.SuperRequest;
import pams.function.xatl.ruyihu.service.DocumentService;
import pams.function.xatl.ruyihu.service.workflow.LakeMobWorkflowService;

@Service
public class GetPendingDocumentApprovalList
extends LakeMobMethod {
    @Resource
    private LakeMobWorkflowService lakeMobWorkflowService;
    @Resource
    private DocumentService documentService;

    @Override
    public Object execute0(String currentUser, SuperRequest request) {
        long timestamp = request.needLong("timestamp", 0L);
        int pageSize = request.needInt("pageSize", 10);
        List<Task> datas = this.lakeMobWorkflowService.getTopPendingDocumentApprovalList(currentUser, timestamp, pageSize);
        int totalCount = this.lakeMobWorkflowService.countTopPendingDocumentApprovalList(currentUser, timestamp);
        boolean dataEnd = totalCount <= datas.size();
        ObjectNode root = JsonNodeFactory.instance.objectNode();
        ArrayNode dataList = JsonNodeFactory.instance.arrayNode();
        for (Task task : datas) {
            String businessKey = this.lakeMobWorkflowService.getBusinessKey(task);
            DocumentEntity doc = this.documentService.getDocumentById(businessKey);
            boolean currentTaskIsDone = task.getTaskDefinitionKey().equals("doneTask");
            boolean showForward = false;
            showForward = doc == null ? false : !currentTaskIsDone;
            ObjectNode one = JsonNodeFactory.instance.objectNode().put("taskId", task.getId()).put("documentId", businessKey).put("node", task.getName()).put("personId", currentUser).put("processInstanceId", task.getProcessInstanceId()).put("showForward", showForward).put("showCopy", currentTaskIsDone).put("showDone", currentTaskIsDone).put("createTime", DateFormatUtils.format((Date)task.getCreateTime(), (String)"yyyy/MM/dd HH:mm:ss"));
            if (doc == null) {
                one.put("title", "\u5f02\u5e38\u6570\u636e " + task.getProcessInstanceId()).put("type", "Unknown");
            } else {
                one.put("title", doc.getDocumentTitle()).put("type", doc.getDocumentType());
            }
            dataList.add((JsonNode)one);
        }
        Task last = (Task)Iterables.getLast(datas, null);
        if (last != null) {
            root.put("timestamp", last.getCreateTime().getTime());
        } else {
            root.put("timestamp", 0);
        }
        root.put("dataEnd", dataEnd);
        root.put("dataList", (JsonNode)dataList);
        return root;
    }
}

