/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.service;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Random;
import javax.annotation.Resource;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import pams.function.jingxin.moments.util.FileInfo;
import pams.function.jingxin.moments.util.HttpUtils;
import pams.function.jingxin.moments.util.ResponseWrap;
import pams.function.xatl.ruyihu.bean.FastFileInfo;
import pams.function.xatl.ruyihu.util.LakeMobException;
import pams.function.xatl.ruyihu.util.MyAssert;
import pams.function.xatl.workreport.util.HmacSha1;

@Service
public class FastDFSClientService {
    @Resource
    private SystemConfigPbService configPbService;
    private static final Logger logger = LoggerFactory.getLogger(FastDFSClientService.class);
    private static final ObjectMapper json = new ObjectMapper();

    public void deleteFile(String downloadUrl) {
        String fastDFSUrl = this.getFastDFSUrl();
        DefaultHttpClient httpClient = new DefaultHttpClient();
        String uri = fastDFSUrl + "/delete/" + downloadUrl;
        logger.info("\u4eceFastDFS\u5220\u9664\u6587\u4ef6: " + uri);
        HttpPost post = new HttpPost(uri);
        try {
            HttpResponse execute = httpClient.execute((HttpUriRequest)post);
            EntityUtils.consumeQuietly((HttpEntity)execute.getEntity());
        }
        catch (IOException e) {
            logger.warn("\u4eceFastDFS\u5220\u9664\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public FastFileInfo uploadFile(byte[] data, String fileName) {
        String fileUrl = this.getFastDFSUrl();
        String userId = this.getFastDFSUserId();
        String userSecret = this.getFastDFSUserSecret();
        FileInfo fileInfo = FastDFSClientService.upload(data, fileName, 1, fileUrl, userId, userSecret);
        FastFileInfo rst = new FastFileInfo();
        rst.setFileId(fileInfo.getFileId());
        rst.setFileSize(data.length);
        rst.setFileName(fileName);
        return rst;
    }

    public FastFileInfo uploadFile(MultipartFile data, String fileName) {
        try {
            return this.uploadFile(data.getBytes(), fileName);
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38", (Throwable)e);
            throw new LakeMobException("\u4e0a\u4f20\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public FastFileInfo uploadFile(File data, String fileName) {
        return this.uploadFile(this.getBytes(data), fileName);
    }

    private byte[] getBytes(File file) {
        byte[] buffer = null;
        try {
            int n;
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    private String getFastDFSUrl() {
        String config = this.configPbService.getValueByCode("FASTDFS_SERVER_URL");
        MyAssert.notNull(config, "FastDFS\u670d\u52a1\u5668\u5730\u5740\u672a\u914d\u7f6e");
        return config;
    }

    private String getFastDFSUserId() {
        String userId = this.configPbService.getValueByCode("FASTDFS_SERVER_USER_ID");
        MyAssert.notNull(userId, "FastDFS\u670d\u52a1\u5668\u7528\u6237id\u672a\u914d\u7f6e");
        return userId;
    }

    private String getFastDFSUserSecret() {
        String userSecret = this.configPbService.getValueByCode("FASTDFS_SERVER_USER_SECRET");
        MyAssert.notNull(userSecret, "FastDFS\u670d\u52a1\u5668userSecret\u672a\u914d\u7f6e");
        return userSecret;
    }

    public String getRealDownloadUrl(String fileid) {
        if (StringUtils.hasText((String)fileid)) {
            String config = this.getFastDFSUrl();
            return config + "/" + fileid;
        }
        return "";
    }

    public static String uploadToFastDFS(String url, ContentBody fileContent) {
        url = !url.endsWith("/") ? url + "/upload" : url + "upload";
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpPost post = new HttpPost(url);
        MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, null, Charsets.UTF_8);
        entity.addPart("file", fileContent);
        post.setEntity((HttpEntity)entity);
        HttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)post);
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u5230FastDFS\u5931\u8d25", (Throwable)e);
            throw new LakeMobException("\u4e0a\u4f20\u6587\u4ef6\u5230FastDFS\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (response.getStatusLine().getStatusCode() == 200) {
            try {
                JsonNode root = json.readTree(response.getEntity().getContent());
                String fileid = root.path("fileid").asText();
                if (StringUtils.hasText((String)fileid)) {
                    logger.info("\u4e0a\u4f20\u6587\u4ef6\u5230FastDFS\u6210\u529f: " + fileid);
                    return fileid;
                }
                logger.error("FastDFS\u672a\u8fd4\u56defileid");
                throw new LakeMobException("FastDFS\u672a\u8fd4\u56defileid");
            }
            catch (Exception e) {
                logger.error("\u89e3\u6790FastDFS\u54cd\u5e94\u5185\u5bb9\u5931\u8d25", (Throwable)e);
                throw new LakeMobException("\u89e3\u6790FastDFS\u54cd\u5e94\u5185\u5bb9\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        logger.error("\u4e0a\u4f20\u6587\u4ef6\u5230FastDFS\uff0c\u54cd\u5e94\u4fe1\u606f\uff1a" + response.getStatusLine().toString());
        throw new LakeMobException("\u4e0a\u4f20\u6587\u4ef6\u5230FastDFS\uff0c\u54cd\u5e94\u4fe1\u606f\uff1a" + response.getStatusLine().toString());
    }

    public static FileInfo upload(byte[] bytes, String filename, int perm, String fileUrl, String userId, String userSecret) {
        Random rand = new Random();
        String boundary = "_" + rand.nextDouble() + "_BOUNDARY_" + rand.nextDouble() + "_";
        try {
            String fastDFSServerUrl = FastDFSClientService.getFastDFSServerUrl(fileUrl, userId, userSecret);
            ResponseWrap execute = HttpUtils.post((String)fastDFSServerUrl).addHeader("Content-Type", "multipart/form-data; boundary=" + boundary).newForm().addParameter("file", bytes, ContentType.APPLICATION_OCTET_STREAM, filename).addParameter("perm", String.valueOf(perm)).setBoundary(boundary).execute();
            int statusCode = execute.getStatusLine().getStatusCode();
            String result = execute.getString();
            if (statusCode == 200) {
                List fileInfos = JSON.parseArray((String)result, FileInfo.class);
                if (fileInfos.size() > 0) {
                    return (FileInfo)fileInfos.get(0);
                }
                return null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    public static void downloadTo(String url, String path) throws IOException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpGet get = new HttpGet(url);
        HttpResponse execute = httpClient.execute((HttpUriRequest)get);
        MyAssert.isTrue(execute.getStatusLine().getStatusCode() == 200, "\u4eceFastDFS\u4e0b\u8f7d\u6587\u4ef6" + url + "\u5931\u8d25\uff1a" + execute.getStatusLine().toString());
        HttpEntity entity = execute.getEntity();
        entity.writeTo((OutputStream)new FileOutputStream(path));
        logger.debug("download {} to {} ", (Object)url, (Object)path);
    }

    public static String getFastDFSServerUrl(String fileUrl, String userId, String userSecret) {
        Long ts = System.currentTimeMillis() + 600000L;
        try {
            String sign = HmacSha1.hamcsha1(new StringBuffer(userId).append(ts).toString(), userSecret);
            logger.debug("url\u5730\u5740\u662f" + new StringBuffer(fileUrl).append("/upload?userid=").append(userId).append("&ts=").append(ts).append("&sign=").append(sign).toString());
            String fileServerUrl = new StringBuffer(fileUrl).append("/upload?userid=").append(userId).append("&ts=").append(ts).append("&sign=").append(sign).toString();
            return fileServerUrl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

