/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.service.impl;

import com.google.common.collect.Lists;
import com.xdja.pams.bims.dao.PersonDao;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.rptms.bean.QueryReportTemplateBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperRunManager;
import org.activiti.engine.task.Task;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import pams.function.xatl.ruyihu.bean.ApplyMoneyDetailBean;
import pams.function.xatl.ruyihu.bean.ApplyMoneyInfo;
import pams.function.xatl.ruyihu.bean.ApplyMoneyListNode;
import pams.function.xatl.ruyihu.bean.FastFileInfo;
import pams.function.xatl.ruyihu.dao.AttachmentDao;
import pams.function.xatl.ruyihu.dao.ElectronicSignDao;
import pams.function.xatl.ruyihu.dao.FlowAssociateDao;
import pams.function.xatl.ruyihu.dao.FlowTraceDao;
import pams.function.xatl.ruyihu.dao.IApplyMoneyDao;
import pams.function.xatl.ruyihu.dao.IFlowNoticeDao;
import pams.function.xatl.ruyihu.entity.ApplyMoneyEntity;
import pams.function.xatl.ruyihu.entity.AttachmentEntity;
import pams.function.xatl.ruyihu.entity.ElectronicSignEntity;
import pams.function.xatl.ruyihu.entity.FlowAssociateEntity;
import pams.function.xatl.ruyihu.entity.FlowNoticeEntity;
import pams.function.xatl.ruyihu.entity.FlowTraceEntity;
import pams.function.xatl.ruyihu.enums.ApplyMoneyStatusEnum;
import pams.function.xatl.ruyihu.enums.ApplyMoneyTypeEnum;
import pams.function.xatl.ruyihu.service.AuthService;
import pams.function.xatl.ruyihu.service.FastDFSClientService;
import pams.function.xatl.ruyihu.service.IApplyMoneyService;
import pams.function.xatl.ruyihu.service.LakeMobPushService;
import pams.function.xatl.ruyihu.service.workflow.LakeMobWorkflowService;
import pams.function.xatl.ruyihu.util.LakeMobUtils;
import pams.function.xatl.ruyihu.util.MyAssert;

@Service
public class ApplyMoneyServiceImpl
implements IApplyMoneyService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IApplyMoneyDao applyMoneyDao;
    @Resource
    private LakeMobWorkflowService lakeMobWorkflowService;
    @Resource
    private FastDFSClientService fastDFSClientService;
    @Resource
    private AttachmentDao attachmentDao;
    @Resource
    private FlowAssociateDao flowAssociateDao;
    @Resource
    private FlowTraceDao flowTraceDao;
    @Resource
    private PersonDao personDao;
    @Resource
    private ElectronicSignDao electronicSignDao;
    @Resource
    private IFlowNoticeDao flowNoticeDao;
    @Resource
    private LakeMobPushService lakeMobPushService;
    @Resource
    private AuthService authService;

    @Override
    @Transactional
    public String applyMoney(ApplyMoneyInfo applyMoneyInfo) {
        this.logger.debug("\u63d0\u4ea4\u8d44\u91d1\u7533\u8bf7\uff1a{}");
        ApplyMoneyEntity applyMoneyEntity = new ApplyMoneyEntity();
        BeanUtils.copyProperties((Object)applyMoneyInfo, (Object)applyMoneyEntity);
        this.applyMoneyDao.save(applyMoneyEntity);
        List<String> attachments = applyMoneyInfo.getAttachments();
        if (!CollectionUtils.isEmpty(attachments)) {
            File parent = new File(QueryReportTemplateBean.ROOT_PATH, "tmpAttacheDir");
            for (String attach : attachments) {
                AttachmentEntity att = this.attachmentDao.getAttachment(attach);
                if (att == null) continue;
                if (att.getOwnerId().equals("0")) {
                    FastFileInfo fastFileInfo = this.fastDFSClientService.uploadFile(new File(parent, att.getAttachmentUrl()), att.getAttachmentName());
                    att.setAttachmentUrl(fastFileInfo.getFileId());
                    att.setOwnerId(applyMoneyEntity.getApplyId());
                    att.setType("apply_money");
                    this.attachmentDao.saveAttachment(att);
                    continue;
                }
                AttachmentEntity attachment = new AttachmentEntity();
                BeanUtils.copyProperties((Object)att, (Object)attachment);
                attachment.setAttachmentId(null);
                attachment.setOwnerId(applyMoneyEntity.getApplyId());
                this.attachmentDao.saveAttachment(attachment);
            }
        }
        int order = 1;
        List<String> deptLeader = applyMoneyInfo.getDeptLeader();
        if (!CollectionUtils.isEmpty(deptLeader)) {
            for (String personId : deptLeader) {
                FlowAssociateEntity flowAssociateEntity = new FlowAssociateEntity();
                flowAssociateEntity.setBusinessId(applyMoneyEntity.getApplyId());
                flowAssociateEntity.setBusinessType("apply_money");
                flowAssociateEntity.setTaskKey("deptLeaderTask");
                flowAssociateEntity.setCreateTime(LakeMobUtils.now());
                flowAssociateEntity.setOrderNum(order++);
                flowAssociateEntity.setPersonId(personId);
                flowAssociateEntity.setProcessStatus("0");
                this.flowAssociateDao.saveFlowAssociate(flowAssociateEntity);
            }
        }
        order = 1;
        List<String> leader = applyMoneyInfo.getLeader();
        if (!CollectionUtils.isEmpty(leader)) {
            for (String personId : leader) {
                FlowAssociateEntity flowAssociateEntity = new FlowAssociateEntity();
                flowAssociateEntity.setBusinessId(applyMoneyEntity.getApplyId());
                flowAssociateEntity.setBusinessType("apply_money");
                flowAssociateEntity.setTaskKey("leaderTask");
                flowAssociateEntity.setCreateTime(LakeMobUtils.now());
                flowAssociateEntity.setOrderNum(order++);
                flowAssociateEntity.setPersonId(personId);
                flowAssociateEntity.setProcessStatus("0");
                this.flowAssociateDao.saveFlowAssociate(flowAssociateEntity);
            }
        }
        order = 1;
        List<String> director = applyMoneyInfo.getDirector();
        if (!CollectionUtils.isEmpty(director)) {
            for (String personId : director) {
                FlowAssociateEntity flowAssociateEntity = new FlowAssociateEntity();
                flowAssociateEntity.setBusinessId(applyMoneyEntity.getApplyId());
                flowAssociateEntity.setBusinessType("apply_money");
                flowAssociateEntity.setTaskKey("directorTask");
                flowAssociateEntity.setCreateTime(LakeMobUtils.now());
                flowAssociateEntity.setOrderNum(order++);
                flowAssociateEntity.setPersonId(personId);
                flowAssociateEntity.setProcessStatus("0");
                this.flowAssociateDao.saveFlowAssociate(flowAssociateEntity);
            }
        }
        order = 1;
        List<String> secretary = applyMoneyInfo.getSecretary();
        if (!CollectionUtils.isEmpty(secretary)) {
            for (String personId : secretary) {
                FlowAssociateEntity flowAssociateEntity = new FlowAssociateEntity();
                flowAssociateEntity.setBusinessId(applyMoneyEntity.getApplyId());
                flowAssociateEntity.setBusinessType("apply_money");
                flowAssociateEntity.setTaskKey("secretaryTask");
                flowAssociateEntity.setCreateTime(LakeMobUtils.now());
                flowAssociateEntity.setOrderNum(order++);
                flowAssociateEntity.setPersonId(personId);
                flowAssociateEntity.setProcessStatus("0");
                this.flowAssociateDao.saveFlowAssociate(flowAssociateEntity);
            }
        }
        String workflowId = this.lakeMobWorkflowService.startApplyMoneyWorkflow(applyMoneyInfo, applyMoneyEntity.getApplyId());
        applyMoneyEntity.setWorkflowId(workflowId);
        applyMoneyEntity.setStatus(ApplyMoneyStatusEnum.ING.value);
        this.applyMoneyDao.save(applyMoneyEntity);
        return applyMoneyEntity.getApplyId();
    }

    @Override
    public List<ApplyMoneyListNode> applyMoneyList(boolean isFinLeader, String currentUser, long timestamp, int pageSize) {
        List<ApplyMoneyEntity> list = this.applyMoneyDao.applyMoneyList(isFinLeader, currentUser, timestamp, pageSize);
        ArrayList result = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(list)) {
            for (ApplyMoneyEntity applyMoney : list) {
                ApplyMoneyListNode listNode = new ApplyMoneyListNode();
                listNode.setApplyDept(applyMoney.getApplyDept());
                listNode.setApplyId(applyMoney.getApplyId());
                listNode.setApplyType(applyMoney.getApplyType());
                listNode.setCreateTime(applyMoney.getCreateTime().getTime());
                listNode.setUpdateTime(applyMoney.getUpdateTime().getTime());
                listNode.setStatus(applyMoney.getStatus());
                Task task = this.lakeMobWorkflowService.getTask(currentUser, applyMoney.getWorkflowId(), "lakemob_apply_money");
                if (null != task) {
                    listNode.setStatus(ApplyMoneyStatusEnum.WAIT.value);
                }
                boolean isNew = true;
                List<FlowNoticeEntity> flowNotice = this.flowNoticeDao.get(applyMoney.getApplyId(), "apply_money", currentUser);
                if (CollectionUtils.isEmpty(flowNotice)) {
                    isNew = false;
                }
                listNode.setIsNew(isNew);
                result.add(listNode);
            }
        }
        return result;
    }

    @Override
    @Transactional
    public ApplyMoneyDetailBean applyMoneyDetail(String personId, String applyId) {
        List<AttachmentEntity> attachmentList;
        ApplyMoneyEntity applyMoney = this.applyMoneyDao.get(applyId);
        ApplyMoneyDetailBean applyMoneyDetail = new ApplyMoneyDetailBean();
        BeanUtils.copyProperties((Object)applyMoney, (Object)applyMoneyDetail);
        Person person = this.personDao.queryPersonById(applyMoneyDetail.getApplyUserId());
        if (null != person) {
            applyMoneyDetail.setApplyUserName(person.getName());
        }
        if (!CollectionUtils.isEmpty(attachmentList = this.attachmentDao.getAttachmentListByOwnerId(applyId, "apply_money"))) {
            ArrayList returnAttachments = Lists.newArrayList();
            for (AttachmentEntity attachment : attachmentList) {
                returnAttachments.add(this.attachment2Map(attachment));
            }
            applyMoneyDetail.setAttachments(returnAttachments);
        }
        boolean deleteNotic = true;
        List<FlowAssociateEntity> flowAssociateList = this.flowAssociateDao.getFlowAssociateListByBusinessTypeAndId("apply_money", applyId);
        if (!CollectionUtils.isEmpty(flowAssociateList)) {
            ArrayList deptLeader = Lists.newArrayList();
            ArrayList leader = Lists.newArrayList();
            ArrayList director = Lists.newArrayList();
            ArrayList secretary = Lists.newArrayList();
            for (FlowAssociateEntity flowAssociate : flowAssociateList) {
                if (StringUtils.isEmpty((CharSequence)personId) || flowAssociate.getPersonId().equals(personId) && flowAssociate.getProcessStatus().equals("0")) {
                    deleteNotic = false;
                }
                FlowTraceEntity flowTrace = this.flowTraceDao.getFlowTraceByBusinessAndWorkflowIdAndPerson(flowAssociate.getTaskKey(), applyId, applyMoney.getWorkflowId(), flowAssociate.getPersonId());
                Map<String, Object> map = null;
                map = null != flowTrace ? this.flowTrace2Map(flowTrace) : this.flowAssociate2Map(flowAssociate);
                if (flowAssociate.getTaskKey().equals("deptLeaderTask")) {
                    deptLeader.add(map);
                    continue;
                }
                if (flowAssociate.getTaskKey().equals("leaderTask")) {
                    leader.add(map);
                    continue;
                }
                if (flowAssociate.getTaskKey().equals("directorTask")) {
                    director.add(map);
                    continue;
                }
                if (!flowAssociate.getTaskKey().equals("secretaryTask")) continue;
                secretary.add(map);
            }
            applyMoneyDetail.setDeptLeader(deptLeader);
            applyMoneyDetail.setLeader(leader);
            applyMoneyDetail.setDirector(director);
            applyMoneyDetail.setSecretary(secretary);
        }
        if (deleteNotic) {
            List<FlowNoticeEntity> flowNoticeEntities = this.flowNoticeDao.get(applyId, "apply_money", personId);
            if (!CollectionUtils.isEmpty(flowNoticeEntities)) {
                this.flowNoticeDao.delete(applyId, "apply_money", personId);
            }
            String finLeader = this.authService.getFinLeader();
            if (applyMoney.getStatus() == ApplyMoneyStatusEnum.DONE.value && finLeader.equals(personId)) {
                applyMoney.setUpdateTime(LakeMobUtils.now());
                this.applyMoneyDao.save(applyMoney);
            }
        }
        return applyMoneyDetail;
    }

    @Override
    @Transactional
    public String applyMoneyAgain(String oldApplyId, ApplyMoneyInfo applyMoneyInfo) {
        ApplyMoneyEntity applyMoneyEntity = this.applyMoneyDao.get(oldApplyId);
        applyMoneyEntity.setStatus(ApplyMoneyStatusEnum.DELETE.value);
        this.applyMoneyDao.save(applyMoneyEntity);
        this.flowNoticeDao.delete(oldApplyId, "apply_money");
        return this.applyMoney(applyMoneyInfo);
    }

    @Override
    public ApplyMoneyEntity get(String applyId) {
        return this.applyMoneyDao.get(applyId);
    }

    @Override
    public void save(ApplyMoneyEntity applyMoney) {
        this.applyMoneyDao.save(applyMoney);
    }

    @Override
    public void doneApplyMoney(String applyId, Object type) {
        ApplyMoneyEntity applyMoney = this.applyMoneyDao.get(applyId);
        if (null == applyMoney) {
            return;
        }
        if (applyMoney.getStatus() == ApplyMoneyStatusEnum.DELETE.value) {
            return;
        }
        if (null != type) {
            if (LakeMobUtils.isTrue(type)) {
                applyMoney.setStatus(ApplyMoneyStatusEnum.DONE.value);
            } else {
                applyMoney.setStatus(ApplyMoneyStatusEnum.REFUSE.value);
            }
        }
        applyMoney.setDoneTime(LakeMobUtils.now());
        this.applyMoneyDao.save(applyMoney);
        if (applyMoney.getStatus() == ApplyMoneyStatusEnum.DONE.value) {
            String finLeader = this.authService.getFinLeader();
            this.flowNoticeDao.save(new FlowNoticeEntity(finLeader, applyId, "apply_money"));
            ArrayList ids = Lists.newArrayList();
            ids.add(finLeader);
            this.lakeMobPushService.pushApplyMoneyApproval(ids, "\u60a8\u6536\u5230\u65b0\u7684\u8d44\u91d1\u7533\u8bf7");
        }
        String applyUserId = applyMoney.getApplyUserId();
        this.flowNoticeDao.save(new FlowNoticeEntity(applyUserId, applyId, "apply_money"));
        ArrayList applyUsers = Lists.newArrayList();
        applyUsers.add(applyUserId);
        this.lakeMobPushService.pushApplyMoneyApproval(applyUsers, "\u60a8\u6536\u5230\u65b0\u7684\u8d44\u91d1\u7533\u8bf7\u5ba1\u6279");
        List<FlowTraceEntity> flowTraceList = this.flowTraceDao.getFlowTraceListByBusinessTypeAndId("apply_money", applyId);
        if (!CollectionUtils.isEmpty(flowTraceList)) {
            FlowTraceEntity last = flowTraceList.get(flowTraceList.size() - 1);
            Person applyUser = this.personDao.queryPersonById(applyUserId);
            Person approvalUser = this.personDao.queryPersonById(last.getPersonId());
            ArrayList ids = Lists.newArrayList();
            for (FlowTraceEntity flowTrace : flowTraceList) {
                if (flowTrace.getTraceId().equals(last.getTraceId())) continue;
                ids.add(flowTrace.getPersonId());
                this.flowNoticeDao.save(new FlowNoticeEntity(flowTrace.getPersonId(), applyId, "apply_money"));
            }
            this.lakeMobPushService.pushApplyMoneyApproval(ids, approvalUser.getName() + "\u5ba1\u6279\u4e86" + applyUser.getName() + "\u7684\u8d44\u91d1\u7533\u8bf7");
        }
    }

    @Override
    @Transactional
    public void delete(String applyId) {
        ApplyMoneyEntity applyMoney = this.applyMoneyDao.get(applyId);
        applyMoney.setStatus(ApplyMoneyStatusEnum.DELETE.value);
        this.applyMoneyDao.save(applyMoney);
        this.flowNoticeDao.delete(applyId, "apply_money");
        this.lakeMobWorkflowService.delete(applyId, "lakemob_apply_money");
    }

    @Override
    public List<ApplyMoneyEntity> applyMoneyList(Integer applyType, String applyDept, String projectName, Integer status, String startDate, String endDate, Page page) {
        return this.applyMoneyDao.applyMoneyList(applyType, applyDept, projectName, status, startDate, endDate, page);
    }

    @Override
    public byte[] reportToPDF(String applyId) throws Exception {
        ApplyMoneyEntity applyMoney = this.applyMoneyDao.get(applyId);
        MyAssert.notNull(applyMoney, "\u8d44\u91d1\u7533\u8bf7" + applyId + "\u4e0d\u5b58\u5728");
        String classResourcePath = null;
        Map<String, Object> parameters = null;
        if (applyMoney.getApplyType() == ApplyMoneyTypeEnum.DAILY_PROC.value) {
            classResourcePath = "/jrxml/dailyApplyMoney.jrxml";
            parameters = this.getDailyApplyMoneyParameters(applyMoney);
        } else if (applyMoney.getApplyType() == ApplyMoneyTypeEnum.GOV_PROC.value) {
            classResourcePath = "/jrxml/govApplyMoney.jrxml";
            parameters = this.getGovApplyMoneyParameters(applyMoney);
        } else {
            MyAssert.notNull(null, "\u8d44\u91d1\u7533\u8bf7\u7c7b\u578b" + applyMoney.getApplyType() + "\u4e0d\u5b58\u5728");
        }
        URL resource = this.getClass().getResource(classResourcePath);
        if (resource == null) {
            this.logger.error("Can't found resource: " + classResourcePath);
            MyAssert.notNull(resource, "Can't found resource: " + classResourcePath);
        }
        this.logger.debug("read resource: " + resource.getFile());
        JasperReport jasperReport = JasperCompileManager.compileReport((InputStream)new FileInputStream(resource.getFile()));
        return JasperRunManager.runReportToPdf((JasperReport)jasperReport, parameters, (JRDataSource)new JREmptyDataSource());
    }

    private Map<String, Object> getGovApplyMoneyParameters(ApplyMoneyEntity applyMoney) throws Exception {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("applyDept", applyMoney.getApplyDept());
        root.put("projectName", applyMoney.getProjectName());
        root.put("info", applyMoney.getInfo());
        root.put("money", applyMoney.getMoney() + " \u5143");
        root.put("procType", applyMoney.getProcType());
        root.put("procSn", applyMoney.getProcSn());
        root.put("agencyRecord", applyMoney.getAgencyRecord());
        root.put("agencyLinkMan", applyMoney.getAgencyLinkMan());
        root.put("agencyLinkManContact", applyMoney.getAgencyLinkManContact());
        root.put("procLinkMan", applyMoney.getProcLinkMan());
        root.put("procLinkManContact", applyMoney.getProcLinkManContact());
        this.flowTraces(root, applyMoney.getApplyId());
        if (applyMoney.getStatus() == ApplyMoneyStatusEnum.DONE.value) {
            String finLeader = this.authService.getFinLeader();
            List<FlowNoticeEntity> flowNotices = this.flowNoticeDao.get(applyMoney.getApplyId(), "apply_money", finLeader);
            if (CollectionUtils.isEmpty(flowNotices)) {
                String sign = "";
                ElectronicSignEntity electronicSign = this.electronicSignDao.getElectronicSignByPerson(finLeader);
                if (null != electronicSign) {
                    sign = this.fastDFSClientService.getRealDownloadUrl(electronicSign.getSignUrl());
                }
                root.put("finLeaderCommon", "\u5df2\u9605");
                root.put("finLeaderSign", sign);
                Date date = applyMoney.getUpdateTime();
                root.put("finLeaderDate", DateFormatUtils.format((Date)date, (String)"yyyy \u5e74 MM \u6708 dd \u65e5"));
            }
        }
        return root;
    }

    private Map<String, Object> getDailyApplyMoneyParameters(ApplyMoneyEntity applyMoney) throws Exception {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("applyDept", applyMoney.getApplyDept());
        Date applyDate = Util.parseDate((String)applyMoney.getApplyDate(), (String)"yyyy-MM-dd");
        root.put("applyDate", DateFormatUtils.format((Date)applyDate, (String)"yyyy \u5e74 MM \u6708 dd \u65e5"));
        root.put("info", applyMoney.getInfo());
        root.put("money", applyMoney.getMoney());
        this.flowTraces(root, applyMoney.getApplyId());
        return root;
    }

    private void flowTraces(Map<String, Object> root, String applyId) {
        List<FlowTraceEntity> flowTraces = this.flowTraceDao.getFlowTraceListByBusinessTypeAndId("apply_money", applyId);
        if (!CollectionUtils.isEmpty(flowTraces)) {
            for (FlowTraceEntity flowTrace : flowTraces) {
                Date date = flowTrace.getDoneTime();
                String common = StringUtils.isEmpty((CharSequence)flowTrace.getProcessComment()) ? "" : flowTrace.getProcessComment();
                String sign = "";
                ElectronicSignEntity electronicSign = this.electronicSignDao.getElectronicSignByPerson(flowTrace.getPersonId());
                if (null != electronicSign) {
                    sign = this.fastDFSClientService.getRealDownloadUrl(electronicSign.getSignUrl());
                }
                String fxxk = "\u62d2\u7edd\u3002";
                if (LakeMobUtils.isTrue(flowTrace.getPass())) {
                    fxxk = "\u540c\u610f\u3002";
                }
                if (flowTrace.getTaskKey().equals("deptLeaderTask")) {
                    root.put("deptCommon", fxxk + common);
                    root.put("deptSign", sign);
                    root.put("deptDate", DateFormatUtils.format((Date)date, (String)"yyyy \u5e74 MM \u6708 dd \u65e5"));
                    continue;
                }
                if (flowTrace.getTaskKey().equals("leaderTask")) {
                    root.put("leaderCommon", fxxk + common);
                    root.put("leaderSign", sign);
                    root.put("leaderDate", DateFormatUtils.format((Date)date, (String)"yyyy \u5e74 MM \u6708 dd \u65e5"));
                    continue;
                }
                if (flowTrace.getTaskKey().equals("directorTask")) {
                    root.put("directorCommon", fxxk + common);
                    root.put("directorSign", sign);
                    root.put("directorDate", DateFormatUtils.format((Date)date, (String)"yyyy \u5e74 MM \u6708 dd \u65e5"));
                    continue;
                }
                if (!flowTrace.getTaskKey().equals("secretaryTask")) continue;
                root.put("secretaryCommon", fxxk + common);
                root.put("secretarySign", sign);
                root.put("secretaryDate", DateFormatUtils.format((Date)date, (String)"yyyy \u5e74 MM \u6708 dd \u65e5"));
            }
        }
    }

    private Map<String, Object> attachment2Map(AttachmentEntity attachment) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", attachment.getAttachmentId());
        map.put("size", attachment.getAttachmentSize());
        map.put("name", attachment.getAttachmentName());
        map.put("url", this.fastDFSClientService.getRealDownloadUrl(attachment.getAttachmentUrl()));
        return map;
    }

    private Map<String, Object> flowTrace2Map(FlowTraceEntity flowTrace) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", flowTrace.getTraceId());
        map.put("personId", flowTrace.getPersonId());
        Person flowPerson = this.personDao.queryPersonById(flowTrace.getPersonId());
        map.put("personName", flowPerson.getName());
        map.put("comment", flowTrace.getProcessComment());
        map.put("statusDesc", flowTrace.getPass().equals("1") ? "\u6279\u51c6" : "\u62d2\u7edd");
        map.put("createTime", Util.getDate((String)"yyyy/MM/dd HH:mm:ss", (Date)flowTrace.getCreateTime()));
        ElectronicSignEntity electronicSign = this.electronicSignDao.getElectronicSignByPerson(flowTrace.getPersonId());
        if (null != electronicSign) {
            map.put("electronicSignUrl", this.fastDFSClientService.getRealDownloadUrl(electronicSign.getSignUrl()));
        }
        return map;
    }

    private Map<String, Object> flowAssociate2Map(FlowAssociateEntity flowAssociate) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", null);
        map.put("personId", flowAssociate.getPersonId());
        Person flowPerson = this.personDao.queryPersonById(flowAssociate.getPersonId());
        map.put("personName", flowPerson.getName());
        map.put("statusDesc", "\u5f85\u5ba1\u6279");
        return map;
    }
}

