/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.service.workflow;

import javax.annotation.Resource;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.springframework.stereotype.Service;
import pams.function.xatl.ruyihu.service.DocumentService;
import pams.function.xatl.ruyihu.service.IApplyMoneyService;
import pams.function.xatl.ruyihu.service.IBusinessTripService;
import pams.function.xatl.ruyihu.service.LeaveService;
import pams.function.xatl.ruyihu.util.LakeMobUtils;

@Service(value="lakeMobActivitiExecutionListener")
public class LakeMobActivitiExecutionListener
implements ExecutionListener {
    private static final long serialVersionUID = 1L;
    @Resource
    private DocumentService documentService;
    @Resource
    private LeaveService leaveService;
    @Resource
    private IApplyMoneyService applyMoneyService;
    @Resource
    private IBusinessTripService businessTripService;

    public void notify(DelegateExecution execution) throws Exception {
        String processDefinitionId = execution.getProcessDefinitionId();
        if (processDefinitionId.startsWith("lakemob_document")) {
            this.processDocument(execution);
        } else if (processDefinitionId.startsWith("lakemob_leave")) {
            this.processLeave(execution);
        } else if (processDefinitionId.startsWith("lakemob_apply_money")) {
            this.processApplyMoney(execution);
        } else if (processDefinitionId.startsWith("lakemob_business_trip")) {
            this.processBusinessTrip(execution);
        }
    }

    private void processBusinessTrip(DelegateExecution execution) {
        if ("end".equals(execution.getEventName())) {
            boolean revoked = LakeMobUtils.isTrue(execution.getVariable("revoked"));
            boolean type = LakeMobUtils.isTrue(execution.getVariable("type"));
            String applyId = execution.getProcessBusinessKey();
            this.businessTripService.doneBusinessTrip(applyId, revoked, type);
        }
    }

    private void processApplyMoney(DelegateExecution execution) {
        if ("end".equals(execution.getEventName())) {
            Object type = execution.getVariable("type");
            String leaveId = execution.getProcessBusinessKey();
            this.applyMoneyService.doneApplyMoney(leaveId, type);
        }
    }

    private void processLeave(DelegateExecution execution) {
        if ("end".equals(execution.getEventName())) {
            boolean revoked = LakeMobUtils.isTrue(execution.getVariable("revoked"));
            boolean pass = LakeMobUtils.isTrue(execution.getVariable("pass"));
            String leaveId = execution.getProcessBusinessKey();
            this.leaveService.doneLeave(leaveId, revoked, pass);
        }
    }

    private void processDocument(DelegateExecution execution) {
        if ("end".equals(execution.getEventName())) {
            String documentId = execution.getProcessBusinessKey();
            this.documentService.doneDocument(documentId);
        }
    }
}

