/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.ruyihu.service.workflow;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.ActivitiTaskAlreadyClaimedException;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import pams.function.xatl.ruyihu.bean.ApplyMoneyInfo;
import pams.function.xatl.ruyihu.bean.BusinessTripInfo;
import pams.function.xatl.ruyihu.bean.LeaveApprovalParam;
import pams.function.xatl.ruyihu.bean.StartIssueForm;
import pams.function.xatl.ruyihu.bean.StartReceiveForm;
import pams.function.xatl.ruyihu.util.LakeMobUtils;

@Service
public class LakeMobWorkflowService {
    public static final Logger LOGGER = LoggerFactory.getLogger(LakeMobWorkflowService.class);
    @Resource
    private RuntimeService runtimeService;
    @Resource
    private TaskService taskService;
    @Resource
    private IdentityService identityService;

    @Transactional
    public String startIssueDocumentWorkflow(StartIssueForm form, String documentId) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("docType", "issue");
        vars.put("officeFlowPersonList", form.getOfficeFlowPersonList());
        vars.put("countersignFlowPersonList", form.getCountersignFlowPersonList());
        vars.put("issueFlowPersonList", form.getIssueFlowPersonList());
        vars.put("doneFlowPersonList", form.getDoneFlowPersonList());
        vars.put("needCountersign", !CollectionUtils.isEmpty(form.getCountersignFlowPersonList()));
        vars.put("needIssue", !CollectionUtils.isEmpty(form.getIssueFlowPersonList()));
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("lakemob_document", documentId, vars);
        return processInstance.getProcessInstanceId();
    }

    @Transactional
    public String startReceiveDocumentWorkflow(StartReceiveForm form, String documentId) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("docType", "receive");
        vars.put("opinionFlowPersonList", form.getOpinionFlowPersonList());
        vars.put("leaderFlowPersonList", form.getLeaderFlowPersonList());
        vars.put("doneFlowPersonList", form.getDoneFlowPersonList());
        vars.put("needLeaderApproval", !CollectionUtils.isEmpty(form.getLeaderFlowPersonList()));
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("lakemob_document", documentId, vars);
        return processInstance.getProcessInstanceId();
    }

    @Transactional
    public String startLeaveWorkflow(String leaveId, String currentUser, List<String> workflowPersonList) {
        this.identityService.setAuthenticatedUserId(currentUser);
        HashMap<String, List<String>> vars = new HashMap<String, List<String>>();
        vars.put("workflowPersonList", workflowPersonList);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("lakemob_leave", leaveId, vars);
        return processInstance.getProcessInstanceId();
    }

    @Transactional
    public boolean revokeLeave(String personId, String leaveId) {
        Task task = (Task)this.taskService.createTaskQuery().processDefinitionKey("lakemob_leave").taskAssignee(personId).processInstanceBusinessKey(leaveId).taskDefinitionKey("revokeTask").singleResult();
        if (task != null) {
            HashMap vars = Maps.newHashMap();
            vars.put("revoked", true);
            this.taskService.complete(task.getId(), (Map)vars);
            return true;
        }
        return false;
    }

    public List<Task> getTopPendingLeaveApprovalList(LeaveApprovalParam leaveApprovalParam, int pageSize) {
        long timestamp = leaveApprovalParam.getTimestamp();
        String currentUser = leaveApprovalParam.getUserId();
        if (timestamp <= 0L) {
            timestamp = System.currentTimeMillis();
        }
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("lakemob_leave").taskDefinitionKey("leaveApprovalTask").taskAssignee(currentUser).taskCreatedBefore(new Date(timestamp)).orderByTaskCreateTime().desc()).listPage(0, pageSize);
        return tasks;
    }

    public int countTopPendingLeaveApprovalList(LeaveApprovalParam leaveApprovalParam) {
        long timestamp = leaveApprovalParam.getTimestamp();
        String currentUser = leaveApprovalParam.getUserId();
        if (timestamp <= 0L) {
            timestamp = System.currentTimeMillis();
        }
        long count = this.taskService.createTaskQuery().processDefinitionKey("lakemob_leave").taskDefinitionKey("leaveApprovalTask").taskAssignee(currentUser).taskCreatedBefore(new Date(timestamp)).count();
        return (int)count;
    }

    public List<Task> getTopPendingDocumentApprovalList(String currentUser, long timestamp, int pageSize) {
        if (timestamp <= 0L) {
            timestamp = System.currentTimeMillis();
        }
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey("lakemob_document").taskInvolvedUser(currentUser).taskCreatedBefore(new Date(timestamp)).orderByTaskCreateTime().desc()).listPage(0, pageSize);
        return tasks;
    }

    public int countTopPendingDocumentApprovalList(String currentUser, long timestamp) {
        if (timestamp <= 0L) {
            timestamp = System.currentTimeMillis();
        }
        long count = this.taskService.createTaskQuery().processDefinitionKey("lakemob_document").taskInvolvedUser(currentUser).taskCreatedBefore(new Date(timestamp)).count();
        return (int)count;
    }

    public String getBusinessKey(Task task) {
        return ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult()).getBusinessKey();
    }

    public Task getTask(String taskId) {
        return (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
    }

    @Transactional
    public boolean completeDocumentApprovalTask(String currentUser, String taskId, String comment, List<String> forwardToList, List<String> copyToList) {
        Task waitTask = null;
        Task candidateTask = (Task)this.taskService.createTaskQuery().processDefinitionKey("lakemob_document").taskCandidateUser(currentUser).taskId(taskId).singleResult();
        if (candidateTask != null) {
            try {
                this.taskService.claim(taskId, currentUser);
                waitTask = candidateTask;
            }
            catch (ActivitiTaskAlreadyClaimedException e) {
                LOGGER.warn("{}\u7b7e\u6536\u4efb\u52a1{}:{}\u5931\u8d25", new Object[]{currentUser, taskId, candidateTask.getName()});
                return false;
            }
        } else {
            waitTask = (Task)this.taskService.createTaskQuery().processDefinitionKey("lakemob_document").taskAssignee(currentUser).taskId(taskId).singleResult();
        }
        if (waitTask != null) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("forwardToList", forwardToList);
            vars.put("copyToList", copyToList);
            vars.put("comment", comment);
            this.taskService.complete(taskId, vars);
            return true;
        }
        LOGGER.warn("\u672a\u627e\u5230\u7b26\u5408\u8981\u6c42\u7684\u5f85\u5ba1\u6279\u516c\u6587\u4efb\u52a1");
        return false;
    }

    @Transactional
    public boolean completeLeaveApprovalTask(String currentUser, String taskId, boolean pass) {
        Task waitTask = (Task)this.taskService.createTaskQuery().processDefinitionKey("lakemob_leave").taskAssignee(currentUser).taskId(taskId).singleResult();
        if (waitTask != null) {
            HashMap<String, Boolean> vars = new HashMap<String, Boolean>();
            vars.put("pass", pass);
            this.taskService.complete(taskId, vars);
            return true;
        }
        LOGGER.warn("\u672a\u627e\u5230\u7b26\u5408\u8981\u6c42\u7684\u5f85\u5ba1\u6279\u8bf7\u5047\u5916\u51fa\u7533\u8bf7");
        return false;
    }

    @Transactional
    public String startApplyMoneyWorkflow(ApplyMoneyInfo applyMoney, String applyId) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("deptLeaderFlowPersonList", applyMoney.getDeptLeader());
        vars.put("leaderFlowPersonList", applyMoney.getLeader());
        vars.put("directorFlowPersonList", applyMoney.getDirector());
        vars.put("secretaryFlowPersonList", applyMoney.getSecretary());
        vars.put("needSecretary", !CollectionUtils.isEmpty(applyMoney.getSecretary()));
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("lakemob_apply_money", applyId, vars);
        return processInstance.getProcessInstanceId();
    }

    @Transactional
    public String startBusinessTripWorkflow(BusinessTripInfo businessTripInfo, String applyId) {
        this.identityService.setAuthenticatedUserId(businessTripInfo.getApplyUserId());
        HashMap<String, List<String>> vars = new HashMap<String, List<String>>();
        vars.put("deptLeaderFlowPersonList", businessTripInfo.getDeptLeader());
        vars.put("directLeaderFlowPersonList", businessTripInfo.getDirectLeader());
        vars.put("mainLeaderFlowPersonList", businessTripInfo.getMainLeader());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("lakemob_business_trip", applyId, vars);
        return processInstance.getProcessInstanceId();
    }

    public Task getTask(String currentUser, String workflowId, String processKey) {
        return (Task)this.taskService.createTaskQuery().taskAssignee(currentUser).processInstanceId(workflowId).singleResult();
    }

    @Transactional
    public boolean completeApplyMoneyApprovalTask(String taskId, String comment, int type) {
        if (StringUtils.isNotEmpty((CharSequence)taskId)) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("comment", comment);
            vars.put("type", type);
            this.taskService.complete(taskId, vars);
            return true;
        }
        LOGGER.warn("\u672a\u627e\u5230\u7b26\u5408\u8981\u6c42\u7684\u5f85\u5ba1\u6279\u7533\u8bf7");
        return false;
    }

    @Transactional
    public boolean completeBusinessTripApprovalTask(String taskId, int type) {
        if (StringUtils.isNotEmpty((CharSequence)taskId)) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("type", type);
            vars.put("comment", LakeMobUtils.isTrue(type) ? "\u6279\u51c6" : "\u62d2\u7edd");
            this.taskService.complete(taskId, vars);
            return true;
        }
        LOGGER.warn("\u672a\u627e\u5230\u7b26\u5408\u8981\u6c42\u7684\u5f85\u5ba1\u6279\u7533\u8bf7");
        return false;
    }

    public boolean revokeBusinessTrip(String personId, String applyId) {
        Task task = (Task)this.taskService.createTaskQuery().processDefinitionKey("lakemob_business_trip").taskAssignee(personId).processInstanceBusinessKey(applyId).taskDefinitionKey("revokeTask").singleResult();
        if (task != null) {
            HashMap vars = Maps.newHashMap();
            vars.put("revoked", true);
            this.taskService.complete(task.getId(), (Map)vars);
            return true;
        }
        return false;
    }

    public void delete(String applyId, String processKey) {
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(applyId, processKey).singleResult();
        if (instance != null) {
            String processInstanceId = instance.getProcessInstanceId();
            this.runtimeService.deleteProcessInstance(processInstanceId, "\u5220\u9664\u6d41\u7a0b\u5b9e\u4f8b");
        }
    }
}

