/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.tims.service.impl;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.util.MD5;
import com.xdja.pams.common.util.MD5Util;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.sso.util.HttpRequestUtil;
import com.xdja.pams.syms.entity.CommonCode;
import com.xdja.pams.syms.service.CommonCodeService;
import com.xdja.pams.syms.service.SystemConfigPbService;
import com.xdja.pams.tims.bean.AppNoticeBean;
import com.xdja.pams.tims.bean.MsgPushFormBean;
import com.xdja.pams.tims.bean.PnRequestBean;
import com.xdja.pams.tims.bean.PnResult;
import com.xdja.pams.tims.bean.QueryForm;
import com.xdja.pams.tims.entity.MsgPush;
import com.xdja.pams.tims.service.impl.MsgPushServiceImpl;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pams.function.xatl.tims.bean.TaxMessageBean;
import pams.function.xatl.tims.dao.MsgPushDaoForXatl;
import pams.function.xatl.tims.service.MsgPushServiceForXatl;

@Service
public class MsgPushServiceImplForXatl
implements MsgPushServiceForXatl {
    private static final Logger log = LoggerFactory.getLogger(MsgPushServiceImpl.class);
    @Autowired
    private MsgPushDaoForXatl msgPushDao;
    @Autowired
    private CommonCodeService commonCodeService;
    @Autowired
    private SystemConfigPbService systemConfigService;

    @Override
    public MsgPush save(MsgPush msgPush) {
        return this.msgPushDao.save(msgPush);
    }

    @Override
    public List<MsgPush> query(QueryForm form, Page page) {
        List<MsgPush> list = this.msgPushDao.query(form, page);
        for (MsgPush msgPush : list) {
            CommonCode commonCode = this.commonCodeService.getByCode(msgPush.getAppId(), "pn_appId");
            if (commonCode == null) continue;
            msgPush.setAppName(commonCode.getName());
        }
        return list;
    }

    @Override
    @Transactional
    public void saveMsgPushFormBean(String formBean, Person sender) {
        MsgPushFormBean msgPushForm = null;
        try {
            msgPushForm = (MsgPushFormBean)Util.readValue((String)formBean, MsgPushFormBean.class);
        }
        catch (Exception e) {
            throw new RuntimeException("\u4fdd\u5355\u683c\u5f0f\u6709\u8bef", e);
        }
        Date sendDate = new Date();
        HashSet<String> personIdSet = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)msgPushForm.getToId())) {
            String[] receiverArr;
            for (String personId : receiverArr = msgPushForm.getToId().split(",")) {
                personIdSet.add(personId);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)msgPushForm.getToDepId())) {
            String[] receiverDepIdArr;
            for (String depId : receiverDepIdArr = msgPushForm.getToDepId().split(",")) {
                List<String> depPersonId = this.msgPushDao.queryToPersonIdByDepId(depId);
                personIdSet.addAll(depPersonId);
            }
        }
        for (String reveiverId : personIdSet) {
            MsgPush msgPush = new MsgPush();
            msgPush.setAppId(msgPushForm.getFrom());
            msgPush.setTitle(msgPushForm.getTitle());
            try {
                msgPush.setMessage(URLDecoder.decode(msgPushForm.getMessageSource(), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error("\u6d88\u606f\u88c5\u6362\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
                msgPush.setMessage(msgPushForm.getMessageSource());
            }
            msgPush.setCache(msgPushForm.getCache());
            msgPush.setSenddate(sendDate);
            msgPush.setSender(sender);
            msgPush.setSingle(msgPushForm.getSingle());
            Person receiver = new Person();
            receiver.setId(reveiverId);
            msgPush.setReceiver(receiver);
            this.msgPushDao.save(msgPush);
        }
    }

    @Override
    public String getPnRequestJson(String formBean) {
        MsgPushFormBean msgPushForm = null;
        try {
            msgPushForm = (MsgPushFormBean)Util.readValue((String)formBean, MsgPushFormBean.class);
        }
        catch (Exception e) {
            throw new RuntimeException("\u4fdd\u5355\u683c\u5f0f\u6709\u8bef", e);
        }
        PnRequestBean pr = new PnRequestBean();
        BeanUtils.copyProperties((Object)msgPushForm, (Object)pr);
        HashSet<String> imeiSet = new HashSet<String>();
        String pushReceiveType = this.systemConfigService.getValueByCode("msgpush_receive_type");
        if (StringUtils.isBlank((CharSequence)pushReceiveType)) {
            pushReceiveType = "0";
        }
        if (StringUtils.isNotBlank((CharSequence)msgPushForm.getToId())) {
            String[] pIdArr;
            for (String pId : pIdArr = msgPushForm.getToId().split(",")) {
                if ("0".equals(pushReceiveType)) {
                    List<String> personImeiList = this.msgPushDao.queryToPersonImeiByPersonId(pId);
                    imeiSet.addAll(personImeiList);
                }
                if (!"1".equals(pushReceiveType)) continue;
                List<String> personIccid = this.msgPushDao.queryToPersonICCIDByPersonId(pId);
                imeiSet.addAll(personIccid);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)msgPushForm.getToDepId())) {
            String[] receiverDepIdArr;
            for (String depId : receiverDepIdArr = msgPushForm.getToDepId().split(",")) {
                List<String> depPersonImei = this.msgPushDao.queryToPersonImeiByDepId(depId);
                List<String> depPersonIccid = this.msgPushDao.queryToPersonICCIDByDepId(depId);
                imeiSet.addAll(depPersonImei);
            }
        }
        StringBuffer sb = new StringBuffer();
        for (String imei : imeiSet) {
            if (imei.length() < 15) {
                imei = (imei + "00000").substring(0, 15);
            }
            if ((imei = MD5Util.MD5((String)imei)) != null) {
                imei = imei.toLowerCase();
            }
            sb.append(imei).append(",");
        }
        String imeiAll = sb.toString();
        if (imeiAll.length() > 0) {
            imeiAll = imeiAll.substring(0, imeiAll.length() - 1);
        }
        pr.setTo(imeiAll);
        String rqJson = Util.toJsonStr((Object)pr);
        return rqJson;
    }

    public void sendAppNotice(AppNoticeBean appNotice, String type) {
        String pushReceiveType = this.systemConfigService.getValueByCode("msgpush_receive_type");
        if (StringUtils.isBlank((CharSequence)pushReceiveType)) {
            pushReceiveType = "0";
        }
        List<String> imeiList = null;
        if ("0".equals(pushReceiveType)) {
            imeiList = this.msgPushDao.queryAppUserImei(appNotice.getAppId());
        }
        if ("1".equals(pushReceiveType)) {
            imeiList = this.msgPushDao.queryAppUserICCID(appNotice.getAppId());
        }
        StringBuffer toImei = new StringBuffer();
        for (String imei : imeiList) {
            if (imei.length() < 15) {
                imei = (imei + "00000").substring(0, 15);
            }
            if ((imei = MD5Util.MD5((String)imei)) != null) {
                imei = imei.toLowerCase();
            }
            toImei.append(imei).append(",");
        }
        String toImeiStr = toImei.toString();
        if (toImeiStr.length() > 0) {
            toImeiStr = toImeiStr.substring(0, toImei.length() - 1);
        }
        String appid = this.systemConfigService.getValueByCode("msgpush_mdp_appid");
        String cache = this.systemConfigService.getValueByCode("msgpush_cache");
        String single = this.systemConfigService.getValueByCode("msgpush_single");
        String title = null;
        if (type == "1") {
            title = "\u5e94\u7528\u4e2d\u5fc3\u6709\u65b0\u7684\u5e94\u7528\u5230\u6765";
        } else if (type == "2") {
            title = "\u5e94\u7528\u4e2d\u5fc3\u5b58\u5728\u53ef\u66f4\u65b0\u5e94\u7528";
            String version = appNotice.getVersion();
            version = version != null ? version : "";
            title = appNotice.getAppName() + version + "\u5df2\u7ecf\u53d1\u5e03\uff0c\u8bf7\u53ca\u65f6\u5728\u5e94\u7528\u4e2d\u5fc3\u67e5\u770b";
        }
        HashMap<String, String> msgMap = new HashMap<String, String>();
        HashMap<String, Object> nrMap = new HashMap<String, Object>();
        HashMap<String, String> msgDetail = new HashMap<String, String>();
        msgMap.put("to", toImeiStr);
        msgMap.put("from", appid);
        msgMap.put("cache", cache);
        msgMap.put("single", single);
        msgMap.put("title", title);
        msgDetail.put("appId", appNotice.getAppId());
        msgDetail.put("appName", appNotice.getAppName());
        msgDetail.put("packageName", appNotice.getPackageName());
        nrMap.put("type", type);
        nrMap.put("msgDetail", msgDetail);
        String nrJson = Util.toJsonStr(nrMap);
        HttpRequestUtil httpclient = new HttpRequestUtil();
        String urlStr = this.systemConfigService.getValueByCode("msgpush_url");
        try {
            nrJson = URLEncoder.encode(nrJson, "utf-8");
            msgMap.put("message", nrJson);
            String msgJson = Util.toJsonStr(msgMap);
            msgJson = URLEncoder.encode(msgJson, "utf-8");
            httpclient.post(urlStr, msgJson);
        }
        catch (Exception e) {
            throw new RuntimeException("\u63a8\u9001\u901a\u77e5\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void sendAddAppNotice(AppNoticeBean appNotice) {
        this.sendAppNotice(appNotice, "1");
    }

    @Override
    public void sendUpdateAppNotice(AppNoticeBean appNotice) {
        this.sendAppNotice(appNotice, "2");
    }

    @Override
    public void sendDelPhoneInfo(Map<String, String> map) {
        log.debug("\u8fdb\u5165sendDelPhoneInfo\u65b9\u6cd5!");
        String toImeiStr = MD5Util.MD5((String)map.get("imei"));
        String appid = this.systemConfigService.getValueByCode("msgpush_wipe_appid");
        String cache = this.systemConfigService.getValueByCode("msgpush_cache");
        String single = this.systemConfigService.getValueByCode("msgpush_single");
        String title = "\u6e05\u9664\u624b\u673a\u4fe1\u606f";
        HashMap<String, String> msgMap = new HashMap<String, String>();
        HashMap<String, String> nrMap = new HashMap<String, String>();
        msgMap.put("to", toImeiStr);
        msgMap.put("from", appid);
        msgMap.put("cache", cache);
        msgMap.put("single", single);
        msgMap.put("title", title);
        nrMap.put("businessType", "1");
        nrMap.put("personId", map.get("personId"));
        String nrJson = Util.toJsonStr(nrMap);
        HttpRequestUtil httpclient = new HttpRequestUtil();
        String urlStr = this.systemConfigService.getValueByCode("msgpush_url");
        try {
            nrJson = URLEncoder.encode(nrJson, "utf-8");
            msgMap.put("message", nrJson);
            String msgJson = Util.toJsonStr(msgMap);
            msgJson = URLEncoder.encode(msgJson, "utf-8");
            httpclient.post(urlStr, msgJson);
            log.debug("\u63a8\u9001\u64e6\u9664\u6307\u4ee4\u5931\u8d25\u6210\u529f!");
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u64e6\u9664\u6307\u4ee4\u5931\u8d25\uff1a" + e.getMessage());
            throw new RuntimeException("\u63a8\u9001\u64e6\u9664\u6307\u4ee4\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void sendTaxMessage(TaxMessageBean taxMessageBean) {
        block7: {
            log.debug("sendTaxMessage() param: {}", (Object)Util.toJsonStr((Object)taxMessageBean));
            if (StringUtils.isBlank((CharSequence)taxMessageBean.getMsg())) {
                throw new RuntimeException("\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
            }
            try {
                StringBuffer toImei = new StringBuffer();
                HashMap<String, String> tmpImeiExist = new HashMap<String, String>();
                MD5 md5 = new MD5();
                List<String> imeiPcidList = this.msgPushDao.queryImeiAndPcid(taxMessageBean);
                for (String imeiPcid : imeiPcidList) {
                    String[] ary;
                    String imeiTmp;
                    if (!StringUtils.isNotBlank((CharSequence)imeiPcid) || imeiPcid.equals(",") || !StringUtils.isNotBlank((CharSequence)(imeiTmp = (ary = imeiPcid.split(","))[0]))) continue;
                    if (!tmpImeiExist.containsKey(imeiTmp)) {
                        tmpImeiExist.put(imeiTmp, imeiTmp);
                    }
                    toImei.append(md5.getMD5ofStr(imeiTmp)).append(",");
                }
                if (tmpImeiExist.isEmpty()) {
                    log.error("sendTaxMessage() \u63a8\u9001\u901a\u77e5\u5931\u8d25\uff1a\u6ca1\u6709\u627e\u5230\u901a\u77e5\u4eba\u5458!");
                    throw new RuntimeException("998");
                }
                HashMap<String, String> msgMapImei = new HashMap<String, String>();
                this.buildMsg(toImei, new StringBuffer(), taxMessageBean.getMsg(), msgMapImei, new HashMap<String, String>());
                HttpRequestUtil httpclient = new HttpRequestUtil();
                String urlStrImei = this.systemConfigService.getValueByCode("msgpush_url");
                String msgJsonImei = Util.toJsonStr(msgMapImei);
                log.debug("sendTaxMessage() postToImei:url[{}],msg[{}]", (Object)urlStrImei, (Object)msgJsonImei);
                msgJsonImei = URLEncoder.encode(msgJsonImei, "utf-8");
                String rst = httpclient.post(urlStrImei, msgJsonImei);
                PnResult pnResult = (PnResult)Util.readValue((String)rst, PnResult.class);
                if (Integer.parseInt("1") == pnResult.getState()) {
                    log.error("\u63a8\u9001\u5931\u8d25");
                    throw new RuntimeException("\u63a8\u9001\u5931\u8d25:" + pnResult.getMsg());
                }
            }
            catch (Exception e) {
                if ("998".equals(e.getMessage())) break block7;
                log.error("sendTaxMessage() error : ", (Throwable)e);
                throw new RuntimeException("\u63a8\u9001\u901a\u77e5\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }

    private void buildMsg(StringBuffer toImei, StringBuffer toPc, String msg, Map<String, String> msgMapImei, Map<String, String> msgMapPcid) throws Exception {
        String appid = this.systemConfigService.getValueByCode("msgpush_appid");
        String appid_pc = this.systemConfigService.getValueByCode("msgpush_pc_appid");
        String cache = this.systemConfigService.getValueByCode("msgpush_cache");
        String cache_pc = this.systemConfigService.getValueByCode("msgpush_pc_cache");
        String single = this.systemConfigService.getValueByCode("msgpush_single");
        if (toImei.length() > 0) {
            msgMapImei.put("to", toImei.substring(0, toImei.length() - 1));
            msgMapImei.put("message", msg);
            msgMapImei.put("from", appid);
            msgMapImei.put("cache", cache);
            msgMapImei.put("single", single);
            msgMapImei.put("title", "");
        }
        if (toPc.length() > 0) {
            msgMapPcid.put("to", toPc.substring(0, toPc.length() - 1));
            msgMapPcid.put("message", msg);
            msgMapPcid.put("from", appid_pc);
            msgMapPcid.put("cache", cache_pc);
            msgMapPcid.put("single", single);
            msgMapPcid.put("title", "");
        }
    }
}

