/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.workreport.rpcMethod;

import com.alibaba.fastjson.JSON;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import pams.function.xatl.ruyihu.jsonrpc.LakeMobMethod;
import pams.function.xatl.ruyihu.jsonrpc.SuperRequest;
import pams.function.xatl.workreport.service.IWorkReportService;
import pams.function.xatl.workreport.service.WorkReportAdminSetService;
import pams.function.xatl.workreport.util.DateUtil;

@Service
public class ReportMonth
extends LakeMobMethod {
    @Resource
    private IWorkReportService workReportService;
    @Resource
    private WorkReportAdminSetService workReportAdminSetService;

    @Override
    protected Object execute0(String currentUser, SuperRequest request) throws Exception {
        this.logger.debug("ReportMonth \u5de5\u4f5c\u6c47\u62a5\u6708\u5217\u8868>>>currentUser: \u3010{}\u3011, params: \u3010{}\u3011", (Object)currentUser, (Object)request.toJsonString());
        String accountId = request.needText("accountId", "");
        String dateMonth = request.needText("dateMonth");
        Map<String, Object> result = null;
        Long startDate = null;
        Long endDate = null;
        int days = 0;
        if (StringUtils.isBlank((CharSequence)dateMonth)) {
            Date startDayOfMonth = DateUtil.getStartDayOfMonth(new Date());
            startDate = Long.parseLong(new SimpleDateFormat("yyyyMMdd").format(startDayOfMonth));
            Date lastDayOfMonth = DateUtil.getLastDayOfMonth(new Date());
            endDate = Long.parseLong(new SimpleDateFormat("yyyyMMdd").format(lastDayOfMonth));
            days = Integer.parseInt((lastDayOfMonth.getTime() - startDayOfMonth.getTime()) / 86400000L + "");
        } else {
            Date yyyyMMdd = DateUtil.getStartDayOfMonth(DateUtil.stringToDate(dateMonth, "yyyyMM"));
            startDate = Long.parseLong(new SimpleDateFormat("yyyyMMdd").format(yyyyMMdd));
            Date yyyyMMdd1 = DateUtil.getLastDayOfMonth(DateUtil.stringToDate(dateMonth, "yyyyMM"));
            endDate = Long.parseLong(new SimpleDateFormat("yyyyMMdd").format(yyyyMMdd1));
            days = Integer.parseInt((yyyyMMdd1.getTime() - yyyyMMdd.getTime()) / 86400000L + "");
        }
        if (StringUtils.isBlank((CharSequence)accountId) || accountId.equals(currentUser)) {
            accountId = currentUser;
            result = this.workReportService.reportMonth(startDate, endDate, accountId, days);
        } else {
            int i = this.workReportAdminSetService.queryAdminRelCount(currentUser, accountId);
            if (i <= 0) {
                throw new IllegalArgumentException("\u8be5\u8d1f\u8d23\u4eba\u6ca1\u6709\u67e5\u770b\u6743\u9650");
            }
            result = this.workReportService.reportMonth(startDate, endDate, accountId, days);
        }
        this.logger.debug("ReportMonth \u5de5\u4f5c\u6c47\u62a5\u6708\u5217\u8868<<<currentUser: \u3010{}\u3011, params: \u3010{}\u3011, resp: \u3010{}\u3011", new Object[]{currentUser, request.toJsonString(), JSON.toJSONString(result)});
        return result;
    }
}

