/*
 * Decompiled with CFR 0.152.
 */
package pams.function.xatl.workreport.util;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DateUtil {
    private static String ymdhms = "yyyy-MM-dd HH:mm:ss";
    private static String ymd = "yyyy-MM-dd";
    public static SimpleDateFormat ymdSDF = new SimpleDateFormat(ymd);
    private static String year = "yyyy";
    private static String month = "MM";
    private static String day = "dd";
    public static SimpleDateFormat yyyyMMddHHmmss = new SimpleDateFormat(ymdhms);
    public static SimpleDateFormat yearSDF = new SimpleDateFormat(year);
    public static SimpleDateFormat monthSDF = new SimpleDateFormat(month);
    public static SimpleDateFormat daySDF = new SimpleDateFormat(day);
    public static SimpleDateFormat yyyyMMddHHmm = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    public static SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyy-MM-dd");
    public static SimpleDateFormat yyyyMMddHH_NOT_ = new SimpleDateFormat("yyyyMMdd");
    public static long DATEMM = 86400L;
    private static transient int gregorianCutoverYear = 1582;
    private static final int[] DAYS_P_MONTH_LY = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] DAYS_P_MONTH_CY = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int Y = 0;
    private static final int M = 1;
    private static final int D = 2;

    public static String getCurrentTime() {
        return yyyyMMddHHmmss.format(new Date());
    }

    public static String getYesterdayYYYYMMDD() {
        Date date = new Date(System.currentTimeMillis() - DATEMM * 1000L);
        String str = yyyyMMdd.format(date);
        try {
            date = yyyyMMddHHmmss.parse(str + " 00:00:00");
            return yyyyMMdd.format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getTodayYYYYMMDD() {
        Date date = new Date(System.currentTimeMillis());
        String str = yyyyMMdd.format(date);
        try {
            date = yyyyMMddHHmmss.parse(str + " 00:00:00");
            return yyyyMMdd.format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static int getDayOfWeek(String date) {
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        Date d = null;
        Calendar c = null;
        try {
            d = sd.parse(date);
            c = Calendar.getInstance();
            c.setTime(d);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return c.get(7);
    }

    public String getStrDate(String backDay) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, Integer.parseInt("-" + backDay));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String back = sdf.format(calendar.getTime());
        return back;
    }

    public static String getCurrentYear() {
        return yearSDF.format(new Date());
    }

    public static String getCurrentMonth() {
        return monthSDF.format(new Date());
    }

    public static String getCurrentDay() {
        return daySDF.format(new Date());
    }

    public static String getCurrentymd() {
        return ymdSDF.format(new Date());
    }

    public static long getTimeNumberToday() {
        Date date = new Date();
        String str = yyyyMMdd.format(date);
        try {
            date = yyyyMMdd.parse(str);
            return date.getTime() / 1000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static String getTodateString() {
        SimpleDateFormat yyyymmddhhNot = new SimpleDateFormat("yyyyMMdd");
        String str = yyyymmddhhNot.format(new Date());
        return str;
    }

    public static String getYesterdayString() {
        Date date = new Date(System.currentTimeMillis() - DATEMM * 1000L);
        SimpleDateFormat yyyymmddhhNot = new SimpleDateFormat("yyyyMMdd");
        String str = yyyymmddhhNot.format(date);
        return str;
    }

    public static Date getBeforeDayZeroHour(int beforeDay) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -beforeDay);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(10, 0);
        return cal.getTime();
    }

    public static Date getAfterDayZeroHour(int afterDay) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, afterDay);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(10, 0);
        return cal.getTime();
    }

    public static Date getYesterDayZeroHour() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(10, 0);
        return cal.getTime();
    }

    public static String longToString(long date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date dt2 = new Date(date * 1000L);
        String sDateTime = sdf.format(dt2);
        return sDateTime;
    }

    public static Date getTodayZeroHour() {
        Calendar cal = Calendar.getInstance();
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(10, 0);
        return cal.getTime();
    }

    public static Date getYesterDay24Hour() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        cal.set(13, 59);
        cal.set(12, 59);
        cal.set(10, 23);
        return cal.getTime();
    }

    public static Date stringToDate(String date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            return sdf.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getStartDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(7, 1);
        date = c.getTime();
        return date;
    }

    public static Date getLastDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(7, 7);
        date = c.getTime();
        return date;
    }

    public static Date getStartDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        date = c.getTime();
        return date;
    }

    public static Date getNextDayOfMonth(Date date, int offset) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, offset);
        date = c.getTime();
        return date;
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        c.add(2, 1);
        c.add(5, -1);
        date = c.getTime();
        return date;
    }

    public static Date getStartDayOfNextMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, 1);
        c.set(5, 1);
        date = c.getTime();
        return date;
    }

    public static Date getLastDayOfNextMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        c.add(2, 2);
        c.add(5, -1);
        date = c.getTime();
        return date;
    }

    public static String givedTimeToBefore(String givedTime, long interval, String format_Date_Sign) {
        String tomorrow = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format_Date_Sign);
            Date gDate = sdf.parse(givedTime);
            long current = gDate.getTime();
            long beforeOrAfter = current - interval * 1000L;
            Date date = new Date(beforeOrAfter);
            tomorrow = new SimpleDateFormat(format_Date_Sign).format(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return tomorrow;
    }

    public static Date givedTimeToBeforeOrAfter(String givedTime, long interval, String formatDateSign) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(formatDateSign);
            Date gDate = sdf.parse(givedTime);
            long current = gDate.getTime();
            long beforeOrAfter = current + interval * 1000L;
            Date date = new Date(beforeOrAfter);
            return date;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static long stringToLong(String date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date dt2 = null;
        long lTime = 0L;
        try {
            dt2 = sdf.parse(date);
            lTime = dt2.getTime() / 1000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return lTime;
    }

    public static Map<String, String> getTwoDay(String endTime, String beginTime, boolean isEndTime) {
        Map<String, String> result = new HashMap<String, String>();
        if (endTime == null || endTime.equals("") || beginTime == null || beginTime.equals("")) {
            return null;
        }
        try {
            Date date = ymdSDF.parse(endTime);
            endTime = ymdSDF.format(date);
            Date mydate = ymdSDF.parse(beginTime);
            long day = (date.getTime() - mydate.getTime()) / 86400000L;
            result = DateUtil.getDate(endTime, Integer.parseInt(day + ""), isEndTime);
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public static Integer getTwoDayInterval(String endTime, String beginTime, boolean isEndTime) {
        if (endTime == null || endTime.equals("") || beginTime == null || beginTime.equals("")) {
            return 0;
        }
        long day = 0L;
        try {
            Date date = ymdSDF.parse(endTime);
            endTime = ymdSDF.format(date);
            Date mydate = ymdSDF.parse(beginTime);
            day = (date.getTime() - mydate.getTime()) / 86400000L;
        }
        catch (Exception e) {
            return 0;
        }
        return Integer.parseInt(day + "");
    }

    public static Integer getTwoDayInterval(String endTime, String beginTime, String formt) {
        if (endTime == null || endTime.equals("") || beginTime == null || beginTime.equals("")) {
            return 0;
        }
        long day = 0L;
        try {
            SimpleDateFormat format = new SimpleDateFormat(formt);
            Date date = format.parse(endTime);
            Date mydate = format.parse(beginTime);
            day = (date.getTime() - mydate.getTime()) / 86400000L;
        }
        catch (Exception e) {
            return 0;
        }
        return Integer.parseInt(day + 1L + "");
    }

    public static Map<String, String> getDate(String endTime, Integer interval, boolean isEndTime) {
        HashMap<String, String> result = new HashMap<String, String>();
        if ((interval == 0 || isEndTime) && isEndTime) {
            result.put(endTime, endTime);
        }
        if (interval > 0) {
            int begin;
            for (int i = begin = 0; i < interval; ++i) {
                endTime = DateUtil.givedTimeToBefore(endTime, DATEMM, ymd);
                result.put(endTime, endTime);
            }
        }
        return result;
    }

    public static int[] splitYMD(String date) {
        date = date.replace("-", "");
        int[] ymd = new int[]{0, 0, 0};
        ymd[0] = Integer.parseInt(date.substring(0, 4));
        ymd[1] = Integer.parseInt(date.substring(4, 6));
        ymd[2] = Integer.parseInt(date.substring(6, 8));
        return ymd;
    }

    public static boolean isLeapYear(int year) {
        return year >= gregorianCutoverYear ? year % 4 == 0 && (year % 100 != 0 || year % 400 == 0) : year % 4 == 0;
    }

    private static int[] addOneDay(int year, int month, int day) {
        if (DateUtil.isLeapYear(year)) {
            if (++day > DAYS_P_MONTH_LY[month - 1]) {
                if (++month > 12) {
                    month = 1;
                }
                day = 1;
            }
        } else if (++day > DAYS_P_MONTH_CY[month - 1]) {
            if (++month > 12) {
                ++year;
                month = 1;
            }
            day = 1;
        }
        int[] ymd = new int[]{++year, month, day};
        return ymd;
    }

    public static String formatMonthDay(int decimal) {
        DecimalFormat df = new DecimalFormat("00");
        return df.format(decimal);
    }

    public static String formatYear(int decimal) {
        DecimalFormat df = new DecimalFormat("0000");
        return df.format(decimal);
    }

    public static long countDay(String begin, String end) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        long day = 0L;
        try {
            Date beginDate = format.parse(begin);
            Date endDate = format.parse(end);
            day = (endDate.getTime() - beginDate.getTime()) / 86400000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return day;
    }

    public static List<String> getEveryday(String beginDate, String endDate) {
        long days = DateUtil.countDay(beginDate, endDate);
        int[] ymd = DateUtil.splitYMD(beginDate);
        ArrayList<String> everyDays = new ArrayList<String>();
        everyDays.add(beginDate);
        int i = 0;
        while ((long)i < days) {
            ymd = DateUtil.addOneDay(ymd[0], ymd[1], ymd[2]);
            everyDays.add(DateUtil.formatYear(ymd[0]) + "-" + DateUtil.formatMonthDay(ymd[1]) + "-" + DateUtil.formatMonthDay(ymd[2]));
            ++i;
        }
        return everyDays;
    }

    public static String getWeek(String date) {
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdw = new SimpleDateFormat("E");
        Date d = null;
        try {
            d = sd.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return sdw.format(d);
    }

    public static String getStringTime(Long date) {
        String stringDate = date + "";
        StringBuilder sb = new StringBuilder(stringDate);
        sb.insert(6, "-");
        sb.insert(4, "-");
        return sb.toString();
    }
}

