/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.common.dao.impl;

import com.xdja.pams.common.util.Page;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import pams.function.zhengzhou.common.dao.BaseDao;

public class BaseDaoImpl
extends HibernateDaoSupport
implements BaseDao {
    public BaseDaoImpl(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    public Session getCurrentSession() {
        return this.getSessionFactory().getCurrentSession();
    }

    @Override
    public <T> T findById(Class<T> clz, Serializable id) {
        return (T)this.getCurrentSession().get(clz, id);
    }

    @Override
    public <T> List<T> findAll(Class<T> clz) {
        DetachedCriteria criteria = DetachedCriteria.forClass(clz);
        Criteria executableCriteria = criteria.getExecutableCriteria(this.getCurrentSession());
        return executableCriteria.list();
    }

    @Override
    public <E> Serializable save(E object) {
        return this.getCurrentSession().save(object);
    }

    @Override
    public <E> void update(E object) {
        this.getCurrentSession().update(object);
    }

    @Override
    public <E> void delete(E object) {
        this.getCurrentSession().delete(object);
    }

    @Override
    public List<?> getListByHQL(String selectCount, String select, Object[] values, Page page) {
        if (StringUtils.isNotBlank((CharSequence)selectCount) && page != null) {
            Long count = (Long)this.getObjectByHQL(selectCount, values);
            page.setTotal(count.intValue());
            if (page.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
        }
        return this.getListByHQL(select, values, page);
    }

    private List<?> getListByHQL(final String select, final Object[] values, final Page page) {
        HibernateCallback selectCallback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.createQuery(select);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        query.setParameter(i, values[i]);
                    }
                }
                if (page != null) {
                    return query.setFirstResult(page.getFirstResult()).setMaxResults(page.getRp()).list();
                }
                return query.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(selectCallback);
    }

    @Override
    public List<?> getListBySQL(String selectCount, String select, Object[] values, Page page, Class<?> c) {
        if (StringUtils.isNotBlank((CharSequence)selectCount) && page != null) {
            String count = this.queryObjectBySQL(selectCount, values).toString();
            page.setTotal(Integer.parseInt(count));
            if (page.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
        }
        return this.getListBySQL(select, values, page, c);
    }

    @Override
    public List<?> getListBySQL(final String select, final Object[] values, final Page page, final Class<?> c) {
        HibernateCallback selectCallback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                SQLQuery query;
                if (c == null) {
                    query = session.createSQLQuery(select);
                } else {
                    Map map = session.getSessionFactory().getAllClassMetadata();
                    if (map.containsKey(c.getName())) {
                        query = session.createSQLQuery(select).addEntity(c);
                    } else {
                        Object resultTransformer = null;
                        resultTransformer = c.isAssignableFrom(HashMap.class) ? Transformers.ALIAS_TO_ENTITY_MAP : Transformers.aliasToBean((Class)c);
                        query = session.createSQLQuery(select).setResultTransformer((ResultTransformer)resultTransformer);
                    }
                }
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        query.setParameter(i, values[i]);
                    }
                }
                if (page != null) {
                    return query.setFirstResult(page.getFirstResult()).setMaxResults(page.getRp()).list();
                }
                return query.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(selectCallback);
    }

    @Override
    public Object getObjectByHQL(final String select, final Object[] values) {
        HibernateCallback selectCallback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                Query query = session.createQuery(select);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        query.setParameter(i, values[i]);
                    }
                }
                return query.uniqueResult();
            }
        };
        return this.getHibernateTemplate().execute(selectCallback);
    }

    @Override
    public Object getObjectBySQL(final String select, final Object[] values) {
        HibernateCallback selectCallback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                SQLQuery query = session.createSQLQuery(select);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        query.setParameter(i, values[i]);
                    }
                }
                return query.executeUpdate();
            }
        };
        return this.getHibernateTemplate().execute(selectCallback);
    }

    @Override
    public Object queryObjectBySQL(final String select, final Object[] values) {
        HibernateCallback selectCallback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                SQLQuery query = session.createSQLQuery(select);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        query.setParameter(i, values[i]);
                    }
                }
                return query.uniqueResult();
            }
        };
        return this.getHibernateTemplate().execute(selectCallback);
    }
}

