/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.common.filter;

import com.xdja.pams.common.util.Response;
import com.xdja.pams.http.ResponseApi;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pams.function.zhengzhou.util.PropertiesUtil;

public class PamsAccessFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(PamsAccessFilter.class);
    private String[] hostWhiteList;

    public void destroy() {
        this.hostWhiteList = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            if (this.hostWhiteList == null) {
                chain.doFilter(request, response);
                return;
            }
            String remoteHost = request.getRemoteHost();
            for (int i = 0; i < this.hostWhiteList.length; ++i) {
                if (!remoteHost.equals(this.hostWhiteList[i])) continue;
                chain.doFilter(request, response);
                return;
            }
            LOG.error("\u65e0\u6743\u9650:" + remoteHost);
            Response result = new Response("1", "\u65e0\u6743\u9650");
            ResponseApi.write((HttpServletResponse)httpResponse, (Response)result);
        }
        catch (Exception e) {
            LOG.error("\u8df3\u8f6c\u51fa\u9519", (Throwable)e);
            Response result = new Response("1", "\u64cd\u4f5c\u5931\u8d25");
            ResponseApi.write((HttpServletResponse)httpResponse, (Response)result);
        }
    }

    public void init(FilterConfig config) throws ServletException {
        LOG.info("\u52a0\u8f7d\u767d\u540d\u5355");
        PropertiesUtil propertiesUtil = new PropertiesUtil("pams.properties");
        String value = propertiesUtil.getValue("host.white.list");
        if (StringUtils.isNotBlank((CharSequence)value)) {
            this.hostWhiteList = value.split(";");
        }
    }
}

