/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.drs;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.xdja.pams.common.util.Util;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import pams.function.zhengzhou.drs.dto.request.DrsRequestDto;
import pams.function.zhengzhou.drs.dto.response.DrsResponseDto;
import pams.function.zhengzhou.drs.service.DrsBridgeControllerService;

@Controller
public class DrsApiController {
    private static Logger logger = LoggerFactory.getLogger(DrsApiController.class);
    @Autowired
    private DrsBridgeControllerService drsBridgeControllerService;

    @RequestMapping(value={"/api/pub/resource/bridge.do"}, method={RequestMethod.POST})
    public void bridge(@RequestBody String reqJson, HttpServletRequest request, HttpServletResponse response) {
        String dataObjId;
        if (logger.isDebugEnabled()) {
            logger.debug("reqJson from drs \n[{}]", (Object)JSON.toJSONString((Object)reqJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
        }
        DrsRequestDto drsRequest = (DrsRequestDto)Util.readValue((String)reqJson, DrsRequestDto.class);
        DrsResponseDto drsResponse = new DrsResponseDto();
        drsResponse.setMessageId(drsRequest.getMessageId());
        drsResponse.setVersion(drsRequest.getVersion());
        drsResponse.setCode("500");
        if (drsRequest.getParameter() == null) {
            drsResponse.setMessage("\u5173\u952e\u53c2\u6570parameter\u4e0d\u5b58\u5728");
            Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)drsResponse));
        }
        if (StringUtils.isBlank((CharSequence)(dataObjId = drsRequest.getParameter().getDataObjId()))) {
            drsResponse.setMessage("\u5173\u952e\u53c2\u6570dataObjId\u4e0d\u5b58\u5728");
            Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)drsResponse));
        }
        this.drsBridgeControllerService.bridge(dataObjId, drsRequest.getParameter(), drsResponse, request, response);
        if (logger.isDebugEnabled()) {
            logger.debug("drsResponse to drs \n[{}]", (Object)JSON.toJSONString((Object)drsResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr((Object)drsResponse));
    }
}

