/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.drs.register;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.util.CollectionUtils;
import pams.function.zhengzhou.drs.register.ControllerPager;
import pams.function.zhengzhou.drs.register.ControllerParameter;

public class ControllerRegister {
    private String dataObjId;
    private Object instance;
    private Method method;
    private ControllerPager pager;
    private List<ControllerParameter> parameters;

    public ControllerRegister(String dataObjId, Object instance) {
        this.dataObjId = dataObjId;
        this.instance = instance;
    }

    public ControllerRegister addParameter(String name, Class<?> classz) {
        return this.addParameter(name, classz, false);
    }

    public ControllerRegister addParameter(String name, Class<?> classz, boolean number) {
        if (CollectionUtils.isEmpty(this.parameters)) {
            this.parameters = Lists.newArrayList();
        }
        ControllerParameter parameter = new ControllerParameter();
        parameter.setName(name);
        parameter.setType(classz);
        parameter.setNumber(number);
        if (number) {
            parameter.setNumberType(classz);
        }
        this.parameters.add(parameter);
        return this;
    }

    public ControllerRegister addPageNumber(String name, Class<? extends Number> classz) {
        this.addParameter(name, classz, true);
        if (this.pager == null) {
            this.pager = new ControllerPager();
        }
        this.pager.setPageNumber(name, classz);
        return this;
    }

    public ControllerRegister addPageSize(String name, Class<? extends Number> classz) {
        this.addParameter(name, classz, true);
        if (this.pager == null) {
            this.pager = new ControllerPager();
        }
        this.pager.setPageSize(name, classz);
        return this;
    }

    public ControllerRegister register(String methodName) {
        if (this.instance == null) {
            throw new UnsupportedOperationException("\u5b9e\u4f8b\u672a\u6ce8\u518c!");
        }
        try {
            Class[] parameterTypes = new Class[this.parameters.size()];
            for (int i = 0; i < this.parameters.size(); ++i) {
                parameterTypes[i] = this.parameters.get(i).getType();
            }
            this.method = this.instance.getClass().getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException(methodName + "\u65b9\u6cd5\u4e0d\u5b58\u5728!");
        }
        if (CollectionUtils.isEmpty(this.parameters)) {
            this.parameters = Lists.newArrayList();
        }
        return this;
    }

    public String getDataObjId() {
        return this.dataObjId;
    }

    public void setDataObjId(String dataObjId) {
        this.dataObjId = dataObjId;
    }

    public Object getInstance() {
        return this.instance;
    }

    public void setInstance(Object instance) {
        this.instance = instance;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public ControllerPager getPager() {
        return this.pager;
    }

    public void setPager(ControllerPager pager) {
        this.pager = pager;
    }

    public List<ControllerParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<ControllerParameter> parameters) {
        this.parameters = parameters;
    }
}

