/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.drs.service.impl;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import pams.function.zhengzhou.drs.dto.request.DrsConditionValueDto;
import pams.function.zhengzhou.drs.dto.request.DrsParameterDto;
import pams.function.zhengzhou.drs.dto.response.DrsDataDto;
import pams.function.zhengzhou.drs.dto.response.DrsResponseDto;
import pams.function.zhengzhou.drs.register.ControllerRegister;
import pams.function.zhengzhou.drs.register.ControllerRegistrator;
import pams.function.zhengzhou.drs.service.DrsBridgeControllerService;
import pams.function.zhengzhou.fjjg.mobile.bean.ResultBean;

@Service
public class DrsBridgeControllerServiceImpl
implements DrsBridgeControllerService {
    private static Logger logger = LoggerFactory.getLogger(DrsBridgeControllerServiceImpl.class);
    @Autowired
    private ControllerRegistrator controllerRegistrator;

    @Override
    public void bridge(String dataObjId, DrsParameterDto parameter, DrsResponseDto drsResponseDto, HttpServletRequest request, HttpServletResponse response) {
        Map<String, ControllerRegister> registerMap = this.controllerRegistrator.getRegisterMap();
        if (!registerMap.containsKey(dataObjId)) {
            drsResponseDto.setMessage("\u672a\u5b9e\u73b0\u5f53\u524d\u63a5\u53e3");
            return;
        }
        ControllerRegister register = registerMap.get(dataObjId);
        this.invoke(register, parameter, drsResponseDto, request, response);
    }

    private void invoke(ControllerRegister register, DrsParameterDto parameter, DrsResponseDto drsResponseDto, HttpServletRequest request, HttpServletResponse response) {
        List<DrsConditionValueDto> conditions = parameter.getCondition().getKeyValueList();
        Object[] parameters = new Object[3];
        if (!CollectionUtils.isEmpty(conditions)) {
            for (DrsConditionValueDto condition : conditions) {
                if (!"req_json".equals(condition.getKey())) continue;
                parameters[0] = condition.getValue();
            }
        }
        Object controllerResponse = null;
        try {
            controllerResponse = ReflectionUtils.invokeMethod((Method)register.getMethod(), (Object)register.getInstance(), (Object[])parameters);
            if (!(controllerResponse instanceof ResultBean)) {
                drsResponseDto.setMessage("\u6ce8\u518c\u65b9\u6cd5\u4e0d\u53ef\u89e3\u6790");
                return;
            }
        }
        catch (Exception e) {
            logger.warn("\u53cd\u5c04\u8c03\u7528\u63a5\u53e3\u53d1\u751f\u5f02\u5e38!{}", (Object)register.getMethod().getName(), (Object)e);
            drsResponseDto.setMessage(e.getMessage());
            return;
        }
        ResultBean resultBean = (ResultBean)controllerResponse;
        DrsDataDto data = new DrsDataDto();
        data.setData(resultBean);
        drsResponseDto.setData(data);
        drsResponseDto.setMessage("ok");
        drsResponseDto.setCode("200");
    }
}

