/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.drs.util;

import com.xdja.pams.common.util.BeanUtils;
import com.xdja.pams.syms.service.SystemConfigService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pams.function.zhengzhou.drs.bean.Data;
import pams.function.zhengzhou.drs.bean.DrsResult;
import pams.function.zhengzhou.drs.bean.Item;
import pams.function.zhengzhou.util.Tools;

public class DrsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DrsUtils.class);
    private static DrsUtils drs = null;
    private String url;
    private static int connectionTimeout = 5;

    private DrsUtils(String url) {
        this.url = url;
    }

    public static DrsUtils getInstance() {
        if (drs == null) {
            SystemConfigService systemConfigService = (SystemConfigService)BeanUtils.getBean(SystemConfigService.class);
            String url = systemConfigService.getValueByCode("drs_url");
            drs = new DrsUtils(url);
        }
        return drs;
    }

    public String executeRequest(String xml) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HttpClient\u8c03\u7528\u63a5\u53e3...");
        }
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpPost post = new HttpPost(this.url);
        BasicHttpParams params = new BasicHttpParams();
        params.setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        params.setIntParameter("http.connection.timeout", connectionTimeout * 1000);
        post.setHeader("Content-Type", "text/xml;charset=UTF-8");
        post.setHeader("Accept-Encoding", "gzip,deflate");
        post.setParams((HttpParams)params);
        LOG.info("\u63a5\u53e3\u8bf7\u6c42\u5185\u5bb9: " + xml);
        post.setEntity((HttpEntity)new EntityTemplate((ContentProducer)new HttpContentProducer(xml)));
        String err = null;
        try {
            String wsRet = null;
            HttpEntity entity = httpClient.execute((HttpUriRequest)post).getEntity();
            InputStream is = entity.getContent();
            byte[] buffer = new byte[262144];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int dataLength = 0;
            while ((dataLength = is.read(buffer)) > -1) {
                baos.write(buffer, 0, dataLength);
            }
            wsRet = new String(baos.toByteArray(), "UTF-8");
            baos = null;
            LOG.info("\u63a5\u53e3\u8fd4\u56de: " + wsRet);
            String string = wsRet;
            return string;
        }
        catch (ClientProtocolException e) {
            err = "\u5ba2\u6237\u7aef\u8bbf\u95ee\u534f\u8bae\u9519\u8bef\uff1a" + e.getMessage();
            throw new Exception(err);
        }
        catch (IOException e) {
            err = "\u7f51\u7edc\u8bbf\u95ee\u5f02\u5e38\uff1a" + e.getMessage() + "\uff0c\u5f53\u524d\u670d\u52a1\u4e0d\u53ef\u7528";
            throw new Exception(err);
        }
        catch (Exception e) {
            err = "\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage();
            throw new Exception(err);
        }
        finally {
            try {
                httpClient.getConnectionManager().shutdown();
            }
            catch (Exception exception) {}
        }
    }

    public DrsResult query(String xml) {
        DrsResult drsResult = new DrsResult();
        try {
            String response = this.executeRequest(xml);
            Document doc = Tools.getDoc(response);
            this.parseDrsResult(doc, drsResult, true);
        }
        catch (Exception e) {
            drsResult.setState(1);
            drsResult.setErrMsg(e.getMessage());
        }
        return drsResult;
    }

    public DrsResult executeIDU(String xml) {
        DrsResult drsResult = new DrsResult();
        try {
            String response = this.executeRequest(xml);
            Document doc = Tools.getDoc(response);
            this.parseDrsResult(doc, drsResult, false);
        }
        catch (Exception e) {
            drsResult.setState(1);
            drsResult.setErrMsg(e.getMessage());
        }
        return drsResult;
    }

    private void parseDrsResult(Document doc, DrsResult drsResult, boolean isQuery) {
        Element node = doc.getRootElement().element("Body");
        node = (Element)node.elements().get(0);
        Element ret = (Element)node.elements().get(0);
        drsResult.setState(Tools.getInt(ret.elementText("state"), 1));
        drsResult.setErrMsg(ret.elementText("errMsg"));
        if (drsResult.getState() > 0) {
            return;
        }
        if (!isQuery) {
            return;
        }
        drsResult.setCurrRows(Tools.getInt(ret.elementText("currRows"), 0));
        drsResult.setRowTotal(Tools.getLong(ret.elementText("rowTotal"), 0L));
        drsResult.setLocalTable(ret.elementText("localTable"));
        List fieldList = ret.elements("localFields");
        String[] fields = new String[fieldList.size()];
        for (int x = 0; x < fields.length; ++x) {
            fields[x] = ((Element)fieldList.get(x)).getText();
        }
        drsResult.setLocalFields(fields);
        List rowList = ret.elements("rows");
        if (rowList.isEmpty()) {
            return;
        }
        for (Element row : rowList) {
            List items = row.elements("item");
            Item item = new Item();
            LinkedHashMap<String, Data> map = new LinkedHashMap<String, Data>();
            for (int y = 0; y < items.size(); ++y) {
                Element itemElement = (Element)items.get(y);
                Data data = new Data();
                data.setValue(itemElement.elementText("value"));
                data.setCode(Tools.getBoolean(itemElement.elementText("code"), false));
                if (data.isCode()) {
                    data.setCodeValue(itemElement.elementText("codeValue"));
                }
                map.put(fields[y], data);
            }
            item.setData(map);
            drsResult.getRows().add(item);
        }
    }

    public class HttpContentProducer
    implements ContentProducer {
        private String soapRequestData;

        public HttpContentProducer(String soapRequestData) {
            this.soapRequestData = soapRequestData;
        }

        public void writeTo(OutputStream outStream) throws IOException {
            OutputStreamWriter writer = new OutputStreamWriter(outStream, "UTF-8");
            writer.write(this.soapRequestData);
            ((Writer)writer).flush();
        }
    }
}

