/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.drs.util;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DrsXml {
    public static String insertXml(String tableName, String condition, Map<String, String> columnValMap) {
        StringBuilder columnVal = new StringBuilder();
        if (columnValMap != null) {
            for (Map.Entry<String, String> entry : columnValMap.entrySet()) {
                columnVal.append("<column><name>" + entry.getKey() + "</name><value>" + entry.getValue() + "</value></column>");
            }
        }
        StringBuilder xml = new StringBuilder();
        xml.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ser=\"http://service.drs.xdja.com/\">");
        xml.append("<soapenv:Header/>");
        xml.append("<soapenv:Body>");
        xml.append("<ser:executeIDU>");
        xml.append("<iduRequest>");
        xml.append("<table>");
        xml.append("<name>" + tableName + "</name>");
        xml.append("<row>");
        xml.append((CharSequence)columnVal);
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            xml.append("<srcCondition><![CDATA[ " + condition + " ]]></srcCondition>");
        }
        xml.append("<type>insert</type>");
        xml.append("</row>");
        xml.append("</table>");
        xml.append("</iduRequest>");
        xml.append("</ser:executeIDU>");
        xml.append("</soapenv:Body>");
        xml.append("</soapenv:Envelope>");
        return xml.toString();
    }

    public static String updateXml(String tableName, String condition, Map<String, String> columnValMap) {
        StringBuilder columnVal = new StringBuilder();
        if (columnValMap != null) {
            for (Map.Entry<String, String> entry : columnValMap.entrySet()) {
                columnVal.append("<column><name>" + entry.getKey() + "</name><value>" + entry.getValue() + "</value></column>");
            }
        }
        StringBuilder xml = new StringBuilder();
        xml.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ser=\"http://service.drs.xdja.com/\">");
        xml.append("<soapenv:Header/>");
        xml.append("<soapenv:Body>");
        xml.append("<ser:executeIDU>");
        xml.append("<iduRequest>");
        xml.append("<table>");
        xml.append("<name>" + tableName + "</name>");
        xml.append("<row>");
        xml.append((CharSequence)columnVal);
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            xml.append("<srcCondition><![CDATA[ " + condition + " ]]></srcCondition>");
        }
        xml.append("<type>update</type>");
        xml.append("</row>");
        xml.append("</table>");
        xml.append("</iduRequest>");
        xml.append("</ser:executeIDU>");
        xml.append("</soapenv:Body>");
        xml.append("</soapenv:Envelope>");
        return xml.toString();
    }

    public static String deleteXml(String tableName, String condition) {
        StringBuilder xml = new StringBuilder();
        xml.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ser=\"http://service.drs.xdja.com/\">");
        xml.append("<soapenv:Header/>");
        xml.append("<soapenv:Body>");
        xml.append("<ser:executeIDU>");
        xml.append("<iduRequest>");
        xml.append("<table>");
        xml.append("<name>" + tableName + "</name>");
        xml.append("<row>");
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            xml.append("<srcCondition><![CDATA[ " + condition + " ]]></srcCondition>");
        }
        xml.append("<type>delete</type>");
        xml.append("</row>");
        xml.append("</table>");
        xml.append("</iduRequest>");
        xml.append("</ser:executeIDU>");
        xml.append("</soapenv:Body>");
        xml.append("</soapenv:Envelope>");
        return xml.toString();
    }

    public static String queryXml(String tableName, String condition, String pageNumber, String pageSize, String ... columns) {
        String cols = null;
        if (columns == null || columns.length == 0) {
            cols = "*";
        } else {
            cols = columns[0];
            if (columns.length > 1) {
                for (int i = 1; i < columns.length; ++i) {
                    cols = cols + "," + columns[i];
                }
            }
        }
        StringBuilder xml = new StringBuilder();
        xml.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ser=\"http://service.drs.xdja.com/\">");
        xml.append("<soapenv:Header/>");
        xml.append("<soapenv:Body>");
        xml.append("<ser:query>");
        xml.append("<parameters>");
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            xml.append("<condition><![CDATA[ " + condition + " ]]></condition>");
        }
        xml.append("<dsid>*</dsid>");
        xml.append("<localFields>" + cols + "</localFields>");
        xml.append("<localTable>" + tableName + "</localTable>");
        if (StringUtils.isNotBlank((CharSequence)pageNumber)) {
            xml.append("<pageNumber>" + pageNumber + "</pageNumber>");
        }
        if (StringUtils.isNotBlank((CharSequence)pageSize)) {
            xml.append("<pageSize>" + pageSize + "</pageSize>");
        }
        xml.append("</parameters>");
        xml.append("</ser:query>");
        xml.append("</soapenv:Body>");
        xml.append("</soapenv:Envelope>");
        return xml.toString();
    }
}

