/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.drs.utils;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import pams.function.zhengzhou.drs.utils.DrsSupportValueEnum;

public class DrsBeanCopyUtils {
    private static Logger logger = LoggerFactory.getLogger(DrsBeanCopyUtils.class);

    public static <T> void copyMap2Bean(Map<String, Object> map, T bean) {
        if (bean == null) {
            return;
        }
        if (CollectionUtils.isEmpty(map)) {
            return;
        }
        Set<Map.Entry<String, Object>> filedSet = map.entrySet();
        for (Map.Entry<String, Object> entry : filedSet) {
            Object value = entry.getValue();
            if (value == null) continue;
            try {
                PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(bean.getClass(), (String)entry.getKey());
                Method write = propertyDescriptor.getWriteMethod();
                if (DrsBeanCopyUtils.isNumber(propertyDescriptor.getPropertyType())) {
                    value = DrsBeanCopyUtils.convertNumber(String.valueOf(value), propertyDescriptor.getPropertyType());
                }
                write.invoke(bean, value);
            }
            catch (Exception e) {
                logger.warn("\u590d\u5236\u5b57\u6bb5\u53d1\u751f\u5f02\u5e38!{}", (Object)entry.getKey(), (Object)e);
            }
        }
    }

    public static Object convertNumber(String string, Class<?> propertyType) {
        if (string == null) {
            return null;
        }
        DrsSupportValueEnum numberType = DrsSupportValueEnum.getByNumberType(propertyType);
        if (numberType == null) {
            return null;
        }
        switch (numberType) {
            case INT: {
                return (int)Integer.valueOf(string);
            }
            case INTEGER_OBJECT: {
                return Integer.valueOf(string);
            }
            case LONG: {
                return (long)Long.valueOf(string);
            }
            case LONG_OBJECT: {
                return Long.valueOf(string);
            }
            case DOUBLE: {
                return (double)Double.valueOf(string);
            }
            case DOUBLE_OBJECT: {
                return Double.valueOf(string);
            }
            case FLOAT: {
                return Float.valueOf(Float.valueOf(string).floatValue());
            }
            case FLOAT_OBJECT: {
                return Float.valueOf(string);
            }
        }
        return null;
    }

    private static boolean isNumber(Class<?> propertyType) {
        return DrsSupportValueEnum.getByNumberType(propertyType) != null;
    }
}

