/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.fjjg.control;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.bean.ReturnResult;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.zhengzhou.fjjg.bean.MjBindInfoBean;
import pams.function.zhengzhou.fjjg.entity.BindInfo;
import pams.function.zhengzhou.fjjg.service.BindInfoService;

@Controller
@Scope(value="session")
public class AuxManagerController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(AuxManagerController.class);
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private BindInfoService bindInfoService;

    @RequestMapping(value={"/fjjg/AuxManagerController/index.do"})
    public String index(HttpServletRequest request, HttpServletResponse response, ModelMap map, PageParam page) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            map.put((Object)"rootDep", (Object)this.getRootId(request));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/fjjg/AuxManagerController/queryList.do"})
    public void queryUseList(HttpServletRequest request, HttpServletResponse response, ModelMap map, MjBindInfoBean queryBean) {
        boolean operateResult = true;
        this.setOperator(request);
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            Page page = new Page(Integer.parseInt(queryBean.getPage()), Integer.parseInt(queryBean.getRows()));
            List<MjBindInfoBean> list = this.bindInfoService.getMjBindList(queryBean, this.getControlDeps(request), this.getControlPolices(request), page);
            result.put("total", page.getTotal());
            result.put("rows", list);
        }
        catch (Exception e) {
            operateResult = false;
            log.error("\u83b7\u53d6\u4eba\u5458\u4fe1\u606f\u5217\u8868\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(result));
    }

    @RequestMapping(value={"/fjjg/AuxManagerController/forwardAssignPage.do"})
    public String forwardAssignPage(String id, ModelMap map, HttpServletRequest request, HttpServletResponse response) {
        try {
            List<BindInfo> list = this.bindInfoService.getAllFjList(id);
            map.put((Object)"maxCount", (Object)100);
            StringBuffer personStrList = new StringBuffer("#");
            StringBuffer nowShowPersonStrList = new StringBuffer("#");
            ArrayList personMapList = new ArrayList();
            HashMap personMapAll = new HashMap();
            int i = 0;
            if (list != null && list.size() > 0) {
                Person person = null;
                for (BindInfo bindInfo : list) {
                    person = this.userManageService.queryPersonById(bindInfo.getFjId());
                    HashMap<String, String> personMap = new HashMap<String, String>();
                    personMap.put("id", person.getId());
                    personMap.put("name", Util.cvNameByPersonType((String)person.getName(), (String)person.getPersonType()));
                    personMap.put("code", person.getCode());
                    personMap.put("depName", person.getDepartment().getName());
                    personMap.put("flag", "person");
                    personMap.put("group", "\u4eba");
                    personMapAll.put(person.getId(), personMap);
                    if (i < 10) {
                        personMapList.add(personMap);
                    } else {
                        nowShowPersonStrList.append(person.getId()).append("#");
                    }
                    ++i;
                    personStrList.append(person.getId()).append("#");
                }
            }
            map.put((Object)"personListJson", (Object)Util.toJsonStr(personMapList));
            map.put((Object)"personStrList", (Object)personStrList);
            map.put((Object)"depStrList", (Object)"#");
            map.put((Object)"nowShowPersonStrList", (Object)nowShowPersonStrList);
            map.put((Object)"personMapAll", (Object)Util.toJsonStr(personMapAll));
            map.put((Object)"personList", null);
            map.put((Object)"depList", null);
            return "fjjg/default/assign";
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7ba1\u8f96\u8f85\u8b66\u5217\u8868\u5931\u8d25:", (Throwable)e);
            return null;
        }
    }

    @RequestMapping(value={"/fjjg/AuxManagerController/assign.do"})
    public void assign(String mjId, String fjIds, HttpServletRequest request, HttpServletResponse response) {
        ReturnResult rtnResult = new ReturnResult();
        try {
            this.bindInfoService.assign(mjId, fjIds);
            rtnResult.setRtnCode("0");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.success"));
        }
        catch (Exception e) {
            rtnResult.setRtnCode("1");
            rtnResult.setRtnMsg(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.message.operate.fail") + ":" + e.getMessage());
            log.error(e.getMessage());
        }
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr((Object)rtnResult));
    }

    @RequestMapping(value={"/fjjg/AuxManagerController/getPersonsJsonByCodeOrName.do"})
    public void getPersonsJsonByCodeOrName(HttpServletRequest request, HttpServletResponse response, ModelMap map, String q, String limit) {
        String jsonlist = "";
        try {
            String codeOrName = URLDecoder.decode(q, "Utf-8");
            String controlDepsIds = this.getControlDeps(request);
            String controlPolices = this.getControlPolices(request);
            List<Map<String, Object>> listmap = this.bindInfoService.getPersonsJsonByCodeOrName(codeOrName, limit, controlDepsIds, controlPolices);
            jsonlist = Util.toJsonStr(listmap);
        }
        catch (Exception e) {
            log.error("#\u83b7\u53d6\u4ee3\u7801\u5f02\u5e38\u3010" + q + "," + limit + "\u3011\uff1a" + e.getMessage(), (Throwable)e);
        }
        Util.writeUtf8Text((HttpServletResponse)response, (String)jsonlist);
    }
}

