/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.fjjg.dao.impl;

import com.xdja.pams.bims.util.BimsUtil;
import com.xdja.pams.common.basedao.BaseDao;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import pams.function.zhengzhou.fjjg.bean.InputApplyBean;
import pams.function.zhengzhou.fjjg.dao.InputApplyDao;
import pams.function.zhengzhou.fjjg.entity.InputApply;

@Repository
public class InputApplyDaoImpl
implements InputApplyDao {
    @Autowired
    private BaseDao baseDao;

    @Override
    public void removeAll(List<String> fjIds) {
        if (CollectionUtils.isEmpty(fjIds)) {
            return;
        }
        ArrayList<String> nameKeys = new ArrayList<String>();
        nameKeys.add("ids");
        this.baseDao.updateBySql("delete from T_FJJG_INPUT_APPLY where STATE='0' and  FJ_ID in (:ids)", new Object[]{fjIds}, nameKeys);
    }

    @Override
    public void remove(InputApplyBean bean) {
        StringBuilder deleteSql = new StringBuilder("delete from T_FJJG_INPUT_APPLY where 1=1 ");
        ArrayList<String> param = new ArrayList<String>();
        if (StringUtils.hasText((String)bean.getModuleId())) {
            deleteSql.append("and module_id=? ");
            param.add(bean.getModuleId());
        }
        if (StringUtils.hasText((String)bean.getState())) {
            deleteSql.append("and state=? ");
            param.add(bean.getState());
        }
        if (StringUtils.hasText((String)bean.getFjId())) {
            deleteSql.append("and fj_id=? ");
            param.add(bean.getFjId());
        }
        this.baseDao.updateBySql(deleteSql.toString(), param.toArray());
    }

    @Override
    public List<InputApply> queryNativeByPage(InputApplyBean queryBean, String controlDepIds, String controlPolices, Page page) throws Exception {
        StringBuilder selectSql = new StringBuilder("select a.* from T_FJJG_INPUT_APPLY a left join t_person p1 on a.FJ_ID = p1.ID left join T_PERSON p2 on a.MJ_ID = p2.ID where p1.flag='0' and p2.flag='0' ");
        StringBuilder countSql = new StringBuilder("select count(a.ID) from T_FJJG_INPUT_APPLY a left join t_person p1 on a.FJ_ID = p1.ID left join T_PERSON p2 on a.MJ_ID = p2.ID where p1.flag='0' and p2.flag='0' ");
        StringBuilder whereSql = new StringBuilder("");
        ArrayList<String> paramList = new ArrayList<String>();
        whereSql.append("and p1.dep_Id in (" + BimsUtil.getChildDepsSql((String)controlDepIds) + ") ");
        if (!"all".equals(controlPolices)) {
            whereSql.append("and p1.police in (" + BimsUtil.getControlPoliceSql((String)controlPolices) + ") ");
        }
        if (StringUtils.hasText((String)queryBean.getBeginUpdateTime())) {
            whereSql.append("and a.UPDATE_TIME>=? ");
            paramList.add(Util.getLongDate((String)(queryBean.getBeginUpdateTime() + " 00:00:00")) + "");
        }
        if (StringUtils.hasText((String)queryBean.getEndUpdateTime())) {
            whereSql.append("and a.UPDATE_TIME<=? ");
            paramList.add(Util.getLongDate((String)(queryBean.getBeginUpdateTime() + " 23:59:59")) + "");
        }
        if (StringUtils.hasText((String)queryBean.getFjName())) {
            whereSql.append("and p1.name like ? ");
            paramList.add("%" + queryBean.getFjName() + "%");
        }
        if (StringUtils.hasText((String)queryBean.getMjName())) {
            whereSql.append("and p2.name like ? ");
            paramList.add("%" + queryBean.getMjName() + "%");
        }
        if (StringUtils.hasText((String)queryBean.getFjCode())) {
            whereSql.append("and p1.code like ? ");
            paramList.add("%" + queryBean.getFjCode() + "%");
        }
        if (StringUtils.hasText((String)queryBean.getMjCode())) {
            whereSql.append("and p2.code like ? ");
            paramList.add("%" + queryBean.getMjCode() + "%");
        }
        String orderStr = " order by a.UPDATE_TIME desc ";
        return this.baseDao.getListBySQL(countSql.append((CharSequence)whereSql).toString(), selectSql.append((CharSequence)whereSql).append(orderStr).toString(), paramList.toArray(), page, InputApply.class);
    }

    @Override
    public List<InputApply> query(InputApplyBean queryBean, Page page) {
        StringBuilder selectHql = new StringBuilder("from InputApply where 1=1 ");
        ArrayList<String> params = new ArrayList<String>();
        if (StringUtils.hasText((String)queryBean.getFjId())) {
            selectHql.append("and fjId=? ");
            params.add(queryBean.getFjId());
        }
        if (StringUtils.hasText((String)queryBean.getModuleId())) {
            selectHql.append("and moduleId=? ");
            params.add(queryBean.getModuleId());
        }
        if (StringUtils.hasText((String)queryBean.getState())) {
            selectHql.append("and state=? ");
            params.add(queryBean.getState());
        }
        return this.baseDao.getListByHQL(selectHql.toString(), params.toArray());
    }

    @Override
    public void add(InputApply inputApply) {
        this.baseDao.create((Object)inputApply);
    }

    @Override
    public void update(InputApply inputApply) {
        this.baseDao.update((Object)inputApply);
    }
}

