/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.fjjg.service.impl;

import com.xdja.pams.bims.bean.QueryPersonBean;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.bims.util.BimsUtil;
import com.xdja.pams.common.util.Page;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import pams.function.zhengzhou.fjjg.bean.BindInfoBean;
import pams.function.zhengzhou.fjjg.bean.FjBindInfoBean;
import pams.function.zhengzhou.fjjg.bean.MjBindInfoBean;
import pams.function.zhengzhou.fjjg.dao.BindApplyDao;
import pams.function.zhengzhou.fjjg.dao.BindInfoDao;
import pams.function.zhengzhou.fjjg.dao.BklxDao;
import pams.function.zhengzhou.fjjg.dao.KkbhDao;
import pams.function.zhengzhou.fjjg.dao.ModulePowerDao;
import pams.function.zhengzhou.fjjg.dao.impl.InputApplyDaoImpl;
import pams.function.zhengzhou.fjjg.entity.BindInfo;
import pams.function.zhengzhou.fjjg.service.BindInfoService;
import pams.function.zhengzhou.fjjg.service.ModulePowerService;

@Service
public class BindInfoServiceImpl
implements BindInfoService {
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private BindApplyDao bindApplyDao;
    @Autowired
    private InputApplyDaoImpl inputApplyDao;
    @Autowired
    private BindInfoDao bindInfoDao;
    @Autowired
    private ModulePowerDao modulePowerDao;
    @Autowired
    private ModulePowerService modulePowerService;
    @Autowired
    private BklxDao bklxDao;
    @Autowired
    private KkbhDao kkbhDao;

    @Override
    public List<MjBindInfoBean> getMjBindList(MjBindInfoBean bean, String controlDepIds, String controlPolices, Page page) throws Exception {
        ArrayList<MjBindInfoBean> result = new ArrayList<MjBindInfoBean>();
        QueryPersonBean personBean = new QueryPersonBean();
        BeanUtils.copyProperties((Object)bean, (Object)personBean);
        personBean.setCode(bean.getMjCode());
        personBean.setName(bean.getMjName());
        personBean.setPersonType("1");
        List personBeanList = this.userManageService.queryPersonList2(personBean, controlDepIds, controlPolices, page);
        MjBindInfoBean mjBindInfoBean = null;
        BindInfoBean bindInfo = new BindInfoBean();
        for (QueryPersonBean person : personBeanList) {
            mjBindInfoBean = new MjBindInfoBean();
            mjBindInfoBean.setMjId(person.getId());
            mjBindInfoBean.setMjName(person.getName());
            mjBindInfoBean.setMjDepName(person.getDepName());
            mjBindInfoBean.setMjCode(person.getCode());
            mjBindInfoBean.setMjMobile(person.getMobile());
            bindInfo.setMjId(person.getId());
            mjBindInfoBean.setFjNum(this.bindInfoDao.queryBindInfoCount(bindInfo));
            result.add(mjBindInfoBean);
        }
        return result;
    }

    @Override
    public List<FjBindInfoBean> getFjBindList(FjBindInfoBean queryBean, String controlDepIds, String controlPolices, Page page) throws Exception {
        StringBuilder selectSql = new StringBuilder("select p1.id as fjId,p2.id as mjId,b.state from t_person p1 left join t_fjjg_bind_info b on p1.id=b.fj_id left join t_person p2 on p2.id=b.mj_id where p1.flag='0' and p2.flag='0' ");
        StringBuilder countSql = new StringBuilder("select count(p1.id) from t_person p1 left join t_fjjg_bind_info b on p1.id=b.fj_id left join t_person p2 on p2.id=b.mj_id where p1.flag='0' and p2.flag='0' ");
        StringBuilder whereSql = new StringBuilder("");
        ArrayList<String> paramList = new ArrayList<String>();
        whereSql.append("and p1.PERSON_TYPE = ? ");
        paramList.add("2");
        if (StringUtils.hasText((String)queryBean.getMjCode())) {
            whereSql.append("and p2.code like ? ");
            paramList.add("%" + queryBean.getMjCode() + "%");
        }
        if (StringUtils.hasText((String)queryBean.getFjCode())) {
            whereSql.append("and p1.code like ? ");
            paramList.add("%" + queryBean.getFjCode() + "%");
        }
        if (StringUtils.hasText((String)queryBean.getMjName())) {
            whereSql.append("and p2.name like ? ");
            paramList.add("%" + queryBean.getMjName() + "%");
        }
        if (StringUtils.hasText((String)queryBean.getFjName())) {
            whereSql.append("and p1.name like ? ");
            paramList.add("%" + queryBean.getFjName() + "%");
        }
        if (StringUtils.hasText((String)queryBean.getState())) {
            whereSql.append(" and b.state = ? ");
            paramList.add(queryBean.getState());
        }
        if (queryBean.getIsContain() != null && queryBean.getIsContain().contains("true")) {
            if (StringUtils.hasText((String)queryBean.getDepId())) {
                whereSql.append("and p1.dep_Id in (" + BimsUtil.getChildDepsSql() + ")");
                paramList.add(queryBean.getDepId());
            } else {
                whereSql.append("and p1.dep_Id in (" + BimsUtil.getChildDepsSql((String)controlDepIds) + ") ");
            }
        } else if (StringUtils.hasText((String)queryBean.getDepId())) {
            whereSql.append("and p1.dep_Id = ? ");
            paramList.add(queryBean.getDepId());
        } else {
            whereSql.append("and p1.dep_Id in (" + BimsUtil.getChildDepsSql((String)controlDepIds) + ") ");
        }
        if (!"all".equals(controlPolices)) {
            whereSql.append("and p1.police in (" + BimsUtil.getControlPoliceSql((String)controlPolices) + ") ");
        }
        List<Map> list = this.bindInfoDao.queryNativeByPage(countSql.append((CharSequence)whereSql).toString(), selectSql.append((CharSequence)whereSql).toString(), paramList.toArray(), page);
        return this.bindInfo2FjBindInfo(list);
    }

    private List<FjBindInfoBean> bindInfo2FjBindInfo(List<Map> list) {
        ArrayList<FjBindInfoBean> result = new ArrayList<FjBindInfoBean>();
        if (CollectionUtils.isEmpty(list)) {
            return result;
        }
        FjBindInfoBean bean = null;
        for (Map map : list) {
            bean = new FjBindInfoBean();
            bean.setState(map.get("STATE") + "");
            Person fj = this.userManageService.queryPersonById(map.get("FJID") + "");
            Person mj = this.userManageService.queryPersonById(map.get("MJID") + "");
            if (mj != null) {
                bean.setMjName(mj.getName());
                bean.setMjDepName(mj.getDepartment().getName());
            }
            bean.setFjName(fj.getName());
            bean.setFjDepName(fj.getDepartment().getName());
            bean.setFjCode(fj.getCode());
            bean.setFjMobile(fj.getMobile());
            result.add(bean);
        }
        return result;
    }

    @Override
    public List<BindInfo> getAllFjList(String mjId) throws Exception {
        BindInfoBean bindInfo = new BindInfoBean();
        bindInfo.setMjId(mjId);
        return this.bindInfoDao.query(bindInfo, null);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void assign(String mjId, String fjIds) throws Exception {
        BindInfoBean bean = new BindInfoBean();
        bean.setMjId(mjId);
        List<BindInfo> list = this.bindInfoDao.query(bean, null);
        List<String> oldFjIdList = BindInfoServiceImpl.getIdList(list);
        String[] fjIdArray = new String[]{};
        if (StringUtils.hasText((String)fjIds) && fjIds.length() > 1) {
            fjIds = fjIds.substring(1, fjIds.length() - 1);
            fjIdArray = fjIds.split(",");
        }
        List<String> newFjIdList = Arrays.asList(fjIdArray);
        ArrayList<String> removeAssignList = new ArrayList<String>(oldFjIdList);
        removeAssignList.removeAll(newFjIdList);
        if (!CollectionUtils.isEmpty(removeAssignList)) {
            this.bindInfoDao.remove(mjId, removeAssignList);
            this.modulePowerDao.removeAll(removeAssignList);
            this.bindApplyDao.removeAll(removeAssignList);
            this.inputApplyDao.removeAll(removeAssignList);
        }
        ArrayList<String> addAssignList = new ArrayList<String>(newFjIdList);
        addAssignList.removeAll(oldFjIdList);
        if (!CollectionUtils.isEmpty(addAssignList)) {
            BindInfoBean queryBean = new BindInfoBean();
            for (String id : addAssignList) {
                queryBean.setFjId(id);
                if (this.bindInfoDao.query(queryBean, null).size() <= 0) continue;
                Person p = this.userManageService.queryPersonById(id);
                throw new Exception("\u8f85\u8b66:" + p.getCode() + "\u5df2\u7ecf\u88ab\u5176\u4ed6\u6c11\u8b66\u7ba1\u8f96");
            }
            this.bindInfoDao.add(mjId, addAssignList);
            this.modulePowerService.initModulePower(addAssignList);
        }
    }

    @Override
    public List<Map<String, Object>> getPersonsJsonByCodeOrName(String q, String limit, String controlDepsIds, String controlPolices) throws Exception {
        Page page = new Page("1", limit);
        QueryPersonBean queryBean = new QueryPersonBean();
        queryBean.setNameOrCode(q);
        queryBean.setPersonType("2");
        List personList = this.userManageService.queryPersonList(queryBean, controlDepsIds, controlPolices, page);
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (Person person : personList) {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("text", person.getName());
            item.put("personId", person.getId());
            mapList.add(item);
        }
        return mapList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unBind(BindInfoBean bean) throws Exception {
        List<BindInfo> list = this.bindInfoDao.query(bean, null);
        if (CollectionUtils.isEmpty(list) || list.size() != 1) {
            throw new Exception("\u6570\u636e\u5f02\u5e38");
        }
        BindInfo info = list.get(0);
        info.setState("0");
        this.bindInfoDao.update(info);
        ArrayList<String> fjId = new ArrayList<String>();
        fjId.add(bean.getFjId());
        this.inputApplyDao.removeAll(fjId);
        Person fj = this.userManageService.queryPersonById(bean.getFjId());
        this.bklxDao.remove(fj.getCode());
        this.kkbhDao.remove(fj.getCode());
    }

    private static List<String> getIdList(List<BindInfo> list) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(list)) {
            for (BindInfo info : list) {
                result.add(info.getFjId());
            }
        }
        return result;
    }
}

