/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.fjjg.service.impl;

import com.xdja.pams.common.service.PnPushService;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.common.util.XpushUtil;
import com.xdja.pams.syms.service.SystemConfigPbService;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.zhengzhou.fjjg.bean.FjjgPushBean;
import pams.function.zhengzhou.fjjg.service.FjjgPnPushService;

@Service
public class FjjgPnPushServiceImpl
implements FjjgPnPushService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FjjgPnPushServiceImpl.class);
    @Autowired
    private SystemConfigPbService systemConfigService;
    @Autowired
    private PnPushService pnPushService;
    @Autowired
    private XpushUtil xpushUtil;

    @Override
    public void push(String receiver, int personType, FjjgPushBean pushBean) throws Exception {
        String pushUse;
        LOGGER.info("FjjgPnPushServiceImpl.push({}, {})", (Object)receiver, (Object)personType);
        if (personType == 1) {
            pushUse = this.systemConfigService.getValueByCode("pushuse_mj");
        } else if (personType == 2) {
            pushUse = this.systemConfigService.getValueByCode("pushuse_fj");
        } else {
            LOGGER.info("pushUse \u662f\u7a7a\uff0c\u4e0d\u63a8\u9001");
            return;
        }
        LOGGER.info("pushUse : {}", (Object)pushUse);
        if ("1".equals(pushUse)) {
            this.push(receiver, pushBean);
        } else if ("2".equals(pushUse)) {
            this.pushNew(receiver, pushBean);
        } else if ("3".equals(pushUse)) {
            this.xpush(receiver, pushBean, personType);
        }
    }

    private void push(String receiver, FjjgPushBean pushBean) throws Exception {
        String appId = this.systemConfigService.getValueByCode("old_pn_fjjg_appid");
        String isCache = this.systemConfigService.getValueByCode("old_pn_cache");
        ArrayList<String> receivers = new ArrayList<String>();
        receivers.add(receiver);
        String pushReceiveType = this.systemConfigService.getValueByCode("old_pn_receive_type");
        String url = this.systemConfigService.getValueByCode("old_pn_url");
        this.pnPushService.push(receivers, appId, isCache, Util.toJsonStr((Object)pushBean), pushReceiveType, url);
    }

    private void pushNew(String receiver, FjjgPushBean pushBean) throws Exception {
        String appId = this.systemConfigService.getValueByCode("new_pn_fjjg_appid");
        String isCache = this.systemConfigService.getValueByCode("new_pn_cache");
        ArrayList<String> receivers = new ArrayList<String>();
        receivers.add(receiver);
        String pushReceiveType = this.systemConfigService.getValueByCode("new_pn_receive_type");
        String url = this.systemConfigService.getValueByCode("new_pn_url");
        this.pnPushService.push(receivers, appId, isCache, Util.toJsonStr((Object)pushBean), pushReceiveType, url);
    }

    private void xpush(String receiver, FjjgPushBean bean, int personType) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(receiver);
        String appId = this.systemConfigService.getValueByCode(personType == 1 ? "zz_xpush_appId_mj" : "zz_xpush_appId_fj");
        String topic = this.systemConfigService.getValueByCode(personType == 1 ? "zz_xpush_topic_mj" : "zz_xpush_topic_fj");
        this.xpushUtil.push(list, Util.toJsonStr((Object)bean), appId, topic);
    }
}

