/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.fjjg.service.impl;

import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Util;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import pams.function.zhengzhou.fjjg.bean.BindInfoBean;
import pams.function.zhengzhou.fjjg.bean.FjjgPushBean;
import pams.function.zhengzhou.fjjg.bean.InputApplyBean;
import pams.function.zhengzhou.fjjg.bean.ModulePowerBean;
import pams.function.zhengzhou.fjjg.bean.PushAuthorityBean;
import pams.function.zhengzhou.fjjg.dao.BindInfoDao;
import pams.function.zhengzhou.fjjg.dao.InputApplyDao;
import pams.function.zhengzhou.fjjg.dao.ModuleDao;
import pams.function.zhengzhou.fjjg.dao.ModulePowerDao;
import pams.function.zhengzhou.fjjg.entity.BindInfo;
import pams.function.zhengzhou.fjjg.entity.InputApply;
import pams.function.zhengzhou.fjjg.entity.Module;
import pams.function.zhengzhou.fjjg.entity.ModulePower;
import pams.function.zhengzhou.fjjg.service.FjjgPnPushService;
import pams.function.zhengzhou.fjjg.service.InputApplyService;

@Service
public class InputApplyServiceImpl
implements InputApplyService {
    private static final Logger log = LoggerFactory.getLogger(InputApplyServiceImpl.class);
    @Autowired
    private InputApplyDao inputApplyDao;
    @Autowired
    private UserManageService userManageService;
    @Autowired
    private ModuleDao moduleDao;
    @Autowired
    private ModulePowerDao modulePowerDao;
    @Autowired
    private BindInfoDao bindInfoDao;
    @Autowired
    private FjjgPnPushService fjjgPnPushService;

    @Override
    public List<InputApplyBean> getList(InputApplyBean queryBean, String controlDepIds, String controlPolices, Page page) throws Exception {
        ArrayList<InputApplyBean> result = new ArrayList<InputApplyBean>();
        List<InputApply> list = this.inputApplyDao.queryNativeByPage(queryBean, controlDepIds, controlPolices, page);
        if (CollectionUtils.isEmpty(list)) {
            return result;
        }
        InputApplyBean bean = null;
        Module module = null;
        for (InputApply inputApply : list) {
            module = this.moduleDao.queryById(inputApply.getModuleId());
            bean = new InputApplyBean();
            BeanUtils.copyProperties((Object)inputApply, (Object)bean);
            Person fj = this.userManageService.queryPersonById(bean.getFjId());
            Person mj = this.userManageService.queryPersonById(bean.getMjId());
            bean.setMjName(mj.getName());
            bean.setMjDepName(mj.getDepartment().getName());
            bean.setFjName(fj.getName());
            bean.setFjDepName(fj.getDepartment().getName());
            bean.setFjCode(fj.getCode());
            bean.setFjMobile(fj.getMobile());
            bean.setApplyContent(module.getName());
            result.add(bean);
        }
        return result;
    }

    @Override
    @Transactional
    public void applyInput(InputApplyBean bean) throws Exception {
        BindInfoBean bindInfoBean = new BindInfoBean();
        bindInfoBean.setFjId(bean.getFjId());
        List<BindInfo> list = this.bindInfoDao.query(bindInfoBean, null);
        if (CollectionUtils.isEmpty(list)) {
            throw new Exception("\u8f85\u8b66\u8fd8\u672a\u5206\u6d3e\u7ba1\u8f96\u6c11\u8b66");
        }
        if (!list.get(0).getState().equals("2")) {
            throw new Exception("\u8f85\u8b66\u8fd8\u672a\u7ed1\u5b9a\u7ba1\u8f96\u6c11\u8b66");
        }
        InputApplyBean applyBean = new InputApplyBean();
        BeanUtils.copyProperties((Object)bean, (Object)applyBean);
        applyBean.setState("0");
        List<InputApply> applyList = this.inputApplyDao.query(applyBean, null);
        if (!CollectionUtils.isEmpty(applyList)) {
            throw new Exception("\u5df2\u7ecf\u63d0\u4ea4\u8fc7\u7533\u8bf7\uff0c\u8bf7\u7b49\u5f85\u6c11\u8b66\u5ba1\u6279");
        }
        long currentTime = System.currentTimeMillis();
        InputApply inputApply = new InputApply();
        BeanUtils.copyProperties((Object)bean, (Object)inputApply);
        inputApply.setState("0");
        inputApply.setMjId(list.get(0).getMjId());
        inputApply.setCreateTime(currentTime);
        inputApply.setUpdateTime(currentTime);
        this.inputApplyDao.add(inputApply);
        Person fj = this.userManageService.queryPersonById(bean.getFjId());
        Module module = this.moduleDao.queryById(bean.getModuleId());
        PushAuthorityBean pushAuthorityBean = new PushAuthorityBean();
        pushAuthorityBean.setModuleId(bean.getModuleId());
        pushAuthorityBean.setModuleName(module.getName());
        pushAuthorityBean.setFjName(fj.getName());
        FjjgPushBean pushBean = new FjjgPushBean("4", Util.toJsonStr((Object)pushAuthorityBean));
        this.fjjgPnPushService.push(list.get(0).getMjId(), 1, pushBean);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void doApplyInput(InputApplyBean bean) throws Exception {
        InputApplyBean queryBean = new InputApplyBean();
        BeanUtils.copyProperties((Object)bean, (Object)queryBean);
        queryBean.setState("0");
        List<InputApply> list = this.inputApplyDao.query(queryBean, null);
        if (CollectionUtils.isEmpty(list) || list.size() != 1) {
            log.error("\u67e5\u8be2\u5f85\u5ba1\u6838\u9ad8\u7ea7\u6743\u9650\u6570\u636e\u5f02\u5e38:" + Util.toJsonStr((Object)bean));
            throw new Exception("\u6570\u636e\u5f02\u5e38");
        }
        InputApply inputApply = list.get(0);
        inputApply.setState(bean.getState());
        inputApply.setUpdateTime(System.currentTimeMillis());
        this.inputApplyDao.update(inputApply);
        ModulePowerBean queryPowerBean = new ModulePowerBean();
        queryPowerBean.setFjId(bean.getFjId());
        queryPowerBean.setModuleId(bean.getModuleId());
        List<ModulePower> powerList = this.modulePowerDao.query(queryPowerBean, null);
        if (CollectionUtils.isEmpty(powerList) || powerList.size() != 1) {
            log.error("\u67e5\u8be2\u5f85\u5ba1\u6838\u9ad8\u7ea7\u6743\u9650\u6a21\u5757\u6570\u636e\u5f02\u5e38:" + Util.toJsonStr((Object)queryPowerBean));
            throw new Exception("\u6570\u636e\u5f02\u5e38");
        }
        ModulePower modulePower = powerList.get(0);
        if (!"2".equals(bean.getState())) {
            modulePower.setInputNum(modulePower.getInputNum() + Integer.parseInt(bean.getState()));
            this.modulePowerDao.update(modulePower);
        }
        Person fj = this.userManageService.queryPersonById(inputApply.getFjId());
        Module module = this.moduleDao.queryById(inputApply.getModuleId());
        PushAuthorityBean pushAuthorityBean = new PushAuthorityBean();
        pushAuthorityBean.setModuleId(bean.getModuleId());
        pushAuthorityBean.setModuleName(module.getName());
        pushAuthorityBean.setFjName(fj.getName());
        pushAuthorityBean.setValue(bean.getState());
        FjjgPushBean pushBean = new FjjgPushBean("1", Util.toJsonStr((Object)pushAuthorityBean));
        this.fjjgPnPushService.push(inputApply.getFjId(), 2, pushBean);
    }

    public static void main(String[] args) {
        PushAuthorityBean pushAuthorityBean = new PushAuthorityBean();
        pushAuthorityBean.setModuleId("xxxxxxsssssssssssss");
        pushAuthorityBean.setModuleName("\u673a\u52a8\u8f66\u67e5\u8be2");
        pushAuthorityBean.setFjName("\u8f85\u8b66\u540d\u79f0");
        pushAuthorityBean.setValue("20");
        FjjgPushBean pushBean = new FjjgPushBean("1", Util.toJsonStr((Object)pushAuthorityBean));
        System.out.println(Util.toJsonStr((Object)pushBean));
    }
}

