/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.fjjg.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import pams.function.zhengzhou.fjjg.bean.InputApplyBean;
import pams.function.zhengzhou.fjjg.bean.ModuleBean;
import pams.function.zhengzhou.fjjg.bean.ModulePowerBean;
import pams.function.zhengzhou.fjjg.dao.InputApplyDao;
import pams.function.zhengzhou.fjjg.dao.ModuleDao;
import pams.function.zhengzhou.fjjg.dao.ModulePowerDao;
import pams.function.zhengzhou.fjjg.entity.Module;
import pams.function.zhengzhou.fjjg.entity.ModulePower;
import pams.function.zhengzhou.fjjg.mobile.bean.ModuleAuthBean;
import pams.function.zhengzhou.fjjg.service.ModulePowerService;

@Service
public class ModulePowerServiceImpl
implements ModulePowerService {
    @Autowired
    private ModuleDao moduleDao;
    @Autowired
    private ModulePowerDao modulePowerDao;
    @Autowired
    private InputApplyDao inputApplyDao;

    @Override
    public void initModulePower(List<String> fjIds) {
        ModuleBean bean = new ModuleBean();
        bean.setState("0");
        List<Module> modules = this.moduleDao.queryList(bean);
        if (CollectionUtils.isEmpty(fjIds) || CollectionUtils.isEmpty(modules)) {
            return;
        }
        ModulePower power = null;
        for (String fjId : fjIds) {
            for (Module module : modules) {
                power = new ModulePower();
                power.setModuleId(module.getId());
                power.setFjId(fjId);
                power.setInputNum(0);
                this.modulePowerDao.add(power);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void authModule(ModuleAuthBean bean) throws Exception {
        ModulePowerBean queryBean = new ModulePowerBean();
        queryBean.setFjId(bean.getFjId());
        List<ModulePower> list = this.modulePowerDao.query(queryBean, null);
        ArrayList<String> modules = new ArrayList<String>();
        for (ModulePower power : list) {
            modules.add(power.getModuleId());
        }
        List<String> requestModules = bean.getModuleIds();
        ArrayList<String> addModuleList = new ArrayList<String>(requestModules);
        addModuleList.removeAll(modules);
        ArrayList<String> removeModuleList = new ArrayList<String>(modules);
        removeModuleList.removeAll(requestModules);
        this.addModule(bean.getFjId(), addModuleList);
        this.removeModule(bean.getFjId(), removeModuleList);
    }

    private void addModule(String fjId, List<String> addModuleList) {
        if (CollectionUtils.isEmpty(addModuleList)) {
            return;
        }
        ModulePower power = null;
        for (String moduleId : addModuleList) {
            power = new ModulePower();
            power.setFjId(fjId);
            power.setModuleId(moduleId);
            power.setInputNum(0);
            this.modulePowerDao.add(power);
        }
    }

    private void removeModule(String fjId, List<String> removeModuleList) {
        if (CollectionUtils.isEmpty(removeModuleList)) {
            return;
        }
        ModulePowerBean bean = new ModulePowerBean();
        bean.setFjId(fjId);
        InputApplyBean applyBean = new InputApplyBean();
        applyBean.setFjId(fjId);
        applyBean.setState("0");
        for (String moduleId : removeModuleList) {
            bean.setModuleId(moduleId);
            applyBean.setModuleId(moduleId);
            this.inputApplyDao.remove(applyBean);
            this.modulePowerDao.remove(bean);
        }
    }
}

