/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.illegalinfo.control;

import com.xdja.pams.common.data.RequestData;
import com.xdja.pams.common.data.RequestDataMap;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.RequestParserUtils;
import com.xdja.pams.common.util.Response;
import com.xdja.pams.http.RequestApi;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.zhengzhou.common.control.BaseController;
import pams.function.zhengzhou.illegalinfo.bean.ForceBean;
import pams.function.zhengzhou.illegalinfo.bean.ForceExtendBean;
import pams.function.zhengzhou.illegalinfo.bean.QueryBean;
import pams.function.zhengzhou.illegalinfo.service.ForceService;
import pams.function.zhengzhou.trafficpolice.entity.DepInfoEntity;
import pams.function.zhengzhou.trafficpolice.service.TrafficPoliceDepService;
import pams.function.zhengzhou.util.Tools;

@Controller
@Scope(value="session")
public class ForceController
extends BaseController {
    private static final Logger LOG = LoggerFactory.getLogger(ForceController.class);
    @Autowired
    private ForceService forceService;
    @Autowired
    private TrafficPoliceDepService depService;

    @RequestMapping(value={"force/query.do"})
    public void initNum(HttpServletRequest request, HttpServletResponse response) {
        LOG.info("\u67e5\u8be2\u5f3a\u5236\u63aa\u65bd\u8fdd\u6cd5");
        try {
            String parameters = RequestApi.getParameters((HttpServletRequest)request);
            LOG.info("param:   " + parameters);
            RequestData requestData = RequestParserUtils.fromJson((String)parameters, QueryBean.class);
            QueryBean queryBean = (QueryBean)requestData.getDataObject().getRows();
            String depcode = queryBean.getControlDep();
            depcode = Tools.getDepLevel(depcode);
            List<DepInfoEntity> deplist = this.depService.findByJwtCode(depcode, null);
            if (deplist != null && deplist.size() > 0) {
                depcode = deplist.get(0).getCode();
                if ((depcode = Tools.getDepLevel(depcode)).length() > 6) {
                    depcode = depcode.substring(0, 6);
                }
            }
            queryBean.setControlDep(depcode);
            if (StringUtils.isBlank((CharSequence)queryBean.getState())) {
                queryBean.setState("0");
            }
            Page page = requestData.getPage();
            List<ForceBean> list = this.forceService.queryListByBean(queryBean, page);
            this.result(response, Response.successData(list, (Page)page));
        }
        catch (Exception e) {
            LOG.error("\u67e5\u8be2\u5f3a\u5236\u63aa\u65bd\u8fdd\u6cd5\u51fa\u9519", (Throwable)e);
            this.fail(response);
        }
    }

    @RequestMapping(value={"force/toApprove.do"})
    public void toApprove(HttpServletRequest request, HttpServletResponse response) {
        LOG.info("\u67e5\u8be2\u5f3a\u5236\u63aa\u65bd\u8fdd\u6cd5\u8be6\u7ec6\u4fe1\u606f");
        try {
            String parameters = RequestApi.getParameters((HttpServletRequest)request);
            LOG.info("param:   " + parameters);
            RequestDataMap requestMap = RequestParserUtils.fromJsonToMap((String)parameters);
            ForceBean forceBean = this.forceService.queryById(requestMap.get("id"));
            ForceExtendBean forceExtendBean = this.forceService.translateForceBean(forceBean);
            this.result(response, Response.successData((Object)forceExtendBean));
        }
        catch (Exception e) {
            LOG.error("\u67e5\u8be2\u5f3a\u5236\u63aa\u65bd\u8fdd\u6cd5\u8be6\u7ec6\u4fe1\u606f\u51fa\u9519", (Throwable)e);
            this.fail(response);
        }
    }

    @RequestMapping(value={"force/approvePass.do"})
    public void approvePass(HttpServletRequest request, HttpServletResponse response) {
        LOG.info("\u5f3a\u5236\u63aa\u65bd\u5ba1\u6279\u901a\u8fc7");
        try {
            String parameters = RequestApi.getParameters((HttpServletRequest)request);
            LOG.info("param:   " + parameters);
            RequestData requestData = RequestParserUtils.fromJson((String)parameters, ForceBean.class);
            Response responseData = this.forceService.approvePass((ForceBean)requestData.getDataObject().getRows());
            this.result(response, responseData);
        }
        catch (Exception e) {
            LOG.error("\u5f3a\u5236\u63aa\u65bd\u5ba1\u6279\u901a\u8fc7\u51fa\u9519", (Throwable)e);
            this.fail(response);
        }
    }

    @RequestMapping(value={"force/approveNotPass.do"})
    public void approveNotPass(HttpServletRequest request, HttpServletResponse response) {
        LOG.info("\u5f3a\u5236\u63aa\u65bd\u5ba1\u6279\u4e0d\u901a\u8fc7");
        try {
            String parameters = RequestApi.getParameters((HttpServletRequest)request);
            LOG.info("param:   " + parameters);
            RequestData requestData = RequestParserUtils.fromJson((String)parameters, ForceBean.class);
            Response responseData = this.forceService.approveNotPass((ForceBean)requestData.getDataObject().getRows());
            this.result(response, responseData);
        }
        catch (Exception e) {
            LOG.error("\u5f3a\u5236\u63aa\u65bd\u5ba1\u6279\u4e0d\u901a\u8fc7\u51fa\u9519", (Throwable)e);
            this.fail(response);
        }
    }
}

