/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.illegalinfo.control;

import com.xdja.pams.common.data.RequestData;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.RequestParserUtils;
import com.xdja.pams.common.util.Response;
import com.xdja.pams.http.RequestApi;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.zhengzhou.common.control.BaseController;
import pams.function.zhengzhou.illegalinfo.bean.QueryBean;
import pams.function.zhengzhou.illegalinfo.bean.SurveilBean;
import pams.function.zhengzhou.illegalinfo.bean.SurveilExtendBean;
import pams.function.zhengzhou.illegalinfo.service.SurveilService;
import pams.function.zhengzhou.trafficpolice.entity.DepInfoEntity;
import pams.function.zhengzhou.trafficpolice.service.TrafficPoliceDepService;
import pams.function.zhengzhou.util.Tools;

@Controller
@Scope(value="session")
public class SurveilController
extends BaseController {
    private static final Logger LOG = LoggerFactory.getLogger(SurveilController.class);
    @Autowired
    private SurveilService surveilService;
    @Autowired
    private TrafficPoliceDepService depService;

    @RequestMapping(value={"surveil/query.do"})
    public void initNum(HttpServletRequest request, QueryBean queryBean, String page, String rows, HttpServletResponse response) {
        LOG.info("\u67e5\u8be2\u8fdd\u7ae0\u505c\u8f66");
        try {
            String depcode = queryBean.getControlDep();
            depcode = Tools.getDepLevel(depcode);
            List<DepInfoEntity> deplist = this.depService.findByJwtCode(depcode, null);
            if (deplist != null && deplist.size() > 0) {
                depcode = deplist.get(0).getCode();
                if ((depcode = Tools.getDepLevel(depcode)).length() > 6) {
                    depcode = depcode.substring(0, 6);
                }
            }
            queryBean.setControlDep(depcode);
            if (StringUtils.isBlank((CharSequence)queryBean.getState())) {
                queryBean.setState("0");
            }
            Page page1 = new Page(page, rows);
            List<SurveilBean> list = this.surveilService.queryListByBean(queryBean, page1);
            this.result(response, Response.successData(list, (Page)page1));
        }
        catch (Exception e) {
            LOG.error("\u67e5\u8be2\u8fdd\u7ae0\u505c\u8f66\u51fa\u9519", (Throwable)e);
            this.fail(response);
        }
    }

    @RequestMapping(value={"surveil/toApprove.do"})
    public String toApprove(HttpServletRequest request, String id, ModelMap map, HttpServletResponse response) {
        LOG.info("\u67e5\u8be2\u8fdd\u7ae0\u505c\u8f66\u8be6\u7ec6\u4fe1\u606f");
        try {
            SurveilBean surveilBean = this.surveilService.queryById(id);
            SurveilExtendBean surveilExtendBean = this.surveilService.translateSurveilBean(surveilBean);
            map.put((Object)"surveilBean", (Object)surveilExtendBean);
        }
        catch (Exception e) {
            LOG.error("\u67e5\u8be2\u8fdd\u7ae0\u505c\u8f66\u8be6\u7ec6\u4fe1\u606f\u51fa\u9519", (Throwable)e);
        }
        return "illegalInfo/surveil/default/approve";
    }

    @RequestMapping(value={"surveil/approvePass.do"})
    public void approvePass(HttpServletRequest request, SurveilBean surveilBean, HttpServletResponse response) {
        LOG.info("\u8fdd\u7ae0\u505c\u8f66\u8be6\u7ec6\u4fe1\u606f\u5ba1\u6279\u901a\u8fc7");
        try {
            Response responseData = this.surveilService.approvePass(surveilBean);
            this.result(response, responseData);
        }
        catch (Exception e) {
            LOG.error("\u8fdd\u7ae0\u505c\u8f66\u8be6\u7ec6\u4fe1\u606f\u5ba1\u6279\u901a\u8fc7\u51fa\u9519", (Throwable)e);
            this.fail(response);
        }
    }

    @RequestMapping(value={"surveil/approveNotPass.do"})
    public void approveNotPass(HttpServletRequest request, SurveilBean surveilBean, HttpServletResponse response) {
        LOG.info("\u8fdd\u7ae0\u505c\u8f66\u8be6\u7ec6\u4fe1\u606f\u5ba1\u6279\u4e0d\u901a\u8fc7");
        try {
            Response responseData = this.surveilService.approveNotPass(surveilBean);
            this.result(response, responseData);
        }
        catch (Exception e) {
            LOG.error("\u8fdd\u7ae0\u505c\u8f66\u8be6\u7ec6\u4fe1\u606f\u5ba1\u6279\u4e0d\u901a\u8fc7\u51fa\u9519", (Throwable)e);
            this.fail(response);
        }
    }

    @RequestMapping(value={"surveil/approvePass2.do"})
    public void approvePass2(HttpServletRequest request, HttpServletResponse response) {
        LOG.info("\u8fdd\u7ae0\u505c\u8f66\u8be6\u7ec6\u4fe1\u606f\u5ba1\u6279\u901a\u8fc7");
        try {
            Response responseData = Response.failData(null);
            String parameters = RequestApi.getParameters((HttpServletRequest)request);
            LOG.info("param:   " + parameters);
            RequestData requestData = RequestParserUtils.fromJson((String)parameters, SurveilBean.class);
            SurveilBean surveilBean = (SurveilBean)requestData.getDataObject().getRows();
            boolean success = this.surveilService.updateVioSurveil(surveilBean.getId(), surveilBean.getZqmj(), surveilBean.getTzsh());
            if (success) {
                responseData = this.surveilService.approvePass((SurveilBean)requestData.getDataObject().getRows());
            }
            this.result(response, responseData);
        }
        catch (Exception e) {
            LOG.error("\u8fdd\u7ae0\u505c\u8f66\u8be6\u7ec6\u4fe1\u606f\u5ba1\u6279\u901a\u8fc7\u51fa\u9519", (Throwable)e);
            this.fail(response);
        }
    }

    @RequestMapping(value={"surveil/approveNotPass2.do"})
    public void approveNotPass2(HttpServletRequest request, HttpServletResponse response) {
        LOG.info("\u8fdd\u7ae0\u505c\u8f66\u8be6\u7ec6\u4fe1\u606f\u5ba1\u6279\u4e0d\u901a\u8fc7");
        try {
            Response responseData = Response.failData(null);
            String parameters = RequestApi.getParameters((HttpServletRequest)request);
            LOG.info("param:   " + parameters);
            RequestData requestData = RequestParserUtils.fromJson((String)parameters, SurveilBean.class);
            SurveilBean surveilBean = (SurveilBean)requestData.getDataObject().getRows();
            boolean success = this.surveilService.updateVioSurveil(surveilBean.getId(), surveilBean.getZqmj(), surveilBean.getTzsh());
            if (success) {
                responseData = this.surveilService.approveNotPass(surveilBean);
            }
            this.result(response, responseData);
        }
        catch (Exception e) {
            LOG.error("\u8fdd\u7ae0\u505c\u8f66\u8be6\u7ec6\u4fe1\u606f\u5ba1\u6279\u4e0d\u901a\u8fc7\u51fa\u9519", (Throwable)e);
            this.fail(response);
        }
    }
}

