/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.illegalinfo.service.impl;

import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Response;
import com.xdja.pams.syms.service.CommonCodeService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.zhengzhou.common.dao.BaseDao;
import pams.function.zhengzhou.common.service.impl.BaseServiceImpl;
import pams.function.zhengzhou.illegalinfo.bean.ForceBean;
import pams.function.zhengzhou.illegalinfo.bean.ForceExtendBean;
import pams.function.zhengzhou.illegalinfo.bean.QueryBean;
import pams.function.zhengzhou.illegalinfo.dao.ForceDao;
import pams.function.zhengzhou.illegalinfo.service.ForceService;
import pams.function.zhengzhou.illegalinfo.service.IllegalInfoDrsService;
import pams.function.zhengzhou.trafficpolice.dao.FdbhDao;
import pams.function.zhengzhou.util.BeanTranslateUtils;
import pams.function.zhengzhou.util.DataWebserviceClient;
import pams.function.zhengzhou.util.Tools;
import pams.function.zhengzhou.util.TranslateColumn;
import xdja.hxd.wsrpc.client.wsrpcClient_new;

@Service(value="forceService")
public class ForceServiceImpl
extends BaseServiceImpl
implements ForceService {
    private static final Logger log = LoggerFactory.getLogger(ForceServiceImpl.class);
    @Autowired
    private ForceDao forceDao;
    @Autowired
    private CommonCodeService codeService;
    @Autowired
    private FdbhDao fdbhDao;
    @Autowired
    private UserManageService personService;
    @Autowired
    private IllegalInfoDrsService illegalInfoDrsService;
    private boolean isWS = false;

    @Override
    public BaseDao getDao() {
        return this.forceDao;
    }

    @Override
    public List<ForceBean> queryListByBean(QueryBean queryBean, Page page) {
        if (StringUtils.isNotBlank((CharSequence)queryBean.getBeginTime())) {
            String beginTime = queryBean.getBeginTime() + " 00:00:00";
            queryBean.setBeginTime(beginTime);
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getEndTime())) {
            String endTime = queryBean.getEndTime() + " 23:59:59";
            queryBean.setEndTime(endTime);
        }
        if (this.isWS) {
            return this.queryWS(queryBean, page);
        }
        List<ForceBean> list = this.illegalInfoDrsService.queryForceList(queryBean, page);
        if (list != null && !list.isEmpty()) {
            ArrayList<String> personCodes = new ArrayList<String>();
            for (ForceBean bean : list) {
                personCodes.add(bean.getZqmj());
            }
            String[] codes = new String[personCodes.size()];
            Map personCodeNameMap = this.personService.queryPersonName(personCodes.toArray(codes));
            Map stateMap = this.codeService.getCodeMap("ILLEGAL_INFO_STATE");
            Map hpzlMap = this.codeService.getCodeMap("hpzl");
            for (ForceBean bean : list) {
                bean.setZqmjName((String)personCodeNameMap.get(bean.getZqmj()));
                bean.setStateVal(Tools.getNameOfCode(stateMap, bean.getState()));
                bean.setHpzlVal(Tools.getNameOfCode(hpzlMap, bean.getHpzl()));
            }
        }
        return list;
    }

    public List<ForceBean> queryWS(QueryBean queryBean, Page page) {
        StringBuilder selectSql = new StringBuilder(" 1=1 ");
        if (StringUtils.isNotBlank((CharSequence)queryBean.getHpzl())) {
            selectSql.append("c_hpzl='" + queryBean.getHpzl() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getHphm())) {
            selectSql.append("and c_hphm='" + queryBean.getHphm() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getBeginTime())) {
            selectSql.append("and d_wfsj>='" + queryBean.getBeginTime() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getEndTime())) {
            selectSql.append("and d_wfsj<='" + queryBean.getEndTime() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getState())) {
            selectSql.append("and c_zt='" + queryBean.getState() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getZqmj())) {
            selectSql.append("and c_zqmj='" + queryBean.getZqmj() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getClzl())) {
            selectSql.append("and c_flag='" + queryBean.getClzl() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getControlDep())) {
            selectSql.append("and c_pzbh like '" + queryBean.getControlDep() + "%' ");
        }
        selectSql.append(" order by spzt asc,wfsj desc ");
        wsrpcClient_new wsc = DataWebserviceClient.getWC();
        wsc.setquerytable("t_vio_force");
        wsc.setquerycolumns("*");
        log.info("\u67e5\u8be2\u6761\u4ef6\uff1a" + selectSql.toString());
        wsc.setquerycondition(selectSql.toString());
        wsc.setrowstart(Integer.valueOf((page.getPage() - 1) * page.getRp() + 1));
        wsc.setrowlen(Integer.valueOf(page.getRp()));
        String xml = "";
        ArrayList<ForceBean> dataList = new ArrayList<ForceBean>();
        int intTotal = 0;
        if (wsc.executeQuery()) {
            log.debug("wsrpcclient \u8fd4\u56de\u7684\u7ed3\u679c\uff1a" + wsc.getResultXML());
            String rstxml = wsc.getResultXML();
            intTotal = Tools.getXMLCount(wsc.getResultXML());
            wsc.beforefirst();
            while (wsc.next()) {
                ForceBean forceBean = new ForceBean();
                forceBean.setPzbh(wsc.getitemstring("c_pzbh"));
                forceBean.setHpzl(wsc.getitemstring("c_hpzl"));
                forceBean.setHphm(wsc.getitemstring("c_hphm"));
                forceBean.setWfsj(wsc.getitemstring("d_wfsj"));
                forceBean.setWfdz(wsc.getitemstring("c_wfdz"));
                forceBean.setZqmj(wsc.getitemstring("c_zqmj"));
                forceBean.setState(wsc.getitemstring("c_zt"));
                dataList.add(forceBean);
            }
        }
        page.setTotal(intTotal);
        return dataList;
    }

    @Override
    public ForceBean queryById(String id) {
        ForceBean forceBean = null;
        id = Tools.decodeStr(id);
        if (this.isWS) {
            forceBean = this.queryWSById(id);
        } else {
            forceBean = this.illegalInfoDrsService.queryForceById(id);
            Map hpzlMap = this.codeService.getCodeMap("hpzl");
            forceBean.setHpzlVal(Tools.getNameOfCode(hpzlMap, forceBean.getHpzl()));
        }
        if (forceBean != null) {
            Map personCodeNameMap = this.personService.queryPersonName(new String[]{forceBean.getZqmj()});
            forceBean.setZqmjName((String)personCodeNameMap.get(forceBean.getZqmj()));
        }
        return forceBean;
    }

    public ForceBean queryWSById(String id) {
        ForceBean force = new ForceBean();
        wsrpcClient_new wsc = DataWebserviceClient.getWC();
        wsc.setquerytable("t_vio_force");
        wsc.setquerycolumns("*");
        log.info("\u67e5\u8be2\u6761\u4ef6\uff1ac_pzbh='" + id + "' ");
        wsc.setquerycondition("c_pzbh='" + id + "' ");
        wsc.executeQuery();
        log.debug("wsrpcclient \u8fd4\u56de\u7684\u7ed3\u679c\uff1a" + wsc.getResultXML());
        if (wsc.getrownum() > 0) {
            force.setHpzl(wsc.getitemstring("c_hpzl"));
            force.setHphm(wsc.getitemstring("c_hphm"));
            force.setClfl(wsc.getitemstring("c_clfl"));
            force.setJdcsyr(wsc.getitemstring("c_jdcsyr"));
            force.setZsxzqh(wsc.getitemstring("c_zsxzqh"));
            force.setZsxxdz(wsc.getitemstring("c_zsxxdz"));
            force.setSyxz(wsc.getitemstring("c_syxz"));
            force.setWfsj(wsc.getitemstring("d_wfsj"));
            force.setXzqh(wsc.getitemstring("c_xzqh"));
            force.setWfdd(wsc.getitemstring("c_wfdd"));
            force.setLddm(wsc.getitemstring("c_lddm"));
            force.setDdms(wsc.getitemstring("c_ddms"));
            force.setWfdz(wsc.getitemstring("c_wfdz"));
            String wfxw1 = wsc.getitemrealstring("c_wfxw1");
            String wfxw2 = wsc.getitemrealstring("c_wfxw2");
            String wfxw3 = wsc.getitemrealstring("c_wfxw3");
            String wfxw4 = wsc.getitemrealstring("c_wfxw4");
            String wfxw5 = wsc.getitemrealstring("c_wfxw5");
            String wfxwnr1 = wsc.getitemstring("c_wfxw1");
            String wfxwnr2 = wsc.getitemstring("c_wfxw2");
            String wfxwnr3 = wsc.getitemstring("c_wfxw3");
            String wfxwnr4 = wsc.getitemstring("c_wfxw4");
            String wfxwnr5 = wsc.getitemstring("c_wfxw5");
            String wfxw = "";
            String wfxwnr = "";
            if (StringUtils.isNotBlank((CharSequence)wfxw1)) {
                wfxw = wfxw + " " + wfxw1;
                wfxwnr = wfxwnr + " " + wfxwnr1;
            }
            if (StringUtils.isNotBlank((CharSequence)wfxw2)) {
                wfxw = wfxw + " " + wfxw2;
                wfxwnr = wfxwnr + " " + wfxwnr2;
            }
            if (StringUtils.isNotBlank((CharSequence)wfxw3)) {
                wfxw = wfxw + " " + wfxw3;
                wfxwnr = wfxwnr + " " + wfxwnr3;
            }
            if (StringUtils.isNotBlank((CharSequence)wfxw4)) {
                wfxw = wfxw + " " + wfxw4;
                wfxwnr = wfxwnr + " " + wfxwnr4;
            }
            if (StringUtils.isNotBlank((CharSequence)wfxw5)) {
                wfxw = wfxw + " " + wfxw5;
                wfxwnr = wfxwnr + " " + wfxwnr5;
            }
            force.setWfdm(wsc.getitemrealstring("c_wfxw"));
            force.setWfnr(wsc.getitemstring("c_wfxw"));
            force.setZqmj(wsc.getitemstring("c_zqmj"));
            force.setState(wsc.getitemstring("c_zt"));
            force.setPzbh(wsc.getitemstring("c_pzbh"));
            force.setSgdj(wsc.getitemstring("c_sgdj"));
            force.setJsjqbj(wsc.getitemstring("c_jsjqbj"));
            force.setBz(wsc.getitemstring("c_bz"));
            force.setZjhm(wsc.getitemstring("c_jszh"));
            force.setDabh(wsc.getitemstring("c_dabh"));
            force.setQzcslx(wsc.getitemstring("c_qzcslx"));
            force.setDsryy(wsc.getitemstring("c_dsryy"));
            force.setMjyj(wsc.getitemstring("c_mjyj"));
            force.setWslb(wsc.getitemstring("c_wslb"));
            force.setRyfl(wsc.getitemstring("c_ryfl"));
            force.setJszh(wsc.getitemstring("c_jszh"));
            force.setZjcx(wsc.getitemstring("c_zjcx"));
            force.setJtfs(wsc.getitemstring("c_jtfs"));
            force.setXzqh(wsc.getitemstring("c_xzqh"));
            force.setWfxw1(wfxw1);
            force.setFxjg(wsc.getitemstring("c_fxjg"));
            String fzjg = wsc.getitemstring("c_fzjg");
            if (StringUtils.isBlank((CharSequence)fzjg)) {
                fzjg = wsc.getitemstring("c_hphm").substring(0, 2);
            }
            force.setFzjg(fzjg);
            ArrayList<String> wfxwList = new ArrayList<String>();
            for (int i = 1; i <= 5; ++i) {
                if (!StringUtils.isNotBlank((CharSequence)wsc.getitemstring("wfxw" + i))) continue;
                wfxwList.add(wsc.getitemstring("wfxw" + i));
            }
            force.setWfxwList(wfxwList);
        }
        return force;
    }

    @Override
    public Response approvePass(ForceBean forceBean) {
        String id = forceBean.getPzbh();
        log.debug("ID\u662f\uff1a " + id);
        forceBean = this.queryById(id);
        if (forceBean == null) {
            log.error("\u6839\u636e\u5f3a\u5236\u63aa\u65bd\u51ed\u8bc1\u7f16\u53f7:" + id + "\u5728\u4e2d\u95f4\u5e93\u627e\u4e0d\u5230\u7f5a\u5355\u4fe1\u606f");
            return Response.failData(null);
        }
        if (!"0".equals(forceBean.getState())) {
            log.error("\u6839\u636e\u5f3a\u5236\u63aa\u65bd\u51ed\u8bc1\u7f16\u53f7:" + id + "\u5728\u4e2d\u95f4\u5e93\u627e\u5230\u7684\u7f5a\u5355\u72b6\u6001\u4e0d\u662f\u672a\u5ba1\u6279\uff01");
            return Response.failData(null);
        }
        boolean isTSFD = this.tscl(forceBean);
        log.debug("isTSFD=" + isTSFD);
        if (!isTSFD) {
            log.error("\u6839\u636e\u5f3a\u5236\u63aa\u65bd\u51ed\u8bc1\u7f16\u53f7:" + id + "\u662f\u7279\u6b8a\u8f66\u8f86\u7684\u7f5a\u5355");
            return Response.failData(null);
        }
        Map<String, String> forceMap = this.buildForceMap(forceBean);
        boolean isSucc = this.illegalInfoDrsService.uploadSixInOne(forceMap, "t_vio_force_write");
        log.debug("isSucc=" + isSucc);
        if (isSucc) {
            if (this.illegalInfoDrsService.changeForceState(id, "1")) {
                return Response.successData(null);
            }
            return Response.failData(null);
        }
        return Response.failData(null);
    }

    private boolean tscl(ForceBean forceBean) {
        log.debug("\u8fdb\u5165tscl\u65b9\u6cd5");
        log.debug("pzbh=\uff1a " + forceBean.getPzbh());
        String hphm = forceBean.getHphm();
        String hpzl = forceBean.getHpzl();
        int num = this.fdbhDao.queryTscl(hphm, hpzl);
        log.debug("num=\uff1a " + num);
        if (num == 0) {
            return true;
        }
        this.cltscl(forceBean.getPzbh());
        return false;
    }

    private Map<String, String> buildForceMap(ForceBean forceBean) {
        log.debug("\u8fdb\u5165buildForceMap\u65b9\u6cd5");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("c_pzbh", forceBean.getPzbh());
        map.put("c_wslb", forceBean.getWslb());
        map.put("c_qzcslx", forceBean.getQzcslx());
        map.put("c_ryfl", forceBean.getRyfl());
        map.put("c_jszh", forceBean.getJszh());
        map.put("c_dabh", forceBean.getDabh());
        map.put("c_fzjg", forceBean.getFzjg());
        map.put("c_zjcx", forceBean.getZjcx());
        map.put("c_clfl", forceBean.getClfl());
        map.put("c_hpzl", forceBean.getHpzl());
        map.put("c_hphm", forceBean.getHphm());
        map.put("c_jtfs", forceBean.getJtfs());
        map.put("d_wfsj", forceBean.getWfsj());
        map.put("c_xzqh", forceBean.getXzqh());
        map.put("c_wfdd", forceBean.getWfdd());
        map.put("c_ddms", forceBean.getDdms());
        map.put("c_lddm", forceBean.getLddm());
        map.put("c_wfdz", forceBean.getWfdz());
        map.put("c_wfxw1", forceBean.getWfxw1());
        map.put("c_fxjg", forceBean.getFxjg());
        map.put("c_zqmj", forceBean.getZqmj());
        map.put("c_jsjqbj", forceBean.getJsjqbj());
        map.put("c_sgdj", forceBean.getSgdj());
        map.put("c_mjyj", forceBean.getMjyj());
        map.put("c_dsr", forceBean.getDsryy());
        map.put("c_bz", forceBean.getBz());
        map.put("c_clpp", forceBean.getClpp());
        map.put("c_csys", forceBean.getCsys());
        map.put("c_jdcsyr", forceBean.getJdcsyr());
        map.put("c_zsxxdz", forceBean.getZsxxdz());
        map.put("c_zsxzqh", forceBean.getZsxzqh());
        map.put("c_clsbdh", forceBean.getClsbdh());
        map.put("c_fdjh", forceBean.getFdjh());
        map.put("c_syxz", forceBean.getSyxz());
        map.put("c_xzqh", forceBean.getXzqh());
        map.put("c_jsjqbj", forceBean.getJsjqbj());
        map.put("c_sgdj", forceBean.getSgdj());
        return map;
    }

    public boolean uploadInfo(String id) {
        try {
            wsrpcClient_new wsc = DataWebserviceClient.getWC();
            wsc.setquerytable("t_vio_force");
            wsc.setquerycolumns("*");
            log.debug("\u67e5\u8be2\u6761\u4ef6\uff1ac_pzbh='" + id + "' and c_zt='" + "0" + "'");
            wsc.setquerycondition("c_pzbh='" + id + "' and c_zt='" + "0" + "'");
            wsc.executeQuery();
            log.debug("wsrpcclient \u8fd4\u56de\u7684\u7ed3\u679c\uff1a" + wsc.getResultXML());
            String xml = "";
            if (wsc.getrownum() > 0) {
                String hpzl;
                String hphm = wsc.getitemstring("c_hphm");
                if (this.fdbhDao.queryTscl(hphm, hpzl = wsc.getitemrealstring("c_hpzl")) > 0) {
                    return this.cltscl(id);
                }
            } else {
                return false;
            }
            xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Root><Version>20071115</Version><ReqType>wzlrfxc</ReqType><SessionID>3000009066</SessionID><TransactionType>1</TransactionType><Tables><Table><Name>t_vio_force_write</Name><IsMain>1</IsMain><Row><Operate>insert</Operate><Data><c_pzbh>" + wsc.getitemstring("c_pzbh") + "</c_pzbh>" + "<c_wslb>" + wsc.getitemrealstring("c_wslb") + "</c_wslb>" + "<c_qzcslx>" + wsc.getitemrealstring("c_qzcslx") + "</c_qzcslx>" + "<c_ryfl>" + wsc.getitemrealstring("c_ryfl") + "</c_ryfl>" + "<c_jszh>" + wsc.getitemstring("c_jszh") + "</c_jszh>" + "<c_dabh>" + wsc.getitemstring("c_dabh") + "</c_dabh>" + "<c_fzjg>" + wsc.getitemstring("c_fzjg") + "</c_fzjg>" + "<c_zjcx>" + wsc.getitemrealstring("c_zjcx") + "</c_zjcx>" + "<c_dsr>" + wsc.getitemstring("c_dsr") + "</c_dsr>" + "<c_clfl>" + wsc.getitemrealstring("c_clfl") + "</c_clfl>" + "<c_hpzl>" + wsc.getitemrealstring("c_hpzl") + "</c_hpzl>" + "<c_hphm>" + wsc.getitemstring("c_hphm") + "</c_hphm>" + "<c_jtfs>" + wsc.getitemrealstring("c_jtfs") + "</c_jtfs>" + "<d_wfsj Type=\"date\" Format=\"yyyy-MM-dd HH:mm\">" + wsc.getitemstring("d_wfsj") + "</d_wfsj>" + "<c_xzqh>" + wsc.getitemrealstring("c_xzqh") + "</c_xzqh>" + "<c_wfdd>" + wsc.getitemstring("c_wfdd") + "</c_wfdd>" + "<c_lddm>" + wsc.getitemstring("c_lddm") + "</c_lddm>" + "<c_ddms>" + wsc.getitemstring("c_ddms") + "</c_ddms>" + "<c_wfdz>" + wsc.getitemstring("c_wfdz") + "</c_wfdz>" + "<c_wfxw1>" + wsc.getitemrealstring("c_wfxw1") + "</c_wfxw1>" + "<c_wfxw2>" + wsc.getitemrealstring("c_wfxw2") + "</c_wfxw2>" + "<c_wfxw3>" + wsc.getitemrealstring("c_wfxw3") + "</c_wfxw3>" + "<c_wfxw4>" + wsc.getitemrealstring("c_wfxw4") + "</c_wfxw4>" + "<c_wfxw5>" + wsc.getitemrealstring("c_wfxw5") + "</c_wfxw5>" + "<c_zqmj>" + wsc.getitemstring("c_zqmj") + "</c_zqmj>" + "<c_fxjg>" + wsc.getitemstring("c_fxjg") + "</c_fxjg>" + "<c_jsjqbj>" + wsc.getitemrealstring("c_jsjqbj") + "</c_jsjqbj>" + "<c_sgdj>" + wsc.getitemstring("c_sgdj") + "</c_sgdj>" + "<c_sjxm>" + wsc.getitemstring("c_sjxm") + "</c_sjxm>" + "<c_sjwpmc>" + wsc.getitemstring("c_sjwpmc") + "</c_sjwpmc>" + "<c_sjwpcfd>" + wsc.getitemstring("c_sjwpcfd") + "</c_sjwpcfd>" + "<c_dh>" + wsc.getitemstring("c_dh") + "</c_dh>" + "<c_mjyj>" + wsc.getitemstring("c_mjyj") + "</c_mjyj>" + "<c_dsryy>" + wsc.getitemstring("c_dsryy") + "</c_dsryy>" + "<c_bz>" + wsc.getitemstring("c_bz") + "</c_bz>" + "<c_klwpcfd>" + wsc.getitemstring("c_klwpcfd") + "</c_klwpcfd>";
            xml = xml + "<c_clpp>" + wsc.getitemstring("c_clpp") + "</c_clpp>" + "<c_csys>" + wsc.getitemrealstring("c_csys") + "</c_csys>" + "<c_jdcsyr>" + wsc.getitemstring("c_jdcsyr") + "</c_jdcsyr>" + "<c_dh>" + wsc.getitemstring("c_dh") + "</c_dh>" + "<c_zsxxdz>" + wsc.getitemstring("c_zsxxdz") + "</c_zsxxdz>" + "<c_zsxzqh>" + wsc.getitemrealstring("c_zsxzqh") + "</c_zsxzqh>" + "<c_clsbdh>" + wsc.getitemstring("c_clsbdh") + "</c_clsbdh>" + "<c_fdjh>" + wsc.getitemstring("c_fdjh") + "</c_fdjh>" + "<c_syxz>" + wsc.getitemrealstring("c_syxz") + "</c_syxz>";
            xml = xml + "</Data></Row></Table></Tables></Root>";
            log.debug("\u5408\u6210\u7684xml\u662f" + xml);
            if (wsc.executeUpdate(xml)) {
                return true;
            }
            log.info(wsc.getError());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean changeState(String infoId, String newState) {
        wsrpcClient_new wsc = DataWebserviceClient.getWC();
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Root><Version>20071115</Version><ReqType>wzlrfxc</ReqType><SessionID>3000009066</SessionID><TransactionType>1</TransactionType><Tables><Table><Name>t_vio_force</Name><IsMain>1</IsMain><Row><Operate>update</Operate><Data>";
        xml = xml + "<c_zt>" + newState + "</c_zt>";
        if (wsc.executeUpdate(xml = xml + "</Data><Condition><![CDATA[c_pzbh='" + infoId + "']]></Condition></Row></Table></Tables></Root>")) {
            return true;
        }
        wsc.getError();
        log.info(wsc.getError());
        return false;
    }

    public boolean cltscl(String id) {
        if (this.illegalInfoDrsService.deleteForce(id)) {
            this.fdbhDao.retrieveFDBH(id);
            return true;
        }
        return false;
    }

    public boolean delete(String infoId) {
        wsrpcClient_new wsc = DataWebserviceClient.getWC();
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Root><Version>20071115</Version><ReqType>wzlrfxc</ReqType><SessionID>3000009066</SessionID><TransactionType>1</TransactionType><Tables><Table><Name>t_vio_force</Name><IsMain>1</IsMain><Row><Operate>delete</Operate><Data>";
        if (wsc.executeUpdate(xml = xml + "</Data><Condition><![CDATA[c_pzbh='" + infoId + "']]></Condition></Row></Table></Tables></Root>")) {
            return true;
        }
        wsc.getError();
        log.info(wsc.getError());
        return false;
    }

    @Override
    public Response approveNotPass(ForceBean forceBean) {
        String id = forceBean.getPzbh();
        log.info("id=" + id);
        if (this.illegalInfoDrsService.changeForceState(id, "2")) {
            if (this.fdbhDao.retrieveFDBH(id) < 1) {
                this.illegalInfoDrsService.changeForceState(id, "0");
                return Response.failData(null);
            }
            return Response.successData(null);
        }
        return Response.failData(null);
    }

    @Override
    public ForceExtendBean translateForceBean(ForceBean forceBean) {
        Field[] fields;
        ForceExtendBean forceExtendBean = new ForceExtendBean();
        BeanUtils.copyProperties((Object)forceBean, (Object)forceExtendBean);
        forceExtendBean.setWfxwList(forceBean.getWfxwList());
        for (Field field : fields = ForceExtendBean.class.getDeclaredFields()) {
            Object object;
            if (field.getAnnotation(TranslateColumn.class) == null || !BeanTranslateUtils.getTranslateColumnIstranslate(field) || (object = BeanTranslateUtils.getter(forceExtendBean, field.getName())) == null) continue;
            String value = String.valueOf(object);
            String dictName = BeanTranslateUtils.getTranslateColumnDictName(field);
            Map dictMap = null;
            dictMap = this.codeService.getCodeMap(dictName);
            String translateValue = Tools.getNameOfCode(dictMap, value);
            translateValue = StringUtils.isBlank((CharSequence)translateValue) ? value : translateValue;
            String translateColumn = BeanTranslateUtils.getTranslateColumnName(field);
            BeanTranslateUtils.setter(forceExtendBean, translateColumn, translateValue, field.getType());
        }
        return forceExtendBean;
    }
}

