/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.illegalinfo.service.impl;

import com.xdja.pams.common.util.Page;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import pams.function.zhengzhou.drs.bean.DrsResult;
import pams.function.zhengzhou.drs.bean.Item;
import pams.function.zhengzhou.drs.util.DrsUtils;
import pams.function.zhengzhou.drs.util.DrsXml;
import pams.function.zhengzhou.illegalinfo.bean.ForceBean;
import pams.function.zhengzhou.illegalinfo.bean.QueryBean;
import pams.function.zhengzhou.illegalinfo.bean.SurveilBean;
import pams.function.zhengzhou.illegalinfo.bean.ViolationBean;
import pams.function.zhengzhou.illegalinfo.service.IllegalInfoDrsService;
import sun.misc.BASE64Decoder;

@Service(value="illegalInfoDrsService")
public class IllegalInfoDrsServiceImpl
implements IllegalInfoDrsService {
    private static final Logger LOG = LoggerFactory.getLogger(IllegalInfoDrsServiceImpl.class);

    @Override
    public List<SurveilBean> querySurveilList(QueryBean queryBean, Page page) {
        LOG.info("DRS\u67e5\u8be2\u8fdd\u7ae0\u505c\u8f66\u4fe1\u606f");
        ArrayList<SurveilBean> dataList = new ArrayList<SurveilBean>();
        StringBuilder condition = new StringBuilder(" 1=1 ");
        if (StringUtils.isNotBlank((CharSequence)queryBean.getHpzl())) {
            condition.append("and hpzl='" + queryBean.getHpzl() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getHphm())) {
            condition.append("and hphm='" + queryBean.getHphm() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getBeginTime())) {
            condition.append("and wfsj>='" + queryBean.getBeginTime() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getEndTime())) {
            condition.append("and wfsj<='" + queryBean.getEndTime() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getState())) {
            condition.append("and spzt='" + queryBean.getState() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getZqmj())) {
            condition.append("and zqmj='" + queryBean.getZqmj() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getClzl())) {
            condition.append("and flag='" + queryBean.getClzl() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getFjjh())) {
            condition.append("and fjjh='" + queryBean.getFjjh() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getCjjg())) {
            condition.append("and cjjg like '%" + queryBean.getCjjg() + "%' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getWfdz())) {
            condition.append("and wfdz like '%" + queryBean.getWfdz() + "%' ");
        }
        LOG.info("\u67e5\u8be2\u6761\u4ef6\uff1a" + condition.toString());
        String pageNumber = null;
        String pageSize = null;
        if (page != null) {
            pageNumber = String.valueOf(page.getPage());
            pageSize = String.valueOf(page.getRp());
        }
        String xml = DrsXml.queryXml("t_dzjk_zzjg", condition.toString(), pageNumber, pageSize, new String[0]);
        DrsResult drsResult = DrsUtils.getInstance().query(xml);
        if (drsResult.getState() == 1) {
            return dataList;
        }
        if (drsResult.getRows().isEmpty()) {
            return dataList;
        }
        Iterator<Item> iterator = drsResult.getRows().iterator();
        while (iterator.hasNext()) {
            SurveilBean surveilBean = new SurveilBean();
            Item item = iterator.next();
            surveilBean.setId(item.getValue("id"));
            surveilBean.setHpzl(item.getValue("hpzl"));
            surveilBean.setHphm(item.getValue("hphm"));
            surveilBean.setWfsj(item.getValue("wfsj"));
            surveilBean.setWfdz(item.getValue("wfdz"));
            surveilBean.setZqmj(item.getValue("zqmj"));
            surveilBean.setState(item.getValue("spzt"));
            surveilBean.setTzsh(item.getValue("tzsh"));
            surveilBean.setCjjg(item.getValue("cjjg"));
            surveilBean.setFjjh(item.getValue("fjjh"));
            dataList.add(surveilBean);
        }
        if (page != null) {
            page.setTotal((int)drsResult.getRowTotal());
        }
        return dataList;
    }

    @Override
    public String querySurveilImage(String id, String xh) {
        LOG.info("\u67e5\u8be2\u8fdd\u7ae0\u505c\u8f66\u7167\u7247\u4fe1\u606f: id=" + id + ", \u7167\u7247\u5e8f\u53f7=" + xh);
        String image = null;
        String xml = DrsXml.queryXml("t_vio_surveil_zp", "id='" + id + "' and xh='" + xh + "'", null, null, new String[0]);
        DrsResult drsResult = DrsUtils.getInstance().query(xml);
        if (drsResult.getState() == 1 || drsResult.getRows().isEmpty()) {
            return null;
        }
        for (Item item : drsResult.getRows()) {
            image = item.getValue("zp");
        }
        return image;
    }

    @Override
    public List<Map<String, String>> querySurveilImageList(String id) {
        LOG.info("\u67e5\u8be2\u8fdd\u7ae0\u505c\u8f66\u7167\u7247\u4fe1\u606f: id=" + id);
        String xml = DrsXml.queryXml("t_vio_surveil_zp", "id='" + id + "'", null, null, new String[0]);
        DrsResult drsResult = DrsUtils.getInstance().query(xml);
        if (drsResult.getState() == 1 || drsResult.getRows().isEmpty()) {
            return null;
        }
        ArrayList<Map<String, String>> imageList = new ArrayList<Map<String, String>>();
        for (Item item : drsResult.getRows()) {
            String image = item.getValue("zp");
            String xh = item.getValue("xh");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("zp", image);
            map.put("xh", xh);
            imageList.add(map);
        }
        return imageList;
    }

    @Override
    public SurveilBean querySurveilById(String id) {
        LOG.info("\u67e5\u8be2\u8fdd\u7ae0\u505c\u8f66: id=" + id);
        SurveilBean surveil = new SurveilBean();
        String xml = DrsXml.queryXml("t_dzjk_zzjg", "id='" + id + "' ", null, null, new String[0]);
        DrsResult drsResult = DrsUtils.getInstance().query(xml);
        if (drsResult.getState() == 1) {
            return surveil;
        }
        if (drsResult.getRows().isEmpty()) {
            return surveil;
        }
        for (Item item : drsResult.getRows()) {
            surveil.setId(item.getValue("id"));
            surveil.setHpzl(item.getValue("hpzl"));
            surveil.setHphm(item.getValue("hphm"));
            surveil.setClfl(item.getValue("clfl"));
            surveil.setJdcsyr(item.getValue("jdcsyr"));
            surveil.setZsxzqh(item.getValue("zsxzqh"));
            surveil.setZsxxdz(item.getValue("zsxxdz"));
            surveil.setSyxz(item.getValue("syxz"));
            surveil.setCsys(item.getValue("csys"));
            surveil.setClpp(item.getValue("clpp"));
            surveil.setWfsj(item.getValue("wfsj"));
            surveil.setXzqh(item.getValue("xzqh"));
            surveil.setWfdd(item.getValue("wfdd"));
            surveil.setLddm(item.getValue("lddm"));
            surveil.setDdms(item.getValue("ddms"));
            surveil.setWfdz(item.getValue("wfdz"));
            surveil.setWfdm(item.getValue("wfxw"));
            surveil.setWfnr(item.getValue("wfxw"));
            surveil.setZqmj(item.getValue("zqmj"));
            surveil.setState(item.getValue("spzt"));
            surveil.setFjjh(item.getValue("fjjh"));
            surveil.setId(item.getValue("id"));
            surveil.setTzsh(item.getValue("tzsh"));
            surveil.setCjfs(item.getValue("cjfs"));
            surveil.setCjjg(item.getValue("cjjg"));
            surveil.setCjjgmc(item.getValue("cjjg"));
            surveil.setFkje("200");
            surveil.setJtfs(item.getValue("jtfs"));
            String fzjg = item.getValue("fzjg");
            if (StringUtils.isBlank((CharSequence)fzjg)) {
                fzjg = item.getValue("hphm").substring(0, 2);
            }
            surveil.setFzjg(fzjg);
            String zpStr1 = item.getValue("zpstr1");
            String zpStr2 = item.getValue("zpstr2");
            String zpStr3 = item.getValue("zpstr3");
            ArrayList<String> list = new ArrayList<String>();
            if (zpStr1 != null && !zpStr1.equals("")) {
                list.add(zpStr1);
            }
            if (zpStr2 != null && !zpStr2.equals("")) {
                list.add(zpStr2);
            }
            if (zpStr3 != null && !zpStr3.equals("")) {
                list.add(zpStr3);
            }
            surveil.setZp64(list);
        }
        return surveil;
    }

    @Override
    public boolean deleteSurveil(String id) {
        LOG.info("\u67e5\u8be2\u8fdd\u7ae0\u505c\u8f66: id=" + id);
        String xml = DrsXml.deleteXml("t_dzjk_zzjg", "id='" + id + "' ");
        DrsResult drsResult = DrsUtils.getInstance().executeIDU(xml);
        if (drsResult.getState() == 1) {
            return false;
        }
        return drsResult.getState() == 0;
    }

    @Override
    public boolean changeSurveilState(String id, String newState, String wfxw) {
        LOG.info("\u66f4\u65b0\u8fdd\u7ae0\u505c\u8f66: jdsbh=" + id + ", state=" + newState);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("spzt", newState);
        String xml = DrsXml.updateXml("t_dzjk_zzjg", "id='" + id + "' ", map);
        DrsResult drsResult = DrsUtils.getInstance().executeIDU(xml);
        if (drsResult.getState() == 1) {
            return false;
        }
        return drsResult.getState() == 0;
    }

    @Override
    public List<ViolationBean> queryViolationList(QueryBean queryBean, Page page) {
        LOG.info("DRS\u67e5\u8be2\u8fdd\u7ae0\u505c\u8f66\u4fe1\u606f");
        ArrayList<ViolationBean> dataList = new ArrayList<ViolationBean>();
        StringBuilder condition = new StringBuilder(" 1=1 ");
        if (StringUtils.isNotBlank((CharSequence)queryBean.getHpzl())) {
            condition.append("and hpzl='" + queryBean.getHpzl() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getHphm())) {
            condition.append("and hphm='" + queryBean.getHphm() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getBeginTime())) {
            condition.append("and wfsj>='" + queryBean.getBeginTime() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getEndTime())) {
            condition.append("and wfsj<='" + queryBean.getEndTime() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getState())) {
            condition.append("and spzt='" + queryBean.getState() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getZqmj())) {
            condition.append("and zqmj='" + queryBean.getZqmj() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getClzl())) {
            condition.append("and flag='" + queryBean.getClzl() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getControlDep())) {
            condition.append("and jdsbh like '" + queryBean.getControlDep() + "%' ");
        }
        LOG.info("\u67e5\u8be2\u6761\u4ef6\uff1a" + condition.toString());
        String pageNumber = null;
        String pageSize = null;
        if (page != null) {
            pageNumber = String.valueOf(page.getPage());
            pageSize = String.valueOf(page.getRp());
        }
        String xml = DrsXml.queryXml("t_vio_violation", condition.toString(), pageNumber, pageSize, new String[0]);
        DrsResult drsResult = DrsUtils.getInstance().query(xml);
        if (drsResult.getState() == 1) {
            return dataList;
        }
        if (drsResult.getRows().isEmpty()) {
            return dataList;
        }
        for (Item item : drsResult.getRows()) {
            ViolationBean violationBean = new ViolationBean();
            violationBean.setJdsbh(item.getValue("jdsbh"));
            violationBean.setHpzl(item.getValue("hpzl"));
            violationBean.setHphm(item.getValue("hphm"));
            violationBean.setWfsj(item.getValue("wfsj"));
            violationBean.setWfdz(item.getValue("wfdz"));
            violationBean.setZqmj(item.getValue("zqmj"));
            violationBean.setState(item.getValue("spzt"));
            dataList.add(violationBean);
        }
        if (page != null) {
            page.setTotal((int)drsResult.getRowTotal());
        }
        return dataList;
    }

    @Override
    public ViolationBean queryViolationById(String id) {
        LOG.info("\u67e5\u8be2\u7b80\u6613\u7a0b\u5e8f: jdsbh=" + id);
        ViolationBean violation = new ViolationBean();
        String xml = DrsXml.queryXml("t_vio_violation", "jdsbh='" + id + "' ", null, null, new String[0]);
        DrsResult drsResult = DrsUtils.getInstance().query(xml);
        if (drsResult.getState() == 1) {
            return violation;
        }
        if (drsResult.getRows().isEmpty()) {
            return violation;
        }
        for (Item item : drsResult.getRows()) {
            violation.setHpzl(item.getValue("hpzl"));
            violation.setHphm(item.getValue("hphm"));
            violation.setClfl(item.getValue("clfl"));
            violation.setJdcsyr(item.getValue("jdcsyr"));
            violation.setZsxzqh(item.getValue("zsxzqh"));
            violation.setZsxxdz(item.getValue("zsxxdz"));
            violation.setSyxz(item.getValue("syxz"));
            violation.setWfsj(item.getValue("wfsj"));
            violation.setXzqh(item.getValue("xzqh"));
            violation.setWfdd(item.getValue("wfdd"));
            violation.setLddm(item.getValue("lddm"));
            violation.setDdms(item.getValue("ddms"));
            violation.setWfdz(item.getValue("wfdz"));
            violation.setWfdm(item.getValue("wfxw"));
            violation.setWfnr(item.getValue("wfxw"));
            violation.setZqmj(item.getValue("zqmj"));
            violation.setState(item.getValue("spzt"));
            violation.setJdsbh(item.getValue("jdsbh"));
            violation.setSgdj(item.getValue("sgdj"));
            violation.setClsj(item.getValue("clsj"));
            violation.setWfjfs(item.getValue("wfjfs"));
            violation.setFkje(item.getValue("fkje"));
            violation.setJkfs(item.getValue("jkfs"));
            violation.setJsjqbj(item.getValue("jsjqbj"));
            violation.setBz(item.getValue("bz"));
            violation.setZjhm(item.getValue("jszh"));
            violation.setCfzl(item.getValue("cfzl"));
        }
        return violation;
    }

    @Override
    public boolean deleteViolation(String id) {
        LOG.info("\u5220\u9664\u7b80\u6613\u7a0b\u5e8f: jdsbh=" + id);
        String xml = DrsXml.deleteXml("t_vio_violation", "jdsbh='" + id + "' ");
        DrsResult drsResult = DrsUtils.getInstance().executeIDU(xml);
        if (drsResult.getState() == 1) {
            return false;
        }
        return drsResult.getState() == 0;
    }

    @Override
    public boolean changeViolationState(String id, String newState) {
        LOG.info("\u66f4\u65b0\u7b80\u6613\u7a0b\u5e8f: jdsbh=" + id + ", state=" + newState);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("spzt", newState);
        String dataStr = "";
        if ("1".equals(newState) || "2".equals(newState)) {
            dataStr = new SimpleDateFormat("yyyyMMdd").format(new Date());
        }
        map.put("spsj", dataStr);
        String xml = DrsXml.updateXml("t_vio_violation", "jdsbh='" + id + "' ", map);
        DrsResult drsResult = DrsUtils.getInstance().executeIDU(xml);
        if (drsResult.getState() == 1) {
            return false;
        }
        return drsResult.getState() == 0;
    }

    @Override
    public List<ForceBean> queryForceList(QueryBean queryBean, Page page) {
        LOG.info("DRS\u67e5\u8be2\u5f3a\u5236\u63aa\u65bd\u4fe1\u606f");
        ArrayList<ForceBean> dataList = new ArrayList<ForceBean>();
        StringBuilder condition = new StringBuilder(" 1=1 ");
        if (StringUtils.isNotBlank((CharSequence)queryBean.getHpzl())) {
            condition.append(" and hpzl='" + queryBean.getHpzl() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getHphm())) {
            condition.append("and hphm='" + queryBean.getHphm() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getBeginTime())) {
            condition.append("and wfsj>='" + queryBean.getBeginTime() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getEndTime())) {
            condition.append("and wfsj<='" + queryBean.getEndTime() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getState())) {
            condition.append("and spzt='" + queryBean.getState() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getZqmj())) {
            condition.append("and zqmj='" + queryBean.getZqmj() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getClzl())) {
            condition.append("and flag='" + queryBean.getClzl() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getControlDep())) {
            condition.append("and pzbh like '" + queryBean.getControlDep() + "%' ");
        }
        LOG.info("\u67e5\u8be2\u6761\u4ef6\uff1a" + condition.toString());
        String pageNumber = null;
        String pageSize = null;
        if (page != null) {
            pageNumber = String.valueOf(page.getPage());
            pageSize = String.valueOf(page.getRp());
        }
        String xml = DrsXml.queryXml("t_vio_force", condition.toString(), pageNumber, pageSize, new String[0]);
        DrsResult drsResult = DrsUtils.getInstance().query(xml);
        if (drsResult.getState() == 1) {
            return dataList;
        }
        if (drsResult.getRows().isEmpty()) {
            return dataList;
        }
        for (Item item : drsResult.getRows()) {
            ForceBean forceBean = new ForceBean();
            forceBean.setPzbh(item.getValue("pzbh"));
            forceBean.setHpzl(item.getValue("hpzl"));
            forceBean.setHphm(item.getValue("hphm"));
            forceBean.setWfsj(item.getValue("wfsj"));
            forceBean.setWfdz(item.getValue("wfdz"));
            forceBean.setZqmj(item.getValue("zqmj"));
            forceBean.setState(item.getValue("spzt"));
            dataList.add(forceBean);
        }
        if (page != null) {
            page.setTotal((int)drsResult.getRowTotal());
        }
        return dataList;
    }

    @Override
    public ForceBean queryForceById(String id) {
        LOG.info("\u67e5\u8be2\u5f3a\u5236\u63aa\u65bd: pzbh=" + id);
        ForceBean force = new ForceBean();
        String xml = DrsXml.queryXml("t_vio_force", "pzbh='" + id + "' ", null, null, new String[0]);
        DrsResult drsResult = DrsUtils.getInstance().query(xml);
        if (drsResult.getState() == 1) {
            return force;
        }
        if (drsResult.getRows().isEmpty()) {
            return force;
        }
        for (Item item : drsResult.getRows()) {
            force.setHpzl(item.getValue("hpzl"));
            force.setHphm(item.getValue("hphm"));
            force.setClfl(item.getValue("clfl"));
            force.setJdcsyr(item.getValue("jdcsyr"));
            force.setZsxzqh(item.getValue("zsxzqh"));
            force.setZsxxdz(item.getValue("zsxxdz"));
            force.setSyxz(item.getValue("syxz"));
            force.setWfsj(item.getValue("wfsj"));
            force.setXzqh(item.getValue("xzqh"));
            force.setWfdd(item.getValue("wfdd"));
            force.setLddm(item.getValue("lddm"));
            force.setDdms(item.getValue("ddms"));
            force.setWfdz(item.getValue("wfdz"));
            force.setWfdm(item.getValue("wfxw1"));
            force.setWfnr(item.getValue("wfxw1"));
            force.setZqmj(item.getValue("zqmj"));
            force.setState(item.getValue("spzt"));
            force.setPzbh(item.getValue("pzbh"));
            force.setSgdj(item.getValue("sgdj"));
            force.setJsjqbj(item.getValue("jsjqbj"));
            force.setBz(item.getValue("bz"));
            force.setZjhm(item.getValue("jszh"));
            force.setDabh(item.getValue("dabh"));
            force.setQzcslx(item.getValue("qzcslx"));
            force.setDsryy(item.getValue("dsryy"));
            force.setMjyj(item.getValue("mjyj"));
            force.setWslb(item.getValue("wslb"));
            force.setRyfl(item.getValue("ryfl"));
            force.setJszh(item.getValue("jszh"));
            force.setZjcx(item.getValue("zjcx"));
            force.setJtfs(item.getValue("jtfs"));
            force.setXzqh(item.getValue("xzqh"));
            force.setWfxw1(item.getValue("wfxw1"));
            force.setFxjg(item.getValue("fxjg"));
            String fzjg = item.getValue("fzjg");
            if (StringUtils.isBlank((CharSequence)fzjg)) {
                fzjg = item.getValue("hphm").substring(0, 2);
            }
            force.setFzjg(fzjg);
            ArrayList<String> wfxwList = new ArrayList<String>();
            for (int i = 1; i <= 5; ++i) {
                if (!StringUtils.isNotBlank((CharSequence)item.getValue("wfxw" + i))) continue;
                wfxwList.add(item.getValue("wfxw" + i));
            }
            force.setWfxwList(wfxwList);
        }
        return force;
    }

    @Override
    public boolean deleteForce(String id) {
        LOG.info("\u5220\u9664\u5f3a\u5236\u63aa\u65bd: pzbh=" + id);
        String xml = DrsXml.deleteXml("t_vio_force", "pzbh='" + id + "' ");
        DrsResult drsResult = DrsUtils.getInstance().executeIDU(xml);
        if (drsResult.getState() == 1) {
            return false;
        }
        return drsResult.getState() == 0;
    }

    @Override
    public boolean changeForceState(String id, String newState) {
        LOG.info("\u66f4\u65b0\u5f3a\u5236\u63aa\u65bd: pzbh=" + id + ", state=" + newState);
        HashMap<String, String> map = new HashMap<String, String>();
        String dataStr = "";
        if ("1".equals(newState) || "2".equals(newState)) {
            dataStr = new SimpleDateFormat("yyyyMMdd").format(new Date());
        }
        map.put("spzt", newState);
        map.put("spsj", dataStr);
        String xml = DrsXml.updateXml("t_vio_force", "pzbh='" + id + "' ", map);
        DrsResult drsResult = DrsUtils.getInstance().executeIDU(xml);
        if (drsResult.getState() == 1) {
            return false;
        }
        return drsResult.getState() == 0;
    }

    @Override
    public boolean uploadSixInOne(Map<String, String> dataMap, String tableName) {
        LOG.debug("\u8fdb\u5165uploadSixInOne\u65b9\u6cd5");
        String requestStr = this.buildXml(dataMap, tableName);
        LOG.debug("requestStr=" + requestStr);
        DrsResult drsResult = DrsUtils.getInstance().executeIDU(requestStr);
        if (drsResult.getState() == 1) {
            return false;
        }
        return drsResult.getState() == 0;
    }

    private String buildXml(Map<String, String> dataMap, String tableName) {
        LOG.debug("\u8fdb\u5165buildXml\u65b9\u6cd5");
        LOG.debug("tableName=" + tableName);
        StringBuffer sb = new StringBuffer();
        sb.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ser=\"http://service.drs.xdja.com/\">");
        sb.append("<soapenv:Header/>");
        sb.append("<soapenv:Body>");
        sb.append("<ser:executeIDU>");
        sb.append("<iduRequest>");
        sb.append("<table>");
        sb.append("<name>" + tableName + "</name>");
        sb.append("<mainTable>1</mainTable>");
        sb.append("<row>");
        if (dataMap != null) {
            for (Map.Entry<String, String> entry : dataMap.entrySet()) {
                sb.append("<column><name>" + entry.getKey() + "</name><value>" + entry.getValue() + "</value></column>");
            }
        }
        sb.append("<srcCondition></srcCondition>");
        sb.append("<type>insert</type>");
        sb.append("</row>");
        sb.append("</table>");
        sb.append("</iduRequest>");
        sb.append("</ser:executeIDU>");
        sb.append("</soapenv:Body>");
        sb.append("</soapenv:Envelope>");
        LOG.debug("sb.toString()=" + sb.toString());
        return sb.toString();
    }

    public static void main(String[] args) {
        String str = "LzlqLzRBQVFTa1pKUmdBQkFRRUFZQUJnQUFELzJ3QkRBQU1DQWdNQ0FnTURBd01FQXdNRUJRZ0ZCUVFFQlFvSEJ3WUlEQW9NREFzS0N3c05EaElRRFE0UkRnc0xFQllRRVJNVUZSVVZEQThYR0JZVUdCSVVGUlQvMndCREFRTUVCQVVFQlFrRkJRa1VEUXNORkJRVUZCUVVGQlFVRkJRVUZCUVVGQlFVRkJRVUZCUVVGQlFVRkJRVUZCUVVGQlFVRkJRVUZCUVVGQlFVRkJRVUZCVC93QUFSQ0FEVUFVSURBU0lBQWhFQkF4RUIvOFFBSHdBQUFRVUJBUUVCQVFFQUFBQUFBQUFBQUFFQ0F3UUZCZ2NJQ1FvTC84UUF0UkFBQWdFREF3SUVBd1VGQkFRQUFBRjlBUUlEQUFRUkJSSWhNVUVHRTFGaEJ5SnhGREtCa2FFSUkwS3h3UlZTMGZBa00ySnlnZ2tLRmhjWUdSb2xKaWNvS1NvME5UWTNPRGs2UTBSRlJrZElTVXBUVkZWV1YxaFpXbU5rWldabmFHbHFjM1IxZG5kNGVYcURoSVdHaDRpSmlwS1RsSldXbDVpWm1xS2pwS1dtcDZpcHFyS3p0TFcydDdpNXVzTER4TVhHeDhqSnl0TFQxTlhXMTlqWjJ1SGk0K1RsNXVmbzZlcng4dlAwOWZiMytQbjYvOFFBSHdFQUF3RUJBUUVCQVFFQkFRQUFBQUFBQUFFQ0F3UUZCZ2NJQ1FvTC84UUF0UkVBQWdFQ0JBUURCQWNGQkFRQUFRSjNBQUVDQXhFRUJTRXhCaEpCVVFkaGNSTWlNb0VJRkVLUm9iSEJDU016VXZBVlluTFJDaFlrTk9FbDhSY1lHUm9tSnlncEtqVTJOemc1T2tORVJVWkhTRWxLVTFSVlZsZFlXVnBqWkdWbVoyaHBhbk4wZFhaM2VIbDZnb09FaFlhSGlJbUtrcE9VbFphWG1KbWFvcU9rcGFhbnFLbXFzck8wdGJhM3VMbTZ3c1BFeGNiSHlNbkswdFBVMWRiWDJObmE0dVBrNWVibjZPbnE4dlAwOWZiMytQbjYvOW9BREFNQkFBSVJBeEVBUHdEOUdpQ1IySDRWK0RIeFUrS21xK0J0ZnQ3R3d0N09hS1MyV2N0Y0k3TnVMdXZaaHhoUlg3MFYvUEorMFA4QThqalpEdjhBWUUvOUdTMTUyRTZoaW9xZFNDa3I3L29KL3dBTkVlSXYrZkhUUCsvY24veHlqL2hvanhGL3o0Nlovd0IrNVA4QTQ1WGx0RmVoWXc5aFQvbFBVdjhBaG9qeEYvejQ2Wi8zN2svK09Vdi9BQTBSNGkvNThkTS83OXlmL0hLOHNvb3NIc0tmOHA2bi93QU5EZUkrdjJIUzhmOEFYS1QvQU9PVjB1bGZFUDRnYTM0UzFUeExZYURZWG1qNlZJa2Q5UERGSXh0OS93QjFuSG1aQ25wbnBYamVoV1Z0cWVxV3R0ZTM2YVpheXlLc2w1SWhkWVZKd1dLamtnZWdyOUIvMmJQQy9oVDRQZUNkVFBobXdnK04xM3Ixd3R2cVN3M2YyUzBHbkRxQkRKeVpBMlRsaDNHSzh2TXNiSEEwbE5LOG0xdm9yWDExMldsOXp1d21YVThWTndVZGwwUEJ2aDFydmluNGs2ZFpTNmRCWXdTaTVsVyttbXQ1QkJCQXFvUTRiek9XeXpESHNLby9FRDR1d1duaVUyL2hPMWR0SmhpalNhYlYweks4MlAzcklFS2dJRG5HY25qclgxZjhjdmg3TjRCOEl5dDRSZ3RQRGZnN1VBaDFQU29FRXR6WWpraVNMc3h3Y0h0OHRmQjhkdHBtcmVKL3N1a3BjWFdrV2psNWJtZmlXNUFQQlBvVzZBZE90ZVpsV1p2SE9XSmVrRmV5L3dBM3RlL1EraG5rMkZvdW5oK1ZTbkxmdXV5dCtKOUwrQnZEOTVyUGg3VEw3V2tqdHB0UVpwSUZ0NUFwTnY4QXd5bU1nbGNuSUFKN1pyeW40dmZHRFQvQ3V1alR2Q1REVVRDWFc3ZStqYkNNUDRWMmxjNDdtdTIxL3dBYlhQaC93N1k2ZmIzYVJlTE5WQy9aSFZjaUdNY1JBNTZjZkxpdm1QUXZCK3VlT1BFOHRqYTJ6VDM3U1NOT3puQ3BnbmN6RThBQTVyWEFmV2FqbmpNVE8wTHZsV3lOczJ5L0EwZVRCWVNrblBxN1hmOEF3L2M2bHYyZ2ZFaW5EV0dtcWV1REZKeVArL2xNL3dDR2hmRVdBZnNXbWRQK2VVbi9BTWNyMjZ4L1pjc2ZpQnFDeXlYMGtMV2x2RGFtMHNWVVBJNm9DV0xOd0FkM1d2WXZoLzhBQUh3SDRYU1N6T2wrR0d1QzM3MDY5Y2VhNnNBQnhrNHg3ZXVheXI4UVlTakgzVTVQc2M5UGhTdE52bVNqSHV6NHdQN1FuaUlZL3dCQzB3LzlzcFAvQUk1U2Y4TkMrSXM4V09tWlBUOTFKLzhBSEsvU2Z3eit6NTRhMUNJdkI0TzhFWENrWURyWlJ1cmUrY1ZxYXY4QXNxK0Q5ZjB1VFQ3ejRjZUZKWTNLbDVOT1NTMG1YbnM4ZGVldUtzTmUwcVR0OGhWT0Z1UlhVNHRuNWlmOE5EZUl2K2ZMVE0vOWNwZi9BSTVRUDJoZkVZem15MHNmOXNwUC9qbGZkWGl6L2dtRjRGOFFUelM2SnIxOTRVdW1qekhwc3JpNGlHT1Nkei9OK3Zhc0hUUDJPLzJidmd0WkR4WDQ1K0thZUtJOU5VeXlhRGJUdzV1SlIvQUVYNWlNakZlelJ6dkI0aitGZHZ0Wm5nMXNyOWc3VGlqNDFmOEFhQzhTSXFzMWhwb1Z1aE1NblA4QTVFcG4vRFEvaUxBLzBMVFArL1VuL3dBY3F2OEFIMzRwV1B4YStKRjdyV2thQmFlR05DUlZ0dE8wbXlqQ0pid0puYm5IVmprc1Q2bXZOajFGZTVGdVVVMnJIQzZGTlA0VDlrUCtDWmQvTHEvaC93QVczMGdSSmJxMTBxZDFRSGFHWkxoampKNlpOZlJ2N1N2eG9QN1BId1U4Ui9FRTZRTmYvc2Y3Ti94THZ0UDJienZOdVlvUDlac2ZianpkMzNUbmJqak9SODBmOEV0ZitSTThSZjhBWVAwZi93QkZ6MTdsKzIvOE5QRWZ4Zy9aZThhK0VmQ1dtLzJ2NGcxSDdGOWxzL1BqaDh6eTcyQ1YvbmtaVUdFUnp5Um5HQnlRSzh5cFoxdGR0RHN3dDFRVnZQOEFNOEI4TS90NmVPL2lGKzBKNHMrSEVHaTZUNE5nOE1RM2NGM1BhZUg5VjhZU3ozZHRkaUJ5aVdadG5TRmcyUTd4OEZBQ2N5S3E5aDRUL2JSOFFXM3dPK0kzam54SGJlRko3bndwNHUxTHcvQmIzOXpjK0dmN1JndGJaWmxXT0c0VzVrRjdJZHdGczIwOVFTQ2gzZkFualA4QVo5OFdlRGYybUw3eFRwRjNvZmg3dzFwWGpxelMrOFQrR2tONW92ZzY3dUwzekk3ZVI1b1lJMyt5Z3g3d0ZFU0ZvbzNLTTRTdnJqNDdmRW15OFRmc3dmR0w0Y2ZCWFVmRXZ4Q244TlE2ZS9pUHhoZitMRnZWZXhsdG11TG01aHVYdUhNeW1PemVDVzNqRWE3cDVOcUVibFBUS25EU3lOVk9XdHpzUGhsKzNKcXZpdnhyOE9ORXVOUTBIeFBIcWZoeC9FM2lsL0IvaHpVTDZYVEVramlTM3NJNDdTYTdjWEVWd3orYzB5UnA1YlJnQlhJRGZVZndvK0xIaGo0MStFWS9GSGc3VUo5VjBDV1o0SXIyYlQ3aTBXWmtPSE1ZbmpRdW9PVjNxQ3U1V1hPVllEOHBOVytCbW9hRW43UHRzOTVQSDRTOGU2bDRRbnZycnhCZVdsL3FHcVhiV3dRQzB0M0VpL1lMR0NieVFrMFErYTZDT0o0eEZzK3pQSG12ZkdyNGQvczU2YnBVZHJydmh6eEpvWGlMK3diVFV2aDU0UHN0Y2ZWOUloZ2tGdmVmMmI1d2pzbzVBc2U1QTJZM2pVQlZXUUt1VlNsRjI1U296bDFQcjhnbnZRRkk3L3BUcUs0VGU1eS94QytJdWlmQy9STGZWdkVNdDlGWXoza05oRzJuNlhkYWc1bm1iWkVoanQ0NUhHOXlxQWtZTHVpNTNPb0o0UytJdWllTmRhOFM2VHBNdDg5OTRkdkJZYWt0M3BkMWFKRk9WM2hFa21qVkpjb1VmTVpZYkpJMnp0a1F0dy83VlVrNStGZHRiV2lhNmJxYnhIb1VpeitITkpsMUs3dFVoMVMydVpiaFlvNFpoKzdpZ2tjRjQyUXNxcmhpeXEzbEVkdnJlbWFOOFg5TmE1K0lPcHl5ZU5MYVY5ZGwwZThzcGJtMk9sMmR0OW9QOW4yMXZOY3d4VDJ6Z0pwd1I1RERBSkpFdDVwWmp2R0VaUnVTNU5NK3RzSDFwQ0NlOWZFZmh2eEMrcGExNEJoOGY2aDhUM1ZkTzhUV00wT2oydmlqVFpicGJUVkxNYWJjR3p0Mk53Vit4M1JIbnltUm1MaFpwWkpVNHRhMUo0d3Q5YTFPMDFlOThkU2ZGMlQ0ZGFEZjZkWjZOZTZuTHBrUGlaMTFDR1I1NHJSanA4TWJ6MjFzR0U0VzJiWTdFRlRLVFhzVUxuUHRIWWZYOUs0ZnhKOGJ2QmZoWFhMblJMald4cWZpRzEybTUwSFFyU2ZWdFR0a1pRd2tsdExSSlpvNDhNbjd4a0Nmdkl4bkxxRDVWNG8rR21vYXI4YnJ2d3JaZUpmRWcwTFdwYlh4VnFVdHI0cjFTTzYwdUtIN1JISmFSR09ZTGJRM1V6Mi9seFl3NlI2bnRaRGJXb2k5ejhZU2VKVjAyS1B3cmI2VkpxRTB3aWt1TllubFNLMGlLdG1jUnhvVGNNaDJueWQ4SWNaSG5SOEdzK1dLS3V6TDFiNHRlRjlIK0cxMzQ4dWIrYi9oR0xPRjU3cTZnMCs0bW10bFJ5a3dsdDBqTXlORXdkWlVaQTBSams4d0xzYkhpbWlmSEQ0ZytQTk4rR3JhSnFPaGVIdFkxZThoOFBlSmRKOFFlRU5SVzQwblZ4bzgrcHpoVmt1N2RqSHRqaVJWMnNNU2J4SzQrV3V4K0pmZ2V6OEwvQVg0aXJyV3FUMzJwZUlZWkxuV2JxenMxTGF0ZFNReFd5MmNGcjVpbmJOSEZCWlJ3UnlyTXlsQUovUGJ6ejR0OFJibndUWStQdkJ4K0pIaXIvaEMvRmQvNDZ1OVYxdlR4NG1uMFdLMWdPZzNOcEJQYnl4enhOTGJsYk95UmJ2SUxTU1R4bGJkcFpyV1BhRVltYmJQVExuOW83Vi9DM3cyMEM3MXEyL3RmeGRxWGk2NzhPcEZvUGh6VUxtM3VZTExXWkxhOGtTS0V6TkhJTEczdUxoWTJrWWt4T1ZEaEdXc1B4ZDhjZmlOL1pmeEE4U2VGZkVuZ3kvOEw2SDRMdHZIV2ttNjhLM29tdmJPNVhVSklJSFk2Z2hWaEhZcm1UeXhreW45Mm0zQjVuNGZhOVpYdmdMd2Ivd3J2VTRQR210YVQ0MDhZUHBXbkplTHFpa2ZhTlNJdnA1amNKSXpKYjNVUVI1WnZMbWJVWVVrYU5ybUc3Zzh4K0pKK0RPamFGOFdOSHN2aUxQRzJsL0NqVE5JMHF5dlBHRjFZWE05NWJRYXJCOWtuc2xtaURUS0V0aEphUENOcnpQdWlWcG4zV29SdnQvVnllWm42TEJTTy82VUVFOTZyNlhxbGxybW1XbXBhZGR3YWhwMTVDbHhiWGRyS3NzVThUcUdSMGRTUXlzQ0NDRGdnZ2lyVmNKdmNac1ByK2xGUG9vQzRWL1BKKzBQL3dBampaZjllQ2YrakphL29icitlVDlvZi9rY2JML3J3VC8wWkxYb1lUcWVkaVA0c1BuK2g1WlJSUlhvRWhSUlRnTWpOQUQxNXdQVHJnMTlLZnNnNko0MzByeHRmYXBvOW5jV3NWdFlQSzMyeTJmN1BOeU1BNUdPY1Z3UDdPUHdiZjR6K1BsMGw5VHR0SHM0SUd1N2krdXpoSVVYdmp2emppdnVqVnZGdW4rQWxDcjQzdVBFZW5tL1pyVzMycEZCSmNGQUdVYmVxS0ZKQTZjbXZrczd4NjVYZ0tVZWFjbDF2Wlg3L0krcXlmQmFyRjFKV2pIWHphdmJUNW5rdjdRL3hDOGJTeVdzYnp3MzhkK3hrdWRCdHZ2eFI3ZHVFSTUyQmczSHJYejU0VHM3YlNrajFhNnRab0xkSGFTNGpVNVpwRllpT0lML0FIc2pPUGV2ZTdhNDBtMThQNjM4Uk5VMUsxMUg0Z2FuSXNQaDNTNFd6RmF3K2FWK2YwenkyVHhXZHJ2anRQRFBqWFc5WjFEd1piMnZpN1I5T3Rvb05PSzdyTVhrbWQxOHk5RytRcVY3WkZjdENwS2xSK3IwWVhqSFJ0YVhlbDByN3BYV3A2bEZLamlQck5TL1BKTnBXMlRUczM4a2NKZmZBUDRzYXpQSDR0dWZCdXBXV20za2kzVm83VElqSkYvQUZWbXlQeXIwSHcxNEcxRFRUYVByRnZiNkZwMFIrMFhOc2poNTVnRHVJa1ljQlNRU2VhNTJYWDdyeFBmTmNhN3ErdDY3ZE9mM3R3MTB5UlpBNUNLRGdBZGdLM0xUdzM0QjhYNlJjV0NhNzRrMGdzQTl4YkdRRlpBRDFZdHpqL0NxcjFhOVhscDFyOHE2UmkzYjhmeHNkRkp5d2xLVW9TWE8rcmRuYnZ0K0Z6eFg0bGVPN3J4SDR5MXJWYkcrbXRyT2E0MnhDS1FvZ0hRSEE3WUhIdGlydmgvNGJlSmZpRnBvdTlFdDlWOFFXcTVFanhYQ2p5ejZrRnM5YTVyNHVYK2kybXBqdy80YmdKMGpUanRhN2M3cExxVHU3SHBqb0FQYXVkOEkrTk5kOEFhbkRxR2tYbHhZU0FqS2hpRWxHZWpEb1JYMWxKeGpSU3AwMG4wVFg2SSticll5VVpjc1h6S3l1OVhkOVhxZFpyMm0rS2ZoOWZqVE5TazFiUnJrSnZTSnJoeGtaeGtZT0NQcFdsNEorS1BqZndocUp2TkM4VjZ2WVhTbkplTzVaZ3h6am9UMXJwL2pEOGF0TytNSGdqd2JNMElqOFIyVHpwZHFCOTFPTVlQb2V0Y1g0YTAxcFpMZUZGM3l1ZHdIOWZ3cjBNQmhxZU0valVsMXVySFpTbXAwK1puYmZGTDlwMzR3VytpUWFMcUhqelViK3gxT0F6TjVoQWtYNWlwVU1PUjkydm5TYTZsbll0SkkwalpKM094SkpQVTEyUHhYMXkzMWp4UDVOdElIdExLRmJaSkIwWTlXUDVrMXc1NjFGWERVTU5WbEdoRkpKOUZZK1hxMUhVZDJ3QnhRVG1rb3JNeFAySS80SmEvOGlYNGkvd0N3Zm8vL0FLTG5yN21yNFovNEphZjhpWDRpL3dDd2ZvLy9BS0xucjdtcnhxLzhSbStFL2hyNS9tRkZGRllIWUZGRkZBQlJSUlFBVVVVVUFZTjU0QzhNNmg0dXNmRlYxNGQwbTU4VVdNSnQ3VFc1ckdKNzIzaUljRkk1eXU5VklrazRCQStkdjd4b3MvQVhoblQvQUJkZmVLclh3N3BOdDRvdm9SYjNldHcyTVNYdHhFQWdDU1RoZDdLQkhId1NSOGkvM1JXOVJUdklSZytIL0FmaG53bnFlc2Fsb2ZoM1NkRzFIV1p2dEdwM2VuMk1VRXQ5THVadDg3b29NalprYzVZazVkajNOYjFGRkxjWVVVVVVBRkZGRkFCUlJSUUFVVVVVQUZmenlmdEQvd0RJNDJYL0FGNEovd0NqSmEvb2JyK2VUOW9mL2tjYkwvcndULzBaTFhvWVRxZWRpUDRzUG4raDVaUlJSWG9FamowcWFLSXlEQTVic01kYWc2OFYxdncxZUNQeHJvejNNRU56QkhjTExMRk9jUnNxODRZK2xST1RqRnlTdTBkV0ZwZldLMEtWN2N6U3YydjFQdW53SDhNUEFQZ240QlNHMnRoZGVNcmkwdFpydUdmT1c4d2p6QUR4OGlqT2ZldUcweUR3aEhwT21sSXBiZnhUY1N6TkZQZXgrWmEyOEdDZ1dPSWtaa09RZDNwazF6SGpMNGpIVjdlUFQ5UDFkalBhdzNFTnN1bmZ2VkNUU2J6RHU3Z0gxNlpybi9GK3NhL3IxbG8wVi9waTJiMnFiRkxNd0xrakIvREdmek5mR1lMSThWVmNxOVNidkozMys1YStSK28xNmxUbStwNGFrcFU0dTNNK3kzYTdxNi9FWFQ3Q0hUL0J4dGJxK2d2ckdUY29rdGxBdWxoRXJiaHQ2a0ZnMkNPeHJTMXJ4S21zMzBlb1hreWZZYlN4VzJUZS9tVFhBQXhHclk1QVVjYzF3YzF6ZjNNcHZKbXQwdUlTcmlXS1BZVkM5SXdCd0Y5UlZXWDRnYWpvOGNndExPeXRyaVVuZmNSeEFuQi9yMXI2RCt6OFRCcVRTZXZlMXJ0WFo1K0tvUXBRVjAwN2IzYmIwdGJWNkx5T3MwMnlhL2x0WlpMT1pSZDdraW51dDBhU09Na0NQKzc5VFcvUHFXaXhhTEczaWV6bGZUSkEwS3pNU3MxdXc0UHpqcVBUUFd2Ti9DUHhUdnROMHVEUXRhbG4xRFFVdTB1bzVCODB0dklPVGcvM1Q2Zld1djBQd3JxWHhMMHU5MEh3cmRSNjNxRTNtM1UyalRNTmtxNXlza0VtZUQyOHM4NUI5YTRxdEowRzNYZGtudjBTN3Q5RGdWYjJrVkdDOTYyM242Yk01Q2Z4L3dDRHRLMXkwZ3NyQ1hVTkdoSjN2UEdGYVErdUs5ajhOandIOFVOSFpvbnNnYkZHa3ZMYTRVTDVVZUFkeUhqMElyNVA4UStHOVQ4TWFwY2FicXRsY2FmZndPVWt0N3FNbzZ0NllOWE5FdFo3SzNtYnpwSWxsWHkzUkd4dVhyaHZhdXVybDFQRXhVNlUybjBkN25KZzgxeFNxT2xWZ25IcXJHenFFV214NnhxRXVreFN4NlU4NU1DeUhMaUlmNDgxNmQ4SVBCMXg0NzhVV0ZuYk1Zb09KYnk0UWNXOXF2M3NuKzh4QVVEdnpYQ2VHOUFtMXEvczRnbUd1SkZndElnY05OSXhBVlY5c25rMTkyZUMvZ0xjZkNyUUNOTWQ1L0U4Z1U2b2k0RnRja1l6R3AvaEtkajZscTdNeXpQK3hjRTR4Zjd5YXRIdjV0K2h0U3cvdDN5dytIcjgraDREKzAxK3pmYnk2TmZlUFBDVm90dkZaQlA3VDB1TWNxaDRFeWowN01PMk05NitRaXBYQXI5WC9EdW9XZGo0bmowMi9pU0M2dUlwRi9zYThHSHVZeU1PZ0I2OEg5TTE4T2Z0V2ZzNFhId1U4U1E2dHBUTmZlQ2RhZG4wNjcyNE1MZFd0NUIyZGYxR0RYeW5EMmJTckw2cGlYNzYyYjZvNE00d0VhVFZhanQxOWU1NENSaWtwN1JrRWVwNkNsV0xlQVF3cjdjK1hQMkUvd0NDV3Y4QXlKbmlML3NINlA4QStpNTYrM05Va3ZZZE51NU5OdDRMdlVWaGRyYTN1cDJnaWxsQ25ZcnlLamxGSndDd1JpQVNRcll3ZmlUL0FJSmJESGczeEVQK29mby8vb3VldnR2VkpMMkhUYnVUVGJlQzcxRllYYTJ0N3Fkb0lwWlFwMks4aW81UlNjQXNFWWdFa0syTUh4NjM4Um0yRS9oZmYrYlBtL3cxKzFiNHkxLzRmL0YveFpKOFBOQ3RyWDRjWG1xYWJkMjYrS3BuZTd1ckFSeVhBalA5bmdMR1lta0tPZm1McXFsRkRGMTZmNENmdE8vOExkMXUzOFBhOTRiL0FPRVE4U1gvQUlkc3ZGK2wya0YvL2FGdmZhUmNxZ1dZVENLTXh5Unl1WW5pZEZPUUdReUtTUjUzNFQvWisrSytpZkN6NDllRXJyVC9BQWFadmlQcVd0NnZhWE1QaUc3WmJPWFVVamhNTWdPbmdzc1VmbVA1ZzVkbFZOaUJpNnA4UC8yU2ZGdGxvT3RYL2kyYnczZWVKSWZocEg4TTlGMGkwdUxwOUxtczBnQmFhOW4yUlRGcFo4NUVLcDVVWEFhUnp1WFJ4cDJadmVXaDljVVY1bCt6WDhOYi93Q0VId1U4T2VFZFMwM1F0SXZ0TyswK1paK0dwN3Vhd2o4eTVsbEhsUGRzMHh5SEJiZVRoaXdIeWdDdlRhNUphT3lOVnNaZmlqeE5wdmd6dzFxL2lEV2JuN0hvK2syYzEvZTNQbHMvbFFSSVhrZmFvTE5oVkp3b0pPT0FUWGxIaHI5b0RWdGExTHhadThNYVRxV24rSGROdTcyOHMvQ25pV0hXZGJ0TG1KaDVXbjNWaEhHb2l1cFFKd0ZqbWxRU1c3cHZPVlp2UlBpaDRMLzRXVDhOUEZ2aEg3Wi9aMzl2NlJkNlY5czhyemZJOCtGNHZNMmJsM2JkK2R1Um5HTWpyWG5tbi9EZnh0cTJwUVg4bHQ0YitHYytpK0Y5UjhPYUFuaHU1ZlZvclpycHJSbzUvS2x0YlZFVzNOakZ0aEN1c2djZ21NSmg5WWN0dmVFNzlDdEYrMHovQUdmYWE3YTYxcCtoUmE1cDk0TlBpZlNmRVAydlJqZENLNW1tZ3VkUWt0NFJiU1cwVmxjVDNLTkdXaWg4b3FKWkpVaUo0YitQbml6eGYvWnRobzNoZnducW1zYXA5dXZOT3U3RHhpYnJSYjNUN1Q3SEhQUEhleFdiUDVndUwwUStVMEE1Z21ZdUFFRDVYaVQ0TGVNdkd2amF6K0lPc2FONFRQaURTYnpUSjdMd3crcVRYVmhQOWpqMVJJNW52V3MxZUtRUHE1bFVMYlB0YXpqdzJaZDBWYld2Z3Y0ODFMVjczWHBORDhOM09vNjNxVnpxVi9iV1hqRFZkR3VkTmI3SnAxcEREYmFuYVd3bG1oa1N3YVdXSjRvMUxtRGh2SUR0cHl3STFOMVAyaWRZMWVKNDlKOE9hRlozV25XZDlkYXhONHA4UnZwbGpGOWp2WjdLN05yT3RwTWJpT0dXMlpwSkhTSFpIY1dqTUFaaWlWdkV2N1Vrc2NkbEY0YTBIU1cxcWVLRmY3QThiZUlvL0R1b1QzOHR0QmN4NlpiUXZGS1picFk3cTJFZ0pTTkd1WVZFanQ1Z2l3bS9aVy80UmFMVHJXMDhHZUJmaVhvOFZtNlI2TjRySDluMk9qM1VsN2QzZHpMcDhJdEx0WTQ1bXZGajh2NVdTT3l0MWFTWWpLQS9aeThaNko0UzhjK0VyU2ZRdkUzL0FBbmVrV3VsYTM0NDFhOW10dFdqMmFURHByeUdBUVRmYTl2bFNYS3E5ekhsN21STXJ6Szd0VEQzajAzeFI4V2RaOE0rSnBSTDRUeDRSdGRYMC9Rcm5WN204ZUc3bHVyeDdhT0dTMXR2Sk1jOXVzbDVBanltZEdWa3VBRVl4S0pDMCtMT3NyNDEwclQ5VThLZjJWNGUxclY3elF0S3Zacnh4ZnlYVnRIZFN0Sk5hTkNxUjI4aVdOdzBjcVR5TTZ0YnRzVVNONWVaNGg4Ti9FdTkrTFVXcndhYjRVMUx3OVpYbHF1bFQ2anExMGt1bTJyQ05iK1lXU1dwU1M5ZEd1b281amNCVWpaRlZVRDNBblBEM2h2NGxSZkZxWFhOYTAzd3BjNlpKZVhWc3VxTHExMUxkMnVrWWtOdmJXdG9iVkk0SkhrVzBrdUpEUElaR1JoeXFXNlFaMmpZZXR6MkNpaWlzRFFLS0tLQUNpaWlnQW9vb29BSy9uay9hSC81SEd5LzY4RS85R1MxL1EzWDg4bjdRLzhBeU9ObC93QmVDZjhBb3lXdlF3blU4N0VmeFlmUDlEeXlpaWl2UUpKb0lHdUpGU01GcEhJVlZIVW12b240YS9CNDJXa3pYdDFiTkxJMGV6S2pQSnhsUjZrWi9XdUcrQVBnWmZGZmlrWE56aGJTeFh6bmR1Z0k2WnI3Y3NQRm1pZUhmRldrNlZMYnhyYldDUnl6SU1ZZlB6c2MrNElyb3B0UVhPOXo5RDRleStFWVBGVmxkdjRmTHpLUGczNE8ySGhHM1dYVUxLTzFtczdVNmplZnU4Zlo3YkdSay8zbXhYbkdzNlhxZmpIVXpQSkMwTXR5R25qVXJnMnNIU010NlpHVFhvZW8vSHRQRlBoalY1WkQ1a21zYW8wazZjWmExaXhzUS83UFFZNzE1NU44YnJLVFZKclI0eXR1Y3pYdDBtT21NS285ZG80VWZXcmhXY3R6N2gxVkZLNTUvd0NKL0R0cnAxbkt4a2ROTWdKaldkdXQzUDNLKzNTdkpiK0lTTzBuS2J6dFFEdlhyWHhFOFFhZDRtdkxhOHU1VHArbVFSNVcxais4cVpPMVFQN3pkU2ZldkxkVXV0OXlyaEVqbW40aHQxT2ZJajdidjlvODFwS29sb2ZQWmxWakpxTFpoMzBiUWxQTGJ5MkhWbDRKcnF2RHVzMnR5YkZGTTJoYXhidis2MVRUNURHU2UyN0dNYzk2NXJVUUdrWUQ1aW9HU0tmSkdMQllneHlEaHo3VUtuVHJhVk52Nis4K1ZsQnhuS1VYb2QvNCsrTlBpcldiRmZEL0FJM2pzdkZTV3dBdDlUbmlDM2kraEU0K1k0OUd6WENXMnAyRm9wbHYwa3VwbVVHM2dpSUlrT2VBNS96bXVqL3NxTHhYb2t5NURNcTdra1AzZzJNWS9Tdks1VWt0WkhqSktzakZjSHFDUDVVcFlLbmwzOENLVVgyMnY2YkhsNGpGVmFiMGQwK3IzKy9kL00xdFU4UWFwTHFzVnc1a3NyaTJjUENrWUtlUVFjakE2akhCcjZMOENmOEFCUWo0ZytHYnF6VFdiTFRQRTJteG9WbnRwME1Vay9HTW1WY3NEeG5nYzE1djhOL2pOcGVtUVcrbGVMdERnMXJUMWNEN2FJMU56RW5jWlAzdnpyM1MxK0Ivd3grTEZzaitEOVEwKzl1bi9lL1pMZWMyMTRBZjRTajhNZnBYeDJaNHVsR1grM1VHNHJhUzFYL0FPN0E0U2VJaTVZYkVKU2U4WG8vOG1kdDRtL2JjOEErTjcvU2RJVFRJN0t6bDAwaTQxVzhRN3JTNWZPNVlpQVdWUU1mTnpubnBpdTV0UGlUOFBQRzNnai9oR2ZHR3NhUDRuME9jS0w3Wk1JTnNpOUpvbXpsR3hqUHJYejU0Zy9ZamtrdHd1bjZmcm1uM0FQekdaRm5YQTY4TGpGZVcrTGYyVlBIWGhyelpMV3htdjdRSDVUdDh1Vi8rQUU4L2dhK1hlRnl2RnlnOFBYZE9TMnYramY4QW1lOXk0L0NVWlJyMEZVVDZwM2YzZjhBN3Y0by9zNi9DSFNycVc4OE1mRnkwZTBubHpEYTNFUG1OYnFlaXN5a2xzZE00ckZzdjJOdGExZTdoa3N0WnR2N01PTjl4TWhWeU91VVh1TUVkU0Qxcngvd3o4THZGdmpMWEo5SjBiUXIyNzFPMlV5VDI2eDdYaVVmeE1EakFyN0srRG53YytLWGhHeTA2WFV2RmNQMmNqOTdwVjRwbUVZOUFTYzV4WHNZL0YxTXNweFgxcFNsMmtsZCtsay92Wjg5aDRVTVRKODlCcGQxZjhiMlBxVC9nbkpvWThNUWVQTkdXVXpycHk2ZGFDVXJ0M2lNWEtic2RzNHppdnM2dmtmOEFZVGpNWGlYNHJveEJaYnUwVWxSZ0g1N3JvSyt1SzlUbmRSS2I2cGZranc2Q1NqWmQzK2JDaXVQMVQ0eCtBTkU4UjNmaC9VdkhIaHV3MTZ6aGU0dWRLdXRYdDRycUNKSVRPN3ZFemhsVllRWkNTTUJBV1BITmFYZy94NTRhK0llbVM2bDRWOFJhVDRsMCtLWTI4bDNvOTlGZHhKS0ZWaWhlTm1BWUJsT001d3dQY1UrV1J2ZEc5UldYcC9palI5VzFyVk5Ic2RYc0x6V05LOHIrMGRQdDdsSHVMUHpWTHhlZEdEdWozcUN5N2dOd0dSa1ZWOFllUFBEUHc4MDJMVXZGWGlMU2ZEV25TekMzanU5WnZvclNKNVNyTUVEeU1vTEVLeHhuT0ZKN0dpMGdONml2TXY4QWhxRDROZjhBUlcvQW4vaFMyWC94MnZROUwxU3kxelRMVFV0T3U0TlEwNjhoUzR0cnUxbFdXS2VKMURJNk9wSVpXQkJCQndRUVJRNHRiaGRNdFVVVVZJd29xcnFHcDJla1c2VDMxM0JZd1BORmJyTGN5ckdyU3l5TEhFZ0pJRzU1SFJGSFZtWlFNa2dVU2FwWlE2bmI2Ykpkd0pxTnhESmNRMmpTcUpaWW8yUlpIVk01S3FaWWd4QXdESWdQM2hrQXRVVnpIalg0b2VEZmh0OWovd0NFdThYYUY0VisyNy9zdjl0NmxEWitmczI3OW5tTXU3YnZUT000M0RQVVZWOEhmR1R3QjhSTlRsMDN3cDQ0OE5lSnRSaWhOeEphYVBxOXZkeXBFR1ZTNVNOMklVRmxHY1l5d0hjVlhMSzF4WFIyTkZGRlNNS0tLS0FDaWlpZ0Fvb29vQUsvbmsvYUgvNUhLeS82OEUvOUdTMS9RM1g4OG43US93RHlPVmwvMTRKLzZNbHIwTUoxUE94SDhXSHovUTh0SFdueEtaSFZSOTRuQUZSMVlzQi9wY1hydkdQenIwQ29MbWtsNW51M3c0dlpmRC9oSHhCcGtVZjcyUzFhUjJUcXhCUWdmbG10eTQxVFVmRld1YTFxZHQvcXA3TkVEazQyZ3hxb0krbUNLd2ZDWDJtODF5UjlPVmt5dVp3eTdsalVLUXplL0hPSytzZmhyOEVQRFBpYnd5LzJPNm5tZVV4M2NHcDJzWkVTeHFBRjh3OU51OFBrZGVCV05ldEdrbHpINi9UY2FWS0tXaWlySHpLL2huWDdXeCt3VDI3YWFwaFdRbVlFRXhOOTNqM05QMDc0UmVKcnF6VzdzckU2bE5JZk1odDA0TGc5R0tucWZhdm9uNG82RjRudGZpVDRiMFBWOUZndk5VMUZSL1pseEhONVVPb3AwYUJaT2djamxRZTVGZTAvOE1sM1B4QThMdzMyaTZycjNoWFZiVURmcG1ySEUxakoxd3JqaHV2QnJLZUtwVTRybGRyblBXeEZDRDVaejFaK1ovakR3ajRoMEs5RjVxOXJPM3pmTjVxRlJrRTl1d0ZjdzF5NGVReHVKYm1USWVYdGowSHBYNlYrSnZCTTNqcXdrOENmRWJUMXN2RThNWWpnMUNQNVUxR0pmdXR1N1AxeVBwNjE4ai9GSDRFTjRNdkRhMmRtNXM1V3dHUExnQWtmMHJsb1k2bldseXkwWjUxWEF6a25PbTlEd3V6UVNNaWpsU2NuUDkwZGFoMVM1TTF5NXpsT2dIdDJxN1BiSFQ3bTdTVjhTUU50QzFsNUR6YnNjWi9DdmVoSkhoVmJxSEs5enJ2QjkzL1oxcTAwcmJJRVB5cVQvckc0d0t4dmlMNGF1TGJWVzFPM3RKQnBsM2d4emdaVm5QVVo5YXJpNExzcTdqdEhwMEJydVBpRDR1dWZETGVHb3JQYkxabXhXYzJrNjdvL01KUHpZOWNZcjBjVTVQQzNncnROYm5GVmpTbkg5NjJrdXFYNkhqcHd2SDE2MVlzTlJ1ZEt1NDdteXVaYmVlTWhsbGhjcXluMXpYdEhoelFmQTN4bHZZN1NOcGZDL2lLWVorVmQ5dklRT2NEMVBOZWovQ0w5a0MxaThjejIvak9acDdXRUNheWlnKzVlRHRrLzByNHZFWnRocUVaTEVYakpMNFd0L1Rvem5lWFZrbFVvdm1qM1g2OVVlZGZCK1A0eC9FWFU1ZjhBaEZ0YTFZK1FBOHR4TmVPa1NnbjFKNStsZllQdzYrSEhqblNiNzdSNDY4WFFlS0xmeThKWlJvUXlranJ2OXZhdlJkSDBQVDlBc0JaYVhaUldGdkhoUkZDb1VjZHMxd2Z4TC9hQThGL0NveXc2bnFBdTlUWDVoWVdaRE9Eam94N2MxK1k0ek02K2ExSFN3ZEpKUFJXaW0vdjZIdlllVXNMVHZWcU8vcm9hTS93L1RUdGVoMVBSNytTdzFpT05oWjZrTXUweWZ4Vzl4L2VBSjR6Nm4wcTFxSHhPMGJ3dm90emUrS2J1RFJMeTBaWTdxMkI0WTQvMWtJUEpVL3pCcjVMMXo5dEhYdkZuanp3OUpZV3NPaWFGYTNzVHlXNi9NMG8zRU1YUHB0Sk9QYWwvYjd2YnhmaUJvbHZjeFF4cmRhYW1wUnJIMWppZDNXTkNlNDJvSCtzaHJ2cFpCaUs5YWxSeHIxYWJ1dFhwME1xbVlVdll5ZEpYYVorZ2Y3QUdzV25pSFUvaVpxdGc3UzJOOU5aWE51N2pCYU4ydW1Va2V1Q0s5MC9haC81Tm0rTG4vWW9hdi82UlMxOHovd0RCTGIva1RQRVgvWGhvL3dENkxucjZyK09mdzcxTDR0L0NUeFQ0TDByeEYvd2kxMXJ0bWJCOVYreExlZVhBNUFuVHltWlFkOFhtUjUzQXJ2M0E1QXI3OXdWR2FndGxaZmNqNWJEdHlwWDczL05uNVNhdDhSTDY0LzRacitEbHI0VjhKMy9oNi92UERQaVdXMm04TDNlZy93Qm8zejV0V2l1NUpqS2wzSEltQkplUndzc3VjcUNGS243ZHRmMnFQRHZ4Ri9aY2orTDN4UDA2ZndGNE5tbVo5SXRmRGZpNitUVmIrNWprdUlEYi93Q2pwYUhjeGpKVkJJNkVaZC9MRVJZZXIrSVAyY05OOFJhMzhNN1NYVVBzM3c5K0gzMmE4MGZ3dGJ3dHZiVUxaZkx0SjVyeHBHa2FPR1BJV0lCZHpuZEk4Z3dsWnZ3Ny9aaS80UUw5a2k3K0NQOEF3a24yOFQ2UnFtbGYyNzlnOHZiOXNlNGJ6UEk4MDUyZmFNYmZNK2JiMUdlT2lWV25KSTBVWkkrTk5MdHRiK0dXaGVFdkhWejRWOFphcHF2eGI4YWFVeDFPSHhyZUlyYVBlUWI3UFRJcDQ5VmdudUxxQ0w1Rm51NGtqREdSU3hRSTcrMWZ0UStFN1NQNGYvQWJUMzAveFhvVWVwL0YzUmZ0Rmw0aDhSM0Y5cWR2dUZ4RWR0MnQzTzBXVlVNdmt6L0x1M0RhNWF2UTQvMk1qZjhBZ2Y0ZStITmMrTFBqTFVJUEJFMm5YdWxDMXR0SnQ0cmU4czR2TGdsUlRZdTVWUVd3a3NrdkJHNHVSbXRUNDAvc3VhaDhZdkEzaHZRTlM4ZXo2MVBvbmlpMjhTcmRlTE5GdEw2SzVXR0tSUHNVdHZhcmFJMExHUWxzNVlnc3BPQ05vNmtXMDcvbUhLN2JIemZjZkd6V05SK3dlQlBFM3hXMTNRUGdjTlh1ZEowdjQxYWNqd1gvQUloa2k4Z1FXQnZnclJ3K1hJODRrMURhSTdwYko4RmNUTTMybjhRUGpmNEorRm5pYndmNGU4VDYxL1plc2VMcno3Qm90dDlrbm0rMXo3NGsyYm8wWlUrYWVJWmNxUG02NEJ4eDJvL0NQNGdhdjRTVHdyZmEzOE1MM3d1a01WdXVpWFB3N3VKTEpZb2lwaVFRSFZTbTFDaWJSakM3VnhqQXJlMXY0UjZ6NDF1dkErcCtJZkgrdWFmckhodThlN25pOEd6UHBHbWF2bVdOMWl1N1YzbmFTTUxFcUZUTHp2bDVBZkM1emNKVy9yOUNrbWowMmlpaXVVMVBGZjJxcnp4TGFlQ05CR2c2VHBXcFF0NHA4UHRjUHFPcVMyYlJ5cnJkZ2JkVVZMYVlPcnlmSzdFcVkxK1lMS2ZrcjVSOFUrTFBHTnZvZXFYcTM4SHcyZjhBc0w0cDNlbFRSWDZTNnpjeXg2d2x6TGFoUXZsVzh5UER5OE10eVRGSE95R0p0c3FmYy94RitHVmw4VDdld3NkWDFYVnJmUmJlWmJpNDB2VGJoYlZieVdPU09XM2Q1MFVYRVRReXhKSWhnbGlPNGZOdlg1YTh5dHYyYmRjOE5YMWt2aHp4RDRibTByVEpyNmJURjhYYUJlYXplMjV1NytMVUovTXVQN1NpV1poZHdSU0pJOGZtSjVVZVhaOXp2MVU1eFNzekdTYlptZnRUYW5xZmczNGlmRGJ4UGJYZmlUVHJLV0srOE1yY2VGWmRHKzJ6WDEvZGFiOWt0aEhxWjJPcm0zbFltTlN5K1Z1WXFnYzF3djdJZW5lSllQaVI0ZjBEV244U2ZiZmh6NEtidzNyZGhyOXhvalJhWmVYQ2FUTkJIYUxZdDU3d3ZGYnlFU3o3c2lJTHUzaVFWN3F2N091Z0hVL0RsM2MzRStxejZYRFpwZWFycTJiclZ0VGF6YTJleldTOVk3bzRWbnRsdVpJWWxSWlp3c2h3R21TZXl2N1AzaFBVZkhXbytLdkVHbVdIaURVLytFalR4SnBFdDNhRGZwYzQwMjBzaUViSjM1K3lMTHlBQS9sbmJ1aFJ3S2NWSGxIWjN1ZW0wVVVWeW1vVVVVVUFGRkZGQUJSUlJRQVYvUEorMFA4QThqalpmOWVDZitqSmEvb2JyK2VUOW9mL0FKSEd5LzY4RS84QVJrdGVoaE9wNTJJL2l3K2Y2SGxsVzlNa1ZMMkl2OTBPQ2FxWXpUazRiMHIwQndseXlVdXg5c2ZzWGFub3NIeE04UDZacnFSb1p0V1M0bGttQTh0bE1iSWlNVDJKYzhkeml2MWorR253RjhNL0RMVGRYc05KaGM2UHFKM3ZwczNNY0p6ODIwZFFEeHg3VitSbi9CUDdXZkRtcC9FVHhGRjR0MDY2MTZOdEdLUjJGakFaWmlGZFQ1cUFkR1RhcHlPUlg2dWVBdmp0NFcrTDBkM29YaFBYcnUzOFFhVkVrMXhaYWhaU1c5MFVHUmdySUJ1Qnh5Um5tdm5jYmYyMTdhSkgxZU54VHhNSWV4YlVYby82OGpvUEdmd0E4SStPZEQwYlRkUnM1REJvMnB4NnBhTXJZZEpZMjNLRmJxRjRBNDlLN0xYbmpuMHlRK1ZsbUFiSGZqb0s0WFQvQUJ5L2gzd2RlK0svRjhrMm5NeUhPbXFONVhZU0YyS09TekRGZUh4ZkZMNDEvSFhWV3RmQ21rMi93dzhQcytZYjNVNHhjNnBMRmpoL0t6c1FIbnEyZmF1R1VvemgyUjVrYUZlVlQzbmRSNjlQUFUzdmlqWlIzK3BlYmMyQzNDSW9aR2FNNWpiSjVCN1Y0YjhRdkRsbHJsckxGUEZ0UGxsdzQrOXVyMDN4QjRIOFFlSEpVWFhmR2VvZUlMaFcyU3lpNFZkell6OXdEZ2YvQUY2NS9YZEtqbGdWZ3pTb3h3SFk1T0s4cHYyVlRtaWZwT1h6dkNON2FuNWovRlRRYkRTZkZGeGFHRjRIREhMTi9GNzF4aDBCV1Q5M0tWeU9DZVZiOHErcGYydHZBcXBaL3dCcVJXeXVZbUN0UGpCNzhlOWZLbHJGSTh3UVRlVW5RZ252NkFldGZvZVgxZmIwMHp4Y3dwVTZWYTA0M1RFbTA2ZXpoSmxVSW1lWkJ5djUxSjlrMTc0dWVKTFN6MG5UNWIyOGpnamdqaWhYTzFSeGsrZzVycEw2dzE3dzNwMWpKcmVqVFE2WnFjVHRiTlBIanpsQndTUHBpdm9QOWpmeGg0TThQLzJsb24ramFSNGl1OHZEcVU4Z0MzRVdPWWR4KzYyUm44YTJ4K0tuU3d6blRYTWwvVi9SSHpHWVVMdzVxTjdMZFBkSFRmQUQ5bE95K0Z0MWFlSXRmbEdvZUlZaGxiYkg3aTMzRG5QOTQ5UlhyT3ZlSG9MRWZaWTdzMnNNMGh1TFp0NDg2emxIekFxT3BqUE9mclhrUHgzL0FHdnRMK0hkNU5vM2hkSU5ZMXVMSWt1QWQ5dkJucU0veEVlM0ZmR21zZkZ2eFY0ZzhVcjRndmRadVp0U1Y5eXR2SVZQOWtLT01kZUsvTlpaUmpjMnF2RTFwY3F0cGZYMDlESEFaaEhCcEpLOTNyNW8raGYyaHYydVBFTFhOMzRYME8zVFNCNWFDN3VsL3dCWXo0NTJIc3BHRCtOZkoxOXFGeGYzTDNGeks4ODduTHl5TnVaajdtdlN2aTdvRStyTlkrTXRQeGQ2UnFrRVN5U3hjaTN1RlVLOGIraDQzRFBZKzFlWCtXV2JIR2ZjMTlobG1Fb1lTaEdOS0tUNjI3OVRoeGs1VHF5dTlPbm9YOUMxQ1BUTmEwKzhtaEZ4RGJ6eHpTUkgrTlZZRXI5Q09LKzcvd0JzSDRiNlorME44UDdENHllQUoxdkxhd3NZcmU3MDZNN250NEZYN3VCM1FzdyttSytBOXBWUWVjSGpJcjBINFEvSEx4WDhFOWUvdEx3N2U3STVGTVZ6WVRqZmIzTVorOHJ4bmprZDYweG1HblZuQ3ZSZHB3dnZzMDkwYzBLaWluR1d6UDFEL3dDQ1c2N2ZCM2lNWXhpdzBjWVAvWE9ldnVTdmpEL2duRnJpK0pyZng1ckNXc1ZnbW9wcDEydHJDTUpDSkJjdnNVZGdNNEgwcjZ4OGVlTUxMNGVlQi9FUGlyVW9wNTlPMExUYm5WTG1LMVZXbGVLR0pwSENCaW9MRUtjQWtET01rZGE1NnJjcDNhMTAvSWVFL2hMNS9tYjFGZktQaGY4QTRLS2VFUEdueEYwandKbzNnRHgxZWVLOVdzNGIrejAveTlNVHpZSmJNWHNiK1kxOEVYTnV3ZkRNQ003U0EzRmUxZkNUNDZlR3ZqQjhIYkQ0bTJEVDZKNFl1b2JtNGFYWFRGYnRiUlc4c2tjcnpFT3lJb01MdG5kZ0x5Y2NnUzZjbzdvNmxKUFk5RW9yNTQ4TS90My9BQXQxMzRYMjNqKytUeFg0YzhOUzd0OTdxZmhYVVh0NGNUbUFicm0zaGx0emx3QU5zcmNzRk9HeW83cjRxZkh6Ui9oVDRhOEhheGRhTHJtc2Y4SlhxOW5vZWw2ZlkycVFYYlhWMGp2Q3NrZDNKQjVPZGhVaVFxeXNRR0F3Y0hzNXAyc0hNajAyaXZsSFR2OEFnb3A0UTFieE40MjhQV3ZnRHgxTHJIZ3V6dnIvQUYrMjhyVEI5amdzM0NYTDdqZmJaTmpFREVaWXQvQ0NLK2tQQWZqQ3krSWZnZnc5NHEwMktlRFR0ZDAyMjFTMml1bFZaVWltaVdSQTRVc0F3RERJQkl6bkJQV2lWT1Vkd1VrOWplb29vck1vS0t6TmMxMyt3L3NETllYOTlEZFhrZHBKSll3ZWQ5bTM1Q3l5S0R2OHZmc1FzaXRzM2gzQ3hySkluazk3KzJMOEo5SjhlNmo0VTFUeGhwT2tYdGhxVTJrejNWOXFkcEhBbHpIYnd6bFcvZmIxVWlTV1B6R1JVRXR0TkV6SzVpV1MxQ1V0aE5wYm50ZEZjZGVmRkRTeHFla1dHbFFUK0pKOVkwSzk4UWFZK2t5UVBGZTI5dTFxdTJPVjVGUXRJYjJIeXlXQ0ViaXpxQUNjejRmZkY2NDhkZUxkYThQemVCZkV2aHFmUjRZM3ZMdlZaZE9sdG81WkFHUzMzMnQzTWZPTVpFaFFqS28wYk50RXNXOWNzdHhYUFJLSzh5Zy9hUitIZHZhVFA0aDhUV0hnZSt0cng5T3V0TjhXWEVlbVhFTjNIRkRMTENQTllKTnNTNWdQbVF0SkV3a1VvN0t3SnErQy93QnFQNGJmRUR3bGJhNW9YaVNEVjU1Tk9nMU9mUU5KL3dDSmxyRnBGSVl4aVd5cy9PbURJMHFLNFZXQ0hPVGdacDhzdXd1WkhxOUZlWitHZmp2WWVJZmhmb3ZqdTQ4TjY3b2VqNjFlYVpiNmZCcUF0R3VMaVBVSjdhRzJ1QXNOeElxeGxycENRekNRQkgrVE8wTjZaVXRPTzVWN2hSUlJTR0ZGRkZBQlg4OG43US8vQUNPTmwvMTRKLzZNbHIraHV2NTVQMmgvK1J4c3YrdkJQL1JrdGVoaE9wNTJJL2l3K2Y2SGxsS3A1cEtBTWtWNkJKN2IreVI0cjhXK0dmamRvc1BnZTdoc1BFV3NCdEt0N3VkQ3l3aVhHNXlCMXh0QnhYNlQrQXZpTjhSajhmVTBEeDdwUzYyZFBzU0xQeHJaYVU5aklyak9WWUZqNWtaT2VSanI5M09hL0p6NFRlTEovQXZ4TDhMZUlMYVkyMHVuYWxCY2VhcTVJVU9OM1hqN3VhL293dDdUVGJ6U1UxaTJJbHRMbUlYZHFjY0JaQnZCSHB4ajJydzh5dEZYYXZkSHI0T3Q3TzEvTmZlZWErTFlwOWZ2Tk1pbDNGT0pTckRjTng2ZStQOEFDdk8vSHZnYjRrK0tQRUZ4cDJpNjFjZUM5Qml0bmwrMFdESjl1MXViQjIyeU93eERuakRuTmU3ZmJJWUx1em5tQ2gzakIzays1UDQ5YTdHYlNMVFVZRUxvSFZoaytoOTYrZG9MbG1wV3Zib2VyV3hqcFUxVFNzbitEN241Zy9BejlqWHgrOHZpVFhmSFBpRHhYNFgxQ1djSnBlbHRxQXVKcytabG1ta09WWUJlTXFCM3I2cXYvQXNQZy93bXNNa3N0eGNNV2NTVG5MZ0hvRDI3WjQ5YStpN2pSN094czVKUEpRWjZxT250aXZDZmkxclN5U05Hb09HT0FQUUNxeHRhVlo2cXgxNVRWbk9mSkhhNThsL0c3dzdCNGw4SDZ2WjNNaGlVUk5KdUF6aGh5RGl2bnp3cjRTOElYL3c1MGZWYkx3ZkxiK0tMaTVpM2FsTEtaclpGVjhCa0dmdk1WT1ZQVDhxK3JQRVZuL2FDellHN3pWZEN1T3ZIL3dCZXZtMzREeTJOZytxNkJxczEzWWFmbytzM055TlZYL2oxc2taY256TTl5SXlGSHFhN01IS2JvdFIremJRKzN4a0tTcVFkVkt6Vzc2UFN4bi90RzZqWVdud1podG11SnBiL0FFdnhFWTdDUjg0VXZHcnpxcFBWZVY5cSthV3VJYnlTTVRSQWJ3Q0doR0ZiMXo2SDNyYitPSHhkbCtKZXRtMnNrYTE4TldFampUclJqbGdwUE1qbnV6ZGZ4QTdWd0ZocWJSR05KT1VCK1VEdFgxK1dwMGFQczZqMzEvNEIrZDQ3TUtkYkdTY1BoMFgzZjVselUvRHgzazJVcTNhQThvdkRyN0VmMXJFYUo0bUt1Q3JkODEwbC9hUFBIOW90bk80OWw3MWhLSmJxZElpclRTczJ4VXdTU2M5QjlhNktzZVY2SGlZbUVLY3JwV3Y5eDJ2d3orSm1zL0RscnlXMXRvOVMwVzZIazNsamR4NzdhWFBRblBBY1k0UFdyR3RmRW5SSnRabnVkUDhBQStrd1dMdUhqdHJneU9SMHlNcXk4SG5wK2Rmb3g4R2YyWnRFOE9mc3l3K0Z2RVdsUWFsTHFlM1ZkWHRwc3F6U0ZSc1ZYSHpJVlhieU9oQnI0bi9hWC9aYXZQZ3pMRnIyaXZOcTNncThZTEZkeUtCTmJTNHlZcFFPUG8zY2UrYTg1MDZVcHVUV3I4N0hoNGJPSTEyNk1YczlMMlBQL0diK0h2RVhoTzA4UzZkWVErSDlWTjAxcmNhWGI3dnM3cUZCRWtXNW1iZ2NFRTljZGE4Nlpzbmc4VlBOZnlUV2NWcTUvY3hNem9NZDJJeWZ5QXFzeEJPY1l6eml1bUs1Vlk3cFBtZHo5aC8rQ1czL0FDSm5pTC9zSDZQL0FPaTU2K21QMm9mK1RaL2k1LzJLT3IvK2tVdGZNMy9CTFgva1RQRVgvWVAwZi8wWFBYMlQ0NThFNlI4Ui9DV3FlR2RlaG51ZEYxU0UyOTViMjE1TmF0TkVTTnlHU0YwY0t3RzFnR0FaU3luS3NRZktxdmxxM05jTC9CKy84ejhHN3Z4RHJmd3orTnVnYTVwMEVFZXEySGhiU3J5SkxueEhlUXEwVGFCQStSZHJOYlRvelJNU3NFY2dBWXJieCtZZ1ZYL1MzNFplRXRmK01IN0YzaCsyMHZ3ZDRGdmREajFhTyswSFFiV1M1aXM1Tkt0NWR5Rzd0RXZIanVyMTVFbFpyUzR2QkNaWFF6eWg0M0ZlcjZqK3diOEI5WThXcjRsdi9oL0JmYXFzMFV5aTUxRzhrdGxFUVVSUkMyTXhoOGxGUkVXRFo1YW9xb0ZDQUxYYytIdmdGNE04SStIZFkwSFFMWFZkQjBYVkp2UGtzTksxN1VMV0sxYnptbUl0RmpuVVdhdEk3Rmt0L0xWZ2RwQlhBclNwWGhKSzI2Tll3YXZjL09pL250dkR2ano0bC9GN1hmREd1V25pSHdQcTlwSGUrSmJIdzM0YXZORlc3bHZsdUpJSk5QV1lPTGlONUk0VE5CZnozU2x3MHNzSi9kMTlEZnRRNmw0NDB6NFNlQjdYNHBhTlllTC9BQmRyZmlOZEwwN1J2QlZqcFkwWjc2WXFsckhQTHJVRjNJc2hqRnl5elJ3cW9MUEcrMGJaRytpTHo5bXY0Y1gvQUlKOE8rRHBmRG0zd2hvT3o3SjRmaHZybUt3bDJ5SktQdFZ1a2dqdS93QjVHcm43UXNtV0xNY2wySjNmaWI4SWZCL3hrMHpTOU44YWFIQjRoMDdUZFNpMVcydExwbjhvWE1hdXFNNkt3RWk0a2NHTnd5TUdJWlRVdXRGdE93K1IyWitMOWo0TUdwZU5mRWhiU0wveEw0cjhJN3RjOGFlR3JUdzNvR2hXbW5wcHNieFRtM3VRMXpGSkhITTZCNFV0Tmx5dVdkQ3dVajlOdkRQeDdtOEVlQ2ZnTFlhTDRmOEE3UzBQeHI1Y0Z2TjRzMTdSZEN2N0t4YVNCYmRvckszQ3hYUDdtZFNrRnNvWlZTTldBZDhWdTIvN0Jmd0F0ZFMxeS9UNFphU1o5WWhuZ3VVZVNaNG8xbGJjNXQ0bWtLV3pBL2NlRlVhTWNJVkhGZW0yL3dBSC9CRUdtK0ViQ1R3cHBON0I0UmhoZzBGOVF0VXU1ZE1XSlkxak1Fc29aMFlDR0w1dzI0bEZKSkl6VHFWb1R0b0VZT0oyRkZGRmNSdWVQZkhxSDdYNGc4QTZkWldsL0I0aDFpOHZ0SjA3VzdhNit6VzF0NXRoTzA4TjA4VWlYVFJtS0o3aEk0Q20rZXh0OTAwQkNTRDVjc2RMOFQ2SHFmZ3JUZkRkcDhRZFAwR3orSmZpYTMwaXo4TnhlR0l0UGhDTnJxN0xCTGtDVldWQklDTGtlV0ZFd1RueUsrOE5YOE02YnJtb2FKZlgxdDU5MW90NDEvWVNlWXkrVE8xdk5ibDhBZ04rNnVKbHcyUjgrY1pBSTRaLzJZdmhGYzNkOWQzZnd5OEo2bmZYMTVjWDkxZWFubzhGM2NUVHp5dk5LN1N5cXpuTHV4QXpoUmhWQVVBRHBoVVVWWm1UaTI3bmoveGkrR0ZocmY3VTJoNnpxZGg0VThGV050NGMxWFdwUEdxV3RwZGFuSjlrbDBqRnhJYnUxTU5ySmJraFVtYzNPSVRLQUlXWU1uTWZzNTZwOFFOQjEvd0xHL2kvWFp2QStvZUk3alJWMGZYTlBzWTdpWjJzTlcxQ1ZyaVNPMVNSN2lNcFlSWEQrYVgrM1E2bXNtN0NzZnFTdytEL0FJSTB6VWhmV25oVFNiZWRZYmFDTkV0VUVVSzI3Uk5DWTRzYkkyVTIxcDg2S0dJdExVRWtXOElSTkYrRWZoYncvcWVrMzluWVRpZlNvWGpzMG52N2llS0tSMmthVzU4cVNSa2E2a00wMis2WlRPNG1rRFNNSFlFOXF1V3djcnZjOER0ZkczeEkxVHdCNGFzZEIxRyswKzYxZnhkZitITkpGOWUyMXZxVnZIWmpWWG1qdjdtVzIxS09UeXhaQzNVb2tra24yZFozdUNiaDQ0Nm5oTFIvRy9nandGNHkrRlY4TlcxVFVkRzBQUUlQRGNGajRnZWVPMVc1dUxtenRTOXhZV0dtM1VjTVQyaVBjUHVrYnlFWWcvZlYvZnRhK0NuaEhYZEVzdEtuczcrMnRiTFY3clhyYVRUZFh2TEc0aHZybHJocDVWbmdsU1FiemVYT1ZEYmNTa0FBQUFXdkEvd244Ty9EelU5VTFMU0JxMCtvNm5EQmIzVjNyT3VYMnFTdkZDMHJSSUh1cHBTaXFaNWpoU0JseVRtbjdXTnRnNVdmRmZnMzRXK0piejRJL0NPMTB1Nm4xTHhYYytGb05YMEszc2RTbE1zZHJiLzJWcVVzcGJVR25oaFkzVmxwRmhIQW43bU0zRXQxNWJvejI4SDJwOEl0UDhMMkh3MzBPVHdVODgzaGpVWVcxZXl1THE0dUxpVzRXN2RycHBua3VHYVpta2FablBtSGRsem5IU3JYZ2Y0YStHL2h6WnJiZUg5Tit4UnJaMm1ucTBrOGs3cGEyc1FpdDRGZVJtWVJvdTRoQWR1K1NWOGI1WkdhejRTOERhRDRFdDlUaDBIVElOTlRVOVN1ZFh2akNEdXVieTRrTWswMGpISlptSnh5ZUZWVkdGVlFJcVZPZlFxTWJHN1JSUldCWVVVVVVBRmZ6eS90RC84QUk1V1gvWVBUL3dCR1MxL1ExWDg4MzdRZ0RlTkxMUDhBejRKLzZNbHIwTUoxUE94SDhXSHovUTh1aVV1NEFCWWs0QUE2bXV1OGVmRExYZmhyRG9yYS9hZllMblY3TmRRZ3RaRCs4V0JpUWpzTzI3Qkk5cSt5UDJNUDJPL3M5cFpmRUx4eHA0WjVHRDZObzl5dkxkQ3M4aStub3A2MTRSKzNiNHF2dkV2N1VYamlDOG04MU5IdXY3SXRWQUFFY0VBMnFvQTk4L25YZGYzckhtMDhaR3ZYZEtucW83czhTMExUanFWNFU3S3JIUHB4Z2ZyWDdxL3NiL0ZWL2pqK3lsNGVtZ21XUFd0TXRQN0Z1MGpQRWNzQzdZd3c2L05Ic1A0MStKWGc2Mjh1eHVwU0FKSFRJOWdLK3cvK0NkSDdRc2Z3ZStMYy9oclY3cExmd3g0dkNSNzJQeTI5OHY4QXFuUG9HUHlrL1N1SE1NTTYxRG1YUSsxcDRSMDhOQ3JGWGx2L0FKSDZCM0hpVHhOcXR3bWsvd0JqUjI5NVpxSXBKQ1NNcjJZY2M5YTk1OFBDNXN0QXMwdS9ubVdJYmpYenQ0OStJUGpqdzc0cWVKN3EyMHUxbEFhSzVodFBPTEU5WS9hdXg4RDY1NDMxTzl0WnRUMUtPYlM5aERNOFd4M1ByaXZrYWNWQmMxOXoyOGJnWjFzUENmdXhXKzd1L3dBRDBYeGZxM2syVFlPMUFPY2V0Zk0zajNVRGRTWjNjZ25GZXNmRWJ4QVlyYnkvTTYrbmV2QnZFZHcxd0habUNBWndTZWxaTzlTUjM1UGh2WndVbWNHK3FHWFdMbUJFeGJhZHNlZVZqakcva0g2WUZmQ254TnMwazBOOVRpbG5TMTFiVzlReWl1UkhjUnhsTnJZNzRMTmdtdnN6eDM0VzAvWEVrdXBJcnBWa1VXMDV0SEt0Tkg2TUIyNU5mT1Bpend2Y2ZHenhoRDRjOEo2WWJEUXZEV215eEkvUGxySnl4eVQvQUJNUml2ZHk1MDFPL1RxZTFtTVhPbW90WHVmSk43YlBiVEVNUHhxdjcxMnQ5WWI1R2l1b1RESXBLbEdYYWVDUVQrWUkvQ3NXKzhPdkV2bVJBc21BY2Q2K3E1Vzd0Ykg1WmlNQk9IdlIxUlcwclZwTENkR1lsb3M4clgxeit5ZCt6MGZFSGpuU1BHK29hZTBlaTJyaTRpczcyTWczRGRuQVA4T2NZOWNHczM5ai93RFpISHhFMWQvRVBqU0EyMmgyREl5YWRJQ0pic25rSEg5eitkZm9rdHZielJSeGVRbHZCQWdoaGlpWGI1VWEvZFFZN0NzWlZuYmtQaE0yenIyVUhnNGF0OWUzb1g0dFNpSW5pbmtCM0wrOFBzYTgvd0JiOE02VHJsdHFmaGZYYmRiN1FkU3dqd1NINVZQTzF4NkVWc1c4NXQ3MmROVXhCQ2NDSzZIS3FNOUQ3MWk2K0o5TTFLNWprelBiOFljZmVBNmcvd0FxNVpLK2g4bGhOSHpSWitYdjdSM3dZdWZnaDhTNy9RaXNqYWVUNXRuTEoxTVp6Z0Urby93cnlvbnBYNnovQUxSSHdrMHo0N2VCRVo0bzVOVG5zV2F6dmY0bzdxUHFwUDhBdEFxSy9LVFZkTnVOSTFLNXNyeUl3WE52STBVc2JEQlZnU0NQekZiMHA4OFZmYy9RY0ZpZmIwN1A0bHVmcjEvd1MwLzVFdnhGL3dCZy9SLy9BRVhQWDNOWHd6L3dTMC81RXZ4Ri93QmcvUi8vQUVYUFgzTlhsMS80alBZd244TmZQOHdvb29yQTdBb29vb0FLS0tLQUNpaWlnQW9vb29BS0tLS0FDaWlpZ0Fvb29vQUtLS0tBQ2lpaWdBcjhtdmduK3pQYi9GYjRwVzNqWHhCSEhQNFgwU0ZJaGJQejlxdVZabkNFZjNRSFFuNjErc3RmQ3Y3SzA0dC9ocnFjck1SNWVxU3NCNytURFhvNE8xNVhQbDg4clNvVW95aTdicjhqMmlLNmlPdW9XQTJXVVp1Q3ZSUVZIeUlCNmRxL0tIOXRMd0xlNlgrMDk0dG1tK2FIVjV2N1hXWEdGS3lqY1JuMk9SWDZrNmJNaldtcHlUdUJoVU80OWNGam5OZk52N1Zmd3huK00rbXl6NlJIR3VxYWRFRGE1QURUSW9PNEUrK0RnVjBRZk5PNTh4dy9XakRHcjJ1a1hvLzAvRS9QbXltU0NjUkxoQTZGUUthSmlzREtDVmFOOTZNcHd5bmpvZndGWXVxM1V0cnE2eE9qeE5iTjVjaU1NRldCK1lmbldyTFBHakNZTm1OMUJiMnJ1VHVtajl4cFlxRlJPSFNKK3VIL0FBVDEvYUl0UGpoOE5MalEvRnNzTjU0eDhPRllaR25JMzNWcHhzbUdlNjhxVDdDdm92eEw0cjBqU2JZcmFNdThER3hPY2M5TVYrQ3ZnL3hYcmZnclhZdFo4UDZ2UHBXb3A4cTNGcXg1WHVEanFQYXZROWYvQUdvZmkxNGdzRFpYL2krNEVNNDhzdkhHcU1SL3ZBWnJ3cXVUVHFTZFJhUk1ZTlJselN1MTZuNmNlS2ZHVnJOZHplWmVSdTZNQVk0bkRrRTlNNDZWNXRxT3B6YXJPM0JFV2Z1LzNoWHpIL3dUNXU3dnhKOGI5YzhOYWxkelhkamU2UlBkT1o1REkzbXhGU3JBbi9lTmZlbmluNFdmWjQ3Zit6VkR0eVdQQXlLK2N4c0hoWmV5aHR1Zlc0REcwWEgzbFovZ2VVejJyclpMc3lvem5jdlgzRlZiYTA4aEpZNElVaTh3N2lJMEMrWTNZbkhXdXUxYTErd09sbTZiWFg3dzlEU2FmbzBsN2RpQzNqTHpkV0RjTEdQN3pIc0s4bFRrdEVlMU90R01IT2JTUzF1K2g0ejhWUGhqbzJ0UjZmY3krSEliMjFBK3dYa0ZyRUJORWpzV1daQ080Wm16OWE0aTMvWk8wYjRkYTFEckdxWGphdnBqTjV0dFl1TWhDUUFxeXQzOXErc0lvYlhTWTVJNDhYVXpJL25YSXp5dTNsUjZET09hNHo0a0cyOFBmQ3lDMzFGc3p2REZBZ2NqTDNFaCtRZlZSelh2WU90T2xpSXR5ZnZhTlgwOWJINUxtdVpUeGszOVdqeXcydnMzNkxvanptTHhWcXNXcExjMmN3dEpGakVleEJnQlI5MGZnSzdqUVBpcnFzS24rMElWdUY3bGVwOTY4NWloa2lJYmFTL1FuMVBldHUybVFvRWxHeGh5UGV2dXBSaTlHajQvRllHalZYdlFUUFpOTzhZYVhxMm15TzUvY29NdkU2OWFxK05kWnNMSFc0SGU1RFEzZ1NOZG95VTQ0RGVsZWY2Wkl1a2Y2ZmZiWXRPaU84TDNsZnNNZmxXSEZycytxbTUxQzd0REhiVHlsa2tZOE4yQ3FPLzRldFlPaXU1NDBNcXB1VjROcEhybmh5M1o3TFhOTGdkV1J5TDJ5Mm5PSFVZY0Q2aitsZkFmN2RId3NQaC94bmFlTUxLRlYwM1hFeE1VSDNMbFJ5RDZaWGI5U0RYMlA0SjhUdjRldjRmTlhiQVpnNnRuUGxrNEJVK3hBcFAyZy9ocmEvRVh3UDRpOE1FSXBrVTNtblRIK0NSY3VNZlhKRmNTVHBWTFBacTRVdWZBNGhjK3pONy9BSUphL3dESWwrSXM5ZjdQMGY4QTlGejE5eTE4UGY4QUJMeUpvUENmaWFLUUZYU3gwaFdCR0NDSTdnR3Z1R3VHdi9FWjlwaE5hS3Q1L21GRkZGWUhZRkZGRkFCUlJSUUFVVVVVQUZGRkZBQlJSUlFBVVVVVUFGRkZGQUJSUlJRQVVVVVVBRmZCZjdNN3FQaFpxYW5HVHEwbURuN3Y3bUhKcjcwcjgyL2dUYzZwZmVHNXRIc1ZLUVBmU1RUVEFjS0RIR09UL3dBQnJ1dzIwajVMaUdQTlJpcjIzL1E5NTAyUk5YdU5WMDFTZ2dGc0dTVWtEenBCa2hSV0xvSGgyL250NDd5ZFhzQXJaak1pNFptejBLbm5GZEJvTmhGcDJ4WUZScGxHN3puNTVHTVkvR3RyV2trM3czNFpuczdzYjhzYzdKZjRrSDgveG9WVlU2bkwzUGc0MVhUcE5VMTh6NHUvYUkvWWkvNFQvd0FjVzNpcncxTkJwMFYvZGdhMWFFaFJFUDRwb2gzeno4dnFhK2VmamY4QUFXWDRNK0lvTE9lNmUrOE5haVQvQUdmcXJKallSMWlrSFpzWS9uWDZXNmhJVnUyT1NNRDE2VjU3OGJ2ZzdMOGJmaC9KNGNqMVNQUllaTG1PNGt1R2c4NWlWNkJSdUdNNU9heWRiRVJ4RUpRYTVGcEpQcXU5ejdMS002VkNDaFhmby8wYVB6T3ZQQ2xycGVKbzlROCsweVZNa0J5MExkd1FPdjRWaGlXV0dSbE0zbndKbkRNTVpIcUsrazEvNEo0ZkYyOThXVGFQbzlqWTZuYVJIOXhxNzNYa1c3cWVnOVZiMUJINDgxOU5mQ1QvQUlKdGFONFF0N2ZWdmlacTZhL3FpcnhwVnR4QWpEbllDUHZEanJYZFh4OUtpci9oYysvdzgxaVduU2QxK0JnZjhFNC9oWmFlR2RZdGZFZCtyTnJtcmFWZHZGdUdQS2cvZDhFZS9YOGErL05QaCszYWpIOGhNU0RleEkvaHI1eS9aOHRTbmk2TzR0N1dRV1kwT1NPRnZMUGx3cTF4Skh0ejZnUkQ4eFgwMXBrOE1lblR3VzdwTGRUTVZrZU53M2xBWXlHeDArbGZuN3J1dmVyTjZ0di9BSVk5bXRKWWFEazlqaVBGSHc1dHZGVjlKTEFvdEoxYkJtUElVWjRZL3JYRTZ6WmYyVmJIVHRPdGJpMTA5TjNtUE45KzRZZFpIYjA5QitkZTBhcjRqMFR3TERHdXFhakZieXlZOHUwWWhybWQ4SEFWTTU1eHdXd3Z2WGp2aWo0aUo4Uko3clRMSzBOem9zSjJTMlFZSUo1UUFTbHpNTTlNZ21PUElJSStma2djL055UG1hMTdIRlZ4VlRFUVVha3ZjWFQrdXB4OXJkV3phZkxxVTBnL3M2SnNSc09CY09PY0wvZVg2WjVCckMxSFJ0UDhjU3hYMnY2Zi9hRVNFeVdscmNNVUVURWY2NEFkSlBUUFFBVjNsejhNZFUxU2EwdjdxVDdTMGFBUVE3UEt0N1VEb0k0aG5BSEl5YWQvd2dHcnZkN1pTaWwrUVM0TE1NOUFLN0tjM0dYdEc5VHlaMm05dER5Vy93RGhoZExKTE5wbDdGZVJmdzI5MGRrMzROMEkvV3FYaHZ3eGNTNnE5cGZXRjdDeXZqQnQzS2x2YVFBcmozelgwQS9ncTIwVkVrMUErYTZqSzIvOGYvQWlPZ3JtZkVIaXk4aUpoODQybHFwQWpnaU9UMS9XdmFobTlXSzVaV2Z5TXBZZU0vSThtOFZwb21qWEFudjdtTHhITjVtSXRGdEpoNWFuL2JaYzgrMVlXdWFyZHJQYmFoclppYStaTnVuNk5iSUVnc0krM3kvaWZmTmVqYTk0WDBLMGNhdGRhUEREcnNqK2JCSEN2bHlMalA3eVRISDRlMWVRZUtOSTFLenZ2dDk1TTk4OXcyNDNlTW4vQUhXSGI4SzliQ1kybGlHb1Nldm4rU0pqUVNYdUltdHRUMlRlWE1kNlQ4TjllMzByMEhSUEZuOW82VHBzVXZ6M051OGtEU0hrYlFBVkh2MXJ5THpjc3luQ3NyZnc5UHJXN28xNk5NVFNaU1NJNVo1bzJKOWRpNHIxNmtieFNlNlBNeGVGVmFOK3A3Lyt3bEdrUGlUNHJSeHFFalc3dEZWVjZBQjdyQXI2NXI1RC9ZTGZ6TmUrS2JmM3JtelAvajExWDE1WGlWLzRqTzNBSzFDSzlmekNpaWlzRHZDaWlpZ0Fvb29vQUtLS0tBQ2lpaWdBb29vb0FLS0tLQUNpaWlnQW9vb29BS0tLS0FDdmh6OWsyM2p1UGhycW8yQXlEVlpOeHg5NVBKaDQvbitkZmNkZkRQN0pONTlrOENYcFBLblZaTWoxSGt3MTZPQzNrZkk4UXE5R0h6L1E5TGxSYkcvTzBaQkhUMjdWMHVqRmRTc2JyUlpTQUpsODZCai9BTTlBT1FQVHBYTTZqemZUSHBsOHJqMHA5cHFFcVhFV3c3V2lZUG42VnpZdWtwNjdOYW41L2g1dU0rUzE3Nlc5UmRPOEhYT3QzYkdRK1JHajdKTStvcnVvZkRXamFURXFyQ1pwRkg4UjcxV2wxVkk1UHRNT0ZqdUFHSUhadS84QUtvb2IxNzI1SWpHN3ZuMnI1cXBpNmxSdld4KzY1UGtHRW80ZU01UjVwUHEwbjh2S3hveTZ4TmFxWXJiL0FFYUxITVNEakhyWEZlUHZpVkhZM05wbzlyYVNhbHIxMEQ1VnJBUW9oVG9aSkpEOHFqcndhNlhXbGF5dGZNREY1ZVFxanJuR2Z5cjQrK0xIaDN4VjQzOFFYajJOMExUUzdpSUc1dVJMdDh4bEpHR3djNEhwNzE1VlN2VFUrU1V2VS9SOG95K2hpNnloT1NoRkozYjBXaS96TzM4R2F4YlhIaWFYd0RvV3J5YXRMOXNCWFVOR3VKSXZzaWtscFRJU2RycUNNZktCOTQxMlBoL3hGcm5pbnh6NVBoaTYvc1h3WHBFalNQYzJjWk10OWVnN1dUYy9MeGdjNXFINEEvQUpmQTNoYWE3UzdMNnRyY0FqYTYyYmZzOXVPU2k1NUJibm12YjlMOE1XV2p4UXhXOFNwREVQa1JCaFJ4L25tc1lVNmNwYzhMcFBwMDlUeWN5V0VlSm5IQnZtcHdYS205bTltN2ZrZWRUL0FBZjAzVzVOY3VMblRwSjlXMStPT0xWZFV1YnFVM0V5SURoRk9mM2EreVk2bk5lcWVITkZzOUIwNjFzN1MxaWhodG8xaWhpQ0FMR29IUWY0MWFpaUhCWmlxK21hWmRhZ3NCMlJnTWNaNXJwazlibno4cWRPTGR0ZnlOS2E1alJjc3l4SjNsY2ZkK2xjNXFPdkxaK2F0aEdvWnhocnVVWmR2OTBkcXl0UzFkM1krWTI0am9Pd3JGdUxwN2hnekU4SHAyeFVFckNxZXJLZXNhdUxXTnBwWkdBWE82V1U5dmMxeTBRdDlIaGs4UWFtZk92SEdkTjA5aGtqUEhtc1BUMEh0NzFQNGoxVzJFaXZjRVNXa1IzR0E5Sm1IUUgyNlZ4TjNxTnpxbC9MY1hqbjdSSzJXQTZJT3lqMEFHSzI2SFBLbHp5OW10SXJmejhoYjlwZFhtbm51V2J6WmVwSk9UK05aVWxuOXFobHRKRHczNWZoV3lXeVIyOXF6emxidGo2aW9oSndrcEo2bnBPRVlxeVI0eHFkdWRQMXk3dDhrQkd3TTFjZ3VEUG9HbHVmNE5Sa2p5ZW1TaVlxVDRpUWl6OFlsc2ZKTkMwMlBVQVlxdlpOdDhGYU5iUXI1OTVxRjg5ekVvNnFpb29INW5QNVYrazBhbnRhTUo5N0h6bUlnb3UzbWZTdjdBdzI2ejhUeG5PTGl6R2YrQlhWZlgxZkgzN0FNTDIycWZFMkdRNWtqbXNrWStwRFhRTmZZTmViWC9pTTVjSHBSWHovQURDaWlpdWM3UW9vb29BS0tLS0FDaWlpZ0Fvb29vQUtLS0tBQ2lpaWdBb29vb0FLS0tLQUNpaWlnQXI0Uy9aV0JiNGU2aUFNL3dERXpsLzlFdzE5MjErWm43TDN4cHN0RjhmVC9EWFVuUzJHcVFEVWRQdUdPTTNHU2pJVDdyR3VQb2E5REI3cytXejZFcWxPUEwwdS93QWo2VTFJYmJoY25ZeFFkZS92UzJpaFlta0JHUit0TDRqdnJYUjdFVDNrcVEyOFoya1NINW05aFhOeDZ6ZTNNRXN6eGpUN0FJVEdqSER5RDE5ajdWNDJjWm5Rd0ZOODh0WDA2bms4TmNQNHZOOFNxbEtIdUo2eWUzL0Jmb2RTZGZzTlAweTdTN3UxZ0tObFdib0R4a2ZXcjFqNGl2anBnSGgvUnBKaTZyNWR6ZUhidEpQVXIxSXJpTkF1N0hWdFUwS09jeDNGdkpDYm9SY0VBbG1BSjk4cWVLOWJuMXVIUXJFelhFMFVTb09HNllPT242VjhWaDV5eGk5cko4cWZRL2VhZUIvcytuN0hXV3Z5dWM3cW5oRHhKcitudkZyV3VDeWxFZ2RUcGFiQW94MHlhNUEvRGk0OEpwY05kT2RiMGk3Vkk1SlpBUE5pSG1LeFlmbC9PdldMRytmVUxJNmxmcjlqdGlOOEt5Y0ZsSDhUZTFjM3IvaksydmJ3V2RxRmthTEV1Vkg3c1pIQlBxSzVzd25oY0xUOS93Q0xwYmMxcHF2VlRwUVdoMTJrK0t0STF0NW9vTGhBa1Nnd3laQWptajZibFAxQkdQYW52cXNTa0NQOTREeGtkQjdWNVZwTi9IbzBNc2NFTUwyeUY1UWpwd21lV3g2RFBQNDFsM254U0hoVllibSt0Myt4VG5MR0k3L0xIWmlQU3VMRDVzcGU1T0x1WmYySmlJcmxwNnhYVHF6MlNTNGtrWWM3YzlCVWNpTVBtSnp4MXJNOFBlT3RNOFM2WEJOYXpRM0tTak1Vc2JBaHVPbnNmYXRDV2NTUTVYOHErZ2hLTlNLbEhZOHQwZlpQa2tyTkdCcWNKODQrL2FzVFdaZGxsSW9iWUVHNTI5dlN1Z3VGTnc1QjRDOVc5Szg1K0lYaWFHUkZzNFhYamdsVDk0MXJGYWsxTlk4cU9MdjlXYldkWGhpNlFsdHFEMnpWMWJNdmN5NEI0ZnIrQXJCMEFOY2VKSVZISlVrZ2ZoWFdXTXlsSjVldWVUVk01T1ZRa29yc1Y1WXRwNmRLeXBqaTRQME5iVXpBcVNPL05Zc3lrVGpJNjlQZW9zZGN0VHpiNHJhVGNhcjRuME9HeHk5NWN4TkFpRDBMRGMzNEROV1V0NGREbVM0RzFVc29UYnhNZnVvaWc1YjhTVFhaYTFGRlpUSmVsY2FrMExRd1RFY1FvZnZINm5wWGgzeGU4YU5wdWxEU05MaE4zcU41L285dmJKOTZVakdhKzl5Nlg3aVBOb2tqNWF2ellpdTRSMlBxNy9nbnZkL2I3djRqM09DUE9leGt3ZmMzUi9yWDJMWHhiL3dUZFM2aXNmSENYc1AyYTlXUFRSUEQvd0E4NU1YTzVmd09SWDJsV05kcDFHMFlZUldwcEx1L3pZVVVVVmdkZ1VVVVVBRkZGRkFCUlJSUUFVVVVVQUZGRkZBQlJSUlFBVVVVVUFGRkZGQUJSUlJRQVYrQnZqdlFkYThSL0dUdy9iZUgvT1RVaGF4UEhOQ1NEQ1JMSWQyUjA2VisrVmZrZjRPYlM5SVc2MVF0SEhyTW9Gc3Nqa1pXSWZNTWZpelZGYkZUd21IblVweHZMUkwxWjFaZmdhT1B6R2xSeEVsR0ZtMjI3YUsybXZjOWVQaWlhTzJ0Yjd4SGVpOHViYUpWakVyWkViQWZNM3V4Ni9qWEgrSi9qQmNhdzZ3MnltU0ljTEd6WXdPOGpIc0FQNVZ3SGluWHJqVkx2WjVoZXpRN1ZFZlhQY21vUENHa1JhdnFMM21yM2tVRmphc050cEpJSTJuQTVCNTU2LzFyOCtsbDlTczNYeENiay9VL2FYaWN1eTJrcWVGY1lwYUpKcXlQVS9obnJHdFgvaUVhb0lDMFNXY2NjVm16ZVcxeW03bGtCN2pyN2l2VHZFdnhVdFBEZmltM3UvRk5ucUM2UmFxWlVnV0lPMDh2UUZzSGdkQU0rbGZPZmlMeHJFZEIwK2F5RjZmRlQzM215eW9DTFcxanpoWTFIZGNESlBUbXRqeDk0bXNOWEdsV29nZ2x1VElqejNNT0dVcW56TXBJT0J1Si9TdXFNY1JCSlJnMHZROENjcWNYRnpxeHZPNzNYWFR2b2ZRT3BmRks5K0xQaWRZTFdXVzA4S1dzQ3ozRWJMc2xlNTZpRC9kVVl6NzhWczZiZGlMUzd2VW40YTVsSVFOd1FneGpqdDNyd3p3cDRzc3RJQnpmd0t6cTdTYnBsNVlqNjEwOTc4UjlMZlE3RlZ2ck5wRVRtTXpxY0gzR2ErWXh1RXhPSXF1YmcrblJudngrcDBZeHB4cXhzdk5hL2llaTYzcXkybWl6eklQbW5JUUQwQnhrMXhXdDNSMUs5aFdOc0JJd2dicmtkNndmRVh4RnNXdElJazFHM25jS0NUSEtwQTlSMXJGdGZITm1WY201Z1Y4NEJNaS80MU5MTHE2OTdrZjNNN0tWZkNRamYyc2IrcS96TDJuZUtMajRWK0paTDZ3a2IvaEhieVZGdTdVZzdiZHljQ1ZQcDNGZlNtamZFT3kxV0szVXlpMkpYTFBKOTBqcmtmVUVIOGErUlBFZXIyT3I2Wk5DYnEzYm5PM3pWK1kvblYzNGQrUDRmK0VjdUxQVTd6eWJ1MGt4QkxLd1hjcEFIR2V1TVY5TGdzUFdWN3hmNG55dkVhd3RTbkN2UXFSNXRuWnJVOS84Yi9GTkxocGJEVDJLUW8yM3plaGYzcnl1K3ZaSnJtSWx6ekozckhpOFFhVk5NQWRadDBMY21TUmdlZnpvbTF2VFk3aFArSnRaektIWDVsbVVjZm5YdEtoVWl2aFo4ZFRkR0R0N1JIY2VCN1lueGpaYnZ1TjVoSi80Q2ExTktrQ1JYa2YzdHFIOE1NYzF5L2hqeHJvdWphdGEzOG1wV012a3lFbUo3aE1NRCtOZEpvWGo3d3ZwbW9hdWJqVWRQZU84aGVPRUplUjdZeXh6NjlxeW5UcWZ5djdqeWE5ZUNydHFTdGJ1TXVMNE1nVURrRG1teFNJWXhjU2o1VjRVZXBySHR0ZTBEKzBHKzFhOXA2MjBiRmlZN3FOaXc5Qnp6bW9OYjhmYUZlM0c2RFViYUtFY0pFc3k0VWZuVFZLVWRaSi9jT3BpZmErNUNTODlVWmZ4VjFwN1BSaGNnN0lrREZpT3d4WHdKOFdmaUhjYTVyaVNRWEVrUmhPSTVZMktzQnp5Q1B4cjYyL2FGOFZSWC93OXU3RFNYTi9mVGpLL1l6NWpLTWpJTzNOZkUvaUx3ZHI5eGRSbVBROVNrd2dCSzJjaDduMnI2N0xFcDBsT2ZTNnMvd0F6bXJSaFFweWxHU3U3ZFQ5V3YrQ1hrejNIaFB4TkxLN1NTdlk2UXpTT2NsaVk3Z2trOXlhKzRhK0hmK0NYa0VscjRUOFRRelJ2RE5IWmFRanh5S1ZaV0Vkd0NDRDBJUGF2dUtpdC9FWjV1RS9ocjUvbUZGRkZZbllGRkZGQUJSUlJRQVVVVVVBRkZGRkFCUlJSUUFVVVVVQUZGRkZBQlJSUlFBVVVVVUFGY1ovd3BiNGUvd0RRaCtHZi9CUGIvd0R4RkZGWEF3cUlQK0ZMZkQzL0FLRVB3ei80SjdmL0FPSW8vd0NGTGZEMy9vUS9EUDhBNEo3Zi93Q0lvb3FpT1ZkZy93Q0ZMZkQzL29RL0RQOEE0SjdmL3dDSW8vNFV0OFBmK2hEOE0vOEFnbnQvL2lLS0tBNVYyRC9oUzN3OS93Q2hEOE0vK0NlMy93RGlLUDhBaFMzdzkvNkVQd3ovQU9DZTMvOEFpS0tLQXNnLzRVdDhQZjhBb1EvRFAvZ250LzhBNGlqL0FJVXQ4UGYraEQ4TS93RGdudC8vQUlpaWlnTExzSC9DbHZoNy93QkNINFovOEU5di93REVVZjhBQ2x2aDcvMElmaG4vQU1FOXYvOEFFVVVVQnlyc0gvQ2x2aDcvQU5DSDRaLzhFOXYvQVBFVWY4S1crSHYvQUVJZmhuL3dUMi8vQU1SUlJURGxqMkQvQUlVdDhQZitoRDhNL3dEZ250Ly9BSWlqL2hTM3c5LzZFUHd6L3dDQ2UzLytJb29vRnlSN0Ivd3BiNGUvOUNINFovOEFCUGIvQVB4RkgvQ2x2aDcvQU5DSDRaLzhFOXYvQVBFVVVVQnlSN0Ivd3BiNGUvOEFRaCtHZi9CUGIvOEF4RkgvQUFwYjRlLzlDSDRaL3dEQlBiLy9BQkZGRkZ3NVk5amI4T2VDUER2Zy93QS8rd2RDMHpSUHRIbCtkL1oxbkhiK2JqZHQzYkZHY1piR2VtNCt0YkZGRllzM2g4SVVVVVVHZ1VVVVVBRkZGRkFCUlJSUUFVVVVVQUZGRkZBQlJSUlFBVVVVVUFGRkZGQUJSUlJR";
        String str1 = "/9j/4AAQSkZJRgABAQAAAQABAAD/2wBDAAYEBQYFBAYGBQYHBwYIChAKCgkJChQODwwQFxQYGBcU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\n3zWP4NfzdBsDn5vIRW/4CMVuqvyntQMiEEYydq/9804Qxj+Ff++af1M=TlbrQBGETnCL/wB81IqqD0X/AL5puKOlACqB97bRikpy/wDAqBAF+VuKWjc2aKBifNtp2KbnP3qc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\n0/8A77i/+Lorj95/vH8qKfMIwPs06kstw/0Kr/hVq28wHDM5+qrj/wA=HaVUgkRliV87flBheqOgPeXeoi3e08kd3kjdB+bfL/FVjNa61C6t7y0gTSbWZJHKtIZJV2cMeea1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\nLWUmmedDcLe3P7kov/Ht94/Nj+P/AHq9q1aZYbNpm6I6P/3ywP8A7LU=4QXSOS1RmYfvUxhd3ZuP/HqRZurceH31GZrrVb2N2ZCyJY7tu3p/y0FW7aTwsuo+ZFrWpvNyfK/s\nxfbP/LauflOnPfXV1PcTI+9eBBuK7fxq/YLoMWs/aP7R1Myuhyg09OP/ACNQBzvxFutPk1KFNLur\nmdVTMnnQCLDbv7oc1ysfPSrmtTR3Ot3csTvLE0x2b0wdu7jIydv519F+GvgFpV/oenXstxqnmXNv\nFOcJDgFgDx8/vW0UlElyPFbxlm8JXaRr9yGB2H+15rqa4xkcKjFWBP3a9h+PfhOw8Ctp9hpVxcNL\nextLOkm37qtx0P8AezXn/ge1t9R1+wstVWY6dPOkc7xDmNN33/bFVEOU7OKZbwafPdbpUniRn8sr\nkvs5/wCBbs11XhfRdHvL9LS3Mz3EknlQp54Qy9Pm+5t+8cfhXd3XwP8ACej232+OfVonR0Cu80eM\nswUZ2r05qCXTlh+KVsYCvmWLwqiFdvmK0vG4gfe3Hb+FQ0EZRZ1E+ma/p9snmrq4iXbHv/tsKB29\nOKs/2J4lx/x76z/4Ox/hXX6jcyzxmxvrK1PnjYIftOS/rj5O1c3pXiz+xYp9K1GB2ksIt6O7li8f\nbbtBzjgbvapGULrw9rc9rLHe2urSQkfMkmtKwYe/FVvD/he6isll0qz1Kzt51Eo8jVFTcp5Bworp\nPGOrXV54YEdhHC41KRLWGaC43A7j/u+gYVvaW97aWsNgtlGfs0Ea5+0dQBj0/wBmp5gOdj8M6htz\nJc+IlPtqYP8AWor3QpbO1kuLrUfEyRL1Iv1bH8PrXaxX0jLIXtihjbYfnGM/5NZfie4kufC1zKlu\n+2SNJBlhwMg0yjh7fQBoEt+I5L64k1I+ZM90yEhF5zlT83zbef8AGqd1uW3uCoyVX/2au78UIGv4\nfU6fc/8AjstvXHDcizNs37Y3bHzfN8jVrR+NGVT+HIyo4BKQrOwz/ttW/wCHLP7NczBX3hkUj5t1\nY1hZGdOeC38W3mug0CyNnetFlnDR55rtxEYxhocOHk+cg1g/6dMP93/0GqWflq7r67NQkX2Ws/PF\neZI9EM1EWp9Ru3NUMfGetSq3Wq6d6ep+WgRYV+TXm/xRT9xKF/57D/x4NXoea8Q8bXrR+Ptcs5G+\nSdIJUB/vKgXj8z+VEQOS0l/+Jtaf9NrNV/SvRvg7qN3p3jm5+wQrcSyg7YfM8oPwR1bp/DXmdo/l\n3+iyfwmNV/8AHmrv/h/dnS/iJp8v38KhOWxnaw/+ypgfQ51vxb/D4fT/AMGMVfMn7S97qd94ztTq\n9n9jljs0QIJll+XdIc5X5f4q+v21K9Szmu305AkasSPtHPy9e3tXy3+1jK8viuweeNI5BZKuA+/+\nOSqhqHKeAnrUfc1IetOWB3y3SpYkQt3pDUjxun3qjK8UDJrd3iImj+8hro/EPiTUdXsLWzuPs/kx\nhdgjj2npXNQ/6mRf+BVqGzupLGG6it5jEgXdIEbA/GgozMEcbU/74oqeigk9D+MM9tZ38Wk2Fha2\nu0ebM8Dykv6A73NcHbzm1iOw/vWHJDfdX0q94k1SfXtcudQmjVHmO7y06Iq/w1iuxO7bT50LlsK9\nwX+8Wpm7iosCnqBSuWTQhmyB2Ga1NAuFtr9LqXbtgR5Vz/eUNj/x6s+wlETyfLv3xlF9t38VJHbm\nRlt4N091I2zZH830A9TmiPvAdL4V8N32qWVzq/lZsLWSNZ3PdnfG0f7X8X+6K6/UNo/suH5QFRSx\n9Olel+IvDcPg34MeHvD10ETULu7+03kW7nf5Mr/ptRfwry3xh4daytYZrOz8jzo5io+1ebuVFyT9\nxNv/AI9QyEchrmuxyzXMdsiujSFt5H3ql0DxtqWkSE2z5D7dwdtw+WsW30u7nRmgt5X27S2B/eqt\nLazQ7i8MqYbbyMYqOaJfKz2+yn1bxjZwtb2ybXffnLfIq+/3a3PDGkroGiXdvrE8Ra4QxtHG27C/\nN3/GuP0Px5Bpfh600qW0mgSONVby225buzbv9qr8OoadrlpNFbXspmZPlR125b/ZNYuZXIeX2ml6\nTP4t/s6S+l/s8ybFnCjJ/wAnivfvD/hzTdH0cWFre3UaSNxNHMULN83Xb8tfMvMM5zuR43/EMtfQ\nvhSN9R0XTbmS5lVXUPgfw+tU5Mixmazp88d00Ti+uJIyVzIv/oLfNmtHR7KCaS7j1SyluVSLesSM\nwf5WCDbz/dro/FmgwapKl++s6ZZII1jVLqZlkf8A2lAHzen4VQmsdLSOfZ4i0kGUFV8u5cYXc3B+\nT/arrhBtXic7lFPlOesYUsNb02N4poI5dQXYJ12nCwzf+zMtelDFcFeaZp076bZ2U6vd7y7zw3wu\nArKnXZsGM7vWu5DIkaK7Nv7tXDicZSoStNm1ODcTH8Yvjw9qH/XN/wD0Fq8QUmTWLUH7qzj/ANBF\ne2eNjt8O3jKWcshXG3+8GFeL2iq+rI3926Rf/HP/ALGqo1o1oc8HoVy2+IsGNXn1E/7a/wDoVQWa\nMNRlOefLm/8AZquojiPUpI0ZjvX+H+61UtN1KykhjN3PDBM0ciyfe/i/3vp92qbsM5G4/dX8/ONr\nk19Qaj+0BpXhnRdE0zR7M6vPFYQLPIs2yON/LHyDg7j6+nvXkUHhDSbu5ubiHWrS4SQYQjnDN/s/\nerYvPh3YnRJoNPKver828nkmpjiozRcabcbmZ45+JL+ONWOoPYx28qRLFHGzb9qKzHr3+81c8+s3\npQ+Q2xx93C1ysMM1tdssisHQ+Ww9/wC7W1Fb3kh2xWkxPstOctfdPRwVGlOHv/Ee4fCz4mXpSPSf\nF22+0112YkTcVX7vH97rSfEDX57f4mSXGi+ZKYPLl86Nt6J82U3jsu7b8x/vV5NDaahboJLqO4gU\nspTIZPm7c16L4at4tZsPtush3mKHTxj5CisCof8A2mG8N+FZzxcaCvMWMwKpLnpP3T3jw54ytbzS\nn1rUYlt3ZSsYO3PyqN6KfUspIBxnK1x/jzxdpMujWGq6XFHdTYlt5974e3TI++Ad27cVx/vVm6Tr\nEfhzRJrCDS11YTzb45rlxFtdsKQuR93+7zXnHxKa4vbgfZdLt7KWT59lp9zZj7zf7WaKeMo1fdps\n8t0ps7Ow+J9tZppfmWtt9i06bebeE7DI+3b5nUr33cf7X+9XfeBviFa6hqOqS6zdeRIBG8Fu4P3G\nPG31+8v86+SIbuCO2EdzNceashDxp8u5fr/nrXoPw9vbTz7dLlWjVn+QoqO5/hDMGH3Qx3Y/iUVr\nHmM43+0fWlrJBqlpffZZhLDLJt8yNx/dXoRnkVVvW3fD8t/04I3/AI4KZ4Ta7dbhZtThu3jmww8t\nMbMDGzZjav13dKjvCF+HM64YbNM+XPfbFWhcR/iIj+0bTHfT7oH/AL6h/wAK5aAokkm8MwMbpx/t\nBl/rXU6+cXmnn1srofoh/wDZa5r7UbKG4uEVN6J8m9MjduH/ALLuqoytImUeaPKZ0+saTZs0Md1h\n0bkOrLitTQLxb3UA6PvTYdh/vVzLX7GSaSazsI/m+V3iVt9b/hS9afUUjZLcLsyvlptreeI51y2M\nIUeR8w/xOmzUF+X70YP/AKFWSCOa3fGI26hD/wBcx/6E1c+O9cstzoQuRSE/LQTUZkjU7XkRD15q\nih2aA4AyzYHrXCabdeKbDS7lZ5LC9u/tRdN8gXdG3VeMbW3f+hVh+NviSbGNtKislkv/ACk+0nzt\nqROwzhfWiwj1CXU7SCB57iZIYo1y7yNgBa8b8TyaZ4i+JdhJp12s8UkG1zH8vzoH/vf8Brgb7xHq\n+rxw2N5cP9lG3ZFGv3mXp/tNW34N07UtP8W6W11p93bBSfnnjZPvIf7wrSMCDf1XwHPEtm1reRol\nuuc3Ksny7vUVTNwsfiHSr+CRJLWdXWKZG4faef8Ax6ui+LWo3f8Awjse3aA7CJ3T5crXJ+BPEGnw\nWel28+qrpV1BI6mSS2aaN0Zt3Po27v71MhxPsu31Ozl8JT6jczJHZSJLIZXPAQs3/stfEnxO8UXH\njDxRdahIvloTsiTduEaD5QK7z4s/Ee01TR00fSbhZAXzO0a8Ki9EU/4eleOGbd7D0oTtoUIscaD5\nFyfU008fep67eaY/3WpAVxz81QSw53Fani6GmucBvTFAFIHYtbFlrF3Hp0loqWvlP94mBd/51j96\nlhfB20AO5opaKANFdVtIIZ40tHJlXazvJuP8qxgcnP3aJSPMbbux2zUWaALUcihxvRXHpUahSdu5\nR/tGmLn1r6O+Hfwn0K78J2N14gsPMv5080kzSptVuUG1T/dqOaMRHzwsSf8APVP++Wra8MXtnpWp\nxX1yZJHgKvGIndOVbPVSrD/eB4r6Q/4U/wCEm4/shdvr9qm/xqdPg34PbrpTH/t6m/xojOIcxw91\n8RvAt/4asLfVI/EE+poS0k/2mWURnDL8qyyOpyrYPT/2WvPfF/jJdZjt7azkeG3iTaQ4+827mvUP\nil8M/C/h3wTqep6fYNHdw7PLPnynBZwvc+9fOJfLNTb5ionotp4v0u1g8uNZgGQLjylrpb+OwPhg\n3l07mGSNZ0zwW7ivFQ24YruNSGoXWiaQqHfYeSitjqNvb/drnnGx0U5yaFCQywNdTpzJyw3f3qh8\nMzudXCwMqfP8gFL/AK2Ly93z9FCfw/71P8Pb7a9WaBFmljfrt3fotQhMYPDc2ueLdQgtf3VusxZ3\nK/dr2LQ3t7OKGxszkWw8hh6bR3ryl/FmraNrN/p9x9kkMdwULvCBna23dxj+GrvgvxoltJqratLD\nBFJteNI07/N93r/s1q4sxPUvGd08ehpcxK2YJNrS/dCI3r/wJVX8a4/T/EwEiLId7/dARs723U+6\n+I/hqbTrm0vmmuoriPy3jSFv64riNP8AFuk6Ysh0/S3DlvvFug7bckkVjPCqpqy4z5T26ygvrieG\nbylt5RGT5AZFMi+g3Hbu+pXvVDV9cuLfWRYy2lw0bRqRMI96DjPLg7f7y15hp3xK3XzXepJcSqg2\npD5q7P8Ae24+9WndfFGxmtZALB4A+U/chV3cfe/CuZ5XTn8SK9rqXNS+Jt6l/qFgdEs72CFjC6OX\nOV6dulYV14whkVVXwlbWzRzCbfG7qW/2WY8lefrVr4Zq91catfQNcojzBg4cA5xIRmvSJNIuvLe2\nl+2tdT5T94UZWKkf/EfoK+yweRYenQhra587jc8jhq06dtjyDW/GzPZyW9jp0mmhjuUJcFkDY2k4\nI9K4MyMd27vXqHxqtXtY9GjdpzGsbKqPjC/LH0/T8MV5Xxg15mKoKhVcIu6PRwWJWLoKt/MW9OvZ\nrGcS28jI+0qcHqG+Uj8q9d0zx/odvYQ3E0V99qkBWSCGbAGB15I4rxuCIyyiNfvE4rfltVs9Fge5\nKur3CuURgSFw1TQwixCm39lXOt13Tsl1Oti8baFb213BFpdxJFczmefzNjb/AJt2Pmz/ALNVJfHq\nb5Ft4btYg3yCSbcQvpn+L5q4Kd42nkMCMIt3yA/wik3L6VzxpxQ5TbO8t/H00SIscEpaNmZSZv73\n8PStG3+KV1Cs23TLd2Z9/wA8vT/O2vNN9PSUYxilOjTqxtNXIjOUT0qx8c6lrN/HaxWCvKzF0EbM\n7sV+b5R/wGu70fW2fzo9S0W4snCIqGTKF12t/eFeBabKIbtJG+6D/eK/+PLXs2qeJvDfh3TYf7P1\n5NbuXA8yEpcP5fH8Jc7fyrH6pBO8EXGZfn+D9/JreFu7FrCeRZU3y7ZFR938OOzfLWN8UrK58HeJ\nJNOhgM8USI8MhCo/bltmf7q4+nQE1jz/ABXmDs1hp0QLNnLsy/oD/WsXXvEEmt+KtR1BmX98STs3\nY3dz/wB9fNW/NyxN6NL2z5ZH1d8FZJ5LCGRo2h2xeVJCmWRT1bn2PA+rV12pov8Awr67DKrbNNfC\nn/ZiNfKugeLtcsnMegalLaAsGMckh8sjfyxH3d3zCu6s/HXjKTdp2oKZrSXMT+XFCyeUeDyDuHBp\nxinG9zOtRlQnyM9l1AyN/Y7TBRILe5icjox8rOR9doNc/qK5spOM8r/6FW4+owSDwrDesttc3KyK\niPkbv3LA/eA+bcyjHvWasL3H7uIZLHcoC/3eaZkciF+X7tbfhA7NZhXb1ytZEa/u1rT8M/JrVo3+\n0f5GojuI2/G64vYD/wBM/wD2auaJ611Hj5f9JtD6o3/oVcqO9EtwQmRXnPxW1vUtDj0+/wBLl8tx\ndGNwVyHGBw3/AHzXohNcB8TESTTkkYZT7Wsa56fcbP8A48tUUbFp4w0mC8i03Vbu2jvZIwd6N8hP\n93P8Lf8AoWVrG8X/AA10zW76XU1uLhCyZYQlWDcfSvMb7wvDeQyGzfyZT82OxrqPCXin/hHNIGma\n/HcGGac7Jo2bfGn3v++flbp+tMRSl8E6fol3nUNaaO3jP7xYYvnX0G/t81aml6f4TsXl1GJrue6t\n2Do5uc9lO5R/F171q31gviTTDH4e1mGayZVdgiNKAfXY5+V/rWZqHhfUodOhtIINERUZV8+S22vJ\nw33z8237vaiLn3EVvH2o2uq+Fg9lIxyQ6o6sj7f721vm2/N96vJ412LtU8/xV0PizVPtus3MsD/u\nkRLWEhm4hiG0AfXburCQfnROQEO3mlSplX5cd6bikUKp60yXpt9adio3PRfemIYOFqC4f5flqQtz\nUD9TQAyNGanqgRizULuVaNhJagB+Y6KZgUUAVn++3+9RW5fW+hSzu9hdXcMR+6lxFuI/EGpdP0CK\n8kT7Ff28/wA6gxk7Dz/vUAanws8Kv4i8R2COqvapOsk6nvEvJ/w/GvsG1t4oYo4027UG0eu1feuS\n+G/gq18Hae0ce2S9n+aebZx/ur/s/wA67NG+XdXM5cwSJNo9aep2j5aqmb/aqSNsrSIPKP2kb4we\nCBCp/wCPi7SNv91Qz/8Asq18tZr6H/abuF+zaFZF8eY8kpH+6AP614faaZburSzySLGnUBRlvYVp\nGSSOilRnNe6ZCnrXdaNrEFrpUMN2jvEU2EIK5tdLgGf3z/8AfH/169E+D1gG8QTOB50UFrtO9du0\nswx/46Gpc0arsbzwtSlHmZxyz2kty0Ml95dr96PG5d3pu4rqPD405dTtUivbWRBIrkyMqkbe6tx+\noWvYrzw3o14W+0adaTH/AG4QxrIvPh54XnX97pUKf9c3ZP8A0E1fs4nNdnivxXgiTxdcz28iSRXM\naTAo2RnGD/48v61xmz5d1dT8RtP0/S/EdzY6QjpawYTBZm525PX61y6jhqfKIk2oEG1ue9Kq5YDs\nzVCn3vaprc5nQf7VANmzqGhwWlhLcJf+a8ezKeTt+9/tZrJMMjx7kHyIoz8397mu00iCO9ma3vCp\nhdVLoZdgfb0p/jfT4JLaKWzeyh8hdpSNwxf0HH0pwJO0+DcmnWHhC4vNTktkU3LrmV8MvygZX1+9\n+lc745+JM19eS2nh9TZWCEjzIyVeXnOcn5gP8mvNH3hju60w4YjjmvRqZhOUVCGh5dPKqP1h4mpq\n3+BZ1DULu+wbu5nuNnTzJCcfnVTdtzRRnNcDlJ6yPUjFJWRLDI0Th4ztZfu1s3mpveaVFAYbffGy\nsZI+C3G35v0rDpyZz8ta0qs6cXy9dCXFPcTacfdalAPXFdb8PrrRLHVWXxRaJPYTgR+ftLeQfXHp\nXrD/AA40S9jN3pFjp1zZS8xSC/lUMPw3VUKN43CU7Hz/AMY6UidTXvi/Ca0lLbtNhjH8OzVX/wDZ\noaH+DunBN7W9wn+5qCt/6FCKv6uyOeJ4IRxUWa6j4haPaaFr8+mWTykQom/zG3EOwyR+tcwibgzZ\nwB3NZONvdLiSQlQTu5q9plxHGZtytym1cVRWBxFJICrBK7/4UzLZJfXJt1cy7Yt7twU7jFZuPMbU\nqjpSuip4b8Yx6Pb6nG2nQ3ZuYNkUzttMTc847r83T6V6T8PfiFpKKLb+xproyKm20e5ZkideuxmO\n7aewJbbtrxXxHCbPWbyBkWNVkOwJ0x221WsrqSCQSW8kvnK3Qf3frUOMbaClWc3eZ9V+M/FkfjLS\nl0m88PTWbAgwXQmH7h+zcdvasfwh47m8LXFxpXjDUYZ5YFQW1xFucsrxn77D0yOvzfN3rzrwP4tm\nXTzBrju5H+qkPVl9G/8AiqveIW8L63qonbUbqxl8gRyv9lebe6gKNq/7u2seZmbl2NnWPinBDdyQ\naRY/aok+Xznl2A/7ox92r/w98e3Gp6lJLftDD5GXhtbaNnmn2hm2ruPzV5bpvjbUdKdP7OgsgIV8\ntd9nGr/L/eKjdu/GrXgi+01PFcV34r+0LblvPDwq3yPvDbvk+bb97pSjJ3M/ePebj4oaF4mvLW2V\nLqwuU/dgXSKA5bspUn+7321keDtVub+61aG8nST7NKqx4x935vm/8dryPWtct77UZjqVvNNas5MF\n0kim48vcxG9v42+vzfw133gsw3FvIbLU/wC0I2X5RIuJom/2q3pSTi4kuUrnfSE5Kr+J9K86+LJe\nPwdcvE2ySK7Rxj+H5mWu10eWd7H/AEg5dXKqf9ndXH/FKPf4O1cMOiof/IrUuhrA4yCRre0t7i4b\nYrheXG0fzqDX7VdTVI2kZFRwd4+bb/D0/GuU8R2cy2mmtt4uEO3D7s9K39O2WukweVceYuR5jydR\n8zJj/d+Zcf8A16qJRzk9jrXhicXdnLLCqn5Lm2fhvr/ga2tS8e6zrHh5bG/8rez/ADzoNpkX0b+H\n+7/drpGmQ6VJI7MFCfN/vLXnlzIstxJIsaorksqBdoFNgUyrZ2qtN+fP3lqcrkkttpFTrSGRruXN\nJ81T7Mn5RQV2Jk9KAKo3/wC9UJbLmruw7NzLiqB/1jUAOc4qFeTuappNu0/59aij/ioKFTqaeo60\nxflJqWmQGBRS0UAVPlBpYzggq20q3ymphbsehQ/8CqF1KHDDbUD5ZRPUPDfxo1/ToEg1JLfU0Rdq\nvMu2T8WHX8a6U/Hm6EQkTQYfK3fNsnbP8q8GyzHFdBpVuJrWS237JJEOD71UYREepj4/XGcroCbc\n97n/AOtQPj9e5+TQIR9bgt/SvFViMayxytslRtpQ9a0bTTJ54Q6RROjt8h8wZ3e/NRylWgdT8QfF\nk/jO8tL69gjtDbRmLyEffu+bdnPvu/8AHa5kTbkCKmxEO5Ru/iphs7iGQRzR26lvl+SQMR+tMEMy\nZ3tC5/iEcm4j/eqJwbO/D4inTiWd45r0X4OXcdvLeJ8jz3U6RqgblVUMSf8Ax6vM9mJgi3EPzdy3\nAq34X8Snw9qSXkdjDcyxltrmRl6jbToUrN3Hi8XGrC0T6g3EK3zKP+A015VEbF2UIvUmvHrT4zps\nxdaO4fP8E3H8qv6n8T9D1HQ76FPtMN08B2I67Rvxx8wNbcqPOujyPX7ttR1y8nVmd5Z3YZ+b+Lio\nl0e9eQRww7n27sIweur8L6Xpc6RFoLt7pdrMXl2oPXoN1dJqOiRXEIht7dI33bvtOVzu/wA9s1HM\nGh5ZLpt0jsrxMm37xf5QKfHp08ZM2FkiRv8AWxncK+gvBrWOm6Clrf3VvNLIXU+dhi/VeN3+7XI/\nFfxhNZzQ6Xotw1rKuTdGB3Ur/cHX0+birEcQrxiPzGmTevytEVb7vqtYl1evLPJ83yL0FTS67qUs\nMkdzeSzh+MzNvcfifashX5agCR3z9ahzUlRmgAozRRigBV+Y1Kvy1GnSnK/WgCdZWVJFHQ19O/Bi\nS1n8DWB0yKRQhMc4Zt373+M/j8p/GvloN711Xg7xhqXhqO5i06G2mSZlcidC+Cvpgj/Irow84x0k\nROPun1vGs3zfI350y4EnkgMG5b3r54t/jJrcf3rCy/4BvT+tacfxtuj/AK/S3/4BdN/hXV7WHcx5\nWcL4/u5NT8WawwjQj7VJggc/Lhev+6n/AKFVLT/D95doFigmKbd7lIWfH+c1Lo9lc63rBaCeGGSW\nQynzN3yfePoc1674I0Q6JFPI+oLeG4Zdsu3YAtedOd2bxM74Zax8Pkgi0bxJ4X3TFvLe8Dyt5hX+\nIrn5fw/vdqpan4Rgivr7/hFNShh0t5C8EN2rMUX0LDNdLrXgrTp3udbs9qXUCPP5SIuGmUcN/wB9\nL92vLLDxvqvmCHy7U7228of8aVyjnNfe7aVPt8Lo+3KFxtJT0/n+dMsbuOFNux8/xYZfmrvfixoj\nW1lYX3zOqu0EhLc/MNw/9BavNEOz7vQc/wC9SlsI3be/hWDczXCOrfIdm4fnUpWDUPK+z3nl3D/e\nhmXaM/7JFYizq+7z2c/3fm6VNaXCwSJPE8scsbKUdG2lT1DVHKTY6TS/tnkzJbRPDNYxuZp7ePcX\njbqJTnbt6/ntqnDeSwQzzwX3zsfLYRnaWDdc9P7q/wB5abo+oRJeB7yKUxDLHyG2Ozduf96oLRIr\nkyQgKDu+Q7duay5AFtr947hLghJNp5DruB+or0H+y4GtrXXNIZdNlk+aP7PMWjb/AGc4DI3UY+Za\n4VNOu7OyGoKy+XvKEbx8w6f5/wB4etdj8NtTEvm6RdNHNpsuWMLMuQ3P/jv09mqoQ6GLO28JeIL6\n5t57a48pbu3ciUFGz/vdf72aqeObi/ufCurRTeSqCHPybvmVWzWHqmjT6PL/AGrosjmGGTy3yclP\nr6rXYKX8UeE7ryo7eGaeF4HH9x8f5b8azjOUZckjeGx49r4VPD+h3EFwrvg7gOqHiqtvcudLvI97\nFpduwbeAv7tP67fwrpJPAmtLbJaz3lkqrnZlOPzxWXqugXel6bJHcIr+VCV85F2/x7vT/ZraMrDC\nK4z4LtAvBa5kjf8A2lVs/wDs1YZXgGroil/4ROQ7l2QagVz/ALyD/wCJ/Wuce7kwyq3y+tVDqBou\nUU5Z6T7Vbj+OsZ3dz8zZpuaoo1HukJ+/xURuv3iDflVaqCr/ABU+NTk=IoA3HdXQlWU1lP8A61vmpqllkBVm+XvQPlcn1oKHn7ppnSgyMfl/ho/goAF+ajd/tUL/ABLSbqZA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\nKKAP/9k=";
        IllegalInfoDrsServiceImpl.GenerateImage(str1);
    }

    public static boolean GenerateImage(String imgStr) {
        if (imgStr == null) {
            return false;
        }
        BASE64Decoder decoder = new BASE64Decoder();
        try {
            byte[] b = decoder.decodeBuffer(imgStr);
            for (int i = 0; i < b.length; ++i) {
                if (b[i] >= 0) continue;
                int n = i;
                b[n] = (byte)(b[n] + 256);
            }
            String imgFilePath = "d://ffe.jpg";
            FileOutputStream out = new FileOutputStream(imgFilePath);
            ((OutputStream)out).write(b);
            out.flush();
            ((OutputStream)out).close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

