/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.illegalinfo.service.impl;

import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Response;
import com.xdja.pams.syms.service.CommonCodeService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pams.function.zhengzhou.common.dao.BaseDao;
import pams.function.zhengzhou.common.service.impl.BaseServiceImpl;
import pams.function.zhengzhou.drs.bean.DrsResult;
import pams.function.zhengzhou.drs.bean.Item;
import pams.function.zhengzhou.drs.util.DrsUtils;
import pams.function.zhengzhou.drs.util.DrsXml;
import pams.function.zhengzhou.illegalinfo.bean.QueryBean;
import pams.function.zhengzhou.illegalinfo.bean.SurveilBean;
import pams.function.zhengzhou.illegalinfo.bean.SurveilExtendBean;
import pams.function.zhengzhou.illegalinfo.dao.SurveilDao;
import pams.function.zhengzhou.illegalinfo.entity.Jgys;
import pams.function.zhengzhou.illegalinfo.service.IllegalInfoDrsService;
import pams.function.zhengzhou.illegalinfo.service.SurveilService;
import pams.function.zhengzhou.trafficpolice.dao.FdbhDao;
import pams.function.zhengzhou.util.BeanTranslateUtils;
import pams.function.zhengzhou.util.DataWebserviceClient;
import pams.function.zhengzhou.util.Tools;
import pams.function.zhengzhou.util.TranslateColumn;
import xdja.hxd.wsrpc.client.wsrpcClient_new;

@Service(value="surveilService")
public class SurveilServiceImpl
extends BaseServiceImpl
implements SurveilService {
    private static final Logger log = LoggerFactory.getLogger(SurveilServiceImpl.class);
    @Autowired
    private SurveilDao surveilDao;
    @Autowired
    private CommonCodeService codeService;
    @Autowired
    private FdbhDao fdbhDao;
    @Autowired
    private UserManageService personService;
    @Autowired
    private IllegalInfoDrsService illegalInfoDrsService;
    private boolean isWS = false;
    private String error;

    @Override
    public BaseDao getDao() {
        return this.surveilDao;
    }

    @Override
    public List<SurveilBean> queryListByBean(QueryBean queryBean, Page page) {
        if (StringUtils.isNotBlank((CharSequence)queryBean.getBeginTime())) {
            String beginTime = queryBean.getBeginTime() + " 00:00:00";
            queryBean.setBeginTime(beginTime);
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getEndTime())) {
            String endTime = queryBean.getEndTime() + " 23:59:59";
            queryBean.setEndTime(endTime);
        }
        if (this.isWS) {
            return this.queryWS(queryBean, page);
        }
        List<SurveilBean> list = this.illegalInfoDrsService.querySurveilList(queryBean, page);
        if (list != null && !list.isEmpty()) {
            ArrayList<String> personCodes = new ArrayList<String>();
            for (SurveilBean bean : list) {
                if (StringUtils.isNotBlank((CharSequence)bean.getZqmj())) {
                    personCodes.add(bean.getZqmj());
                }
                if (!StringUtils.isNotBlank((CharSequence)bean.getFjjh())) continue;
                personCodes.add(bean.getFjjh());
            }
            String[] codes = new String[personCodes.size()];
            Map personCodeNameMap = this.personService.queryPersonName(personCodes.toArray(codes));
            Map stateMap = this.codeService.getCodeMap("ILLEGAL_INFO_STATE");
            Map hpzlMap = this.codeService.getCodeMap("hpzl");
            for (SurveilBean bean : list) {
                bean.setZqmjName((String)personCodeNameMap.get(bean.getZqmj()));
                bean.setFjxm((String)personCodeNameMap.get(bean.getFjjh()));
                bean.setStateVal(Tools.getNameOfCode(stateMap, bean.getState()));
                bean.setHpzlVal(Tools.getNameOfCode(hpzlMap, bean.getHpzl()));
                personCodes.add(bean.getZqmj());
            }
        }
        return list;
    }

    public List<SurveilBean> queryWS(QueryBean queryBean, Page page) {
        ArrayList<SurveilBean> dataList = new ArrayList<SurveilBean>();
        StringBuilder selectSql = new StringBuilder(" 1=1 ");
        if (StringUtils.isNotBlank((CharSequence)queryBean.getHpzl())) {
            selectSql.append("and c_hpzl='" + queryBean.getHpzl() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getHphm())) {
            selectSql.append("and c_hphm='" + queryBean.getHphm() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getBeginTime())) {
            selectSql.append("and d_wfsj>='" + queryBean.getBeginTime() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getEndTime())) {
            selectSql.append("and d_wfsj<='" + queryBean.getEndTime() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getState())) {
            selectSql.append("and c_zt='" + queryBean.getState() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getZqmj())) {
            selectSql.append("and c_zqmj='" + queryBean.getZqmj() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getClzl())) {
            selectSql.append("and c_flag='" + queryBean.getClzl() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getControlDep())) {
            selectSql.append("and c_tzsh like '" + queryBean.getControlDep() + "%' ");
        }
        selectSql.append(" order by spzt asc,wfsj desc ");
        wsrpcClient_new wsc = DataWebserviceClient.getWC();
        wsc.setquerytable("t_vio_surveil");
        wsc.setquerycolumns("*");
        log.info("\u67e5\u8be2\u6761\u4ef6\uff1a" + selectSql.toString());
        wsc.setquerycondition(selectSql.toString());
        wsc.setrowstart(Integer.valueOf((page.getPage() - 1) * page.getRp() + 1));
        wsc.setrowlen(Integer.valueOf(page.getRp()));
        int intTotal = 0;
        if (wsc.executeQuery()) {
            if (log.isDebugEnabled()) {
                log.debug("wsrpcclient \u8fd4\u56de\u7684\u7ed3\u679c\uff1a" + wsc.getResultXML());
            }
            String rstxml = wsc.getResultXML();
            intTotal = Tools.getXMLCount(rstxml);
            wsc.beforefirst();
            while (wsc.next()) {
                SurveilBean surveilBean = new SurveilBean();
                surveilBean.setId(wsc.getitemstring("c_id"));
                surveilBean.setHpzl(wsc.getitemstring("c_hpzl"));
                surveilBean.setHphm(wsc.getitemstring("c_hphm"));
                surveilBean.setWfsj(wsc.getitemstring("d_wfsj"));
                surveilBean.setWfdz(wsc.getitemstring("c_wfdz"));
                surveilBean.setZqmj(wsc.getitemstring("c_zqmj"));
                surveilBean.setState(wsc.getitemstring("c_zt"));
                dataList.add(surveilBean);
            }
        }
        page.setTotal(intTotal);
        return dataList;
    }

    @Override
    public SurveilBean queryById(String id) {
        SurveilBean surveilBean;
        if (this.isWS) {
            surveilBean = this.queryWSByID(id);
        } else {
            surveilBean = this.illegalInfoDrsService.querySurveilById(id);
            Map hpzlMap = this.codeService.getCodeMap("hpzl");
            surveilBean.setHpzlVal(Tools.getNameOfCode(hpzlMap, surveilBean.getHpzl()));
        }
        ArrayList<String> codeList = new ArrayList<String>();
        if (surveilBean.getZqmj() != null && !"".equals(surveilBean.getZqmj())) {
            codeList.add(surveilBean.getZqmj());
        }
        if (surveilBean.getFjjh() != null && !"".equals(surveilBean.getFjjh())) {
            codeList.add(surveilBean.getFjjh());
        }
        if (surveilBean.getZqxj() != null && !"".equals(surveilBean.getZqxj())) {
            codeList.add(surveilBean.getZqxj());
        }
        String[] s = new String[codeList.size()];
        for (int i = 0; i < codeList.size(); ++i) {
            int j = 0;
            s[j++] = (String)codeList.get(i);
        }
        Map personCodeNameMap = this.personService.queryPersonName(s);
        surveilBean.setZqmjName((String)personCodeNameMap.get(surveilBean.getZqmj()));
        surveilBean.setZqxjName((String)personCodeNameMap.get(surveilBean.getZqxj()));
        surveilBean.setFjxm((String)personCodeNameMap.get(surveilBean.getFjjh()));
        return surveilBean;
    }

    public SurveilBean queryWSByID(String id) {
        SurveilBean surveil = new SurveilBean();
        wsrpcClient_new wsc = DataWebserviceClient.getWC();
        wsc.setquerytable("t_vio_surveil");
        wsc.setquerycolumns("*");
        log.info("\u67e5\u8be2\u6761\u4ef6\uff1ac_id='" + id + "' ");
        wsc.setquerycondition("c_id='" + id + "' ");
        wsc.executeQuery();
        if (log.isDebugEnabled()) {
            log.debug("wsrpcclient \u8fd4\u56de\u7684\u7ed3\u679c\uff1a" + wsc.getResultXML());
        }
        if (wsc.getrownum() > 0) {
            surveil.setHpzl(wsc.getitemstring("c_hpzl"));
            surveil.setHphm(wsc.getitemstring("c_hphm"));
            surveil.setClfl(wsc.getitemstring("c_clfl"));
            surveil.setJdcsyr(wsc.getitemstring("c_jdcsyr"));
            surveil.setZsxzqh(wsc.getitemstring("c_zsxzqh"));
            surveil.setZsxxdz(wsc.getitemstring("c_zsxxdz"));
            surveil.setSyxz(wsc.getitemstring("c_syxz"));
            surveil.setWfsj(wsc.getitemstring("d_wfsj"));
            surveil.setXzqh(wsc.getitemstring("c_xzqh"));
            surveil.setWfdd(wsc.getitemstring("c_wfdd"));
            surveil.setLddm(wsc.getitemstring("c_lddm"));
            surveil.setDdms(wsc.getitemstring("c_ddms"));
            surveil.setWfdz(wsc.getitemstring("c_wfdz"));
            surveil.setWfdm(wsc.getitemrealstring("c_wfxw"));
            surveil.setWfnr(wsc.getitemstring("c_wfxw"));
            surveil.setZqmj(wsc.getitemstring("c_zqmj"));
            surveil.setState(wsc.getitemstring("c_zt"));
            surveil.setId(wsc.getitemstring("c_id"));
            surveil.setTzsh(wsc.getitemstring("c_tzsh"));
            surveil.setCjfs(wsc.getitemstring("c_cjfs"));
            surveil.setCjjg(wsc.getitemstring("c_cjjg"));
            surveil.setCjjgmc(wsc.getitemstring("c_cjjgmc"));
            surveil.setFkje(wsc.getitemstring("n_fkje"));
            surveil.setJtfs(wsc.getitemstring("c_jtfs"));
            String fzjg = wsc.getitemstring("c_fzjg");
            if (StringUtils.isBlank((CharSequence)fzjg)) {
                fzjg = wsc.getitemstring("c_hphm").substring(0, 2);
            }
            surveil.setFzjg(fzjg);
        }
        wsc.setquerytable("T_VIO_SURVEIL_ZP");
        wsc.setquerycolumns("*");
        log.info("\u67e5\u8be2\u6761\u4ef6\uff1ac_id='" + id + "'");
        wsc.setquerycondition("c_id='" + id + "'");
        boolean b = wsc.executeQuery();
        log.info(b + ":" + wsc.getError());
        wsc.beforefirst();
        ArrayList<String> zps = new ArrayList<String>();
        while (wsc.next()) {
            zps.add(wsc.getitemstring("n_xh"));
        }
        surveil.setZpxh(zps);
        return surveil;
    }

    @Override
    public String queryImge(String id, String xh) {
        String str = null;
        str = "/9j/4AAQSkZJRgABAQEAYABgAAD/2wBDAAMCAgMCAgMDAwMEAwMEBQgFBQQEBQoHBwYIDAoMDAsKCwsNDhIQDQ4RDgsLEBYQERMUFRUVDA8XGBYUGBIUFRT/2wBDAQMEBAUEBQkFBQkUDQsNFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBT/wAARCADUAUIDASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwD9GiCR2H4V+DHxU+Kmq+Btft7Gwt7OaKS2WctcI7NuLuvZhxhRX70V/PJ+0P8A8jjZDv8AYE/9GS152E6hioqdSCkr7/oJ/wANEeIv+fHTP+/cn/xyj/hojxF/z46Z/wB+5P8A45XltFehYw9hT/lPUv8AhojxF/z46Z/37k/+OUv/AA0R4i/58dM/79yf/HK8soosHsKf8p6n/wANDeI+v2HS8f8AXKT/AOOV0ulfEP4ga34S1TxLYaDYXmj6VIkd9PDFIxt9/wB1nHmZCnpnpXjehWVtqeqWtte36aZayyKsl5IhdYVJwWKjkgegr9B/2bPC/hT4PeCdTPhmwg+N13r1wtvqSw3f2S0GnDqBDJyZA2Tlh3GK8vMsbHA0lNK8m1vorX112Wl9zuwmXU8VNwUdl0PBvh1rvin4k6dZS6dBYwSi5lW+mmt5BBBAqoQ4bzOWyzDHsKo/ED4uwWniU2/hO1dtJhijSabV0zK82P3rIEKgIDnGcnjrX1f8cvh7N4B8Iyt4RgtPDfg7UAh1PSoEEtzYjkiSLsxwcHt8tfB8dtpmreJ/sukpcXWkWjl5bmfiW5APBPoW6AdOteZlWZvHOWJekFey/wA3te/Q+hnk2Founh+VSnLfuuyt+J9L+BvD95rPh7TL7WkjtptQZpIFt5ApNv8AwymMglcnIAJ7Zryn4vfGDT/CuujTvCTDUTCXW7e+jbCMP4V2lc47mu21/wAbXPh/w7Y6fb3aReLNVC/ZHVciGMcRA56cfLivmPQvB+ueOPE8tja2zT37SSNOznCpgnczE8AA5rXAfWajnjMTO0LvlWyNs2y/A0eTBYSknPq7Xf8Aw/c6lv2gfEinDWGmqeuDFJyP+/lM/wCGhfEWAfsWmdP+eUn/AMcr26x/ZcsfiBqCyyX0kLWlvDam0sVUPI6oCWLNwAd3WvYvh/8AAHwH4XSSzOl+GGuC37069cea6sABxk4x7euayr8QYSjH3U5Psc9PhStNvmSjHuz4wP7QniIY/wBC0w/9spP/AI5Sf8NC+Is8WOmZPT91J/8AHK/Sfwz+z54a1CIvB4O8EXCkYDrZRure+cVqav8Asq+D9f0uTT7z4ceFJY3Kl5NOSS0mXns8deeuKsNe0qTt8hVOFuRXU4tn5if8NDeIv+fLTM/9cpf/AI5QP2hfEYzmy0sf9spP/jlfdXiz/gmF4F8QTzS6Jr194UumjzHpsri4iGOSdz/N+vasHTP2O/2bvgtZDxX45+KaeKI9NUyyaDbTw5uJR/AEX5iMjFezRzvB4j+FdvtZng1sr9g7Tij41f8AaC8SIqs1hpoVuhMMnP8A5Epn/DQ/iLA/0LTP+/Un/wAcqv8AH34pWPxa+JF7rWkaBaeGNCRVttO0myjCJbwJnbnHVjksT6mvNj1Fe5FuUU2rHC6FNP4T9kP+CZd/Lq/h/wAW30gRJbq10qd1QHaGZLhjjJ6ZNfRv7SvxoP7PHwU8R/EE6QNf/sf7N/xLvtP2bzvNuYoP9Zsfbjzd33TnbjjOR80f8Etf+RM8Rf8AYP0f/wBFz17l+2/8NPEfxg/Ze8a+EfCWm/2v4g1H7F9ls/Pjh8zy72CV/nkZUGERzyRnGByQK8ypZ1tdtDswt1QVvP8AM8B8M/t6eO/iF+0J4s+HEGi6T4Ng8MQ3cF3PaeH9V8YSz3dtdiByiWZtnSFg2Q7x8FACcyKq9h4T/bR8QW3wO+I3jnxHbeFJ7nwp4u1Lw/Bb39zc+Gf7RgtbZZlWOG4W5kF7IdwFs209QSCh3fAnjP8AZ98WeDf2mL7xTpF3ofh7w1pXjqzS+8T+GkN5ovg67uL3zI7eR5oYI3+ygx7wFESFoo3KM4Svrj47fEmy8TfswfGL4cfBXUfEvxCn8NQ6e/iPxhf+LFvVexltmuLm5huXuHMymOzeCW3jEa7p5NqEblPTKnDSyNVOWtzsPhl+3Jqvivxr8ONEuNQ0HxPHqfhx/E3il/B/hzUL6XTEkjiS3sI47Sa7cXEVwz+c0yRp5bRgBXIDfUfwo+LHhj41+EY/FHg7UJ9V0CWZ4Ir2bT7i0WZkOHMYnjQuoOV3qCu5WXOVYD8pNW+BmoaEn7Pts95PH4S8e6l4QnvrrxBeWl/qGqXbWwQC0t3Ei/YLGCbyQk0Q+a6COJ4xFs+zPHmvfGr4d/s56bpUdrrvhzxJoXiL+wbTUvh54PstcfV9IhgkFvef2b5wjso5Ase5A2Y3jUBVWQKuVSlF25Sozl1Pr8gnvQFI7/pTqK4Te5y/xC+IuifC/RLfVvEMt9FYz3kNhG2n6Xdag5nmbZEhjt45HG9yqAkYLui53OoJ4S+IuieNda8S6TpMt8994dvBYakt3pd1aJFOV3hEkmjVJcoUfMZYbJI2ztkQtw/7VUk5+FdtbWia6bqbxHoUiz+HNJl1K7tUh1S2uZbhYo4Zh+7igkcF42Qsqrhiyq3lEdvremaN8X9Na5+IOpyyeNLaV9dl0e8spbm2Ol2dt9oP9n21vNcwxT2zgJpwR5DDAJJEt5pZjvGEZRuS5NM+tsH1pCCe9fEfhvxC+pa14Bh8f6h8T3VdO8TWM0Oj2vijTZbpbTVLMabcGzt2NwV+x3RHnymRmLhZpZJU4ta1J4wt9a1O01e98dSfF2T4daDf6dZ6Ne6nLpkPiZ11CGR54rRjp8Mbz21sGE4W2bY7EFTKTXsULnPtHYfX9K4fxJ8bvBfhXXLnRLjWxqfiG12m50HQrSfVtTtkZQwkltLRJZo48Mn7xkCfvIxnLqD5V4o+Gmoar8brvwrZeJfEg0LWpbXxVqUtr4r1SO60uKH7RHJaRGOYLbQ3Uz2/lxYw6R6ntZDbWoi9z8YSeJV02KPwrb6VJqE0wikuNYnlSK0iKtmcRxoTcMh2nyd8IcZHnR8Gs+WKKuzL1b4teF9H+G1348ub+b/hGLOF57q6g0+4mmtlRykwlt0jMyNEwdZUZA0Rjk8wLsbHimifHD4g+PNN+GraJqOheHtY1e8h8PeJdJ8QeENRW40nVxo8+pzhVku7djHtjiRV2sMSbxK4+Wux+Jfgez8L/AX4irrWqT32peIYZLnWbqzs1LatdSQxWy2cFr5inbNHFBZRwRyrMylAJ/Pbzz4t8RbnwTY+PvBx+JHir/hC/Fd/46u9V1vTx4mn0WK1gOg3NpBPbyxzxNLblbOyRbvILSSTxlbdpZrWPaEYmbbPTLn9o7V/C3w20C71q2/tfxdqXi678OpFoPhzULm3uYLLWZLa8kSKEzNHILG3uLhY2kYkxOVDhGWsPxd8cfiN/ZfxA8SeFfEngy/8L6H4LtvHWkm68K3omvbO5XUJIIHY6ghVhHYrmTyxkyn92m3B5n4fa9ZXvgLwb/wrvU4PGmtaT408YPpWnJeLqikfaNSIvp5jcJIzJb3UQR5ZvLmbUYUkaNrmG7g8x+JJ+DOjaF8WNHsviLPG2l/CjTNI0qyvPGF1YXM95bQarB9knslmiDTKEthJaPCNrzPuiVpn3WoRvt/VyeZn6LBSO/6UEE96r6XqllrmmWmpaddwahp15ClxbXdrKssU8TqGR0dSQysCCCDgggirVcJvcZsPr+lFPooC4V/PJ+0P/wAjjZf9eCf+jJa/obr+eT9of/kcbL/rwT/0ZLXoYTqediP4sPn+h5ZRRRXoEhRRTgMjNAD15wPTrg19Kfsg6J430rxtfapo9ncWsVtYPK32y2f7PNyMA5GOcVwP7OPwbf4z+Pl0l9TttHs4IGu7i+uzhIUXvjvzjivujVvFun+AlCr43uPEenm/ZrW32pFBJcFAGUbeqKFJA6cmvks7x65XgKUeacl1vZX7/I+qyfBarF1JWjHXzavbT5nkv7Q/xC8bSyWsbzw38d+xkudBtvvxR7duEI52Bg3HrXz54Ts7bSkj1a6tZoLdHaS4jU5ZpFYiOIL/AHsjOPeve7a40m18P638RNU1K11H4ganIsPh3S4WzFaw+aV+f0zy2TxWdrvjtPDPjXW9Z1DwZb2vi7R9OtooNOK7rMXkmd18y9G+QqV7ZFctCpKlR+r0YXjHRtaXel0r7pXWp6lFKjiPrNS/PJNpW2TTs38kcJffAP4sazPH4tufBupWWm3ki3Vo7TIjJF/AFVmyPyr0Hw14G1DTTaPrFvb6Fp0R+0XNsjh55gDuIkYcBSQSea52XX7rxPfNca7q+t67dOf3tw10yRZA5CKDgAdgK3LTw34B8X6RcWCa74k0gsA9xbGQFZAD1Ytzj/Cqr1a9Xlp1r8q6Ri3b8fxsdFJywlKUoSXO+rdnbvt+FzxX4leO7rxH4y1rVbG+mtrOa42xCKQogHQHA7YHHtirvh/4beJfiFpou9Et9V8QWq5EjxXCjyz6kFs9a5r4uX+i2mpjw/4bgJ0jTjta7c7pLqTu7HpjoAPaud8I+NNd8AanDqGkXlxYSAjKhiElGejDoRX1lJxjRSp00n0TX6I+brYyUZcsXzKyu9Xd9XqdZr2m+Kfh9fjTNSk1bRrkJvSJrhxkZxkYOCPpWl4J+KPjfwhqJvNC8V6vYXSnJeO5ZgxzjoT1rp/jD8atO+MHgjwbM0Ij8R2TzpdqB91OMYPoetcX4a01pZLeFF3yudwH9fwr0MBhqeM/jUl1urHZSmp0+ZnbfFL9p34wW+iQaLqHjzUb+x1OAzN5hAkX5ipUMOR92vnSa6lnYtJI0jZJ3OxJJPU12PxX1y31jxP5NtIHtLKFbZJB0Y9WP5k1w561FXDUMNVlGhFJJ9FY+Xq1HUd2wBxQTmkorMxP2I/4Ja/8iX4i/wCwfo//AKLnr7mr4Z/4Jaf8iX4i/wCwfo//AKLnr7mrxq/8Rm+E/hr5/mFFFFYHYFFFFABRRRQAUUUUAYN54C8M6h4usfFV14d0m58UWMJt7TW5rGJ723iIcFI5yu9VIkk4BA+dv7xos/AXhnT/ABdfeKrXw7pNt4ovoRb3etw2MSXtxEAgCSThd7KBHHwSR8i/3RW9RTvIRg+H/Afhnwnqesalofh3SdG1HWZvtGp3en2MUEt9LuZt87ooMjZkc5Yk5dj3Nb1FFLcYUUUUAFFFFABRRRQAUUUUAFfzyftD/wDI42X/AF4J/wCjJa/obr+eT9of/kcbL/rwT/0ZLXoYTqediP4sPn+h5ZRRRXoEjj0qaKIyDA5bsMdag68V1vw1eCPxroz3MENzBHcLLLFOcRsq84Y+lROTjFySu0dWFpfWK0KV7czSv2v1PunwH8MPAPgn4BSG2thdeMri0tZruGfOW8wjzADx8ijOfeuG0yDwhHpOmlIpbfxTcSzNFPex+Za28GCgWOIkZkOQd3pk1zHjL4jHV7ePT9P1djPaw3ENsunfvVCTSbzDu7gH16Zrn/F+sa/r1lo0V/pi2b2qbFLMwLkjB/DGfzNfGYLI8VVcq9SbvJ33+5a+R+o16lTm+p4akpU4u3M+y3a7q6/EXT7CHT/Bxtbq+gvrGTcoktlAulhErbht6kFg2COxrS1rxKms30eoXkyfYbSxW2Te/mTXAAxGrY5AUcc1wc1zf3MpvJmt0uISriWKPYVC9IwBwF9RVWX4gajo8cgtLOytriUnfcRxAnB/r1r6D+z8TBqTSeve1rtXZ5+KoQpQV007b3bb0tbV6LyOs02ya/ltZZLOZRd7kinut0aSOMkCP+79TW/PqWixaLG3iezlfTJA0KzMSs1uw4PzjqPTPWvN/CPxTvtN0uDQtaln1DQUu0uo5B80tvIOTg/3T6fWuv0PwrqXxL0u90HwrdR63qE3m3U2jTMNkq5yskEmeD28s85B9a4qtJ0G3Xdknv0S7t9DgVb2kVGC9623n6bM5Cfx/wCDtK1y0gsrCXUNGhJ3vPGFaQ+uK9j8NjwH8UNHZonsgbFGkvLa4UL5UeAdyHj0Ir5P8Q+G9T8MapcabqtlcaffwOUkt7qMo6t6YNXNEtZ7K3mbzpIllXy3RGxuXrhvauurl1PExU6U2n0d7nJg81xSqOlVgnHqrGzqEWmx6xqEukxSx6U85MCyHLiIf4816d8IPB1x478UWFnbMYoOJby4QcW9qv3sn+8xAUDvzXCeG9Am1q/s4gmGuJFgtIgcNNIxAVV9snk192eC/gLcfCrQCNMd5/E8gU6oi4FtckYzGp/hKdj6lq7MyzP+xcE4xf7yatHv5t+htSw/t3yw+Hr8+h4D+01+zfby6NfePPCVotvFZBP7T0uMcqh4Eyj07MO2M96+QipXAr9X/DuoWdj4nj02/iSC6uIpF/sa8GHuYyMOgB68H9M18OftWfs4XHwU8SQ6tpTNfeCdadn06724MLdWt5B2df1GDXynD2bSrL6piX762b6o4M4wEaTVajt19e54CRikp7RkEep6ClWLeAQwr7c+XP2E/wCCWv8AyJniL/sH6P8A+i56+3NUkvYdNu5NNt4LvUVhdra3up2gillCnYryKjlFJwCwRiASQrYwfiT/AIJbDHg3xEP+ofo//ouevtvVJL2HTbuTTbeC71FYXa2t7qdoIpZQp2K8io5RScAsEYgEkK2MHx638Rm2E/hff+bPm/w1+1b4y1/4f/F/xZJ8PNCtrX4cXmqabd26+Kpne7urARyXAjP9ngLGYmkKOfmLqqlFDF16f4CftO/8Ld1u38Pa94b/AOEQ8SX/AIdsvF+l2kF//aFvfaRcqgWYTCKMxyRyuYnidFOQGQyKSR534T/Z++K+ifCz49eErrT/AAaZviPqWt6vaXMPiG7ZbOXUUjhMMgOngssUfmP5g5dlVNiBi6p8P/2SfFtloOtX/i2bw3eeJIfhpH8M9F0i0uLp9Lms0gBaa9n2RTFpZ85EKp5UXAaRzuXRxp2ZveWh9cUV5l+zX8Nb/wCEHwU8OeEdS03QtIvtO+0+ZZ+Gp7uawj8y5llHlPds0xyHBbeThiwHygCvTa5JaOyNVsZfijxNpvgzw1q/iDWbn7Ho+k2c1/e3Pls/lQRIXkfaoLNhVJwoJOOATXlHhr9oDVta1LxZu8MaTqWn+HdNu728s/CniWHWdbtLmJh5Wn3VhHGoiupQJwFjmlQSW7pvOVZvRPih4L/4WT8NPFvhH7Z/Z39v6Rd6V9s8rzfI8+F4vM2bl3bd+duRnGMjrXnmn/Dfxtq2pQX8lt4b+Gc+i+F9R8OaAnhu5fVorZrprRo5/KltbVEW3NjFthCusgcgmMJh9YctveE79CtF+0z/AGfaa7a61p+hRa5p94NPifSfEP2vRjdCK5mmgudQkt4RbSW0VlcT3KNGWih8oqJZJUiJ4b+Pnizxf/Ztho3hfwnqmsap9uvNOu7DxibrRb3T7T7HHPPHexWbP5guL0Q+U0A5gmYuAED5XiT4LeMvGvjaz+IOsaN4TPiDSbzTJ7Lww+qTXVhP9jj1RI5nvWs1eKQPq5lULbPtazjw2Zd0VbWvgv481LV73XpND8N3Oo63qVzqV/bWXjDVdGudNb7Jp1pDDbanaWwlmhkSwaWWJ4o1LmDhvIDtpywI1N1P2idY1eJ49J8OaFZ3WnWd9daxN4p8RvpljF9jvZ7K7NrOtpMbiOGW2ZpJHSHZHcWjMAZiiVvEv7UkscdlF4a0HSW1qeKFf7A8beIo/DuoT38ttBcx6ZbQvFKZbpY7q2EgJSNGuYVEjt5giwm/ZW/4RaLTrW08GeBfiXo8Vm6R6N4rH9n2Oj3Ul7d3dzLp8ItLtY45mvFj8v5WSOyt1aSYjKA/Zy8Z6J4S8c+ErSfQvE3/AAnekWula3441a9mttWj2aTDpryGAQTfa9vlSXKq9zHl7mRMrzK7tTD3j03xR8WdZ8M+JpRL4Tx4RtdX0/QrnV7m8eG7lurx7aOGS1tvJMc9usl5AjymdGVkuAEYxKJC0+LOsr410rT9U8Kf2V4e1rV7zQtKvZrxxfyXVtHdStJNaNCqR28iWNw0cqTyM6tbtsUSN5eZ4h8N/Eu9+LUWrwab4U1Lw9ZXlqulT6jq10kum2rCNb+YWSWpSS9dGuoo5jcBUjZFVUD3AnPD3hv4lRfFqXXNa03wpc6ZJeXVsuqLq11Ld2ukYkNvbWtobVI4JHkW0kuJDPIZGRhyqW6QZ2jYetz2CiiisDQKKKKACiiigAooooAK/nk/aH/5HGy/68E/9GS1/Q3X88n7Q/8AyONl/wBeCf8AoyWvQwnU87EfxYfP9DyyiiivQJJoIGuJFSMFpHIVVHUmvon4a/B42WkzXt1bNLI0ezKjPJxlR6kZ/WuG+APgZfFfikXNzhbSxXzndugI6Zr7csPFmieHfFWk6VLbxrbWCRyzIMYfPzsc+4IroptQXO9z9D4ey+EYPFVldv4fLzKPg34O2HhG3WXULKO1ms7U6jefu8fZ7bGRk/3mxXnGs6XqfjHUzPJC0MtyGnjUrg2sHSMt6ZGTXoeo/HtPFPhjV5ZD5kmsao0k6cZa1ixsQ/7PQY7155N8brKTVJrR4ytuczXt0mOmMKo9do4UfWrhWctz7h1VFK55/wCJ/Dtrp1nKxkdNMgJjWdut3P3K+3SvJb+ISO0nKbztQDvXrXxE8Qad4mvLa8u5Tp+mQR5W1j+8qZO1QP7zdSfevLdUut9yrhEjmn4ht1OfIj7bv9o81pKolofPZlVjJqLZh30bQlPLby2HVl4JrqvDus2tybFFM2haxbv+61TT5DGSe27GMc965rUQGkYD5ioGSKfJGLBYgxyDhz7UKnTraVNv6+8+VlBxnKUXod/4++NPirWbFfD/AI3jsvFSWwAt9TniC3i+hE4+Y49GzXCW2p2Foplv0kupmUG3giIIkOeA5/zmuj/sqLxXoky5DMq7kkP3g2MY/SvK5UktZHjJKsjFcHqCP5UpYKnl38CKUX22v6bHl4jFVab0d0+r3+/d/M1tU8QapLqsVw5ksri2cPCkYKeQQcjA6jHBr6L8Cf8ABQj4g+GbqzTWbLTPE2mxoVntp0MUk/GMmVcsDxngc15v8N/jNpemQW+leLtDg1rT1cD7aI1NzEncZP3vzr3S1+B/wx+LFsj+D9Q0+9un/e/ZLec214Af4Sj8MfpXx2Z4ulGX+3UG4raS1X/AO7A4SeIi5YbEJSe8Xo/8mdt4m/bc8A+N7/SdITTI7Kzl00i41W8Q7rS5fO5YiAWVQMfNznnpiu5tPiT8PPG3gj/hGfGGsaP4n0OcKL7ZMINsi9JomzlGxjPrXz54g/Yjkktwun6frmn3APzGZFnXA68LjFeW+Lf2VPHXhrzZLWxmv7QH5Tt8uV/+AE8/ga+XeFyvFyg8PXdOS2v+jf8Ame9y4/CUZRr0FUT6p3f3f8A7v4o/s6/CHSrqW88MfFy0e0nlzDa3EPmNbqeisyklsdM4rFsv2Nta1e7hkstZtv7MON9xMhVyOuUXuMEdSD1rx/wz8LvFvjLXJ9J0bQr271O2UyT26x7XiUfxMDjAr7K+Dnwc+KXhGy06XUvFcP2cj97pV4pmEY9ASc5xXsY/F1MspxX1pSl2kld+lk/vZ89h4UMTJ89Bpd1f8b2PqT/gnJoY8MQePNGWUzrpy6daCUrt3iMXKbsds4zivs6vkf8AYTjMXiX4roxBZbu0UlRgH57roK+uK9TndRKb6pfkjw6CSjZd3+bCiuP1T4x+ANE8R3fh/UvHHhuw16zhe4udKutXt4rqCJITO7vEzhlVYQZCSMBAWPHNaXg/x54a+IemS6l4V8RaT4l0+KY28l3o99FdxJKFViheNmAYBlOM5wwPcU+WRvdG9RWXp/ijR9W1rVNHsdXsLzWNK8r+0dPt7lHuLPzVLxedGDuj3qCy7gNwGRkVV8YePPDPw802LUvFXiLSfDWnSzC3ju9ZvorSJ5SrMEDyMoLEKxxnOFJ7Gi0gN6ivMv8AhqD4Nf8ARW/An/hS2X/x2vQ9L1Sy1zTLTUtOu4NQ068hS4tru1lWWKeJ1DI6OpIZWBBBBwQQRQ4tbhdMtUUUVIwoqrqGp2ekW6T313BYwPNFbrLcyrGrSyyLHEgJIG55HRFHVmZQMkgUSapZQ6nb6bJdwJqNxDJcQ2jSqJZYo2RZHVM5KqZYgxAwDIgP3hkAtUVzHjX4oeDfht9j/wCEu8XaF4V+27/sv9t6lDZ+fs279nmMu7bvTOM43DPUVV8HfGTwB8RNTl03wp448NeJtRihNxJaaPq9vdypEGVS5SN2IUFlGcYywHcVXLK1xXR2NFFFSMKKKKACiiigAooooAK/nk/aH/5HKy/68E/9GS1/Q3X88n7Q/wDyOVl/14J/6Mlr0MJ1POxH8WHz/Q8tHWnxKZHVR94nAFR1YsB/pcXrvGPzr0CoLmkl5nu3w4vZfD/hHxBpkUf72S1aR2TqxBQgflmty41TUfFWua1qdt/qp7NEDk42gxqoI+mCKwfCX2m81yR9OVkyuZwy7ljUKQze/HOK+sfhr8EPDPibwy/2O6nmeUx3cGp2sZESxqAF8w9Nu8PkdeBWNetGklzH6/TcaVKKWiirHzK/hnX7Wx+wT27aaphWQmYEExN93j3NP074ReJrqzW7srE6lNIfMht04Lg9GKnqfavon4o6F4ntfiT4b0PV9FgvNU1FR/ZlxHN5UOop0aBZOgcjlQe5Fe0/8Ml3PxA8Lw32i6rr3hXVbUDfpmrHE1jJ1wrjhuvBrKeKpU4rldrnPWxFCD5Zz1Z+Z/jDwj4h0K9F5q9rO3zfN5qFRkE9uwFcw1y4eQxuJbmTIeXtj0HpX6V+JvBM3jqwk8CfEbT1svE8MYjg1CP5U1GJfutu7P1yPp618j/FH4EN4MvDa2dm5s5WwGPLgAkf0rloY6nWlyy0Z51XAzknOm9DwuzQSMijlScnP90dah1S5M1y5zlOgHt2q7PbHT7m7SV8SQNtC1l5DzbscZ/CvehJHhVbqHK9zrvB93/Z1q00rbIEPyqT/rG4wKxviL4auLbVW1O3tJBpl3gxzgZVnPUZ9ari4Lsq7jtHp0BruPiD4uufDLeGorPbLZmxWc2k67o/MJPzY9cYr0cU5PC3grtNbnFVjSnH962kuqX6HjpwvH161YsNRudKu47myuZbeeMhllhcqyn1zXtHhzQfA3xlvY7SNpfC/iKYZ+Vd9vIQOcD1PNej/CL9kC1i8cz2/jOZp7WECayig+5eDtk/0r4vEZthqEZLEXjJL4Wt/TozneXVklUovmj3X69UedfB+P4x/EXU5f8AhFta1Y+QA8txNeOkSgn1J5+lfYPw6+HHjnSb77R468XQeKLfy8JZRoQykjrv9vavRdH0PT9AsBZaXZRWFvHhRFCoUcds1wfxL/aA8F/Coyw6nqAu9TX5hYWZDODjox7c1+Y4zM6+a1HSwdJJPRWim/v6HvYeUsLTvVqO/roaM/w/TTteh1PR7+Sw1iONhZ6kMu0yfxW9x/eAJ4z6n0q1qHxO0bwvotze+KbuDRLy0ZY7q2B4Y4/1kIPJU/zBr5L1z9tHXvFnjzw9JYWsOiaFa3sTyW6/M0o3EMXPptJOPal/b7vbxfiBolvcxQxrdaampRrH1jid3WNCe42oH+shrvpZBiK9alRxr1abutXp0MqmYUvYydJXaZ+gf7AGsWniHU/iZqtg7S2N9NZXNu7jBaN2umUkeuCK90/ah/5Nm+Ln/Yoav/6RS18z/wDBLb/kTPEX/Xho/wD6Lnr6r+Ofw71L4t/CTxT4L0rxF/wi11rtmbB9V+xLeeXA5AnTymZQd8XmR53Arv3A5Ar79wVGagtlZfcj5bDtypX73/Nn5Sat8RL64/4Zr+Dlr4V8J3/h6/vPDPiWW2m8L3eg/wBo3z5tWiu5JjKl3HImBJeRwssucqCFKn7dtf2qPDvxF/Zcj+L3xP06fwF4NmmZ9ItfDfi6+TVb+5jkuIDb/wCjpaHcxjJVBI6EZd/LERYer+IP2cNN8Ra38M7SXUPs3w9+H32a80fwtbwtvbULZfLtJ5rxpGkaOGPIWIBdzndI8gwlZvw7/Zi/4QL9ki7+CP8Awkn28T6Rqmlf279g8vb9se4bzPI8052faMbfM+bb1GeOiVWnJI0UZI+NNLttb+GWheEvHVz4V8Zapqvxb8aaUx1OHxreIraPeQb7PTIp49VgnuLqCL5Fnu4kjDGRSxQI7+1ftQ+E7SP4f/AbT30/xXoUep/F3RftFl4h8R3F9qdvuFxEdt2t3O0WVUMvkz/Lu3Da5avQ4/2Mjf8Agf4e+HNc+LPjLUIPBE2nXulC1ttJt4re8s4vLglRTYu5VQWwkskvBG4uRmtT40/suah8YvA3hvQNS8ez61Ponii28SrdeLNFtL6K5WGKRPsUtvaraI0LGQls5YgspOCNo6kW07/mHK7bHzfcfGzWNR+weBPE3xW13QPgcNXudJ0v41acjwX/AIhki8gQWBvgrRw+XI84k1DaI7pbJ8FcTM32n8QPjf4J+Fnibwf4e8T61/ZeseLrz7Bott9knm+1z74k2bo0ZU+aeIZcqPm64Bxx2o/CP4gav4STwrfa38ML3wukMVuuiXPw7uJLJYoipiQQHVSm1CibRjC7VxjAre1v4R6z41uvA+p+IfH+uafrHhu8e7ni8GzPpGmavmWN1iu7V3naSMLEqFTLzvl5AfC5zcJW/r9Ckmj02iiiuU1PFf2qrzxLaeCNBGg6TpWpQt4p8PtcPqOqS2bRyrrdgbdUVLaYOryfK7EqY1+YLKfkr5R8U+LPGNvoeqXq38Hw2f8AsL4p3elTRX6S6zcyx6wlzLahQvlW8yPDy8MtyTFHOyGJtsqfc/xF+GVl8T7ewsdX1XVrfRbeZbi40vTbhbVbyWOSOW3d50UXETQyxJIhgliO4fNvX5a8ytv2bdc8NX1kvhzxD4bm0rTJr6bTF8XaBeaze25u7+LUJ/MuP7SiWZhdwRSJI8fmJ5UeXZ9zv1U5xSszGSbZmftTanqfg34ifDbxPbXfiTTrKWK+8MrceFZdG+2zX1/dab9kthHqZ2Orm3lYmNSy+VuYqgc1wv7IeneJYPiR4f0DWn8Sfbfhz4Kbw3rdhr9xojRaZeXCaTNBHaLYt57wvFbyESz7siILu3iQV7qv7OugHU/Dl3c3E+qz6XDZpearq2brVtTaza2ezWS9Y7o4VntluZIYlRZZwshwGmSeyv7P3hPUfHWo+KvEGmWHiDU/+EjTxJpEt3aDfpc4020siEbJ35+yLLyAA/lnbuhRwKcVHlHZ3uem0UUVymoUUUUAFFFFABRRRQAV/PJ+0P8A8jjZf9eCf+jJa/obr+eT9of/AJHGy/68E/8ARktehhOp52I/iw+f6HllW9MkVL2Iv90OCaqYzTk4b0r0BwlyyUux9sfsXanosHxM8P6ZrqRoZtWS4lkmA8tlMbIiMT2Jc8dziv1j+GnwF8M/DLTdXsNJhc6PqJ3vps3McJz820dQDxx7V+Rn/BP7WfDmp/ETxFF4t06616NtGKR2FjAZZiFdT5qAdGTapyORX6ueAvjt4W+L0d3oXhPXru38QaVEk1xZahZSW90UGRgrIBuBxyRnmvncbf217aJH1eNxTxMIexbUXo/68joPGfwA8I+OdD0bTdRs5DBo2px6paMrYdJY23KFbqF4A49K7LXnjn0yQ+VlmAbHfjoK4XT/ABy/h3wde+K/F8k2nMyHOmqN5XYSF2KOSzDFeHxfFL41/HXVWtfCmk2/ww8Ps+Yb3U4xc6pLFjh/KzsQHnq2fauGUozh2R5kaFeVT3ndR69PPU3vijZR3+pebc2C3CIoZGaM5jbJ5B7V4b8QvDllrlrLFPFtPllw4+9ur03xB4H8QeHJUXXfGeoeILhW2Syi4VdzYz9wDgf/AF65/XdKjlgVgzSoxwHY5OK8pv2VTmifpOXzvCN7an5j/FTQbDSfFFxaGF4HDHLN/F71xh0BWT93KVyOCeVb8q+pf2tvAqpZ/wBqRWyuYmCtPjB78e9fKlrFI8wQTeUnQgnv6AetfoeX1fb00zxcwpU6Va043TEm06ezhJlUImeZByv51J9k174ueJLSz0nT5b28jgjgjihXO1Rxk+g5rpL6w17w3p1jJrejTQ6ZqcTtbNPHjzlBwSPpivoP9jfxh4M8P/2lon+jaR4iu8vDqU8gC3EWOYdx+62Rn8a2x+KnSwznTXMl/V/RHzGYULw5qN7LdPdHTfAD9lOy+Ft1aeItflGoeIYhlbbH7i33DnP949RXrOveHoLEfZY7s2sM0huLZt486zlHzAqOpjPOfrXkPx3/AGvtL+Hd5No3hdINY1uLIkuAd9vBnqM/xEe3FfGmsfFvxV4g8Ur4gvdZuZtSV9ytvIVP9kKOMdeK/NZZRjc2qvE1pcqtpfX09DHAZhHBpJK93r5o+hf2hv2uPELXN34X0O3TSB5aC7ul/wBYz452HspGD+NfJ19qFxf3L3FzK887nLyyNuZj7mvSvi7oE+rNY+MtPxd6RqkESySxci3uFUK8b+h43DPY+1eX+WWbHGfc19hlmEoYShGNKKT6279Thxk5Tqyu9OnoX9C1CPTNa0+8mhFxDbzxzSRH+NVYEr9COK+7/wBsH4b6Z+0N8P7D4yeAJ1vLawsYre706M7nt4FX7uB3Qsw+mK+A9pVQecHjIr0H4Q/HLxX8E9e/tLw7e7I5FMVzYTjfb3MZ+8rxnjkd60xmGnVnCvRdpwvvs090c0KiinGWzP1D/wCCW67fB3iMYxiw0cYP/XOevuSvjD/gnFri+Jrfx5rCWsVgmopp12trCMJCJBcvsUdgM4H0r6x8eeMLL4eeB/EPirUop59O0LTbnVLmK1VWleKGJpHCBioLEKcAkDOMkda56rcp3a10/IeE/hL5/mb1FfKPhf8A4KKeEPGnxF0jwJo3gDx1eeK9Ws4b+z0/y9MTzYJbMXsb+Y18EXNuwfDMCM7SA3Fe1fCT46eGvjB8HbD4m2DT6J4Yuobm4aXXTFbtbRW8skcrzEOyIoMLtndgLyccgS6co7o6lJPY9Eor548M/t3/AAt134X23j++TxX4c8NS7t97qfhXUXt4cTmAbrm3hltzlwANsrcsFOGyo7r4qfHzR/hT4a8HaxdaLrmsf8JXq9noel6fY2qQXbXV0jvCskd3JB5OdhUiQqysQGAwcHs5p2sHMj02ivlHTv8Agop4Q1bxN428PWvgDx1LrHguzvr/AF+28rTB9jgs3CXL7jfbZNjEDEZYt/CCK+kPAfjCy+Ifgfw94q02KeDTtd0221S2iulVZUimiWRA4UsAwDDIBIznBPWiVOUdwUk9jeooorMoKKzNc13+w/sDNYX99DdXkdpJJYwed9m35CyyKDv8vfsQsits3h3CxrJInk97+2L8J9J8e6j4U1TxhpOkXthqU2kz3V9qdpHAlzHbwzlW/fb1UiSWPzGRUEttNEzK5iWS1CUthNpbntdFcdefFDSxqekWGlQT+JJ9Y0K98QaY+kyQPFe29u1qu2OV5FQtIb2HyyWCEbizqACcz4ffF648deLda8PzeBfEvhqfR4Y3vLvVZdOlto5ZAGS332t3MfOMZEhQjKo0bNtEsW9cstxXPRKK8yg/aR+HdvaTP4h8TWHge+trx9OutN8WXEemXEN3HFDLLCPNYJNsS5gPmQtJEwkUo7KwJq+C/wBqP4bfEDwlba5oXiSDV55NOg1OfQNJ/wCJlrFpFIYxiWys/OmDI0qK4VWCHOTgZp8suwuZHq9FeZ+GfjvYeIfhfovju48N67oej61eaZb6fBqAtGuLiPUJ7aG2uAsNxIqxlrpCQzCQBH+TO0N6ZUtOO5V7hRRRSGFFFFABX88n7Q//ACONl/14J/6Mlr+huv55P2h/+Rxsv+vBP/RktehhOp52I/iw+f6HllKp5pKAMkV6BJ7b+yR4r8W+GfjdosPge7hsPEWsBtKt7udCywiXG5yB1xtBxX6T+AviN8Rj8fU0Dx7pS62dPsSLPxrZaU9jIrjOVYFj5kZOeRjr93Oa/Jz4TeLJ/AvxL8LeILaY20unalBceaq5IUON3Xj7ua/owt7TTbzSU1i2IltLmIXdqccBZBvBHpxj2rw8ytFXavdHr4Ot7O1/Nfeea+LYp9fvNMil3FOJSrDcNx6e+P8ACvO/Hvgb4k+KPEFxp2i61ceC9Bitnl+0WDJ9u1ubB22yOwxDnjDnNe7fbIYLuznmCh3jB3k+5P49a7GbSLTUYELoHVhk+h96+doLlmpWvboerWxjpU1TSsn+D7n5g/Az9jXx+8viTXfHPiDxX4X1CWcJpeltqAuJs+ZlmmkOVYBeMqB3r6qv/AsPg/wmsMkstxcMWcSTnLgHoD27Z49a+i7jR7Oxs5JPJQZ6qOntivCfi1rSySNGoOGOAPQCqxtaVZ6qx15TVnOfJHa58l/G7w7B4l8H6vZ3MhiURNJuAzhhyDivnzwr4S8IX/w50fVbLwfLb+KLi5i3alLKZrZFV8BkGfvMVOVPT8q+rPEVn/aCzYG7zVdCuOvH/wBevm34Dy2Ng+q6Bqs13Yafo+s3NyNVX/j1skZcnzM9yIyFHqa7MHKbotR+zbQ+3xkKSqQdVKzW76PSxn/tG6jYWnwZhtmuJpb/AEvxEY7CR84UvGrzqpPVeV9q+aWuIbySMTRAbwCGhGFb1z6H3rb+OHxdl+Jetm2ska18NWEjjTrRjlgpPMjnuzdfxA7VwFhqbRGNJOUB+UDtX1+Wp0aPs6j31/4B+d47MKdbGScPh0X3f5lzU/Dx3k2Uq3aA8ovDr7Ef1rEaJ4mKuCrd810l/aPPH9otnO49l71hKJbqdIirTSs2xUwSSc9B9a6KseV6HiYmEKcrpWv9x2vwz+Jms/DlryW1to9S0W6Hk3ljdx77aXPQnPAcY4PWrGtfEnRJtZnudP8AA+kwWLuHjtrgyOR0yMqy8Hnp+dfox8Gf2ZtE8Ofsyw+FvEWlQalLqe3VdXtpsqzSFRsVXHzIVXbyOhBr4n/aX/ZavPgzLFr2ivNq3gq8YLFdyKBNbS4yYpQOPo3ce+a8506UpuTWr87Hh4bOI126MXs9L2PP/Gb+HvEXhO08S6dYQ+H9VN01rcaXb7vs7qFBEkW5mbgcEE9cda86Zsng8VPNfyTWcVq5/cxMzoMd2IyfyAqsxBOcYzziumK5VY7pPmdz9h/+CW3/ACJniL/sH6P/AOi56+mP2of+TZ/i5/2KOr/+kUtfM3/BLX/kTPEX/YP0f/0XPX2T458E6R8R/CWqeGdehnudF1SE295b215NatNESNyGSF0cKwG1gGAZSynKsQfKqvlq3NcL/B+/8z8G7vxDrfwz+Nuga5p0EEeq2HhbSryJLnxHeQq0TaBA+RdrNbTozRMSsEcgAYrbx+YgVX/S34ZeEtf+MH7F3h+20vwd4FvdDj1aO+0HQbWS5is5NKt5dyG7tEvHjur15ElZrS4vBCZXQzyh43Fer6j+wb8B9Y8Wr4lv/h/Bfaqs0Uyi51G8ktlEQURRC2Mxh8lFREWDZ5aoqoFCALXc+HvgF4M8I+HdY0HQLXVdB0XVJvPksNK17ULWK1bzmmItFjnUWatI7Fkt/LVgdpBXArSpXhJK26NYwavc/Oi/ntvDvjz4l/F7XfDGuWniHwPq9pHe+JbHw34avNFW7lvluJIJNPWYOLiN5I4TNBfz3Slw0ssJ/d19DftQ6l440z4SeB7X4paNYeL/ABdrfiNdL07RvBVjpY0Z76YqlrHPLrUF3IshjFyyzRwqoLPG+0bZG+iLz9mv4cX/AIJ8O+DpfDm3whoOz7J4fhvrmKwl2yJKPtVukgju/wB5Grn7QsmWLMcl2J3fib8IfB/xk0zS9N8aaHB4h07TdSi1W2tLpn8oXMauqM6KwEi4kcGNwyMGIZTUutFtOw+R2Z+L9j4MGpeNfEhbSL/xL4r8I7tc8aeGrTw3oGhWmnppsbxTm3uQ1zFJHHM6B4UtNlyuWdCwUj9NvDPx7m8EeCfgLYaL4f8A7S0Pxr5cFvN4s17RdCv7KxaSBbdorK3CxXP7mdSkFsoZVSNWAd8Vu2/7BfwAtdS1y/T4ZaSZ9YhnguUeSZ4o1lbc5t4mkKWzA/ceFUaMcIVHFem2/wAH/BEGm+EbCTwppN7B4Rhhg0F9QtUu5dMWJY1jMEsoZ0YCGL5w24lFJJIzTqVoTtoEYOJ2FFFFcRuePfHqH7X4g8A6dZWl/B4h1i8vtJ07W7a6+zW1t5thO08N08UiXTRmKJ7hI4Cm+ext900BCSD5csdL8T6HqfgrTfDdp8QdP0Gz+Jfia30iz8NxeGItPhCNrq7LBLkCVWVBICLkeWFEwTnyK+8NX8M6brmoaJfX1t591ot41/YSeYy+TO1vNbl8AgN+6uJlw2R8+cZAI4Z/2YvhFc3d9d3fwy8J6nfX15cX91eano8F3cTTzyvNK7SyqznLuxAzhRhVAUADphUUVZmTi27nj/xi+GFhrf7U2h6zqdh4U8FWNt4c1XWpPGqWtpdanJ9kl0jFxIbu1MNrJbkhUmc3OITKAIWYMnMfs56p8QNB1/wLG/i/XZvA+oeI7jRV0fXNPsY7iZ2sNW1CVriSO1SR7iMpYRXD+aX+3Q6msm7CsfqSw+D/AII0zUhfWnhTSbedYbaCNEtUEUK27RNCY4sbI2U21p86KGItLUEkW8IRNF+Efhbw/qek39nYTifSoXjs0nv7ieKKR2kaW58qSRka6kM02+6ZTO4mkDSMHYE9quWwcrvc8DtfG3xI1TwB4asdB1G+0+61fxdf+HNJF9e21vqVvHZjVXmjv7mW21KOTyxZC3Uokkkn2dZ3uCbh446nhLR/G/gjwF4y+FV8NW1TUdG0PQIPDcFj4geeO1W5uLmztS9xYWGm3UcMT2iPcPukbyEYg/fV/fta+CnhHXdEstKns7+2tbLV7rXraTTdXvLG4hvrlrhp5VnglSQbzeXOVDbcSkAAAAWvA/wn8O/DzU9U1LSBq0+o6nDBb3V3rOuX2qSvFC0rRIHuppSiqZ5jhSBlyTmn7WNtg5WfFfg34W+Jbz4I/CO10u6n1LxXc+FoNX0K3sdSlMsdrb/2VqUspbUGnhhY3VlpFhHAn7mM3Et15boz28H2p8ItP8L2Hw30OTwU883hjUYW1eyuLq4uLiW4W7drppnkuGaZmkaZnPmHdlznHSrXgf4a+G/hzZrbeH9N+xRrZ2mnq0k8k7pa2sQit4FeRmYRou4hAdu+SV8b5ZGaz4S8DaD4Et9Th0HTINNTU9SudXvjCDuuby4kMk00jHJZmJxyeFVVGFVQIqVOfQqMbG7RRRWBYUUUUAFfzy/tD/8AI5WX/YPT/wBGS1/Q1X8837QgDeNLLP8Az4J/6Mlr0MJ1POxH8WHz/Q8uiUu4ABYk4AA6muu8efDLXfhrDora/afYLnV7NdQgtZD+8WBiQjsO27BI9q+yP2MP2O/s9pZfELxxp4Z5GD6No9yvLdCs8i+nop614R+3b4qvvEv7UXjiC8m81NHuv7ItVAAEcEA2qoA98/nXdf3rHm08ZGvXdKnqo7s8S0LTjqV4U7KrHPpxgfrX7q/sb/FV/jj+yl4emgmWPWtMtP7Fu0jPEcsC7Yww6/NHsP41+JXg628uxupSAJHTI9gK+w/+CdH7Qsfwe+Lc/hrV7pLfwx4vCR72Py298v8AqnPoGPyk/SuHMMM61DmXQ+1p4R08NCrFXlv/AJH6B3HiTxNqtwmk/wBjR295ZqIpJCSMr2Ycc9a958PC5stAs0u/nmWIbjXzt49+IPjjw74qeJ7q20u1lAaK5htPOLE9Y/aux8D65431O9tZtT1KObS9hDM8Wx3PrivkacVBc19z28bgZ1sPCfuxW+7u/wAD0Xxfq3k2TYO1AOcetfM3j3UDdSZ3cgnFesfEbxAYrby/M6+nevBvEdw1wHZmCAZwSelZO9SR35PhvZwUmcG+qGXWLmBExbadseeVjjG/kH6YFfCnxNs0k0N9TilnS11bW9QyiuRHcRxlNrY74LNgmvszx34W0/XEkupIrpVkUW05tHKtNH6MB25NfOPizwvcfGzxhD4c8J6YbDQvDWmyxI/PlrJyxyT/ABMRivdy501O/Tqe1mMXOmotXufJN7bPbTEMPxqv712t9Yb5GiuoTDIpKlGXaeCQT+YI/CsW+8OvEvmRAsmAcd6+q5W7tbH5ZiMBOHvR1RW0rVpLCdGYlos8rX1z+yd+z0fEHjnSPG+oae0ei2ri4is72Mg3DdnAP8OcY9cGs39j/wDZHHxE1d/EPjSA22h2DIyadICJbsnkHH9z+dfoktvbzRRxeQlvBAghhiiXb5Ua/dQY7CsZVnbkPhM2zr2UHg4at9e3oX4tSiIninkB3L+8Psa8/wBb8M6TrltqfhfXbdb7QdSwjwSH5VPO1x6EVsW85t72dNUxBCcCK6HKqM9D71i6+J9M1K5jkzPb8YcfeA6g/wAq5ZK+h8lhNHzRZ+Xv7R3wYufgh8S7/QisjaeT5tnLJ1MZzgE+o/wryonpX6z/ALRHwk0z47eBEZ4o5NTnsWazvf4o7qPqpP8AtAqK/KTVdNuNI1K5sryIwXNvI0UsbDBVgSCPzFb0p88Vfc/QcFifb07P4lufr1/wS0/5EvxF/wBg/R//AEXPX3NXwz/wS0/5EvxF/wBg/R//AEXPX3NXl1/4jPYwn8NfP8wooorA7AooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAr8mvgn+zPb/Fb4pW3jXxBHHP4X0SFIhbPz9quVZnCEf3QHQn61+stfCv7K04t/hrqcrMR5eqSsB7+TDXo4O15XPl88rSoUoyi7br8j2iK6iOuoWA2WUZuCvRQVHyIB6dq/KH9tLwLe6X+094tmm+aHV5v7XWXGFKyjcRn2ORX6k6bMjWmpyTuBhUO49cFjnNfNv7Vfwxn+M+myz6RHGuqadEDa5ADTIoO4E++DgV0QfNO58xw/WjDGr2ukXo/0/E/PmymSCcRLhA6FQKaJisDKCVaN96MpwynjofwFYuq3Utrq6xOjxNbN5ciMMFWB+YfnWrLPGjCYNmN1Bb2ruTumj9xpYqFROHSJ+uH/AAT1/aItPjh8NLjQ/FssN54x8OFYZGnI33VpxsmGe68qT7CvovxL4r0jSbYraMu8DGxOcc9MV+Cvg/xXrfgrXYtZ8P6vPpWop8q3Fqx5XuDjqPavQ9f/AGofi14gsDZX/i+4EM48svHGqMR/vAZrwquTTqSdRaRMYNRlzSu16n6ceKfGVrNdzeZeRu6MAY4nDkE9M46V5tqOpzarO3BEWfu/3hXzH/wT5u7vxJ8b9c8NaldzXdje6RPdOZ5DI3mxFSrAn/eNfenin4WfZ47f+zVDtyWPAyK+cxsHhZeyhtufW4DG0XH3lZ/geUz2rrZLsyozncvX3FVba08hJY4IUi8w7iI0C+Y3YnHWuu1a1+wOlm6bXX7w9DSafo0l7diC3jLzdWDcLGP7zHsK8lTktEe1OtGMHObSS1u+h4z8VPhjo2tR6fcy+HIb21A+wXkFrEBNEjsWWZCO4Zmz9a4i3/ZO0b4da1DrGqXjavpjN5ttYuMhCQAqyt39q+sIobXSY5I48XUzI/nXIzyu3lR6DOOa4z4kG28PfCyC31FszvDFAgcjL3Eh+QfVRzXvYOtOliItyfvaNX09bH5LmuZTxk39Wjyw2vs36LojzmLxVqsWpLc2cwtJFjEexBgBR90fgK7jQPirqsKn+0IVuF7lep9685ihkiIbaS/Qn1Petu2mQoElGxhyPevupRi9Gj4/FYGjVXvQTPZNO8YaXq2myO5/coMvE69aq+NdZsLHW4He5DQ3gSNdoyU44Delef6ZIukf6ffbYtOiO8L3lfsMflWHFrs+qm51C7tDHbTylkkY8N2CqO/4etYOiu540MqpuV4NpHrnhy3Z7LXNLgdWRyL2y2nOHUYcD6j+lfAf7dHwsPh/xnaeMLKFV03XExMUH3LlRyD6ZXb9SDX2P4J8Tv4ev4fNXbAZg6tnPlk4BU+xApP2g/hra/EXwP4i8MEIpkU3mnTH+CRcuMfXJFcSTpVLPZq4UufA4hc+zN7/AIJa/wDIl+Is9f7P0f8A9Fz19y18Pf8ABLyJoPCfiaKQFXSx0hWBGCCI7gGvuGuGv/EZ9phNaKt5/mFFFFYHYFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFfBf7M7qPhZqanGTq0mDn7v7mHJr70r82/gTc6pfeG5tHsVKQPfSTTTAcKDHGOT/wABruw20j5LiGPNRir23/Q9502RNXuNV01SggFsGSUkDzpBkhRWLoHh2/nt47ydXsArZjMi4Zmz0KnnFdBoNhFp2xYFRplG7zn55GMY/GtrWkk3w34Zns7sb8sc7Jf4kH8/xoVVU6nL3Pg41XTpNU18z4u/aI/Yi/4T/wAcW3irw1NBp0V/dga1aEhREP4poh3zz8vqa+efjf8AAWX4M+IoLOe6e+8NaiT/AGfqrJjYR1ikHZsY/nX6W6hIVu2OSMD16V578bvg7L8bfh/J4cj1SPRYZLmO4kuGg85iV6BRuGM5OaydbERxEJQa5FpJPqu9z7LKM6VCChXfo/0aPzOvPClrpeJo9Q8+0yVMkBy0LdwQOv4VhiWWGRlM3nwJnDMMZHqK+k1/4J4fF298WTaPo9jY6naRH9xq73XkW7qeg9Vb1BH4819NfCT/AIJtaN4Qt7fVviZq6a/qirxpVtxAjDnYCPvDjrXdXx9Kir/hc+/w81iWnSd1+Bgf8E4/hZaeGdYtfEd+rNrmraVdvFuGPKg/d8Ee/X8a+/NPh+3ajH8hMSDexI/hr5y/Z8tSni6O4t7WQWY0OSOFvLPlwq1xJHtz6gRD8xX01pk8MenTwW7pLdTMVkeNw3lAYyGx0+lfn7ruverN6tv/AIY9mtJYaDk9jiPFHw5tvFV9JLAotJ1bBmPIUZ4Y/rXE6zZf2VbHTtOtbi109N3mPN9+4YdZHb09B+de0ar4j0TwLDGuqajFbyyY8u0Yhrmd8HAVM55xwWwvvXjvij4iJ8RJ7rTLK0NzosJ2S2QYIJ5QASlzMM9MgmOPIII+fkgc/NyPma17HFVxVTEQUakvcXT+upx9rdWzafLqU0g/s6JsRsOBcOOcL/eX6Z5BrC1HRtP8cSxX2v6f/aESEyWlrcMUETEf64AdJPTPQAV3lz8MdU1Sa0v7qT7S0aAQQ7PKt7UDoI4hnAHIyad/wgGrvd7ZSil+QS4LMM9AK7Kc3GXtG9TyZ2m9tDyW/wDhhdLJLNpl7FeRfw290dk34N0I/WqXhvwxcS6q9pfWF7CyvjBt3KlvaQArj3zX0A/gq20VEk1A+a6jK2/8f/AiOgrmfEHiy8iJh842lqpAjgiOT1/Wvahm9WK5ZWfyMpYeM/I8m8VpomjXAnv7mLxHN5mItFtJh5an/bZc8+1YWuardrPbahrZia+ZNun6NbIEgsI+3y/iffNeja94X0K0catdaPDDrsj+bBHCvlyLjP7yTHH4e1eQeKNI1Kzvvt95M989w243eMn/AHWHb8K9bCY2liGoSevn+SJjQSXuImttT2TeXMd6T8N9e30r0HRPFn9o6TpsUvz3Nu8kDSHkbQAVHv1ryLzcsynCsrfw9PrW7o16NMTSZSSI5Z5o2J9di4r16kbxSe6PMxeFVaN+p7/+wlGkPiT4rRxqEjW7tFVV6AB7rAr65r5D/YLfzNe+Kbf3rmzP/j11X15XiV/4jO3AK1CK9fzCiiisDvCiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACvhz9k23juPhrqo2AyDVZNxx95PJh4/n+dfcdfDP7JN59k8CXpPKnVZMj1Hkw16OC3kfI8Qq9GHz/Q9LlRbG/O0ZBHT27V0ujFdSsbrRZSAJl86Bj/AM9AOQPTpXM6jzfTHpl8rj0p9pqEqXEWw7WiYPn6VzYukp67Nan5/h5uM+S176W9RdO8HXOt3bGQ+RGj7JM+oruofDWjaTEqrCZpFH8R71Wl1VI5PtMOFjuAGIHZu/8AKoob1725IjG7vn2r5qpi6lRvWx+65PkGEo4eM5R5pPq0n8vKxoy6xNaqYrb/AEaLHMSDjHrXFePviVHY3Npo9raSalr10D5VrAQohToZJJD8qjrwa6XWlaytfMDF5eQqjrnGfyr4++LHh3xV438QXj2N0LTS7iIG5uRLt8xlJGGwc4Hp715VSvTU+SUvU/R8oy+hi6yhOShFJ3b0Wi/zO38GaxbXHiaXwDoWryatL9sBXUNGuJIvsiklpTISdrqCMfKB9412Ph/xFrninxz5Phi6/sXwXpEjSPc2cZMt9eg7WTc/Lxgc5qH4A/AJfA3haa7S7L6trcAja62bfs9uOSi55Bbnmvb9L8MWWjxQxW8SpDEPkRBhRx/nmsYU6cpc8LpPp09TycyWEeJnHBvmpwXKm9m9m7fkedT/AAf03W5NcuLnTpJ9W1+OOLVdUubqU3EyIDhFOf3a+yY6nNeqeHNFs9B061s7S1ihhto1ihiCALGoHQf41aiiHBZiq+maZdagsB2RgMcZ5rpk9bnz8qdOLdtfyNKa5jRcsyxJ3lcfd+lc5qOvLZ+athGoZxhruUZdv90dqytS1d3Y+Y24joOwrFuLp7hgzE8Hp2xUErCqerKesauLWNppZGAXO6WU9vc1y0Qt9Hhk8QamfOvHGdN09hkjPHmsPT0Ht71P4j1W2EivcESWkR3GA9JmHQH26VxN3qNzql/LcXjn7RK2WA6IOyj0AGK26HPKlzy9mtIrfz8hb9pdXmnnuWbzZepJOT+NZUln9qhltJDw35fhWyWyR29qzzlbtj6iohJwkpJ6npOEYqyR4xqdudP1y7t8kBGwM1cguDPoGluf4NRkjyemSiYqT4iQiz8YlsfJNC02PUAYqvZNt8FaNbQr595qF89zEo6qiooH5nP5V+k0antaMJ97HzmIgou3mfSv7Aw26z8TxnOLizGf+BXVfX1fH37AML22qfE2GQ5kjmskY+pDXQNfYNebX/iM5cHpRXz/ADCiiiuc7QooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAr4S/ZWBb4e6iAM/wDEzl/9Ew1921+Zn7L3xpstF8fT/DXUnS2GqQDUdPuGOM3GSjIT7rGuPoa9DB7s+Wz6EqlOPL0u/wAj6U1IbbhcnYxQde/vS2ihYmkBGR+tL4jvrXR7ET3kqQ28Z2kSH5m9hXNx6ze3MEszxjT7AITGjHDyD19j7V42cZnQwFN88tX06nk8NcP4vN8SqlKHuJ6ye3/BfodSdfsNP0y7S7u1gKNlWboDxkfWr1j4ivjpgHh/RpJi6r5dzeHbtJPUr1IriNAu7HVtU0KOcx3FvJCboRcEAlmAJ98qeK9bn1uHQrEzXE0USoOG6YOOn6V8Vh5yxi9rJ8qfQ/eaeB/s+n7HWWvyuc7qnhDxJr+nvFrWuCylEgdTpabAox0ya5A/Di48JpcNdOdb0i7VI5JZAPNiHmKxYfl/OvWLG+fULI6lfr9jtiN8KycFlH8Te1c3r/jK2vbwWdqFkaLEuVH7sZHBPqK5swnhcLT9/wCLpbc1pqvVTpQWh12k+KtI1t5ooLhAkSgwyZAjmj6blP1BGPanvqsSkCP94DxkdB7V5VpN/Ho0MscEML2yF5QjpwmeWx6DPP41l3nxSHhVYbm+t3+xTnLGI7/LHZiPSuLD5spe5OLuZf2JiIrlp6xXTqz2SS4kkYc7c9BUciMPmJzx1rM8PeOtM8S6XBNazQ3KSjMUsbAhuOnsfatCWcSQ5X8q+ghKNSKlHY8t0fZPkkrNGBqcJ84+/asTWZdllIobYEG529vSuguFNw5B4C9W9K85+IXiaGRFs4XXjglT941rFak1NY8qOLv9WbWdXhi6QltqD2zV1bMvcy4B4fr+ArB0ANceJIVHJUkgfhXWWMylJ5eueTVM5OVQkorsV5Ytp6dKypji4P0NbUzAqSO/NYsykTjI69PeosdctTzb4raTcar4n0OGxy95cxNAiD0LDc34DNWUt4dDmS4G1UsoTbxMfuoig5b8STXZa1FFZTJelcak0LQwTEcQofvH6npXh3xe8aNpulDSNLhN3qN5/o9vbJ96UjGa+9y6X7iPNokj5avzYiu4R2Pq7/gnvd/b7v4j3OCPOexkwfc3R/rX2LXxb/wTdS6isfHCXsP2a9WPTRPD/wA85MXO5fwORX2lWNdp1G0YYRWppLu/zYUUUVgdgUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAV+BvjvQda8R/GTw/beH/OTUhaxPHNCSDCRLId2R06V++Vfkf4ObS9IW61QtHHrMoFssjkZWIfMMfizVFbFTwmHnUpxvLRL1Z1ZfgaOPzGlRxElGFm227aK2mvc9ePiiaO2tb7xHei8ubaJVjErZEbAfM3ux6/jXH+J/jBcaw6w2ymSIcLGzYwO8jHsAP5VwHinXrjVLvZ5hezQ7VEfXPcmoPCGkRavqL3mr3kUFjasNtpJII2nA5B556/1r8+ll9Ss3XxCbk/U/aXicuy2kqeFcYpaJJqyPU/hnrGtX/iEaoIC0SWcccVmzeW1ym7lkB7jr7ivTvEvxUtPDfim3u/FNnqC6RaqZUgWIO08vQFsHgdAM+lfOfiLxrEdB0+ayF6fFT33myyoCLW1jzhY1HdcDJPTmtjx94msNXGlWoggluTIjz3MOGUqnzMpIOBuJ/SuqMcRBJRg0vQ8CcqcXFzqxvO73XXTvofQOpfFK9+LPidYLWWW08KWsCz3EbLsle56iD/dUYz78Vs6bdiLS7vUn4a5lIQNwQgxjjt3rwzwp4sstIBzfwKzq7Sbpl5Yj610978R9LfQ7FVvrNpETmMzqcH3Ga+YxuExOIqubg+nRnvx+p0YxpxqxsvNa/iei63qy2mizzIPmnIQD0Bxk1xWt3R1K9hWNsBIwgbrkd6wfEXxFsWtIIk1G3ncKCTHKpA9R1rFtfHNmVcm5gV84BMi/41NLLq697kf3M7KVfCQjf2sb+q/zL2neKLj4V+JZL6wkb/hHbyVFu7Ug7bdycCVPp3FfSmjfEOy1WK3Uyi2JXLPJ90jrkfUEH8a+RPEer2Or6ZNCbq3bnO3zV+Y/nV34d+P4f+EcuLPU7zybu0kxBLKwXcpAHGeuMV9LgsPWV7xf4nyvEawtSnCvQqR5tnZrU9/8b/FNLhpbDT2KQo23zehf3ryu+vZJrmIlzzJ3rHi8QaVNMAdZt0LcmSRgefzom1vTY7hP+JtZzKHX5lmUcfnXtKhUivhZ8dTdGDt7RHceB7YnxjZbvuN5hJ/4Ca1NKkCRXkf3tqH8MMc1y/hjxroujata38mpWMvkyEmJ7hMMD+NdJoXj7wvpmoaubjUdPeO8heOEJeR7Yyxz69qynTqfyv7jya9eCrtqStbuMuL4MgUDkDmmxSIYxcSj5V4UeprHtte0D+0G+1a9p620bFiY7qNiw9BzzmoNb8faFe3G6DUbaKEcJEsy4UfnTVKUdZJ/cOpifa+5CS89UZfxV1p7PRhcg7IkDFiOwxXwJ8WfiHca5riSQXEkRhOI5Y2KsBzyCPxr62/aF8VRX/w9u7DSXN/fTjK/Yz5jKMjIO3NfE/iLwdr9xdRmPQ9SkwgBK2ch7n2r67LEp0lOfS6s/wAzmrRhQpylGSu7dT9Wv+CXkz3HhPxNLK7SSvY6QzSOcliY7gkk9ya+4a+Hf+CXkElr4T8TQzRvDNHZaQjxyKVZWEdwCCD0IPavuKit/EZ5uE/hr5/mFFFFYnYFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFcZ/wpb4e/wDQh+Gf/BPb/wDxFFFXAwqIP+FLfD3/AKEPwz/4J7f/AOIo/wCFLfD3/oQ/DP8A4J7f/wCIooqiOVdg/wCFLfD3/oQ/DP8A4J7f/wCIo/4Ut8Pf+hD8M/8Agnt//iKKKA5V2D/hS3w9/wChD8M/+Ce3/wDiKP8AhS3w9/6EPwz/AOCe3/8AiKKKAsg/4Ut8Pf8AoQ/DP/gnt/8A4ij/AIUt8Pf+hD8M/wDgnt//AIiiigLLsH/Clvh7/wBCH4Z/8E9v/wDEUf8AClvh7/0Ifhn/AME9v/8AEUUUByrsH/Clvh7/ANCH4Z/8E9v/APEUf8KW+Hv/AEIfhn/wT2//AMRRRTDlj2D/AIUt8Pf+hD8M/wDgnt//AIij/hS3w9/6EPwz/wCCe3/+IoooFyR7B/wpb4e/9CH4Z/8ABPb/APxFH/Clvh7/ANCH4Z/8E9v/APEUUUByR7B/wpb4e/8AQh+Gf/BPb/8AxFH/AApb4e/9CH4Z/wDBPb//ABFFFFw5Y9jb8OeCPDvg/wA/+wdC0zRPtHl+d/Z1nHb+bjdt3bFGcZbGem4+tbFFFYs3h8IUUUUGgUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQ";
        if (this.isWS) {
            wsrpcClient_new wsc = DataWebserviceClient.getWC();
            wsc.setquerytable("T_VIO_SURVEIL_ZP");
            wsc.setquerycolumns("*");
            log.info("\u67e5\u8be2\u6761\u4ef6\uff1ac_id='" + id + "' and  n_xh='" + xh + "'");
            wsc.setquerycondition("c_id='" + id + "' and n_xh='" + xh + "'");
            str = wsc.executeQuery() ? wsc.getitemstring("b_zp") : "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";
        }
        if (StringUtils.isBlank((CharSequence)str)) {
            str = "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";
        }
        return str;
    }

    @Override
    @Transactional
    public Response approvePass(SurveilBean surveilBean) {
        String wfxw;
        String id = surveilBean.getId();
        if (this.illegalInfoDrsService.changeSurveilState(id, "1", wfxw = surveilBean.getWfxw())) {
            return Response.successData(null);
        }
        return Response.failData(null);
    }

    private boolean tscl(SurveilBean surveilBean) {
        log.debug("\u8fdb\u5165tscl\u65b9\u6cd5");
        log.debug("id=\uff1a " + surveilBean.getId());
        String hphm = surveilBean.getHphm();
        String hpzl = surveilBean.getHpzl();
        String tzsh = surveilBean.getTzsh();
        int num = this.fdbhDao.queryTscl(hphm, hpzl);
        log.debug("num=\uff1a " + num);
        if (num == 0) {
            return true;
        }
        this.cltscl(surveilBean.getId(), tzsh);
        return false;
    }

    private Map<String, String> buildSurveilMap(SurveilBean surveilBean) {
        log.debug("\u8fdb\u5165buildForceMap\u65b9\u6cd5");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("c_cjr", surveilBean.getZqmj());
        map.put("c_cjdw", surveilBean.getCjjg());
        map.put("c_clfl", surveilBean.getClfl());
        map.put("c_hpzl", surveilBean.getHpzl());
        map.put("c_hphm", surveilBean.getHphm());
        map.put("c_jtfs", surveilBean.getJtfs());
        map.put("c_cjfs", surveilBean.getCjfs());
        map.put("d_wfsj", surveilBean.getWfsj());
        map.put("c_xzqh", surveilBean.getXzqh());
        map.put("c_wfdd", surveilBean.getWfdd());
        map.put("c_lddm", surveilBean.getLddm());
        map.put("c_ddms", surveilBean.getDdms());
        map.put("c_wfdz", surveilBean.getWfdz());
        map.put("c_wfxw", surveilBean.getWfxw());
        map.put("c_clpp", surveilBean.getClpp());
        map.put("c_csys", surveilBean.getCsys());
        map.put("c_jdcsyr", surveilBean.getJdcsyr());
        map.put("c_zsxxdz", surveilBean.getZsxxdz());
        map.put("c_zsxzqh", surveilBean.getZsxzqh());
        map.put("c_clsbdh", surveilBean.getClsbdh());
        map.put("c_fdjh", surveilBean.getFdjh());
        map.put("c_syxz", surveilBean.getSyxz());
        String destJG = this.convertJG(surveilBean.getHphm().substring(0, 2));
        map.put("c_fzjg", destJG);
        map.put("c_jsjg", destJG);
        return map;
    }

    public boolean uploadInfo(String id, List<String> zps) {
        try {
            wsrpcClient_new wsc = DataWebserviceClient.getWC();
            wsc.setquerytable("t_vio_surveil");
            wsc.setquerycolumns("*");
            log.info("\u67e5\u8be2\u6761\u4ef6\uff1ac_id='" + id + "' and c_zt='" + "0" + "'");
            wsc.setquerycondition("c_id='" + id + "' and c_zt='" + "0" + "'");
            wsc.executeQuery();
            log.debug("wsrpcclient \u8fd4\u56de\u7684\u7ed3\u679c\uff1a" + wsc.getResultXML());
            String xml = "";
            if (wsc.getrownum() > 0) {
                String hphm = wsc.getitemstring("c_hphm");
                String hpzl = wsc.getitemrealstring("c_hpzl");
                String tzsh = wsc.getitemstring("c_tzsh");
                if (this.fdbhDao.queryTscl(hphm, hpzl) > 0) {
                    return this.cltscl(id, tzsh);
                }
            } else {
                return false;
            }
            xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Root><Version>20071115</Version><ReqType>wzlrfxc</ReqType><SessionID>3000009066</SessionID><TransactionType>1</TransactionType><Tables><Table><Name>t_vio_surveil_write</Name><IsMain>1</IsMain><Row><Operate>insert</Operate><Data><c_zqmj>" + wsc.getitemstring("c_zqmj") + "</c_zqmj>" + "<c_cjjg>" + wsc.getitemstring("c_cjjg") + "</c_cjjg>" + "<c_cjdw>" + wsc.getitemstring("c_cjdw") + "</c_cjdw>" + "<c_clfl>" + wsc.getitemrealstring("c_clfl") + "</c_clfl>" + "<c_hpzl>" + wsc.getitemrealstring("c_hpzl") + "</c_hpzl>" + "<c_hphm>" + wsc.getitemstring("c_hphm") + "</c_hphm>" + "<c_jtfs>" + wsc.getitemrealstring("c_jtfs") + "</c_jtfs>" + "<c_fzjg>" + wsc.getitemstring("c_fzjg") + "</c_fzjg>" + "<c_cjfs>" + wsc.getitemrealstring("c_cjfs") + "</c_cjfs>" + "<d_wfsj Type=\"date\" Format=\"yyyy-MM-dd HH:mm\">" + wsc.getitemstring("d_wfsj") + "</d_wfsj>" + "<c_xzqh>" + wsc.getitemrealstring("c_xzqh") + "</c_xzqh>" + "<c_glxzdj>" + wsc.getitemstring("c_glxzdj") + "</c_glxzdj>" + "<c_wfdd>" + wsc.getitemstring("c_wfdd") + "</c_wfdd>" + "<c_lddm>" + wsc.getitemstring("c_lddm") + "</c_lddm>" + "<c_ddms>" + wsc.getitemstring("c_ddms") + "</c_ddms>" + "<c_wfdz>" + wsc.getitemstring("c_wfdz") + "</c_wfdz>" + "<c_wfxw>" + wsc.getitemrealstring("c_wfxw") + "</c_wfxw>" + "<c_bzz>" + wsc.getitemstring("c_bzz") + "</c_bzz>" + "<c_scz>" + wsc.getitemstring("c_scz") + "</c_scz>" + "<c_cjr>" + wsc.getitemstring("c_cjr") + "</c_cjr>" + "<c_jsjg>" + wsc.getitemstring("c_jsjg") + "</c_jsjg>" + "<c_ddms1>" + wsc.getitemstring("c_ddms1") + "</c_ddms1>" + "<c_lddm1>" + wsc.getitemstring("c_lddm1") + "</c_lddm1>" + "<c_wfdd1>" + wsc.getitemstring("c_wfdd1") + "</c_wfdd1>" + "<d_wfsj1>" + wsc.getitemstring("d_wfsj1") + "</d_wfsj1>" + "<n_fkje>" + wsc.getitemstring("n_fkje") + "</n_fkje>";
            xml = xml + "<c_clpp>" + wsc.getitemstring("c_clpp") + "</c_clpp>" + "<c_csys>" + wsc.getitemrealstring("c_csys") + "</c_csys>" + "<c_jdcsyr>" + wsc.getitemstring("c_jdcsyr") + "</c_jdcsyr>" + "<c_zsxxdz>" + wsc.getitemstring("c_zsxxdz") + "</c_zsxxdz>" + "<c_lxfs>" + wsc.getitemstring("c_lxfs") + "</c_lxfs>" + "<c_dh>" + wsc.getitemstring("c_dh") + "</c_dh>" + "<c_zsxzqh>" + wsc.getitemrealstring("c_xzqh") + "</c_zsxzqh>" + "<c_clsbdh>" + wsc.getitemstring("c_clsbdm") + "</c_clsbdh>" + "<c_fdjh>" + wsc.getitemstring("c_fdjh") + "</c_fdjh>" + "<c_syxz>" + wsc.getitemrealstring("c_syxz") + "</c_syxz>";
            String strZps = "#";
            for (String zpxh : zps) {
                strZps = strZps + zpxh + "#";
            }
            wsc.setquerytable("T_VIO_SURVEIL_ZP");
            wsc.setquerycolumns("*");
            log.info("\u67e5\u8be2\u6761\u4ef6\uff1ac_id='" + id + "'");
            wsc.setquerycondition("c_id='" + id + "'");
            boolean b = wsc.executeQuery();
            if (!b) {
                this.error = "\u56fe\u7247\u4fe1\u606f\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01";
                return false;
            }
            this.error = "";
            log.info(b + ":" + wsc.getError());
            int intTotal = Tools.getXMLCount(wsc.getResultXML());
            if (intTotal < 1) {
                this.error = "\u8fdd\u6cd5\u56fe\u7247\u4fe1\u606f\u5c11\u4e8e1\u5f20\uff0c\u7981\u6b62\u63d0\u4ea4\uff01";
                return false;
            }
            this.error = "";
            wsc.beforefirst();
            String xml1 = "";
            while (wsc.next()) {
                String zpxh = "#" + wsc.getitemstring("n_xh") + "#";
                if (strZps.indexOf(zpxh) < 0) continue;
                xml1 = xml1 + "<b_zp>" + wsc.getitemstring("b_zp") + "</b_zp>";
            }
            xml = xml + xml1;
            xml = xml + "</Data></Row></Table></Tables></Root>";
            log.debug("\u5408\u6210\u7684xml\u662f" + xml);
            if (wsc.executeUpdate(xml)) {
                return true;
            }
            this.error = wsc.getError();
            log.info(wsc.getError());
            return false;
        }
        catch (Exception e) {
            this.error = "\u6570\u636e\u4e0a\u4f20\u4ea4\u8b66\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage();
            return false;
        }
    }

    public boolean cltscl(String id, String fdbh) {
        if (this.illegalInfoDrsService.deleteSurveil(id)) {
            this.fdbhDao.retrieveFDBH(fdbh);
            return true;
        }
        return false;
    }

    public boolean delete(String infoId) {
        wsrpcClient_new wsc = DataWebserviceClient.getWC();
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Root><Version>20071115</Version><ReqType>wzlrfxc</ReqType><SessionID>3000009066</SessionID><TransactionType>1</TransactionType><Tables><Table><Name>t_vio_surveil</Name><IsMain>1</IsMain><Row><Operate>delete</Operate><Data>";
        if (wsc.executeUpdate(xml = xml + "</Data><Condition><![CDATA[c_id='" + infoId + "']]></Condition></Row></Table></Tables></Root>")) {
            return true;
        }
        wsc.getError();
        log.info(wsc.getError());
        return false;
    }

    public String getError() {
        return this.error;
    }

    @Override
    @Transactional
    public Response approveNotPass(SurveilBean surveilBean) {
        String id = surveilBean.getId();
        log.info("id=" + id);
        if (this.illegalInfoDrsService.changeSurveilState(id, "2", null)) {
            return Response.successData(null);
        }
        return Response.failData(null);
    }

    public boolean changeState(String infoId, String newState) {
        log.info("\u66f4\u65b0\u72b6\u6001\uff1a" + newState);
        wsrpcClient_new wsc = DataWebserviceClient.getWC();
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Root><Version>20071115</Version><ReqType>wzlrfxc</ReqType><SessionID>3000009066</SessionID><TransactionType>1</TransactionType><Tables><Table><Name>t_vio_surveil</Name><IsMain>1</IsMain><Row><Operate>update</Operate><Data>";
        xml = xml + "<c_zt>" + newState + "</c_zt>";
        xml = xml + "</Data><Condition><![CDATA[c_id='" + infoId + "']]></Condition></Row></Table></Tables></Root>";
        log.debug(xml);
        if (wsc.executeUpdate(xml)) {
            return true;
        }
        wsc.getError();
        log.info(wsc.getError());
        return false;
    }

    @Override
    public SurveilExtendBean translateSurveilBean(SurveilBean surveilBean) {
        Field[] fields;
        SurveilExtendBean surveilExtendBean = new SurveilExtendBean();
        BeanUtils.copyProperties((Object)surveilBean, (Object)surveilExtendBean);
        surveilExtendBean.setZp64(surveilBean.getZp64());
        surveilExtendBean.setZpxh(surveilBean.getZpxh());
        for (Field field : fields = SurveilExtendBean.class.getDeclaredFields()) {
            Object object;
            if (field.getAnnotation(TranslateColumn.class) == null || !BeanTranslateUtils.getTranslateColumnIstranslate(field) || (object = BeanTranslateUtils.getter(surveilExtendBean, field.getName())) == null) continue;
            String value = String.valueOf(object);
            String dictName = BeanTranslateUtils.getTranslateColumnDictName(field);
            Map dictMap = null;
            dictMap = this.codeService.getCodeMap(dictName);
            String translateValue = Tools.getNameOfCode(dictMap, value);
            translateValue = StringUtils.isBlank((CharSequence)translateValue) ? value : translateValue;
            String translateColumn = BeanTranslateUtils.getTranslateColumnName(field);
            BeanTranslateUtils.setter(surveilExtendBean, translateColumn, translateValue, field.getType());
        }
        return surveilExtendBean;
    }

    @Override
    public boolean updateVioSurveil(String id, String zqmj, String tzsh) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("c_zqmj", zqmj);
        map.put("c_tzsh", tzsh);
        String[] returnInfo = this.getDep(zqmj);
        map.put("c_cjjg", returnInfo[2]);
        map.put("c_cjjgmc", returnInfo[3]);
        map.put("c_xzqh", returnInfo[4]);
        String xml = DrsXml.updateXml("t_vio_surveil", "c_id='" + id + "' ", map);
        DrsResult drsResult = DrsUtils.getInstance().executeIDU(xml);
        if (drsResult.getState() == 1) {
            return false;
        }
        log.info(drsResult.getErrMsg());
        return drsResult.getState() == 0;
    }

    private String[] getDep(String jh) {
        log.info("\u6839\u636e\u8b66\u53f7\u83b7\u53d6\u4ea4\u7ba1\u5355\u4f4d\u4fe1\u606f: jh=" + jh);
        String[] returnInfo = new String[5];
        String xml = DrsXml.queryXml("t_jtwf_jyxx", "c_jh='" + jh + "' ", null, null, new String[0]);
        DrsResult drsResult = DrsUtils.getInstance().query(xml);
        if (drsResult.getState() == 1) {
            return returnInfo;
        }
        if (drsResult.getRows().isEmpty()) {
            return returnInfo;
        }
        for (Item item : drsResult.getRows()) {
            returnInfo[0] = item.getValue("c_jh");
            returnInfo[1] = item.getValue("c_xm");
            returnInfo[2] = item.getValue("c_dwbm");
            returnInfo[3] = item.getValue("c_dwmc");
            returnInfo[4] = item.getValue("c_xzqh");
        }
        return returnInfo;
    }

    private Jgys getJgysByOriJg(String oriJg) {
        String sql = "select * from t_jgys where orijg = '" + oriJg + "'";
        List<?> list = this.surveilDao.getListBySQL(sql, null, null, Jgys.class);
        if (list != null && list.size() > 0) {
            return (Jgys)list.get(0);
        }
        return null;
    }

    private String convertJG(String jg) {
        Jgys jgys = this.getJgysByOriJg(jg);
        if (jgys != null) {
            return jgys.getDestJg();
        }
        return jg;
    }
}

