/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.illegalinfo.service.impl;

import com.xdja.pams.bims.service.UserManageService;
import com.xdja.pams.common.util.Page;
import com.xdja.pams.common.util.Response;
import com.xdja.pams.syms.service.CommonCodeService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pams.function.zhengzhou.common.dao.BaseDao;
import pams.function.zhengzhou.common.service.impl.BaseServiceImpl;
import pams.function.zhengzhou.illegalinfo.bean.QueryBean;
import pams.function.zhengzhou.illegalinfo.bean.ViolationBean;
import pams.function.zhengzhou.illegalinfo.bean.ViolationExtendBean;
import pams.function.zhengzhou.illegalinfo.dao.ViolationDao;
import pams.function.zhengzhou.illegalinfo.service.IllegalInfoDrsService;
import pams.function.zhengzhou.illegalinfo.service.ViolationService;
import pams.function.zhengzhou.trafficpolice.dao.FdbhDao;
import pams.function.zhengzhou.util.BeanTranslateUtils;
import pams.function.zhengzhou.util.DataWebserviceClient;
import pams.function.zhengzhou.util.Tools;
import pams.function.zhengzhou.util.TranslateColumn;
import xdja.hxd.wsrpc.client.wsrpcClient_new;

@Service(value="violationService")
public class ViolationServiceImpl
extends BaseServiceImpl
implements ViolationService {
    private static final Logger log = LoggerFactory.getLogger(ViolationServiceImpl.class);
    @Autowired
    private ViolationDao violationDao;
    @Autowired
    private CommonCodeService codeService;
    @Autowired
    private FdbhDao fdbhDao;
    @Autowired
    private UserManageService personService;
    @Autowired
    private IllegalInfoDrsService illegalInfoDrsService;
    private boolean isWS = false;

    @Override
    public BaseDao getDao() {
        return this.violationDao;
    }

    @Override
    public List<ViolationBean> queryListByBean(QueryBean queryBean, Page page) {
        if (StringUtils.isNotBlank((CharSequence)queryBean.getBeginTime())) {
            String beginTime = queryBean.getBeginTime() + " 00:00:00";
            queryBean.setBeginTime(beginTime);
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getEndTime())) {
            String endTime = queryBean.getEndTime() + " 23:59:59";
            queryBean.setEndTime(endTime);
        }
        if (this.isWS) {
            return this.queryWS(queryBean, page);
        }
        List<ViolationBean> list = this.illegalInfoDrsService.queryViolationList(queryBean, page);
        if (list != null && !list.isEmpty()) {
            ArrayList<String> personCodes = new ArrayList<String>();
            for (ViolationBean bean : list) {
                personCodes.add(bean.getZqmj());
            }
            String[] codes = new String[personCodes.size()];
            Map personCodeNameMap = this.personService.queryPersonName(personCodes.toArray(codes));
            Map stateMap = this.codeService.getCodeMap("ILLEGAL_INFO_STATE");
            Map hpzlMap = this.codeService.getCodeMap("hpzl");
            for (ViolationBean bean : list) {
                bean.setZqmjName((String)personCodeNameMap.get(bean.getZqmj()));
                bean.setStateVal(Tools.getNameOfCode(stateMap, bean.getState()));
                bean.setHpzlVal(Tools.getNameOfCode(hpzlMap, bean.getHpzl()));
            }
        }
        return list;
    }

    public List<ViolationBean> queryWS(QueryBean queryBean, Page page) {
        ArrayList<ViolationBean> dataList = new ArrayList<ViolationBean>();
        StringBuilder selectSql = new StringBuilder(" 1=1 ");
        if (StringUtils.isNotBlank((CharSequence)queryBean.getHpzl())) {
            selectSql.append("and c_hpzl='" + queryBean.getHpzl() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getHphm())) {
            selectSql.append("and c_hphm='" + queryBean.getHphm() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getBeginTime())) {
            selectSql.append("and d_wfsj>='" + queryBean.getBeginTime() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getEndTime())) {
            selectSql.append("and d_wfsj<='" + queryBean.getEndTime() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getState())) {
            selectSql.append("and c_zt='" + queryBean.getState() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getZqmj())) {
            selectSql.append("and c_zqmj='" + queryBean.getZqmj() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getClzl())) {
            selectSql.append("and c_flag='" + queryBean.getClzl() + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)queryBean.getControlDep())) {
            selectSql.append("and c_jdsbh like '" + queryBean.getControlDep() + "%' ");
        }
        selectSql.append(" order by spzt asc,wfsj desc ");
        wsrpcClient_new wsc = DataWebserviceClient.getWC();
        wsc.setquerytable("t_vio_violation");
        wsc.setquerycolumns("*");
        log.info("\u67e5\u8be2\u6761\u4ef6\uff1a" + selectSql.toString());
        wsc.setquerycondition(selectSql.toString());
        wsc.setrowstart(Integer.valueOf((page.getPage() - 1) * page.getRp() + 1));
        wsc.setrowlen(Integer.valueOf(page.getRp()));
        int intTotal = 0;
        if (wsc.executeQuery()) {
            log.debug("wsrpcclient \u8fd4\u56de\u7684\u7ed3\u679c\uff1a" + wsc.getResultXML());
            String rstxml = wsc.getResultXML();
            intTotal = Tools.getXMLCount(rstxml);
            wsc.beforefirst();
            while (wsc.next()) {
                ViolationBean violationBean = new ViolationBean();
                violationBean.setJdsbh(wsc.getitemstring("c_jdsbh"));
                violationBean.setHpzl(wsc.getitemstring("c_hpzl"));
                violationBean.setHphm(wsc.getitemstring("c_hphm"));
                violationBean.setWfsj(wsc.getitemstring("d_wfsj"));
                violationBean.setWfdz(wsc.getitemstring("c_wfdz"));
                violationBean.setZqmj(wsc.getitemstring("c_zqmj"));
                violationBean.setState(wsc.getitemstring("c_zt"));
                dataList.add(violationBean);
            }
        }
        page.setTotal(intTotal);
        return dataList;
    }

    @Override
    public ViolationBean queryById(String id) {
        ViolationBean violationBean = null;
        id = Tools.decodeStr(id);
        if (this.isWS) {
            violationBean = this.queryWSById(id);
        } else {
            violationBean = this.illegalInfoDrsService.queryViolationById(id);
            Map hpzlMap = this.codeService.getCodeMap("hpzl");
            violationBean.setHpzlVal(Tools.getNameOfCode(hpzlMap, violationBean.getHpzl()));
        }
        if (violationBean != null) {
            Map personCodeNameMap = this.personService.queryPersonName(new String[]{violationBean.getZqmj(), violationBean.getZqxj()});
            violationBean.setZqmjName((String)personCodeNameMap.get(violationBean.getZqmj()));
            violationBean.setZqxjName((String)personCodeNameMap.get(violationBean.getZqxj()));
        }
        return violationBean;
    }

    public ViolationBean queryWSById(String id) {
        ViolationBean violation = new ViolationBean();
        wsrpcClient_new wsc = DataWebserviceClient.getWC();
        wsc.setquerytable("t_vio_violation");
        wsc.setquerycolumns("*");
        log.info("\u67e5\u8be2\u6761\u4ef6\uff1ac_jdsbh='" + id + "' ");
        wsc.setquerycondition("c_jdsbh='" + id + "' ");
        wsc.executeQuery();
        if (log.isDebugEnabled()) {
            log.debug("wsrpcclient \u8fd4\u56de\u7684\u7ed3\u679c\uff1a" + wsc.getResultXML());
        }
        if (wsc.getrownum() > 0) {
            violation.setHpzl(wsc.getitemstring("c_hpzl"));
            violation.setHphm(wsc.getitemstring("c_hphm"));
            violation.setClfl(wsc.getitemstring("c_clfl"));
            violation.setJdcsyr(wsc.getitemstring("c_jdcsyr"));
            violation.setZsxzqh(wsc.getitemstring("c_zsxzqh"));
            violation.setZsxxdz(wsc.getitemstring("c_zsxxdz"));
            violation.setSyxz(wsc.getitemstring("c_syxz"));
            violation.setWfsj(wsc.getitemstring("d_wfsj"));
            violation.setXzqh(wsc.getitemstring("c_xzqh"));
            violation.setWfdd(wsc.getitemstring("c_wfdd"));
            violation.setLddm(wsc.getitemstring("c_lddm"));
            violation.setDdms(wsc.getitemstring("c_ddms"));
            violation.setWfdz(wsc.getitemstring("c_wfdz"));
            violation.setWfdm(wsc.getitemrealstring("c_wfxw"));
            violation.setWfnr(wsc.getitemstring("c_wfxw"));
            violation.setZqmj(wsc.getitemstring("c_zqmj"));
            violation.setState(wsc.getitemstring("c_zt"));
            violation.setJdsbh(wsc.getitemstring("c_jdsbh"));
            violation.setSgdj(wsc.getitemstring("c_sgdj"));
            violation.setClsj(wsc.getitemstring("d_clsj"));
            violation.setWfjfs(wsc.getitemstring("d_wfjfs"));
            violation.setFkje(wsc.getitemstring("n_fkje"));
            violation.setJkfs(wsc.getitemstring("c_jkfs"));
            violation.setJsjqbj(wsc.getitemstring("c_jsjqbj"));
            violation.setBz(wsc.getitemstring("c_bz"));
            violation.setZjhm(wsc.getitemstring("c_jszh"));
            violation.setCfzl(wsc.getitemstring("c_cfzl"));
            violation.setRyfl(wsc.getitemstring("c_ryfl"));
            violation.setJszh(wsc.getitemstring("c_jszh"));
            violation.setDabh(wsc.getitemstring("c_dabh"));
            violation.setZjcx(wsc.getitemstring("c_zjcx"));
            violation.setDsr(wsc.getitemstring("c_dsr"));
            violation.setJtfs(wsc.getitemstring("c_jtfs"));
            violation.setXzqh(wsc.getitemstring("c_xzqh"));
            violation.setJkbj(wsc.getitemstring("c_jkbj"));
            String fzjg = wsc.getitemstring("c_fzjg");
            if (StringUtils.isBlank((CharSequence)fzjg)) {
                fzjg = wsc.getitemstring("c_hphm").substring(0, 2);
            }
            violation.setFzjg(fzjg);
        }
        return violation;
    }

    @Override
    public Response approvePass(ViolationBean violationBean) {
        String id = violationBean.getJdsbh();
        log.info("jdsbh= " + id);
        violationBean = this.queryById(id);
        if (violationBean == null) {
            log.error("\u6839\u636e\u7b80\u6613\u7a0b\u5e8f\u51b3\u5b9a\u4e66\u7f16\u53f7:" + id + "\u5728\u4e2d\u95f4\u5e93\u627e\u4e0d\u5230\u7f5a\u5355\u4fe1\u606f");
            return Response.failData(null);
        }
        if (!"0".equals(violationBean.getState())) {
            log.error("\u6839\u636e\u7b80\u6613\u7a0b\u5e8f\u51b3\u5b9a\u4e66\u7f16\u53f7:" + id + "\u5728\u4e2d\u95f4\u5e93\u627e\u5230\u7684\u7f5a\u5355\u72b6\u6001\u4e0d\u662f\u672a\u5ba1\u6279\uff01");
            return Response.failData(null);
        }
        boolean isTSFD = this.tscl(violationBean);
        log.debug("isTSFD=" + isTSFD);
        if (!isTSFD) {
            log.error("\u7b80\u6613\u7a0b\u5e8f\u51b3\u5b9a\u4e66\u7f16\u53f7:" + id + "\u662f\u7279\u6b8a\u8f66\u8f86\u7684\u7f5a\u5355");
            return Response.failData(null);
        }
        Map<String, String> violationMap = this.buildViolationMap(violationBean);
        boolean isSucc = this.illegalInfoDrsService.uploadSixInOne(violationMap, "t_vio_violation");
        log.debug("isSucc=" + isSucc);
        if (isSucc) {
            if (this.illegalInfoDrsService.changeViolationState(id, "1")) {
                return Response.successData(null);
            }
            return Response.failData(null);
        }
        return Response.failData(null);
    }

    private boolean tscl(ViolationBean violationBean) {
        log.debug("\u8fdb\u5165tscl\u65b9\u6cd5");
        log.debug("jdsbh=\uff1a " + violationBean.getJdsbh());
        String hphm = violationBean.getHphm();
        String hpzl = violationBean.getHpzl();
        int num = this.fdbhDao.queryTscl(hphm, hpzl);
        log.debug("num=\uff1a " + num);
        if (num == 0) {
            return true;
        }
        this.cltscl(violationBean.getJdsbh());
        return false;
    }

    private Map<String, String> buildViolationMap(ViolationBean violationBean) {
        log.debug("\u8fdb\u5165buildViolationMap\u65b9\u6cd5");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("c_jdsbh", violationBean.getJdsbh());
        map.put("c_jszh", violationBean.getJszh());
        map.put("c_ryfl", violationBean.getRyfl());
        map.put("c_dabh", violationBean.getDabh());
        map.put("c_fzjg", violationBean.getFzjg());
        map.put("c_zjcx", violationBean.getZjcx());
        map.put("c_dsr", violationBean.getDsr());
        map.put("c_clfl", violationBean.getClfl());
        map.put("c_hpzl", violationBean.getHpzl());
        map.put("c_hphm", violationBean.getHphm());
        map.put("c_jtfs", violationBean.getJtfs());
        map.put("d_wfsj", violationBean.getWfsj());
        map.put("c_xzqh", violationBean.getXzqh());
        map.put("c_wfdd", violationBean.getWfdd());
        map.put("c_lddm", violationBean.getLddm());
        map.put("c_ddms", violationBean.getDdms());
        map.put("c_wfdz", violationBean.getWfdz());
        map.put("c_xzqh", violationBean.getXzqh());
        map.put("c_wfxw", violationBean.getWfdm());
        map.put("c_cfzl", violationBean.getCfzl());
        map.put("n_fkje", violationBean.getFkje());
        map.put("c_zqmj", violationBean.getZqmj());
        map.put("c_jkfs", violationBean.getJkfs());
        map.put("c_jkbj", violationBean.getJkbj());
        map.put("c_jsjqbj", violationBean.getJsjqbj());
        map.put("c_sgdj", violationBean.getSgdj());
        map.put("c_clpp", violationBean.getClpp());
        map.put("c_csys", violationBean.getCsys());
        map.put("c_jdcsyr", violationBean.getJdcsyr());
        map.put("c_zsxxdz", violationBean.getZsxxdz());
        map.put("c_zsxzqh", violationBean.getZsxzqh());
        map.put("c_clsbdh", violationBean.getClsbdh());
        map.put("c_fdjh", violationBean.getFdjh());
        map.put("c_syxz", violationBean.getSyxz());
        return map;
    }

    public boolean uploadInfo(String id) {
        try {
            wsrpcClient_new wsc = DataWebserviceClient.getWC();
            wsc.setquerytable("t_vio_violation");
            wsc.setquerycolumns("*");
            log.info("\u67e5\u8be2\u6761\u4ef6\uff1ac_jdsbh='" + id + "' and c_zt='" + "0" + "'");
            wsc.setquerycondition("c_jdsbh='" + id + "' and c_zt='" + "0" + "'");
            wsc.executeQuery();
            log.debug("wsrpcclient \u8fd4\u56de\u7684\u7ed3\u679c\uff1a" + wsc.getResultXML());
            String xml = "";
            if (wsc.getrownum() > 0) {
                String hpzl;
                String hphm = wsc.getitemstring("c_hphm");
                if (this.fdbhDao.queryTscl(hphm, hpzl = wsc.getitemrealstring("c_hpzl")) > 0) {
                    return this.cltscl(id);
                }
            } else {
                return false;
            }
            xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Root><Version>20071115</Version><ReqType>wzlrfxc</ReqType><SessionID>3000009066</SessionID><TransactionType>1</TransactionType><Tables><Table><Name>t_vio_violation_write</Name><IsMain>1</IsMain><Row><Operate>insert</Operate><Data><c_jdsbh>" + wsc.getitemstring("c_jdsbh") + "</c_jdsbh>" + "<c_jszh Type=\"varchar\">" + wsc.getitemstring("c_jszh") + "</c_jszh>" + "<c_ryfl>" + wsc.getitemrealstring("c_ryfl") + "</c_ryfl>" + "<c_dabh>" + wsc.getitemstring("c_dabh") + "</c_dabh>" + "<c_fzjg>" + wsc.getitemstring("c_fzjg") + "</c_fzjg>" + "<c_zjcx>" + wsc.getitemrealstring("c_zjcx") + "</c_zjcx>" + "<c_dsr>" + wsc.getitemstring("c_dsr") + "</c_dsr>" + "<c_clfl>" + wsc.getitemrealstring("c_clfl") + "</c_clfl>" + "<c_hpzl>" + wsc.getitemrealstring("c_hpzl") + "</c_hpzl>" + "<c_hphm>" + wsc.getitemstring("c_hphm") + "</c_hphm>" + "<c_jtfs>" + wsc.getitemrealstring("c_jtfs") + "</c_jtfs>" + "<d_wfsj Type=\"date\" Format=\"yyyy-MM-dd HH:mm\">" + wsc.getitemstring("d_wfsj") + "</d_wfsj>" + "<c_xzqh>" + wsc.getitemrealstring("c_xzqh") + "</c_xzqh>" + "<c_wfdd>" + wsc.getitemstring("c_wfdd") + "</c_wfdd>" + "<c_lddm>" + wsc.getitemstring("c_lddm") + "</c_lddm>" + "<c_ddms>" + wsc.getitemstring("c_ddms") + "</c_ddms>" + "<c_wfdz>" + wsc.getitemstring("c_wfdz") + "</c_wfdz>" + "<c_wfxw>" + wsc.getitemrealstring("c_wfxw") + "</c_wfxw>" + "<c_cfzl>" + wsc.getitemrealstring("c_cfzl") + "</c_cfzl>" + "<n_fkje>" + wsc.getitemstring("n_fkje") + "</n_fkje>" + "<c_zqmj>" + wsc.getitemstring("c_zqmj") + "</c_zqmj>" + "<c_jkfs>" + wsc.getitemrealstring("c_jkfs") + "</c_jkfs>" + "<c_jkbj>" + wsc.getitemrealstring("c_jkbj") + "</c_jkbj>" + "<c_fxjg Type=\"varchar\">" + wsc.getitemstring("c_fxjg") + "</c_fxjg>" + "<c_jsjqbj>" + wsc.getitemrealstring("c_jsjqbj") + "</c_jsjqbj>" + "<c_sgdj>" + wsc.getitemrealstring("c_sgdj") + "</c_sgdj>";
            xml = xml + "<c_clpp>" + wsc.getitemstring("c_clpp") + "</c_clpp>" + "<c_csys>" + wsc.getitemrealstring("c_csys") + "</c_csys>" + "<c_jdcsyr>" + wsc.getitemstring("c_jdcsyr") + "</c_jdcsyr>" + "<c_dh>" + wsc.getitemstring("c_dh") + "</c_dh>" + "<c_zsxxdz>" + wsc.getitemstring("c_zsxxdz") + "</c_zsxxdz>" + "<c_zsxzqh>" + wsc.getitemrealstring("c_zsxzqh") + "</c_zsxzqh>" + "<c_clsbdh>" + wsc.getitemstring("c_clsbdh") + "</c_clsbdh>" + "<c_fdjh>" + wsc.getitemstring("c_fdjh") + "</c_fdjh>" + "<c_syxz>" + wsc.getitemrealstring("c_syxz") + "</c_syxz>";
            xml = xml + "</Data></Row></Table></Tables></Root>";
            log.debug("\u5408\u6210\u7684xml\u662f" + xml);
            if (wsc.executeUpdate(xml)) {
                return true;
            }
            log.info(wsc.getError());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean changeState(String infoId, String newState) {
        wsrpcClient_new wsc = DataWebserviceClient.getWC();
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Root><Version>20071115</Version><ReqType>wzlrfxc</ReqType><SessionID>3000009066</SessionID><TransactionType>1</TransactionType><Tables><Table><Name>t_vio_violation</Name><IsMain>1</IsMain><Row><Operate>update</Operate><Data>";
        xml = xml + "<c_zt>" + newState + "</c_zt>";
        if (wsc.executeUpdate(xml = xml + "</Data><Condition><![CDATA[c_jdsbh='" + infoId + "']]></Condition></Row></Table></Tables></Root>")) {
            return true;
        }
        wsc.getError();
        log.info(wsc.getError());
        return false;
    }

    public boolean cltscl(String id) {
        if (this.illegalInfoDrsService.deleteViolation(id)) {
            this.fdbhDao.retrieveFDBH(id);
            return true;
        }
        return false;
    }

    public boolean delete(String infoId) {
        wsrpcClient_new wsc = DataWebserviceClient.getWC();
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Root><Version>20071115</Version><ReqType>wzlrfxc</ReqType><SessionID>3000009066</SessionID><TransactionType>1</TransactionType><Tables><Table><Name>t_vio_violation</Name><IsMain>1</IsMain><Row><Operate>delete</Operate><Data>";
        if (wsc.executeUpdate(xml = xml + "</Data><Condition><![CDATA[c_jdsbh='" + infoId + "']]></Condition></Row></Table></Tables></Root>")) {
            return true;
        }
        log.info(wsc.getError());
        return false;
    }

    @Override
    public Response approveNotPass(ViolationBean violationBean) {
        String id = violationBean.getJdsbh();
        log.info("id=" + id);
        if (this.illegalInfoDrsService.changeViolationState(id, "2")) {
            if (this.fdbhDao.retrieveFDBH(id) < 1) {
                this.illegalInfoDrsService.changeViolationState(id, "0");
                return Response.failData(null);
            }
            return Response.successData(null);
        }
        return Response.failData(null);
    }

    @Override
    public ViolationExtendBean translateViolationBean(ViolationBean violationBean) {
        Field[] fields;
        ViolationExtendBean violationExtendBean = new ViolationExtendBean();
        BeanUtils.copyProperties((Object)violationBean, (Object)violationExtendBean);
        for (Field field : fields = ViolationExtendBean.class.getDeclaredFields()) {
            Object object;
            if (field.getAnnotation(TranslateColumn.class) == null || !BeanTranslateUtils.getTranslateColumnIstranslate(field) || (object = BeanTranslateUtils.getter(violationExtendBean, field.getName())) == null) continue;
            String value = String.valueOf(object);
            String dictName = BeanTranslateUtils.getTranslateColumnDictName(field);
            Map dictMap = null;
            dictMap = this.codeService.getCodeMap(dictName);
            String translateValue = Tools.getNameOfCode(dictMap, value);
            translateValue = StringUtils.isBlank((CharSequence)translateValue) ? value : translateValue;
            String translateColumn = BeanTranslateUtils.getTranslateColumnName(field);
            BeanTranslateUtils.setter(violationExtendBean, translateColumn, translateValue, field.getType());
        }
        return violationExtendBean;
    }
}

