/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.syms.controller;

import com.alibaba.fastjson.JSON;
import com.xdja.pams.bims.entity.Person;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.login.entity.Operator;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.syms.entity.SystemConfig;
import com.xdja.pams.syms.service.SystemConfigService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import pams.function.zhengzhou.syms.bean.ZzInfoUpdateBean;

@Controller
@Scope(value="session")
@RequestMapping(value={"syms/zzsysconfigcontroller"})
public class ZzSysConfigController
extends BaseControler {
    private static final Logger log = LoggerFactory.getLogger(ZzSysConfigController.class);
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private SystemLogService systemLogService;

    @RequestMapping(value={"/index.do"})
    public String index(HttpServletRequest request, PageParam page, HttpServletResponse response, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
            SystemConfig sysCfgTheme = this.systemConfigService.getByCode("systemTheme");
            if (sysCfgTheme != null) {
                map.put((Object)"sysCfgTheme", (Object)sysCfgTheme);
            }
            String theme = this.operator.getPerson().getTheme();
            map.put((Object)"theme", (Object)theme);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"));
        }
        return sendUrl;
    }

    @RequestMapping(value={"/query.do"})
    public void query(HttpServletResponse response, String name) {
        List list = this.systemConfigService.queryByCodeLike("zz_");
        try {
            for (SystemConfig pSC : list) {
                List list2 = pSC.getcSystemConfig();
                for (int i = 0; i < list2.size(); ++i) {
                    for (int j = i + 1; j < list2.size(); ++j) {
                        if (((SystemConfig)list2.get(i)).getCode().compareTo(((SystemConfig)list2.get(j)).getCode()) <= 0) continue;
                        SystemConfig temp = (SystemConfig)list2.get(i);
                        list2.set(i, list2.get(j));
                        list2.set(j, temp);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        ArrayList listmap = new ArrayList();
        for (SystemConfig pSC : list) {
            String id = "";
            List listMatch = null;
            if (!Util.varCheckEmp((String)name) && pSC.getName() != null) {
                if (pSC.getName().contains(name)) {
                    id = pSC.getId();
                } else {
                    for (SystemConfig cSC : pSC.getcSystemConfig()) {
                        if (!cSC.getName().contains(name)) continue;
                        id = pSC.getId();
                        break;
                    }
                }
                if (!Util.varCheckEmp((String)id)) {
                    listMatch = this.systemConfigService.getById(id).getcSystemConfig();
                }
            } else {
                listMatch = pSC.getcSystemConfig();
            }
            if (null == listMatch) continue;
            for (SystemConfig cSC : listMatch) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", cSC.getId());
                map.put("name", cSC.getName());
                map.put("code", cSC.getCode());
                map.put("value", cSC.getValue());
                map.put("note", cSC.getNote());
                map.put("group", pSC.getName());
                HashMap<String, Object> editor = new HashMap<String, Object>();
                editor.put("type", "validatebox");
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("validType", "length[0,128]");
                editor.put("options", options);
                map.put("editor", editor);
                map.put("type", pSC.getId());
                listmap.add(map);
            }
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("total", Integer.valueOf(listmap.size()));
        map.put("rows", listmap);
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(map));
    }

    @RequestMapping(value={"/update.do"})
    public void update(@RequestBody String json, HttpServletRequest request, HttpServletResponse response) {
        ZzInfoUpdateBean zzInfoUpdateBean = (ZzInfoUpdateBean)JSON.parseObject((String)json, ZzInfoUpdateBean.class);
        List<SystemConfig> list = zzInfoUpdateBean.getSystemConfigList();
        Operator operator = this.getOperator(request);
        Person person = operator.getPerson();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            this.systemConfigService.updateBatch(list);
            map.put("flag", "1");
            map.put("message", "\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            map = new HashMap();
            map.put("flag", "0");
            map.put("message", e.getMessage());
        }
        this.systemLogService.saveOperateLog(person.getCode(), person.getName(), person.getDepartment().getCode(), person.getDepartment().getName(), operator.getLoginIp(), Integer.valueOf(3), Integer.valueOf(Integer.parseInt((String)map.get("flag"))), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8JSON((HttpServletResponse)response, (String)Util.toJsonStr(map));
    }
}

