/*
 * Decompiled with CFR 0.152.
 */
package pams.function.zhengzhou.tdms.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xdja.pams.common.basecontroler.BaseControler;
import com.xdja.pams.common.bean.PageParam;
import com.xdja.pams.common.token.TokenFactory;
import com.xdja.pams.common.util.CookieUtils;
import com.xdja.pams.common.util.MessageManager;
import com.xdja.pams.common.util.Util;
import com.xdja.pams.common.util.excel.ExcelUtil;
import com.xdja.pams.logms.service.SystemLogService;
import com.xdja.pams.scms.util.Strings;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import pams.function.zhengzhou.tdms.bean.ImportTerminalBean;
import pams.function.zhengzhou.tdms.bean.QueryTerminalBean;
import pams.function.zhengzhou.tdms.bean.Rt;
import pams.function.zhengzhou.tdms.bean.TerminalInfo;
import pams.function.zhengzhou.tdms.service.TerminalDistributionService;

@Controller
@Scope(value="session")
public class TerminalDistribController
extends BaseControler {
    @Autowired
    private ResourceBundleMessageSource message;
    @Autowired
    private SystemLogService systemLogService;
    @Autowired
    private TerminalDistributionService terminalDistributionService;
    @Autowired
    private TokenFactory tokenFactory;
    private final DecimalFormat df = new DecimalFormat("######0.00");
    private static final Logger log = LoggerFactory.getLogger(TerminalDistribController.class);

    @RequestMapping(value={"/tdms/terminalDistributionController/index.do"})
    public String index(HttpServletRequest request, PageParam page, ModelMap map) {
        String sendUrl = "error/error";
        try {
            this.setMenuInfo(request, page.getMenuId(), page.getParentId());
            sendUrl = this.menuLinkPage;
        }
        catch (Exception e) {
            log.error(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"), (Throwable)e);
            map.put((Object)"errMsg", (Object)MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"common.error.exception"));
        }
        map.put((Object)"rootDep", (Object)this.getRootId(request));
        return sendUrl;
    }

    @RequestMapping(value={"/tdms/terminalDistributionController/list.do"})
    public void list(HttpServletRequest request, HttpServletResponse response, QueryTerminalBean queryBean) {
        int operateResult = 1;
        this.setOperator(request);
        Map<Object, Object> result = new HashMap<String, String>();
        try {
            Long distriCount;
            result = this.terminalDistributionService.list(queryBean);
            Integer totalCount = (Integer)result.get("total");
            if ("2".equals(queryBean.getState())) {
                distriCount = 0L;
            } else {
                queryBean.setState("1");
                distriCount = this.terminalDistributionService.queryCount(queryBean);
            }
            result.put("code", "1");
            result.put("totalCount", totalCount);
            result.put("distriCount", distriCount);
        }
        catch (Exception e) {
            result.put("code", "0");
            result.put("msg", e.getMessage());
            operateResult = 0;
            log.error("\u83b7\u53d6\u7ec8\u7aef\u8bbe\u5907\u5217\u8868\u5f02\u5e38", (Throwable)e);
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(1), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(result));
    }

    @RequestMapping(value={"/tdms/terminalDistributionController/toEditOrAdd.do"})
    public String toAddOrEdit(ModelMap map, String id) {
        if (!"noID".equals(id)) {
            TerminalInfo terminalInfo = this.terminalDistributionService.queryById(id);
            map.put((Object)"terminal", (Object)terminalInfo);
            return "tdms/terminalManage/default/edit";
        }
        return "tdms/terminalManage/default/add";
    }

    @RequestMapping(value={"/tdms/terminalDistributionController/save.do"})
    public void save(HttpServletRequest request, HttpServletResponse response, QueryTerminalBean terminalBean) {
        int operateResult = 0;
        this.setOperator(request);
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            if (StringUtils.isBlank((CharSequence)terminalBean.getImei()) || StringUtils.isBlank((CharSequence)terminalBean.getPersonId())) {
                result.put("code", "0");
                result.put("msg", "\u64cd\u4f5c\u5931\u8d25\uff0c\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a");
            } else {
                terminalBean.setCreatedBy(this.person.getId());
                terminalBean.setUpdatedBy(this.person.getId());
                this.terminalDistributionService.save(terminalBean);
                operateResult = 1;
                result.put("code", "1");
                result.put("msg", "\u64cd\u4f5c\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u7ec8\u7aef\u8bbe\u5907\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            result.put("code", "0");
            result.put("msg", e.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(1), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(result));
    }

    @RequestMapping(value={"/tdms/terminalDistributionController/toImportExcel.do"})
    public String toImport(HttpServletRequest request) {
        String ticket = (String)CookieUtils.getCookie((HttpServletRequest)request, (String)"operator", String.class);
        this.tokenFactory.getOperator().add("upload:terminal:rate:" + ticket, "0");
        return "tdms/terminalManage/default/import";
    }

    @RequestMapping(value={"/tdms/terminalDistributionController/importExcel.do"})
    public void importExcel(@RequestParam MultipartFile file, HttpServletResponse response, HttpServletRequest request) {
        int operateResult = 0;
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<ImportTerminalBean> errorList = new ArrayList<ImportTerminalBean>();
        String ticket = (String)CookieUtils.getCookie((HttpServletRequest)request, (String)"operator", String.class);
        try {
            if (file == null) {
                result.put("code", "0");
                result.put("msg", MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"bims.person.imp.error.parseExcel.notFile"));
                Util.writeUtf8Text1((HttpServletResponse)response, (String)Util.toJsonStr(result));
            }
            long currentTime = System.currentTimeMillis();
            this.terminalDistributionService.importExcel(file, errorList, this.person.getId(), request, result);
            this.tokenFactory.getOperator().add("imp:terminal:error:list:" + ticket, errorList);
            log.info("import spend : " + (System.currentTimeMillis() - currentTime) + "ms");
            this.tokenFactory.getOperator().add("upload:terminal:rate:" + ticket, "end");
            operateResult = 1;
            result.put("code", "1");
            result.put("msg", "\u5bfc\u5165\u6210\u529f");
        }
        catch (Exception e) {
            this.tokenFactory.getOperator().add("upload:terminal:rate:" + ticket, "end");
            log.error("\u4fdd\u5b58\u7ec8\u7aef\u8bbe\u5907\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            result.put("code", "0");
            result.put("msg", e.getMessage());
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(1), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text1((HttpServletResponse)response, (String)Util.toJsonStr(result));
    }

    @RequestMapping(value={"/tdms/terminalDistributionController/importProgress.do"})
    public void importProgress(HttpServletResponse response, HttpServletRequest request) {
        String ticket = (String)CookieUtils.getCookie((HttpServletRequest)request, (String)"operator", String.class);
        String result = (String)this.tokenFactory.getOperator().get("upload:terminal:rate:" + ticket);
        String progress = "end".equals(result) ? "end" : (result != null && !result.equals("0") ? this.df.format(Double.valueOf(result) * 100.0) : "0.00");
        Util.writeUtf8Text1((HttpServletResponse)response, (String)progress);
    }

    @RequestMapping(value={"/tdms/terminalDistributionController/exportErrInfoExcel.do"})
    public void exportErrInfoExcel(HttpServletRequest request, HttpServletResponse response) {
        log.info("exportExcel...............");
        try {
            String ticket = (String)CookieUtils.getCookie((HttpServletRequest)request, (String)"operator", String.class);
            String fileTitle = "\u5bfc\u5165\u5931\u8d25\u6570\u636e";
            String fileName = Util.toUtf8String((String)"\u5bfc\u5165\u5931\u8d25\u6570\u636e") + ".xls";
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            List errorInfoList = (List)this.tokenFactory.getOperator().get("imp:terminal:error:list:" + ticket);
            if (errorInfoList.size() <= 0) {
                ImportTerminalBean terminalBean = new ImportTerminalBean();
                errorInfoList.add(terminalBean);
            }
            ArrayList<String> titleList = new ArrayList<String>();
            titleList.add("IMEI\u53f7\u7801");
            titleList.add("\u8eab\u4efd\u8bc1\u53f7\u7801");
            titleList.add("\u59d3\u540d");
            titleList.add("\u8bbe\u5907\u54c1\u724c");
            titleList.add("\u8bbe\u5907\u578b\u53f7");
            titleList.add("\u88c5\u7bb1\u53f7");
            titleList.add("\u8bbe\u5907\u53d1\u653e\u72b6\u6001");
            titleList.add("\u5f02\u5e38\u4fe1\u606f");
            ExcelUtil.getExcelAsTitle((OutputStream)response.getOutputStream(), (String)fileTitle, (String)fileTitle, (List)errorInfoList, titleList);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Util.writeUtf8Text((HttpServletResponse)response, (String)(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"exp.error.msg") + ":" + e.getMessage()));
        }
    }

    @RequestMapping(value={"/tdms/terminalDistributionController/exportExcel.do"})
    public void exportExcel(HttpServletResponse response, QueryTerminalBean queryTerminalBean) {
        log.info("exportExcel...............");
        try {
            String fileTitle = "\u5bfc\u51fa\u8bbe\u5907\u4fe1\u606f";
            String fileName = Util.toUtf8String((String)"\u8bbe\u5907\u4fe1\u606f") + ".xls";
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            if ("on".equals(queryTerminalBean.getIsContain())) {
                queryTerminalBean.setIsContain("1");
            } else {
                queryTerminalBean.setIsContain("0");
            }
            queryTerminalBean.setPage(1);
            queryTerminalBean.setRows(Integer.MAX_VALUE);
            Map<String, Object> result = this.terminalDistributionService.list(queryTerminalBean);
            ArrayList<TerminalInfo> list = (ArrayList<TerminalInfo>)result.get("rows");
            if (list.size() <= 0) {
                list = new ArrayList<TerminalInfo>();
                TerminalInfo terminalBean = new TerminalInfo();
                list.add(terminalBean);
            }
            ArrayList<String> titleList = new ArrayList<String>();
            titleList.add("\u8b66\u53f7");
            titleList.add("\u59d3\u540d");
            titleList.add("\u624b\u673a\u53f7\u7801");
            titleList.add("\u8eab\u4efd\u8bc1\u53f7");
            titleList.add("\u6240\u5c5e\u5355\u4f4d");
            titleList.add("\u7ec8\u7aefIMEI\u53f7");
            titleList.add("\u5de5\u4f5c\u7cfb\u7edfIMEI\u53f7");
            titleList.add("\u88c5\u7bb1\u53f7");
            titleList.add("\u8bbe\u5907\u578b\u53f7");
            titleList.add("\u8bbe\u5907\u54c1\u724c");
            titleList.add("\u8bbe\u5907\u72b6\u6001");
            titleList.add("\u6dfb\u52a0\u65f6\u95f4");
            titleList.add("\u53d1\u653e\u65f6\u95f4");
            titleList.add("\u53d1\u653e\u4eba");
            ExcelUtil.getExcelAsTitle((OutputStream)response.getOutputStream(), (String)fileTitle, (String)fileTitle, list, titleList);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Util.writeUtf8Text((HttpServletResponse)response, (String)(MessageManager.getProMessage((ResourceBundleMessageSource)this.message, (String)"exp.error.msg") + ":" + e.getMessage()));
        }
    }

    @RequestMapping(value={"/tdms/terminalDistributionController/delete.do"})
    public void delete(String id, HttpServletResponse response) {
        HashMap<String, String> result = new HashMap<String, String>();
        int operateResult = 0;
        try {
            this.terminalDistributionService.delete(id);
            operateResult = 1;
            result.put("code", "1");
            result.put("msg", "\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            result.put("code", "0");
            result.put("msg", "\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.systemLogService.saveOperateLog(this.person.getCode(), this.person.getName(), this.person.getDepartment().getCode(), this.person.getDepartment().getName(), this.operator.getLoginIp(), Integer.valueOf(4), Integer.valueOf(operateResult), "", "", "", this.menuCode, this.menuName);
        Util.writeUtf8Text((HttpServletResponse)response, (String)Util.toJsonStr(result));
    }

    @RequestMapping(value={"/SCMS/terminalDistribController/terminalInfo.do"})
    public void terminalInfo(@RequestBody String str, HttpServletResponse response) {
        log.info("--> \u53c2\u6570: {}", (Object)str);
        try {
            if (Strings.isEmpty((String)str)) {
                Util.writeUtf8JSON((HttpServletResponse)response, (String)Rt.faile("\u53c2\u6570\u5f02\u5e38"));
                return;
            }
            JSONObject jsonObject = JSON.parseObject((String)str);
            String imei = jsonObject.getString("imei");
            String identifier = jsonObject.getString("idNo");
            String code = jsonObject.getString("code");
            if (Strings.isEmpty((String)imei) && Strings.isEmpty((String)code) && Strings.isEmpty((String)identifier)) {
                Util.writeUtf8JSON((HttpServletResponse)response, (String)Rt.faile("imei\u6216\u8005\u4eba\u5458\u8b66\u53f7\u548c\u8eab\u4efd\u8bc1\u53f7\u4e0d\u53ef\u7a7a"));
                return;
            }
            List<TerminalInfo> terminalInfoList = this.terminalDistributionService.terminalInfo(imei, identifier, code);
            Util.writeUtf8JSON((HttpServletResponse)response, (String)(CollectionUtils.isEmpty(terminalInfoList) ? Rt.faile("\u6ca1\u6709\u8bb0\u5f55") : Rt.success(terminalInfoList)));
        }
        catch (Exception e) {
            Util.writeUtf8JSON((HttpServletResponse)response, (String)Rt.error("\u7cfb\u7edf\u5f02\u5e38"));
        }
    }

    @RequestMapping(value={"/SCMS/terminalDistribController/distrib.do"})
    public void distrib(@RequestBody String str, HttpServletResponse response) {
        try {
            if (Strings.isEmpty((String)str)) {
                Util.writeUtf8JSON((HttpServletResponse)response, (String)Rt.faile("\u53c2\u6570\u5f02\u5e38"));
                return;
            }
            JSONObject jsonObject = JSON.parseObject((String)str);
            String id = jsonObject.getString("id");
            String distributorId = jsonObject.getString("distributorId");
            if (Strings.isEmpty((String)id) || Strings.isEmpty((String)distributorId)) {
                Util.writeUtf8JSON((HttpServletResponse)response, (String)Rt.faile("\u53c2\u6570\u5f02\u5e38"));
                return;
            }
            TerminalInfo info = this.terminalDistributionService.getterminalInfoById(id);
            if (info != null && "1".equals(info.getState())) {
                Util.writeUtf8JSON((HttpServletResponse)response, (String)Rt.success("\u5df2\u7ecf\u53d1\u653e\u7ed9" + info.getPersonName()));
            } else {
                this.terminalDistributionService.distrib(id, distributorId);
                Util.writeUtf8JSON((HttpServletResponse)response, (String)Rt.success("\u53d1\u653e\u6210\u529f"));
            }
        }
        catch (Exception e) {
            Util.writeUtf8JSON((HttpServletResponse)response, (String)Rt.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage()));
        }
    }

    @RequestMapping(value={"/SCMS/terminalDistribController/list.do"})
    public void list(@RequestBody String str, HttpServletResponse response) {
        try {
            if (Strings.isEmpty((String)str)) {
                Util.writeUtf8JSON((HttpServletResponse)response, (String)Rt.faile("\u53c2\u6570\u5f02\u5e38"));
                return;
            }
            JSONObject jsonObject = JSON.parseObject((String)str);
            Integer page = jsonObject.getInteger("pageNo");
            Integer rows = jsonObject.getInteger("pageSize");
            QueryTerminalBean bean = (QueryTerminalBean)JSON.parseObject((String)str, QueryTerminalBean.class);
            bean.setPage(page == null ? 1 : page);
            bean.setRows(rows == null ? 10 : rows);
            if (Strings.isEmpty((String)bean.getDistributorId())) {
                Util.writeUtf8JSON((HttpServletResponse)response, (String)Rt.error("\u53c2\u6570\u5f02\u5e38"));
            } else {
                Map<String, Object> map = this.terminalDistributionService.list(bean);
                Util.writeUtf8JSON((HttpServletResponse)response, (String)Rt.success(map));
            }
        }
        catch (Exception e) {
            log.error("\u52a0\u8f7d\u6570\u636e\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            Util.writeUtf8JSON((HttpServletResponse)response, (String)Rt.error("\u7cfb\u7edf\u5f02\u5e38"));
        }
    }
}

